/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.GssapiAuthenticationTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001\u001d\u0011\u0001dR:tCBL\u0017)\u001e;iK:$\u0018nY1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0004CBL\u0017BA\u0007\u000b\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bCA\u0005\u0010\u0013\t\u0001\"BA\u0005TCNd7+\u001a;va\")!\u0003\u0001C\u0001'\u00051A(\u001b8jiz\"\u0012\u0001\u0006\t\u0003+\u0001i\u0011A\u0001\u0005\b/\u0001\u0011\r\u0011\"\u0011\u0019\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u00111!\u00138u\u0011\u0019\u0001\u0003\u0001)A\u00053\u0005a!M]8lKJ\u001cu.\u001e8uA!)!\u0005\u0001C)G\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002IA\u0011Q%M\u0007\u0002M)\u0011q\u0005K\u0001\u0005CV$\bN\u0003\u0002*U\u0005A1/Z2ve&$\u0018P\u0003\u0002,Y\u000511m\\7n_:T!!B\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e\u0019\u0012\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000fQ\u0002!\u0019!C\u0005k\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t1\fgn\u001a\u0006\u0002w\u0005!!.\u0019<b\u0013\ti\u0004H\u0001\u0004TiJLgn\u001a\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001c\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000e\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003\r\u00032\u0001R%7\u001b\u0005)%B\u0001$H\u0003%IW.\\;uC\ndWM\u0003\u0002I7\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)+%\u0001\u0002'jgRDa\u0001\u0014\u0001!\u0002\u0013\u0019\u0015AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0003b\u0002(\u0001\u0005\u0004%I\u0001G\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\bB\u0002)\u0001A\u0003%\u0011$A\u0006ok6$\u0006N]3bIN\u0004\u0003b\u0002*\u0001\u0005\u0004%IaU\u0001\tKb,7-\u001e;peV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005eS\u0014\u0001B;uS2L!a\u0017,\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016Da!\u0018\u0001!\u0002\u0013!\u0016!C3yK\u000e,Ho\u001c:!\u0011\u001dy\u0006A1A\u0005\n\u0001\fAb\u00197jK:$8i\u001c8gS\u001e,\u0012!\u0019\t\u0003E\u000el\u0011\u0001W\u0005\u0003Ib\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u00191\u0007\u0001)A\u0005C\u0006i1\r\\5f]R\u001cuN\u001c4jO\u0002B\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011B5\u0002\u0015M,'O^3s\u0003\u0012$'/F\u0001k!\tYg.D\u0001m\u0015\ti'(A\u0002oKRL!a\u001c7\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u0005r\u0001\u0001\u0007\t\u0019!C\u0005e\u0006q1/\u001a:wKJ\fE\r\u001a:`I\u0015\fHCA:w!\tQB/\u0003\u0002v7\t!QK\\5u\u0011\u001d9\b/!AA\u0002)\f1\u0001\u001f\u00132\u0011\u0019I\b\u0001)Q\u0005U\u0006Y1/\u001a:wKJ\fE\r\u001a:!\u0011\u001dY\bA1A\u0005\nq\fA\u0001^5nKV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003Q\u0013!B;uS2\u001c\u0018bAA\u0003\u007f\nAQj\\2l)&lW\rC\u0004\u0002\n\u0001\u0001\u000b\u0011B?\u0002\u000bQLW.\u001a\u0011\t\u0011\u00055\u0001A1A\u0005\u0002U\nQ\u0001^8qS\u000eDq!!\u0005\u0001A\u0003%a'\u0001\u0004u_BL7\r\t\u0005\t\u0003+\u0001!\u0019!C\u00011\u0005!\u0001/\u0019:u\u0011\u001d\tI\u0002\u0001Q\u0001\ne\tQ\u0001]1si\u0002B\u0011\"!\b\u0001\u0005\u0004%\t!a\b\u0002\u0005Q\u0004XCAA\u0011!\u0011\t\u0019#!\n\u000e\u0003)J1!a\n+\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a\u000b\u0001A\u0003%\u0011\u0011E\u0001\u0004iB\u0004\u0003\u0002CA\u0018\u0001\t\u0007I\u0011\u0002\r\u00027\u0019\f\u0017\u000e\\3e\u0003V$\b.\u001a8uS\u000e\fG/[8o\t\u0016d\u0017-_'t\u0011\u001d\t\u0019\u0004\u0001Q\u0001\ne\tADZ1jY\u0016$\u0017)\u001e;iK:$\u0018nY1uS>tG)\u001a7bs6\u001b\b\u0005C\u0004\u00028\u0001!\t%!\u000f\u0002\u000bM,G/\u00169\u0015\u0003MDC!!\u000e\u0002>A!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D=\nQA[;oSRLA!a\u0012\u0002B\t1!)\u001a4pe\u0016Dq!a\u0013\u0001\t\u0003\nI$\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\tI%a\u0014\u0011\t\u0005}\u0012\u0011K\u0005\u0005\u0003'\n\tEA\u0003BMR,'\u000fC\u0004\u0002X\u0001!\t!!\u000f\u0002)Q,7\u000f\u001e*fcV,7\u000f^%t\u0003J+\u0007\u000f\\1zQ\u0011\t)&a\u0017\u0011\t\u0005}\u0012QL\u0005\u0005\u0003?\n\tE\u0001\u0003UKN$\bbBA2\u0001\u0011\u0005\u0011\u0011H\u0001%i\u0016\u001cHoU3sm\u0016\u0014hj\u001c;G_VtG-\u00138LKJ\u0014WM]8t\t\u0006$\u0018MY1tK\"\"\u0011\u0011MA.\u0011\u001d\tI\u0007\u0001C\u0001\u0003s\tq\u0004^3tiN+'O^3s\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\u0011\t9'a\u0017\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\u0005Yc/\u001a:jMf\u0014V\r\u001e:jC\ndWMR1jYV\u0014Xm\u001d#ve&tw-Q;uQ\u0016tG/[2bi&|g\u000eF\u0002t\u0003gBq!!\u001e\u0002n\u0001\u0007\u0011$\u0001\nok6\u001cVoY2fgN4W\u000f\\!vi\"\u001c\bbBA=\u0001\u0011%\u0011\u0011H\u0001(m\u0016\u0014\u0018NZ=O_:\u0014V\r\u001e:jC\ndW-Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rC\u0004\u0002~\u0001!I!a \u0002\u001d\r\u0014X-\u0019;f'\u0016dWm\u0019;peR\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\u0016\u0002\u000f9,Go^8sW&!\u00111RAC\u0005!\u0019V\r\\3di>\u0014\b")
public class GssapiAuthenticationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final int numThreads;
    private final ExecutorService kafka$server$GssapiAuthenticationTest$$executor;
    private final Properties clientConfig;
    private InetSocketAddress serverAddr;
    private final MockTime time;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int failedAuthenticationDelayMs;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup$class.jaasClientLoginModule$default$2(this);
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private int numThreads() {
        return this.numThreads;
    }

    public ExecutorService kafka$server$GssapiAuthenticationTest$$executor() {
        return this.kafka$server$GssapiAuthenticationTest$$executor;
    }

    private Properties clientConfig() {
        return this.clientConfig;
    }

    private InetSocketAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetSocketAddress x$1) {
        this.serverAddr = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private int failedAuthenticationDelayMs() {
        return this.failedAuthenticationDelayMs;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        this.serverConfig().put(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().put(KafkaConfig$.MODULE$.FailedAuthenticationDelayMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.failedAuthenticationDelayMs())).toString());
        super.setUp();
        this.serverAddr_$eq(new InetSocketAddress("localhost", ((KafkaServer)this.servers().head()).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))));
        this.clientConfig().put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        this.clientConfig().put("sasl.mechanism", this.kafkaClientSaslMechanism());
        this.clientConfig().put("sasl.jaas.config", this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        this.clientConfig().put("connections.max.idle.ms", "5000");
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$server$GssapiAuthenticationTest$$executor().shutdownNow();
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testRequestIsAReplay() {
        int successfulAuthsPerThread = 10;
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numThreads()).map((Function1)new Serializable(this, successfulAuthsPerThread){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GssapiAuthenticationTest $outer;
            public final int successfulAuthsPerThread$1;

            public final Future<?> apply(int x$1) {
                return this.$outer.kafka$server$GssapiAuthenticationTest$$executor().submit(new Runnable(this){
                    private final /* synthetic */ $anonfun$1 $outer;

                    public void run() {
                        this.$outer.kafka$server$GssapiAuthenticationTest$$anonfun$$$outer().kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(this.$outer.successfulAuthsPerThread$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GssapiAuthenticationTest kafka$server$GssapiAuthenticationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulAuthsPerThread$1 = successfulAuthsPerThread$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Future<?> x$2) {
                return x$2.get(60L, TimeUnit.SECONDS);
            }
        });
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "failed-authentication-total"));
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "successful-authentication-total");
        Assert.assertTrue((String)new StringBuilder().append((Object)"Too few authentications: ").append((Object)BoxesRunTime.boxToLong((long)successfulAuths)).toString(), (successfulAuths > (long)(successfulAuthsPerThread * this.numThreads()) ? 1 : 0) != 0);
    }

    @Test
    public void testServerNotFoundInKerberosDatabase() {
        String jaasConfig = this.clientConfig().getProperty("sasl.jaas.config");
        String invalidServiceConfig = jaasConfig.replace("serviceName=\"kafka\"", "serviceName=\"invalid-service\"");
        this.clientConfig().put("sasl.jaas.config", invalidServiceConfig);
        this.clientConfig().put("sasl.kerberos.service.name", "invalid-service");
        this.verifyNonRetriableAuthenticationFailure();
    }

    @Test
    public void testServerAuthenticationFailure() {
        String clientLoginContext = this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), (Option<String>)new Some((Object)"another-kafka-service"));
        Properties configOverrides = new Properties();
        configOverrides.setProperty("sasl.jaas.config", clientLoginContext);
        Properties x$3 = configOverrides;
        ByteArrayDeserializer x$4 = this.createConsumer$default$1();
        ByteArrayDeserializer x$5 = this.createConsumer$default$2();
        List<String> x$6 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$4, x$5, x$3, x$6);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        long startMs = System.currentTimeMillis();
        try {
            consumer.poll(Duration.ofMillis(50L));
            Assert.fail();
        }
        catch (SaslAuthenticationException saslAuthenticationException) {}
        long endMs = System.currentTimeMillis();
        Predef$.MODULE$.require(endMs - startMs < (long)this.failedAuthenticationDelayMs(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed authentication must not be delayed on the client";
            }
        });
        consumer.close();
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(int numSuccessfulAuths) {
        Selector selector = this.createSelector();
        try {
            int actualSuccessfulAuths = 0;
            while (actualSuccessfulAuths < numSuccessfulAuths) {
                String nodeId = ((Object)BoxesRunTime.boxToInteger((int)actualSuccessfulAuths)).toString();
                selector.connect(nodeId, this.serverAddr(), 1024, 1024);
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, selector, nodeId){
                    public static final long serialVersionUID = 0L;
                    private final Selector selector$1;
                    private final String nodeId$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.selector$1.poll(100L);
                        ChannelState disconnectState = (ChannelState)this.selector$1.disconnected().get(this.nodeId$1);
                        if (disconnectState != null) {
                            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication failed with exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{disconnectState.exception()})), (Object)ChannelState.State.AUTHENTICATE, (Object)disconnectState.state());
                        }
                        return this.selector$1.isChannelReady(this.nodeId$1) || disconnectState != null;
                    }
                    {
                        this.selector$1 = selector$1;
                        this.nodeId$1 = nodeId$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Client not ready or disconnected within timeout";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                if (selector.isChannelReady(nodeId)) {
                    ++actualSuccessfulAuths;
                }
                selector.close(nodeId);
            }
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        selector.close();
    }

    private void verifyNonRetriableAuthenticationFailure() {
        Selector selector = this.createSelector();
        String nodeId = "1";
        selector.connect(nodeId, this.serverAddr(), 1024, 1024);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, selector, nodeId){
            public static final long serialVersionUID = 0L;
            private final Selector selector$2;
            private final String nodeId$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.selector$2.poll(100L);
                ChannelState disconnectState = (ChannelState)this.selector$2.disconnected().get(this.nodeId$2);
                if (disconnectState != null) {
                    Assert.assertEquals((Object)ChannelState.State.AUTHENTICATION_FAILED, (Object)disconnectState.state());
                }
                return disconnectState != null;
            }
            {
                this.selector$2 = selector$2;
                this.nodeId$2 = nodeId$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Client not disconnected within timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private Selector createSelector() {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig((Map)this.clientConfig()), null, (String)this.kafkaClientSaslMechanism(), (Time)this.time(), (boolean)true);
        return NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder, (Time)this.time());
    }

    public GssapiAuthenticationTest() {
        SaslSetup$class.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "GSSAPI";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GSSAPI"}));
        this.numThreads = 10;
        this.kafka$server$GssapiAuthenticationTest$$executor = Executors.newFixedThreadPool(this.numThreads());
        this.clientConfig = new Properties();
        this.time = new MockTime(10L);
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.failedAuthenticationDelayMs = 2000;
    }
}

