/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class AdminUtils$
implements Logging {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map;
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication factor: ", " larger than available brokers: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicationFactor), BoxesRunTime.boxToInteger((int)brokerMetadatas.size())})));
        }
        if (brokerMetadatas.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BrokerMetadata x$1) {
                return x$1.rack().isEmpty();
            }
        })) {
            map = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Seq<Object>)((Seq)brokerMetadatas.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(BrokerMetadata x$2) {
                    return x$2.id();
                }
            }, Seq$.MODULE$.canBuildFrom())), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(BrokerMetadata x$3) {
                    return x$3.rack().isEmpty();
                }
            })) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
            }
            map = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)new Serializable(replicationFactor, ret, brokerArray, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$1;
            private final scala.collection.mutable.Map ret$1;
            public final int[] brokerArray$1;
            private final int startIndex$1;
            private final IntRef currentPartitionId$1;
            public final IntRef nextReplicaShift$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$1.elem > 0 && this.currentPartitionId$1.elem % this.brokerArray$1.length == 0) {
                    ++this.nextReplicaShift$1.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$1.elem + this.startIndex$1) % this.brokerArray$1.length;
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerArray$1[firstReplicaIndex]}));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$1 - 1).foreach((Function1)new Serializable(this, firstReplicaIndex, replicaBuffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackUnaware.1 $outer;
                    private final int firstReplicaIndex$1;
                    private final ArrayBuffer replicaBuffer$1;

                    public final ArrayBuffer<Object> apply(int j) {
                        return this.replicaBuffer$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.$outer.brokerArray$1[AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$1, this.$outer.nextReplicaShift$1.elem, j, this.$outer.brokerArray$1.length)]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$1 = firstReplicaIndex$1;
                        this.replicaBuffer$1 = replicaBuffer$1;
                    }
                });
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)this.currentPartitionId$1.elem), (Object)replicaBuffer);
                ++this.currentPartitionId$1.elem;
            }
            {
                this.replicationFactor$1 = replicationFactor$1;
                this.ret$1 = ret$1;
                this.brokerArray$1 = brokerArray$1;
                this.startIndex$1 = startIndex$1;
                this.currentPartitionId$1 = currentPartitionId$1;
                this.nextReplicaShift$1 = nextReplicaShift$1;
            }
        });
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((TraversableOnce)brokerMetadatas.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.x();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)rack);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)new Serializable(replicationFactor, brokerRackMap, numRacks, arrangedBrokerList, numBrokers, ret, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$2;
            public final scala.collection.immutable.Map brokerRackMap$1;
            public final int numRacks$1;
            public final IndexedSeq arrangedBrokerList$1;
            public final int numBrokers$1;
            private final scala.collection.mutable.Map ret$2;
            private final int startIndex$2;
            private final IntRef currentPartitionId$2;
            public final IntRef nextReplicaShift$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$2.elem > 0 && this.currentPartitionId$2.elem % this.arrangedBrokerList$1.size() == 0) {
                    ++this.nextReplicaShift$2.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$2.elem + this.startIndex$2) % this.arrangedBrokerList$1.size();
                int leader = BoxesRunTime.unboxToInt((Object)this.arrangedBrokerList$1.apply(firstReplicaIndex));
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                Set racksWithReplicas = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.brokerRackMap$1.apply((Object)BoxesRunTime.boxToInteger((int)leader))}));
                Set brokersWithReplicas = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                IntRef k = IntRef.create((int)0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$2 - 1).foreach$mVc$sp((Function1)new Serializable(this, firstReplicaIndex, replicaBuffer, racksWithReplicas, brokersWithReplicas, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackAware.1 $outer;
                    private final int firstReplicaIndex$2;
                    private final ArrayBuffer replicaBuffer$2;
                    private final Set racksWithReplicas$1;
                    private final Set brokersWithReplicas$1;
                    private final IntRef k$1;

                    public final void apply(int _) {
                        this.apply$mcVI$sp(_);
                    }

                    public void apply$mcVI$sp(int _) {
                        boolean done = false;
                        while (!done) {
                            int broker = BoxesRunTime.unboxToInt((Object)this.$outer.arrangedBrokerList$1.apply(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$2, this.$outer.nextReplicaShift$2.elem * this.$outer.numRacks$1, this.k$1.elem, this.$outer.arrangedBrokerList$1.size())));
                            String rack = (String)this.$outer.brokerRackMap$1.apply((Object)BoxesRunTime.boxToInteger((int)broker));
                            if (!(this.racksWithReplicas$1.contains((Object)rack) && this.racksWithReplicas$1.size() != this.$outer.numRacks$1 || this.brokersWithReplicas$1.contains((Object)BoxesRunTime.boxToInteger((int)broker)) && this.brokersWithReplicas$1.size() != this.$outer.numBrokers$1)) {
                                this.replicaBuffer$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                                this.racksWithReplicas$1.$plus$eq((Object)rack);
                                this.brokersWithReplicas$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                                done = true;
                            }
                            ++this.k$1.elem;
                        }
                        return;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$2 = firstReplicaIndex$2;
                        this.replicaBuffer$2 = replicaBuffer$2;
                        this.racksWithReplicas$1 = racksWithReplicas$1;
                        this.brokersWithReplicas$1 = brokersWithReplicas$1;
                        this.k$1 = k$1;
                    }
                });
                this.ret$2.put((Object)BoxesRunTime.boxToInteger((int)this.currentPartitionId$2.elem), (Object)replicaBuffer);
                ++this.currentPartitionId$2.elem;
            }
            {
                this.replicationFactor$2 = replicationFactor$2;
                this.brokerRackMap$1 = brokerRackMap$1;
                this.numRacks$1 = numRacks$1;
                this.arrangedBrokerList$1 = arrangedBrokerList$1;
                this.numBrokers$1 = numBrokers$1;
                this.ret$2 = ret$2;
                this.startIndex$2 = startIndex$2;
                this.currentPartitionId$2 = currentPartitionId$2;
                this.nextReplicaShift$2 = nextReplicaShift$2;
            }
        });
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterator<Object>> apply(Tuple2<String, Seq<Object>> x0$1) {
                Tuple2<String, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String rack = (String)tuple2._1();
                    Seq brokers = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)rack, (Object)brokers.toIterator());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class))).sorted((Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((TraversableLike)brokerRackMap.toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    String rack = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)rack, (Object)BoxesRunTime.boxToInteger((int)id));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String rack;
                    String string = rack = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Seq<Tuple2<String, Object>>> x0$4) {
                Tuple2<String, Seq<Tuple2<String, Object>>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String rack = (String)tuple2._1();
                    Seq rackAndIdList = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)rack, ((SeqLike)rackAndIdList.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<String, Object> x0$5) {
                            Tuple2<String, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                int id;
                                int n = id = tuple2._2$mcI$sp();
                                return n;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
    }
}

