/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005##A\u0006ce>\\WM]\"pk:$X#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\u0007%sG\u000f\u0003\u0004\u001b\u0001\u0001\u0006IaE\u0001\rEJ|7.\u001a:D_VtG\u000f\t\u0005\u00069\u0001!\t\"H\u0001\u0011aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012,\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\")q\u0005\u0001C\t;\u0005\u00012m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0005\u0006S\u00011\tBK\u0001\u0017GJ,\u0017\r^3Rk>$\u0018\rV3ti\u000ec\u0017.\u001a8ugR\u00191F\f\u001c\u0011\u0005%a\u0013BA\u0017\u0003\u0005A\tVo\u001c;b)\u0016\u001cHo\u00117jK:$8\u000fC\u00030Q\u0001\u0007\u0001'A\u0003u_BL7\r\u0005\u00022i9\u0011ACM\u0005\u0003gU\ta\u0001\u0015:fI\u00164\u0017BA\u00136\u0015\t\u0019T\u0003C\u00038Q\u0001\u0007\u0001(\u0001\u0006mK\u0006$WM\u001d(pI\u0016\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\rM,'O^3s\u0013\ti$HA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB \u0001\u0005\u0004%\tAE\u0001\u0015I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1\t\r\u0005\u0003\u0001\u0015!\u0003\u0014\u0003U!WMZ1vYR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\u0002Bqa\u0011\u0001C\u0002\u0013\u0005!#\u0001\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3s#V|G/\u0019\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\n\u0002+\u0011,g-Y;mi\u000e{gn];nKJ\fVo\u001c;bA!9q\t\u0001b\u0001\n\u0003\u0011\u0012a\u00053fM\u0006,H\u000e\u001e*fcV,7\u000f^)v_R\f\u0007BB%\u0001A\u0003%1#\u0001\u000beK\u001a\fW\u000f\u001c;SKF,Xm\u001d;Rk>$\u0018\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001\u001e\u0003\u0019!x\u000e]5dc!1Q\n\u0001Q\u0001\ny\tq\u0001^8qS\u000e\f\u0004\u0005C\u00058\u0001\u0001\u0007\t\u0019!C\u0001\u001fV\t\u0001\bC\u0005R\u0001\u0001\u0007\t\u0019!C\u0001%\u0006qA.Z1eKJtu\u000eZ3`I\u0015\fHCA*W!\t!B+\u0003\u0002V+\t!QK\\5u\u0011\u001d9\u0006+!AA\u0002a\n1\u0001\u001f\u00132\u0011\u0019I\u0006\u0001)Q\u0005q\u0005YA.Z1eKJtu\u000eZ3!\u0011%Y\u0006\u00011AA\u0002\u0013\u0005q*\u0001\u0007g_2dwn^3s\u001d>$W\rC\u0005^\u0001\u0001\u0007\t\u0019!C\u0001=\u0006\u0001bm\u001c7m_^,'OT8eK~#S-\u001d\u000b\u0003'~Cqa\u0016/\u0002\u0002\u0003\u0007\u0001\b\u0003\u0004b\u0001\u0001\u0006K\u0001O\u0001\u000eM>dGn\\<fe:{G-\u001a\u0011\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0003!\u0017\u0001E9v_R\fG+Z:u\u00072LWM\u001c;t+\u0005Y\u0003\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0001h\u0003Q\tXo\u001c;b)\u0016\u001cHo\u00117jK:$8o\u0018\u0013fcR\u00111\u000b\u001b\u0005\b/\u0016\f\t\u00111\u0001,\u0011\u0019Q\u0007\u0001)Q\u0005W\u0005\t\u0012/^8uCR+7\u000f^\"mS\u0016tGo\u001d\u0011\t\u000b1\u0004A\u0011I7\u0002\u000bM,G/\u00169\u0015\u0003MC#a[8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018!\u00026v]&$(\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002wc\n1!)\u001a4pe\u0016DQ\u0001\u001f\u0001\u0005\u00025\fQ\u0004^3tiRC'o\u001c;uY\u0016$\u0007K]8ek\u000e,'oQ8ogVlWM\u001d\u0015\u0003oj\u0004\"\u0001]>\n\u0005q\f(\u0001\u0002+fgRDQA \u0001\u0005\u00025\fq\u0005^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u0014xJ^3se&$W-\u00168uQJ|G\u000f\u001e7fI\"\u0012QP\u001f\u0005\u0007\u0003\u0007\u0001A\u0011A7\u0002/Q,7\u000f^)v_R\fwJ^3se&$W\rR3mKR,\u0007fAA\u0001u\"1\u0011\u0011\u0002\u0001\u0005\u00025\fA\u0003^3tiRC'o\u001c;uY\u0016$'+Z9vKN$\bfAA\u0004u\u0002")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int brokerCount;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private final String topic1;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaServer var2);

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = this.createTopic(this.topic1(), numPartitions, this.brokerCount(), this.createTopic$default$4());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        int x$1 = numRecords;
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(x$1, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$3 = true;
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        qual$2.verifyProduceThrottle(x$3, x$4);
        QuotaTestClients qual$3 = this.quotaTestClients();
        int x$5 = produced;
        boolean x$6 = qual$3.consumeUntilThrottled$default$2();
        qual$3.consumeUntilThrottled(x$5, x$6);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$4.verifyConsumeThrottle$default$2();
        qual$4.verifyConsumeThrottle(x$7, x$8);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$5 = this.quotaTestClients();
        long x$9 = Long.MAX_VALUE;
        long x$10 = Long.MAX_VALUE;
        double x$11 = 2.147483647E9;
        KafkaServer x$12 = qual$5.waitForQuotaUpdate$default$4();
        qual$5.waitForQuotaUpdate(x$9, x$10, x$11, x$12);
        int numRecords = 1000;
        QuotaTestClients qual$6 = this.quotaTestClients();
        int x$13 = numRecords;
        boolean x$14 = qual$6.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$6.produceUntilThrottled(x$13, x$14));
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$15 = false;
        boolean x$16 = qual$7.verifyProduceThrottle$default$2();
        qual$7.verifyProduceThrottle(x$15, x$16);
        QuotaTestClients qual$8 = this.quotaTestClients();
        int x$17 = numRecords;
        boolean x$18 = qual$8.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$8.consumeUntilThrottled(x$17, x$18));
        QuotaTestClients qual$9 = this.quotaTestClients();
        boolean x$19 = false;
        boolean x$20 = qual$9.verifyConsumeThrottle$default$2();
        qual$9.verifyConsumeThrottle(x$19, x$20);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$10 = this.quotaTestClients();
        long x$21 = Long.MAX_VALUE;
        long x$22 = Long.MAX_VALUE;
        double x$23 = 2.147483647E9;
        KafkaServer x$24 = qual$10.waitForQuotaUpdate$default$4();
        qual$10.waitForQuotaUpdate(x$21, x$22, x$23, x$24);
        int numRecords = 1000;
        QuotaTestClients qual$11 = this.quotaTestClients();
        int x$25 = numRecords;
        boolean x$26 = qual$11.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$11.produceUntilThrottled(x$25, x$26));
        QuotaTestClients qual$12 = this.quotaTestClients();
        boolean x$27 = false;
        boolean x$28 = qual$12.verifyProduceThrottle$default$2();
        qual$12.verifyProduceThrottle(x$27, x$28);
        QuotaTestClients qual$13 = this.quotaTestClients();
        int x$29 = numRecords;
        boolean x$30 = qual$13.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$13.consumeUntilThrottled(x$29, x$30));
        QuotaTestClients qual$14 = this.quotaTestClients();
        boolean x$31 = false;
        boolean x$32 = qual$14.verifyConsumeThrottle$default$2();
        qual$14.verifyConsumeThrottle(x$31, x$32);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$15 = this.quotaTestClients();
        int x$33 = numRecords;
        boolean x$34 = qual$15.produceUntilThrottled$default$2();
        int produced = qual$15.produceUntilThrottled(x$33, x$34);
        QuotaTestClients qual$16 = this.quotaTestClients();
        boolean x$35 = true;
        boolean x$36 = qual$16.verifyProduceThrottle$default$2();
        qual$16.verifyProduceThrottle(x$35, x$36);
        this.quotaTestClients().consumer().seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$17 = this.quotaTestClients();
        int x$37 = numRecords + produced;
        boolean x$38 = qual$17.consumeUntilThrottled$default$2();
        qual$17.consumeUntilThrottled(x$37, x$38);
        QuotaTestClients qual$18 = this.quotaTestClients();
        boolean x$39 = true;
        boolean x$40 = qual$18.verifyConsumeThrottle$default$2();
        qual$18.verifyConsumeThrottle(x$39, x$40);
    }

    @Test
    public void testThrottledRequest() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        QuotaTestClients qual$19 = this.quotaTestClients();
        long x$41 = Long.MAX_VALUE;
        long x$42 = Long.MAX_VALUE;
        double x$43 = 0.1;
        KafkaServer x$44 = qual$19.waitForQuotaUpdate$default$4();
        qual$19.waitForQuotaUpdate(x$41, x$42, x$43, x$44);
        KafkaConsumer<byte[], byte[]> consumer = this.quotaTestClients().consumer();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.quotaTestClients().exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(Duration.ofMillis(100L));
            KafkaMetric throttleMetric = this.quotaTestClients().throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            throttled = throttleMetric != null && QuotaTestClients$.MODULE$.metricValue((Metric)throttleMetric) > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        KafkaMetric exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)exemptMetric);
        Assert.assertTrue((String)"Exempt requests not recorded", (QuotaTestClients$.MODULE$.metricValue((Metric)exemptMetric) > 0.0 ? 1 : 0) != 0);
    }

    public BaseQuotaTest() {
        this.brokerCount = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "-1");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.topic1 = "topic-1";
    }
}

