/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.util.Arrays;
import kafka.coordinator.group.MemberMetadata;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u0013\t\u0011R*Z7cKJlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\u0002]\tqa\u001a:pkBLE-F\u0001\u0019!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u0015;sS:<\u0007BB\u0011\u0001A\u0003%\u0001$\u0001\u0005he>,\b/\u00133!\u0011\u001d\u0019\u0003A1A\u0005\u0002\u0011\nqb\u001a:pkBLen\u001d;b]\u000e,\u0017\nZ\u000b\u0002KA\u00191B\n\r\n\u0005\u001db!\u0001B*p[\u0016Da!\u000b\u0001!\u0002\u0013)\u0013\u0001E4s_V\u0004\u0018J\\:uC:\u001cW-\u00133!\u0011\u001dY\u0003A1A\u0005\u0002]\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\r\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u0018\u0001\u0005\u0004%\taF\u0001\u000bG2LWM\u001c;I_N$\bBB\u0019\u0001A\u0003%\u0001$A\u0006dY&,g\u000e\u001e%pgR\u0004\u0003bB\u001a\u0001\u0005\u0004%\taF\u0001\t[\u0016l'-\u001a:JI\"1Q\u0007\u0001Q\u0001\na\t\u0011\"\\3nE\u0016\u0014\u0018\n\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001/\u0005a\u0001O]8u_\u000e|G\u000eV=qK\"1\u0011\b\u0001Q\u0001\na\tQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003bB\u001e\u0001\u0005\u0004%\t\u0001P\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5/F\u0001>!\tYa(\u0003\u0002@\u0019\t\u0019\u0011J\u001c;\t\r\u0005\u0003\u0001\u0015!\u0003>\u0003M\u0011XMY1mC:\u001cW\rV5nK>,H/T:!\u0011\u001d\u0019\u0005A1A\u0005\u0002q\n\u0001c]3tg&|g\u000eV5nK>,H/T:\t\r\u0015\u0003\u0001\u0015!\u0003>\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000f\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u001ei\u0016\u001cH/T1uG\",7oU;qa>\u0014H/\u001a3Qe>$xnY8mgR\t\u0011\n\u0005\u0002\f\u0015&\u00111\n\u0004\u0002\u0005+:LG\u000f\u000b\u0002G\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002%\u0006\u0019qN]4\n\u0005Q{%\u0001\u0002+fgRDQA\u0016\u0001\u0005\u0002!\u000bA\u0004^3tiZ{G/\u001a$peB\u0013XMZ3se\u0016$\u0007K]8u_\u000e|G\u000e\u000b\u0002V\u001b\")\u0011\f\u0001C\u0001\u0011\u0006aA/Z:u\u001b\u0016$\u0018\rZ1uC\"\u0012\u0001,\u0014\u0005\u00069\u0002!\t\u0001S\u0001(i\u0016\u001cH/T3uC\u0012\fG/\u0019*bSN,7o\u00148V]N,\b\u000f]8si\u0016$\u0007K]8u_\u000e|G\u000e\u000b\u0003\\\u001bz{\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003\u0001\u0004\"!Y5\u000f\u0005\t<gBA2g\u001b\u0005!'BA3\t\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002i\u0019\u00059\u0001/Y2lC\u001e,\u0017B\u00016l\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003Q2AQ!\u001c\u0001\u0005\u0002!\u000bA\u0005^3tiZ{G/\u001a*bSN,7o\u00148O_N+\b\u000f]8si\u0016$\u0007K]8u_\u000e|Gn\u001d\u0015\u0005Y6sv\fC\u0003q\u0001\u0011\u0005\u0001*A\u000euKN$\b*Y:WC2LGm\u0012:pkBLen\u001d;b]\u000e,\u0017\n\u001a\u0015\u0003_6\u0003")
public class MemberMetadataTest {
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String clientId;
    private final String clientHost;
    private final String memberId;
    private final String protocolType;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;

    public String groupId() {
        return this.groupId;
    }

    public Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public String memberId() {
        return this.memberId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Test
    public void testMatchesSupportedProtocols() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertTrue((boolean)member.matches(protocols));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()))}))));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
    }

    @Test
    public void testVoteForPreferredProtocol() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertEquals((Object)"range", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))));
        Assert.assertEquals((Object)"roundrobin", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah", "roundrobin"}))));
    }

    @Test
    public void testMetadata() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()), member.metadata("range")));
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()), member.metadata("roundrobin")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMetadataRaisesOnUnsupportedProtocol() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        member.metadata("blah");
        Assert.fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVoteRaisesOnNoSupportedProtocols() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah"})));
        Assert.fail();
    }

    @Test
    public void testHasValidGroupInstanceId() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertTrue((boolean)member.isStaticMember());
        Assert.assertEquals(this.groupInstanceId(), (Object)member.groupInstanceId());
    }

    public MemberMetadataTest() {
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.memberId = "memberId";
        this.protocolType = "consumer";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

