/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.nio.ByteBuffer;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.AbstractCoordinatorConcurrencyTest;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionCoordinatorConcurrencyTest$;
import kafka.coordinator.transaction.TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$;
import kafka.coordinator.transaction.TransactionCoordinatorConcurrencyTest$EndTxnOperation$;
import kafka.coordinator.transaction.TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.log.Log;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rUf\u0001B\u0001\u0003\u0001%\u0011Q\u0005\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\"p]\u000e,(O]3oGf$Vm\u001d;\u000b\u0005\r!\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0002\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000b!\rYABD\u0007\u0002\t%\u0011Q\u0002\u0002\u0002#\u0003\n\u001cHO]1di\u000e{wN\u001d3j]\u0006$xN]\"p]\u000e,(O]3oGf$Vm\u001d;\u0011\u0005=AcB\u0001\t\u001a\u001d\t\t\u0002D\u0004\u0002\u0013/9\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!!\u0002\u0004\n\u0005\r!q!\u0002\u000e\u0003\u0011\u0003Y\u0012!\n+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:D_:\u001cWO\u001d:f]\u000eLH+Z:u!\taR$D\u0001\u0003\r\u0015\t!\u0001#\u0001\u001f'\tir\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\u0005\u0006Mu!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m1A!K\u000f\u0001U\tYAK]1og\u0006\u001cG/[8o'\rAsd\u000b\t\u0003Y=r!!E\u0017\n\u00059\"\u0011AI!cgR\u0014\u0018m\u0019;D_>\u0014H-\u001b8bi>\u00148i\u001c8dkJ\u0014XM\\2z)\u0016\u001cH/\u0003\u00021c\t\t2i\\8sI&t\u0017\r^8s\u001b\u0016l'-\u001a:\u000b\u00059\"\u0001\u0002C\u001a)\u0005\u000b\u0007I\u0011\u0001\u001b\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012!\u000e\t\u0003mer!\u0001I\u001c\n\u0005a\n\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0011\t\u0011uB#\u0011!Q\u0001\nU\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0011\t\u0011}B#\u0011!Q\u0001\n\u0001\u000b!\u0002\u001d:pIV\u001cWM]%e!\t\u0001\u0013)\u0003\u0002CC\t!Aj\u001c8h\u0011!!\u0005F!A!\u0002\u0013)\u0015\u0001\u0002;j[\u0016\u0004\"A\u0012)\u000e\u0003\u001dS!\u0001S%\u0002\u000bU$\u0018\u000e\\:\u000b\u0005)[\u0015AB2p[6|gN\u0003\u0002\b\u0019*\u0011QJT\u0001\u0007CB\f7\r[3\u000b\u0003=\u000b1a\u001c:h\u0013\t\tvI\u0001\u0005N_\u000e\\G+[7f\u0011\u00151\u0003\u0006\"\u0001T)\u0011!fk\u0016-\u0011\u0005UCS\"A\u000f\t\u000bM\u0012\u0006\u0019A\u001b\t\u000b}\u0012\u0006\u0019\u0001!\t\u000b\u0011\u0013\u0006\u0019A#\t\u000fiC#\u0019!C\u00017\u0006\u0011B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3t+\u0005a\u0006c\u0001\u0011^?&\u0011a,\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003A\u0001L!!Y\u0011\u0003\t\tKH/\u001a\u0005\u0007G\"\u0002\u000b\u0011\u0002/\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm\u001d\u0011\t\u000f\u0015D\u0003\u0019!C\u0001M\u0006)QM\u001c3fIV\tq\r\u0005\u0002!Q&\u0011\u0011.\t\u0002\b\u0005>|G.Z1o\u0011\u001dY\u0007\u00061A\u0005\u00021\f\u0011\"\u001a8eK\u0012|F%Z9\u0015\u00055\u0004\bC\u0001\u0011o\u0013\ty\u0017E\u0001\u0003V]&$\bbB9k\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0004BB:)A\u0003&q-\u0001\u0004f]\u0012,G\r\t\u0015\u0003eV\u0004\"\u0001\t<\n\u0005]\f#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000beDC\u0011\t>\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u000e\u0005\u0006M\u0001!\t\u0001 \u000b\u0002{B\u0011A\u0004\u0001\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005ia\u000e\u0016:b]N\f7\r^5p]N,\"!a\u0001\u0011\u0007\u0001\n)!C\u0002\u0002\b\u0005\u00121!\u00138u\u0011!\tY\u0001\u0001Q\u0001\n\u0005\r\u0011A\u00048Ue\u0006t7/Y2uS>t7\u000f\t\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003\u0003\t\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u0007\t\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u0011%\t9\u0002\u0001b\u0001\n\u0013\t\t!A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0004\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0003%!\bP\\\"p]\u001aLw-\u0006\u0002\u0002$A\u0019A$!\n\n\u0007\u0005\u001d\"AA\tUe\u0006t7/Y2uS>t7i\u001c8gS\u001eD\u0001\"a\u000b\u0001A\u0003%\u00111E\u0001\u000bibt7i\u001c8gS\u001e\u0004\u0003bCA\u0018\u0001\u0001\u0007\t\u0019!C\u0005\u0003c\ta\u0003\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0003g\u00012\u0001HA\u001b\u0013\r\t9D\u0001\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\"Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0003i!(/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\ri\u0017q\b\u0005\nc\u0006e\u0012\u0011!a\u0001\u0003gA\u0001\"a\u0011\u0001A\u0003&\u00111G\u0001\u0018iJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0002B1\"a\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002J\u0005yA\u000f\u001f8Ti\u0006$X-T1oC\u001e,'/\u0006\u0002\u0002LA\u0019A$!\u0014\n\u0007\u0005=#AA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\"Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0003M!\bP\\*uCR,W*\u00198bO\u0016\u0014x\fJ3r)\ri\u0017q\u000b\u0005\nc\u0006E\u0013\u0011!a\u0001\u0003\u0017B\u0001\"a\u0017\u0001A\u0003&\u00111J\u0001\u0011ibt7\u000b^1uK6\u000bg.Y4fe\u0002B1\"a\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002b\u00059B\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u000b\u0003\u0003G\u00022\u0001HA3\u0013\r\t9G\u0001\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\bbCA6\u0001\u0001\u0007\t\u0019!C\u0005\u0003[\n1\u0004\u001e=o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:`I\u0015\fHcA7\u0002p!I\u0011/!\u001b\u0002\u0002\u0003\u0007\u00111\r\u0005\t\u0003g\u0002\u0001\u0015)\u0003\u0002d\u0005AB\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0014!D1mY>\u0003XM]1uS>t7/\u0006\u0002\u0002|A1\u0011QPAB\u0003\u000fk!!a \u000b\u0007\u0005\u0005\u0015%\u0001\u0006d_2dWm\u0019;j_:LA!!\"\u0002\u0000\t\u00191+Z91\t\u0005%\u0015Q\u001c\t\u0007\u0003\u0017\u000bi)a7\u000e\u0003\u00011q!a$\u0001\u0003\u0003\t\tJ\u0001\u0007Uq:|\u0005/\u001a:bi&|g.\u0006\u0003\u0002\u0014\u0006\u00156\u0003BAG\u0003+\u0003B!a#\u0002\u0018&\u0019\u0011\u0011\u0014\u0007\u0003\u0013=\u0003XM]1uS>t\u0007b\u0002\u0014\u0002\u000e\u0012\u0005\u0011Q\u0014\u000b\u0003\u0003?\u0003b!a#\u0002\u000e\u0006\u0005\u0006\u0003BAR\u0003Kc\u0001\u0001\u0002\u0005\u0002(\u00065%\u0019AAU\u0005\u0005\u0011\u0016\u0003BAV\u0003c\u00032\u0001IAW\u0013\r\ty+\t\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u00131W\u0005\u0004\u0003k\u000b#aA!os\"Q\u0011\u0011XAG\u0001\u0004%\t!a/\u0002\rI,7/\u001e7u+\t\ti\fE\u0003!\u0003\u007f\u000b\t+C\u0002\u0002B\u0006\u0012aa\u00149uS>t\u0007BCAc\u0003\u001b\u0003\r\u0011\"\u0001\u0002H\u0006Q!/Z:vYR|F%Z9\u0015\u00075\fI\rC\u0005r\u0003\u0007\f\t\u00111\u0001\u0002>\"I\u0011QZAGA\u0003&\u0011QX\u0001\be\u0016\u001cX\u000f\u001c;!Q\r\tY-\u001e\u0005\t\u0003'\fi\t\"\u0001\u0002V\u0006q!/Z:vYR\u001c\u0015\r\u001c7cC\u000e\\GcA7\u0002X\"A\u0011\u0011\\Ai\u0001\u0004\t\t+A\u0001s!\u0011\t\u0019+!8\u0005\u0017\u0005}\u0007!!A\u0001\u0002\u000b\u0005\u0011\u0011\u001d\u0002\u0004?V\u001a\u0014\u0003BAr\u0003w\u0014b!!:\u0002j\u0006UhABAt\u0001\u0001\t\u0019O\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0002l\u0006EXBAAw\u0015\r\ty/S\u0001\taJ|Go\\2pY&!\u00111_Aw\u0005\u0019)%O]8sgB\u0019A$a>\n\u0007\u0005e(A\u0001\u000bJ]&$\bK]8ek\u000e,'/\u00133SKN,H\u000e\u001e\n\u0007\u0003{\fyPa\u0004\u0007\r\u0005\u001d\b\u0001AA~!\u0011\u0011\tAa\u0003\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\tA\u0001\\1oO*\u0011!\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u000e\t\r!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\u0011\u0011)Ba\u0002\u0002\u0005%|\u0017\u0002\u0002B\r\u0005'\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B!\b\u0001A\u0003%\u00111P\u0001\u000fC2dw\n]3sCRLwN\\:!\u0011%\u0011\t\u0003\u0001b\u0001\n\u0013\u0011\u0019#A\bbY2$&/\u00198tC\u000e$\u0018n\u001c8t+\t\u0011)\u0003E\u0003\u0003(\t5b\"\u0004\u0002\u0003*)!!1FA@\u0003\u001diW\u000f^1cY\u0016LAAa\f\u0003*\t\u00191+\u001a;\t\u0011\tM\u0002\u0001)A\u0005\u0005K\t\u0001#\u00197m)J\fgn]1di&|gn\u001d\u0011\t\u0013\t]\u0002A1A\u0005\n\te\u0012!\u0006;y]J+7m\u001c:eg\nK\b+\u0019:uSRLwN\\\u000b\u0003\u0005w\u0001\u0002\"! \u0003>\u0005\r!\u0011I\u0005\u0005\u0005\u007f\tyHA\u0002NCB\u0004bAa\n\u0003D\t\u001d\u0013\u0002\u0002B#\u0005S\u00111\"\u0011:sCf\u0014UO\u001a4feB!!\u0011\nB(\u001b\t\u0011YEC\u0002\u0003N%\u000baA]3d_J$\u0017\u0002\u0002B)\u0005\u0017\u0012AbU5na2,'+Z2pe\u0012D\u0001B!\u0016\u0001A\u0003%!1H\u0001\u0017ibt'+Z2pe\u0012\u001c()\u001f)beRLG/[8oA!9!\u0011\f\u0001\u0005B\tm\u0013!B:fiV\u0003H#A7)\t\t]#q\f\t\u0005\u0005C\u00129'\u0004\u0002\u0003d)\u0019!Q\r(\u0002\u000b),h.\u001b;\n\t\t%$1\r\u0002\u0007\u0005\u00164wN]3\t\u000f\t5\u0004\u0001\"\u0011\u0003\\\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0003l\tE\u0004\u0003\u0002B1\u0005gJAA!\u001e\u0003d\t)\u0011I\u001a;fe\"9!\u0011\u0010\u0001\u0005\u0002\tm\u0013A\b;fgR\u001cuN\\2veJ,g\u000e^$p_\u0012\u0004\u0016\r\u001e5TKF,XM\\2fQ\u0011\u00119H! \u0011\t\t\u0005$qP\u0005\u0005\u0005\u0003\u0013\u0019G\u0001\u0003UKN$\bb\u0002BC\u0001\u0011\u0005!1L\u0001\u001ei\u0016\u001cHoQ8oGV\u0014(/\u001a8u%\u0006tGm\\7TKF,XM\\2fg\"\"!1\u0011B?\u0011\u001d\u0011Y\t\u0001C\u0001\u00057\n!\u0005^3ti\u000e{gnY;se\u0016tG\u000fT8bIVsGn\\1e!\u0006\u0014H/\u001b;j_:\u001c\b\u0006\u0002BE\u0005{BqA!%\u0001\t\u0003\u0011Y&A\u0012uKN$8i\u001c8dkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>tW\t\u001f9je\u0006$\u0018n\u001c8)\t\t=%Q\u0010\u0005\b\u0005/\u0003A\u0011\tB.\u0003A)g.\u00192mK\u000e{W\u000e\u001d7fi&|g\u000eC\u0004\u0003\u001c\u0002!IA!(\u0002#1|\u0017\rZ+oY>\fG-Q2uS>t7\u000f\u0006\u0004\u0003 \n%&q\u0016\t\u0006m\t\u0005&1U\u0005\u0004\u0005_Y\u0004c\u0001\u0017\u0003&&\u0019!qU\u0019\u0003\r\u0005\u001bG/[8o\u0011!\u0011YK!'A\u0002\t5\u0016\u0001\u00059beRLG/[8ogR{Gj\\1e!\u00151$\u0011UA\u0002\u0011!\u0011\tL!'A\u0002\t5\u0016A\u00059beRLG/[8ogR{WK\u001c7pC\u0012DqA!.\u0001\t\u0013\u00119,\u0001\nde\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003\u0002B]\u0005w\u0003BA\u000eBQ\u001d!9!Q\u0018BZ\u0001\u0004)\u0014!\u0003;y]B\u0013XMZ5y\u0011\u001d\u0011\t\r\u0001C\u0005\u0005\u0007\f\u0011C^3sS\u001aLHK]1og\u0006\u001cG/[8o)\u0015i'Q\u0019Be\u0011\u001d\u00119Ma0A\u00029\t1\u0001\u001e=o\u0011!\u0011YMa0A\u0002\t5\u0017!D3ya\u0016\u001cG/\u001a3Ti\u0006$X\rE\u0002\u001d\u0005\u001fL1A!5\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003V\u0002!IAa6\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\t\te'\u0011\u001d\t\u0006A\u0005}&1\u001c\t\u00049\tu\u0017b\u0001Bp\u0005\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"9!q\u0019Bj\u0001\u0004q\u0001b\u0002Bs\u0001\u0011%!q]\u0001\u0013aJ,\u0007/\u0019:f)J\fgn]1di&|g\u000eF\u0002n\u0005SDqAa2\u0003d\u0002\u0007a\u0002C\u0004\u0003n\u0002!IAa<\u0002\u001bA\u0014X\r]1sKRCh\u000eT8h)\ri'\u0011\u001f\u0005\t\u0005g\u0014Y\u000f1\u0001\u0002\u0004\u0005Y\u0001/\u0019:uSRLwN\\%e\r\u0019\u00119\u0010\u0001\u0001\u0003z\n9\u0012J\\5u!J|G-^2fe&#w\n]3sCRLwN\\\n\u0005\u0005k\u0014Y\u0010\u0005\u0004\u0002\f\u00065\u0015Q\u001f\u0005\bM\tUH\u0011\u0001B\u0000)\t\u0019\t\u0001\u0005\u0003\u0002\f\nU\b\u0002CB\u0003\u0005k$\tea\u0002\u0002\u0007I,h\u000eF\u0002n\u0007\u0013AqAa2\u0004\u0004\u0001\u0007a\u0002\u0003\u0005\u0004\u000e\tUH\u0011IB\b\u00039\tw/Y5u\u0003:$g+\u001a:jMf$2!\\B\t\u0011\u001d\u00119ma\u0003A\u000291aa!\u0006\u0001\u0001\r]!aG!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:|\u0005/\u001a:bi&|gn\u0005\u0003\u0004\u0014\re\u0001CBAF\u0003\u001b\u000bI\u000fC\u0006\u0004\u001e\rM!\u0011!Q\u0001\n\r}\u0011A\u00039beRLG/[8ogB)aG!)\u0004\"A!11EB\u0013\u001b\u0005I\u0015bAB\u0014\u0013\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002\u0014\u0004\u0014\u0011\u000511\u0006\u000b\u0005\u0007[\u0019y\u0003\u0005\u0003\u0002\f\u000eM\u0001\u0002CB\u000f\u0007S\u0001\raa\b\t\u0011\r\u001511\u0003C!\u0007g!2!\\B\u001b\u0011\u001d\u00119m!\rA\u00029A\u0001b!\u0004\u0004\u0014\u0011\u00053\u0011\b\u000b\u0004[\u000em\u0002b\u0002Bd\u0007o\u0001\rA\u0004\u0004\u0007\u0007\u007f\u0001\u0001a!\u0011\u0003\u001f\u0015sG\r\u0016=o\u001fB,'/\u0019;j_:\u001cBa!\u0010\u0004\u001a!9ae!\u0010\u0005\u0002\r\u0015CCAB$!\u0011\tYi!\u0010\t\u0011\r\u00151Q\bC!\u0007\u0017\"2!\\B'\u0011\u001d\u00119m!\u0013A\u00029A\u0001b!\u0004\u0004>\u0011\u00053\u0011\u000b\u000b\u0004[\u000eM\u0003b\u0002Bd\u0007\u001f\u0002\rA\u0004\u0005\t\u0007/\u001ai\u0004\"\u0003\u0004Z\u0005\tBO]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0015\t\rm3q\r\t\u0005\u0007;\u001a\u0019'\u0004\u0002\u0004`)\u00191\u0011M%\u0002\u0011I,\u0017/^3tiNLAa!\u001a\u0004`\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\t\u001d7Q\u000ba\u0001\u001d\u0019111\u000e\u0001\u0001\u0007[\u0012a\u0003T8bIRCh\u000eU1si&$\u0018n\u001c8BGRLwN\\\n\u0007\u0007S\nyPa)\t\u0017\rE4\u0011\u000eB\u0001B\u0003%\u00111A\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\n\u001a\u0005\bM\r%D\u0011AB;)\u0011\u00199h!\u001f\u0011\t\u0005-5\u0011\u000e\u0005\t\u0007c\u001a\u0019\b1\u0001\u0002\u0004!A1QAB5\t\u0003\u0012Y\u0006\u0003\u0005\u0004\u0000\r%D\u0011\tB.\u0003\u0015\tw/Y5u\r\u0019\u0019\u0019\t\u0001\u0001\u0004\u0006\nARK\u001c7pC\u0012$\u0006P\u001c)beRLG/[8o\u0003\u000e$\u0018n\u001c8\u0014\r\r\u0005\u0015q BR\u0011-\u0019\th!!\u0003\u0002\u0003\u0006I!a\u0001\t\u000f\u0019\u001a\t\t\"\u0001\u0004\fR!1QRBH!\u0011\tYi!!\t\u0011\rE4\u0011\u0012a\u0001\u0003\u0007A!ba%\u0004\u0002\n\u0007I\u0011ABK\u0003)!\bP\u001c*fG>\u0014Hm]\u000b\u0003\u0005\u0003B\u0011b!'\u0004\u0002\u0002\u0006IA!\u0011\u0002\u0017QDhNU3d_J$7\u000f\t\u0005\t\u0007\u000b\u0019\t\t\"\u0011\u0003\\!A1qPBA\t\u0003\u0012YF\u0002\u0004\u0004\"\u0002\u000111\u0015\u0002\u0019\u000bb\u0004\u0018N]3Ue\u0006t7/Y2uS>t7/Q2uS>t7CBBP\u0003\u007f\u0014\u0019\u000bC\u0006\u0004(\u000e}%\u0011!Q\u0001\n\te\u0016\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001c\bb\u0002\u0014\u0004 \u0012\u000511\u0016\u000b\u0005\u0007[\u001by\u000b\u0005\u0003\u0002\f\u000e}\u0005\u0002CBT\u0007S\u0003\rA!/\t\u0011\r\u00151q\u0014C!\u00057B\u0001ba \u0004 \u0012\u0005#1\f")
public class TransactionCoordinatorConcurrencyTest
extends AbstractCoordinatorConcurrencyTest<Transaction> {
    private final int nTransactions = this.nThreads() * 10;
    private final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    private final int numPartitions = this.nThreads() * 5;
    private final TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
    private TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    private TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    private TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Seq<TxnOperation<? extends Object>> allOperations = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnOperation[]{new InitProducerIdOperation(this), new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)})))), new EndTxnOperation(this)}));
    private final scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Tuple2<Object, ArrayBuffer<SimpleRecord>> apply(int i) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
    }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());

    private int nTransactions() {
        return this.nTransactions;
    }

    public int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    public TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig;
    }

    public TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(TransactionCoordinator x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator = x$1;
    }

    public TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(TransactionStateManager x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager = x$1;
    }

    private TransactionMarkerChannelManager txnMarkerChannelManager() {
        return this.txnMarkerChannelManager;
    }

    private void txnMarkerChannelManager_$eq(TransactionMarkerChannelManager x$1) {
        this.txnMarkerChannelManager = x$1;
    }

    private Seq<TxnOperation<? extends Object>> allOperations() {
        return this.allOperations;
    }

    public scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    }

    private Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition() {
        return this.txnRecordsByPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), (ReplicaManager)this.replicaManager(), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Time)this.time(), new Metrics()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().addLoadedTransactionsToCache(i, this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int producerId = 11;
        ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)pidManager.generateProducerId())).andReturn((Object)BoxesRunTime.boxToLong((long)producerId)).anyTimes();
        String x$7 = "txn-purgatory-name";
        MockTimer x$8 = new MockTimer();
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory txnMarkerPurgatory = new DelayedOperationPurgatory(x$7, (Timer)x$8, x$10, x$11, x$9, x$12);
        Node brokerNode = new Node(0, "host", 10);
        MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getPartitionLeaderEndpoint(EasyMock.anyString(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)brokerNode)).anyTimes();
        NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
        this.txnMarkerChannelManager_$eq(new TransactionMarkerChannelManager(this, txnMarkerPurgatory, metadataCache, networkClient){
            private final DelayedOperationPurgatory txnMarkerPurgatory$1;

            public void shutdown() {
                this.txnMarkerPurgatory$1.shutdown();
            }
            {
                this.txnMarkerPurgatory$1 = txnMarkerPurgatory$1;
                super(KafkaConfig$.MODULE$.fromProps($outer.serverProps()), metadataCache$1, networkClient$1, $outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), txnMarkerPurgatory$1, (Time)$outer.time());
            }
        });
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(new TransactionCoordinator(0, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Scheduler)this.scheduler(), pidManager, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), this.txnMarkerChannelManager(), (Time)this.time(), new LogContext()));
        EasyMock.replay((Object[])new Object[]{pidManager});
        EasyMock.replay((Object[])new Object[]{metadataCache});
        EasyMock.replay((Object[])new Object[]{networkClient});
    }

    @Override
    @After
    public void tearDown() {
        try {
            EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().shutdown();
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testConcurrentGoodPathSequence() {
        this.verifyConcurrentOperations(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final scala.collection.immutable.Set<Transaction> apply(String txnPrefix) {
                return this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$createTransactions(txnPrefix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
    }

    @Test
    public void testConcurrentRandomSequences() {
        this.verifyConcurrentRandomSequences(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final scala.collection.immutable.Set<Transaction> apply(String txnPrefix) {
                return this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$createTransactions(txnPrefix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
    }

    @Test
    public void testConcurrentLoadUnloadPartitions() {
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions() / 2).toSet();
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.numPartitions() / 2), this.numPartitions()).toSet();
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload));
    }

    @Test
    public void testConcurrentTransactionExpiration() {
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions() / 3).toSet();
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.numPartitions() / 3), this.numPartitions() * 2 / 3).toSet();
        scala.collection.immutable.Set partitionsWithExpiringTxn = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.numPartitions() * 2 / 3), this.numPartitions()).toSet();
        scala.collection.immutable.Set expiringTransactions = ((TraversableOnce)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().filter((Function1)new Serializable(this, partitionsWithExpiringTxn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;
            private final scala.collection.immutable.Set partitionsWithExpiringTxn$1;

            public final boolean apply(Transaction txn) {
                return this.partitionsWithExpiringTxn$1.contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsWithExpiringTxn$1 = partitionsWithExpiringTxn$1;
            }
        })).toSet();
        ExpireTransactionsAction expireAction = new ExpireTransactionsAction(this, (scala.collection.immutable.Set<Transaction>)expiringTransactions);
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload).$plus((Object)expireAction));
    }

    @Override
    public void enableCompletion() {
        super.enableCompletion();
        TransactionCoordinatorConcurrencyTest transactionCoordinatorConcurrencyTest = this;
        synchronized (transactionCoordinatorConcurrencyTest) {
            this.txnMarkerChannelManager().generateRequests().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

                public final void apply(RequestAndCompletionHandler requestAndHandler) {
                    WriteTxnMarkersRequest request = (WriteTxnMarkersRequest)((WriteTxnMarkersRequest.Builder)requestAndHandler.request()).build();
                    WriteTxnMarkersResponse response = this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$createResponse$1(request);
                    requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    private scala.collection.immutable.Set<AbstractCoordinatorConcurrencyTest.Action> loadUnloadActions(scala.collection.immutable.Set<Object> partitionsToLoad, scala.collection.immutable.Set<Object> partitionsToUnload) {
        scala.collection.immutable.Set transactions = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final scala.collection.immutable.Set<Transaction> apply(int i) {
                return this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$createTransactions(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testConcurrentLoadUnloadPartitions", "-"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        transactions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final void apply(Transaction txn) {
                this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$prepareTransaction(txn);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Set unload = (scala.collection.immutable.Set)partitionsToLoad.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final UnloadTxnPartitionAction apply(int x$1) {
                return new UnloadTxnPartitionAction(this.$outer, x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        unload.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(UnloadTxnPartitionAction x$2) {
                x$2.run();
            }
        });
        unload.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(UnloadTxnPartitionAction x$3) {
                x$3.await();
            }
        });
        return (scala.collection.immutable.Set)((TraversableLike)partitionsToLoad.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final LoadTxnPartitionAction apply(int x$4) {
                return new LoadTxnPartitionAction(this.$outer, x$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsToUnload.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

            public final UnloadTxnPartitionAction apply(int x$5) {
                return new UnloadTxnPartitionAction(this.$outer, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$createTransactions(String txnPrefix) {
        IndexedSeq transactions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nTransactions()).map((Function1)new Serializable(this, txnPrefix){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;
            private final String txnPrefix$1;

            public final Transaction apply(int i) {
                return new Transaction(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.txnPrefix$1, BoxesRunTime.boxToInteger((int)i)})), i, this.$outer.time());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnPrefix$1 = txnPrefix$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().$plus$plus$eq((TraversableOnce)transactions);
        return transactions.toSet();
    }

    public void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(Transaction txn, TransactionState expectedState) {
        Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue(new Serializable(this, txn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;
            private final Transaction txn$3;

            public final Option<TransactionMetadata> apply() {
                this.$outer.enableCompletion();
                return this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(this.txn$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txn$3 = txn$3;
            }
        }, TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), new Serializable(this, expectedState){
            public static final long serialVersionUID = 0L;
            public final TransactionState expectedState$1;

            public final boolean apply(Option<TransactionMetadata> metadata) {
                return metadata.nonEmpty() && metadata.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final boolean apply(TransactionMetadata m) {
                        TransactionState transactionState = m.state();
                        TransactionState transactionState2 = this.$outer.expectedState$1;
                        return !(transactionState != null ? !transactionState.equals(transactionState2) : transactionState2 != null) && m.pendingState().isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.expectedState$1 = expectedState$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option metadata = (Option)tuple2._1();
            boolean success = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)metadata, (Object)BoxesRunTime.boxToBoolean((boolean)success));
            Option metadata2 = (Option)tuple23._1();
            boolean success2 = tuple23._2$mcZ$sp();
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid metadata state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata2})), (boolean)success2);
            return;
        }
        throw new MatchError(tuple2);
    }

    public Option<TransactionMetadata> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(Transaction txn) {
        Either either;
        block6: {
            None$ none$;
            block4: {
                Option option;
                Right right;
                boolean bl;
                block5: {
                    block2: {
                        Errors error;
                        block3: {
                            bl = false;
                            right = null;
                            either = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().getTransactionState(txn.transactionalId());
                            if (!(either instanceof Left)) break block2;
                            Left left = (Left)either;
                            Errors errors = error = (Errors)left.a();
                            Errors errors2 = Errors.NOT_COORDINATOR;
                            if (errors != null ? !errors.equals(errors2) : errors2 != null) break block3;
                            none$ = None$.MODULE$;
                            break block4;
                        }
                        throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected transaction error ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, txn})));
                    }
                    if (!(either instanceof Right)) break block5;
                    bl = true;
                    right = (Right)either;
                    Option option2 = (Option)right.b();
                    if (!(option2 instanceof Some)) break block5;
                    Some some = (Some)option2;
                    CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)some.x();
                    none$ = new Some((Object)metadata.transactionMetadata());
                    break block4;
                }
                if (!bl || !None$.MODULE$.equals(option = (Option)right.b())) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)either);
    }

    public void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$prepareTransaction(Transaction txn) {
        int partitionId = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId());
        ArrayBuffer txnRecords = (ArrayBuffer)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId));
        InitProducerIdOperation initPidOp = new InitProducerIdOperation(this);
        AddPartitionsToTxnOperation addPartitionsOp = new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)}))));
        initPidOp.run(txn);
        initPidOp.awaitAndVerify(txn);
        addPartitionsOp.run(txn);
        addPartitionsOp.awaitAndVerify(txn);
        TransactionMetadata txnMetadata = (TransactionMetadata)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).getOrElse((Function0)new Serializable(this, txn){
            public static final long serialVersionUID = 0L;
            private final Transaction txn$2;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction not found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.txn$2})));
            }
            {
                this.txn$2 = txn$2;
            }
        });
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        txnMetadata.state_$eq((TransactionState)PrepareCommit$.MODULE$);
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        this.prepareTxnLog(partitionId);
    }

    private void prepareTxnLog(int partitionId) {
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        long startOffset = BoxesRunTime.unboxToLong((Object)this.replicaManager().getLogEndOffset(topicPartition).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 20L;
            }
        }));
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records2.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, records2, bufferCapture){
            private final MemoryRecords records$1;
            private final Capture bufferCapture$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.records$1 = records$1;
                this.bufferCapture$1 = bufferCapture$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock});
        TransactionCoordinatorConcurrencyTest transactionCoordinatorConcurrencyTest = this;
        synchronized (transactionCoordinatorConcurrencyTest) {
            this.replicaManager().updateLog(topicPartition, logMock, endOffset);
            return;
        }
    }

    public final WriteTxnMarkersResponse kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$createResponse$1(WriteTxnMarkersRequest request) {
        java.util.Map pidErrorMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.markers()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Long, java.util.Map<TopicPartition, Errors>> apply(WriteTxnMarkersRequest.TxnMarkerEntry marker) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)marker.producerId()), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(marker.partitions()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, Errors> apply(TopicPartition tp) {
                        return new Tuple2((Object)tp, (Object)Errors.NONE);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        return new WriteTxnMarkersResponse(pidErrorMap);
    }

    public TransactionCoordinatorConcurrencyTest() {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch = 10;
    }

    public static class Transaction
    implements AbstractCoordinatorConcurrencyTest.CoordinatorMember {
        private final String transactionalId;
        private final byte[] txnMessageKeyBytes;
        private volatile boolean ended;

        public String transactionalId() {
            return this.transactionalId;
        }

        public byte[] txnMessageKeyBytes() {
            return this.txnMessageKeyBytes;
        }

        public boolean ended() {
            return this.ended;
        }

        public void ended_$eq(boolean x$1) {
            this.ended = x$1;
        }

        public String toString() {
            return this.transactionalId();
        }

        public Transaction(String transactionalId, long producerId, MockTime time) {
            this.transactionalId = transactionalId;
            this.txnMessageKeyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            this.ended = false;
        }
    }

    public abstract class TxnOperation<R>
    extends AbstractCoordinatorConcurrencyTest.Operation {
        private volatile Option<R> result = None$.MODULE$;

        public Option<R> result() {
            return this.result;
        }

        public void result_$eq(Option<R> x$1) {
            this.result = x$1;
        }

        public void resultCallback(R r) {
            this.result_$eq((Option<R>)new Some(r));
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$TxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public TxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class EndTxnOperation
    extends TxnOperation<Errors> {
        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1)new Serializable(this, txn){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ EndTxnOperation $outer;
                private final Transaction txn$1;

                public final void apply(TransactionMetadata txnMetadata) {
                    this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleEndTransaction(this.txn$1.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$transactionResult(this.txn$1), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ EndTxnOperation$$anonfun$run$3 $outer;

                        public final void apply(Errors r) {
                            this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$anonfun$$$outer().resultCallback(r);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ EndTxnOperation kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.txn$1 = txn$1;
                }
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Errors error = (Errors)this.result().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalStateException("EndTransaction has not completed");
                }
            });
            if (txn.ended()) {
                Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)error);
            } else {
                txn.ended_$eq(true);
                Assert.assertEquals((Object)Errors.NONE, (Object)error);
                TransactionResult transactionResult = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$transactionResult(txn);
                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                CompleteCommit$ expectedState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
                this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)expectedState);
            }
        }

        public TransactionResult kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$transactionResult(Transaction txn) {
            String txnId = txn.transactionalId();
            char lastDigit = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(txnId), txnId.length() - 1);
            return lastDigit % 2 == 0 ? TransactionResult.COMMIT : TransactionResult.ABORT;
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public EndTxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class LoadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        public final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$txnTopicPartitionId;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onElection(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$txnTopicPartitionId, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LoadTxnPartitionAction $outer;

                public final void apply(Transaction txn) {
                    if (this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$txnTopicPartitionId) {
                        this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)CompleteCommit$.MODULE$);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public LoadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class InitProducerIdOperation
    extends TxnOperation<InitProducerIdResult> {
        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleInitProducerId(txn.transactionalId(), 60000, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InitProducerIdOperation $outer;

                public final void apply(InitProducerIdResult r) {
                    this.$outer.resultCallback(r);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void awaitAndVerify(Transaction txn) {
            InitProducerIdResult initPidResult = (InitProducerIdResult)this.result().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalStateException("InitProducerId has not completed");
                }
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)initPidResult.error());
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Empty$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public InitProducerIdOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class ExpireTransactionsAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        public final scala.collection.immutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$transactions;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$transactions.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExpireTransactionsAction $outer;

                public final void apply(Transaction txn) {
                    this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ExpireTransactionsAction$$anonfun$run$4 $outer;

                        public final void apply(TransactionMetadata txnMetadata) {
                            txnMetadata.txnLastUpdateTimestamp_$eq(this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$anonfun$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$anonfun$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ ExpireTransactionsAction kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().enableTransactionalIdExpiration();
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().sleep(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().removeExpiredTransactionalIdsIntervalMs() + 1);
        }

        @Override
        public void await() {
            Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExpireTransactionsAction $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().replicaManager().tryCompleteDelayedRequests();
                    return this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$transactions.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ExpireTransactionsAction$$anonfun$2 $outer;

                        public final boolean apply(Transaction txn) {
                            return this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$anonfun$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ ExpireTransactionsAction kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(boolean x) {
                    return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
                }
            });
            if (tuple2 != null) {
                boolean success;
                boolean bl;
                boolean success2 = bl = (success = tuple2._2$mcZ$sp());
                Assert.assertTrue((String)"Transaction not expired", (boolean)success2);
                return;
            }
            throw new MatchError(tuple2);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer() {
            return this.$outer;
        }

        public ExpireTransactionsAction(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<Transaction> transactions) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$transactions = transactions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class UnloadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        public final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$txnTopicPartitionId;
        private final ArrayBuffer<SimpleRecord> txnRecords;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        public ArrayBuffer<SimpleRecord> txnRecords() {
            return this.txnRecords;
        }

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onResignation(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$txnTopicPartitionId, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch())));
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UnloadTxnPartitionAction $outer;

                public final void apply(Transaction txn) {
                    if (this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$txnTopicPartitionId) {
                        Assert.assertTrue((String)"Transaction metadata not removed", (boolean)this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public UnloadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }

    public class AddPartitionsToTxnOperation
    extends TxnOperation<Errors> {
        public final scala.collection.immutable.Set<TopicPartition> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$partitions;

        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1)new Serializable(this, txn){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AddPartitionsToTxnOperation $outer;
                private final Transaction txn$4;

                public final void apply(TransactionMetadata txnMetadata) {
                    this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleAddPartitionsToTransaction(this.txn$4.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$partitions, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AddPartitionsToTxnOperation$$anonfun$run$2 $outer;

                        public final void apply(Errors r) {
                            this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$anonfun$$$outer().resultCallback(r);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ AddPartitionsToTxnOperation kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.txn$4 = txn$4;
                }
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Errors error = (Errors)this.result().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalStateException("AddPartitionsToTransaction has not completed");
                }
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)error);
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Ongoing$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public AddPartitionsToTxnOperation(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<TopicPartition> partitions) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$partitions = partitions;
            super($outer);
        }
    }
}

