/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.log.LogValidatorTest$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012\u0001\u0002;j[\u0016,\u0012A\u0006\t\u0003/\u0005j\u0011\u0001\u0007\u0006\u00033i\tQ!\u001e;jYNT!a\u0007\u000f\u0002\r\r|W.\\8o\u0015\t)QD\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u0019\u0005\u0011!\u0016.\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001)!\tI#&D\u0001\u001b\u0013\tY#D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r5\u0002\u0001\u0015!\u0003)\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001c4\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0003\u00049\u0001\u0001\u0006I!M\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%\taO\u0001\u000e[\u0016$(/[2t\u0017\u0016L8+\u001a;\u0016\u0003q\u00022!\u0010\"E\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\t\u00191+\u001a;\u0011\u0005\u0015sU\"\u0001$\u000b\u0005\u001dC\u0015\u0001B2pe\u0016T!!\u0013&\u0002\u000f5,GO]5dg*\u00111\nT\u0001\u0007s\u0006lW.\u001a:\u000b\u00035\u000b1aY8n\u0013\tyeI\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Da!\u0015\u0001!\u0002\u0013a\u0014AD7fiJL7m]&fsN+G\u000f\t\u0005\u0006'\u0002!\t\u0001V\u0001\u0011i\u0016\u001cHo\u00148ms>sWMQ1uG\"$\u0012!\u0016\t\u0003\u0013YK!a\u0016\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003%f\u0003\"AW/\u000e\u0003mS!\u0001X\u0010\u0002\u000b),h.\u001b;\n\u0005y[&\u0001\u0002+fgRDQ\u0001\u0019\u0001\u0005\u0002Q\u000b1\u0003^3ti\u0006cGn\\<Nk2$\u0018NQ1uG\"D#aX-\t\u000b\r\u0004A\u0011\u0001+\u0002#Q,7\u000f^'jg6\u000bGo\u00195NC\u001eL7\r\u000b\u0002c3\")a\r\u0001C\u0005O\u0006\t2\r[3dW>sG._(oK\n\u000bGo\u00195\u0015\tUCW.\u001e\u0005\u0006S\u0016\u0004\rA[\u0001\u0006[\u0006<\u0017n\u0019\t\u0003\u0013-L!\u0001\u001c\u0006\u0003\t\tKH/\u001a\u0005\u0006]\u0016\u0004\ra\\\u0001\u0016g>,(oY3D_6\u0004(/Z:tS>tG+\u001f9f!\t\u00018/D\u0001r\u0015\t\u0011($\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003iF\u0014qbQ8naJ,7o]5p]RK\b/\u001a\u0005\u0006m\u0016\u0004\ra\\\u0001\u0016i\u0006\u0014x-\u001a;D_6\u0004(/Z:tS>tG+\u001f9f\u0011\u0015A\b\u0001\"\u0003z\u0003Q\u0019\u0007.Z2l\u00032dwn^'vYRL')\u0019;dQR!QK_>}\u0011\u0015Iw\u000f1\u0001k\u0011\u0015qw\u000f1\u0001p\u0011\u00151x\u000f1\u0001p\u0011\u0015q\b\u0001\"\u0003\u0000\u0003I\u0019\u0007.Z2l\u001b&\u001cX.\u0019;dQ6\u000bw-[2\u0015\u000fU\u000b\t!!\u0002\u0002\n!1\u00111A?A\u0002)\f!BY1uG\"l\u0015mZ5d\u0011\u0019\t9! a\u0001U\u0006Y!/Z2pe\u0012l\u0015mZ5d\u0011\u0019\tY! a\u0001_\u0006y1m\\7qe\u0016\u001c8/[8o)f\u0004X\rC\u0004\u0002\u0010\u0001!I!!\u0005\u0002!Y\fG.\u001b3bi\u0016lUm]:bO\u0016\u001cH#C+\u0002\u0014\u0005u\u0011qDA\u0011\u0011!\t)\"!\u0004A\u0002\u0005]\u0011a\u0002:fG>\u0014Hm\u001d\t\u0004a\u0006e\u0011bAA\u000ec\niQ*Z7pef\u0014VmY8sINDa![A\u0007\u0001\u0004Q\u0007B\u00028\u0002\u000e\u0001\u0007q\u000e\u0003\u0004w\u0003\u001b\u0001\ra\u001c\u0005\u0007\u0003K\u0001A\u0011\u0001+\u0002AQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004\u0003GI\u0006bBA\u0016\u0001\u0011%\u0011QF\u0001 G\",7m\u001b'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$GcA+\u00020!1\u0011.!\u000bA\u0002)Da!a\r\u0001\t\u0003!\u0016\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-JBa!a\u000e\u0001\t\u0003!\u0016\u0001\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f\u001b*fG>l\u0007O]3tg&|gNV\u0019)\u0007\u0005U\u0012\fC\u0004\u0002>\u0001!I!a\u0010\u0002G\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]R\u0019Q+!\u0011\t\u000f\u0005\r\u00131\ba\u0001U\u0006YA/\u0019:hKRl\u0015mZ5d\u0011\u0019\t9\u0005\u0001C\u0001)\u0006!C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:4&\u0007K\u0002\u0002FeCa!!\u0014\u0001\t\u0003!\u0016a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-FB3!a\u0013Z\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+\nae\u00195fG.dunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o)\r)\u0016q\u000b\u0005\u0007S\u0006E\u0003\u0019\u00016\t\r\u0005m\u0003\u0001\"\u0001U\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e*b]\u001e,\u0017I\u001c3SK\u000e|'\u000fZ\"pk:$\bfAA-3\"9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0014\u0001I1tg\u0016\u0014H/\u00138wC2LGMQ1uG\"\u001cu.\u001e8u\u001fZ,'O]5eKN$R!VA3\u0003_B\u0001\"a\u001a\u0002`\u0001\u0007\u0011\u0011N\u0001\u0010Y\u0006\u001cHo\u00144gg\u0016$H)\u001a7uCB\u0019\u0011\"a\u001b\n\u0007\u00055$BA\u0002J]RD\u0001\"!\u001d\u0002`\u0001\u0007\u0011\u0011N\u0001\u0006G>,h\u000e\u001e\u0005\b\u0003k\u0002A\u0011BA<\u0003\u00152\u0018\r\\5eCR,'+Z2pe\u0012\u0014\u0015\r^2i/&$\bnQ8v]R|e/\u001a:sS\u0012,7\u000fF\u0003V\u0003s\nY\b\u0003\u0005\u0002h\u0005M\u0004\u0019AA5\u0011!\t\t(a\u001dA\u0002\u0005%\u0004BBA@\u0001\u0011\u0005A+A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u0013\u0004fAA?3\"1\u0011Q\u0011\u0001\u0005\u0002Q\u000b1\u0003^3ti:{gnQ8naJ,7o]3e-FB3!a!Z\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b\u000b!c\u00195fG.tuN\\\"p[B\u0014Xm]:fIR\u0019Q+a$\t\r%\fI\t1\u0001k\u0011\u0019\t\u0019\n\u0001C\u0001)\u0006\u0019B/Z:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a\u0011\u0011S-\t\r\u0005e\u0005\u0001\"\u0001U\u0003M!Xm\u001d;SK\u000e|W\u000e\u001d:fgNLwN\u001c,2Q\r\t9*\u0017\u0005\b\u0003?\u0003A\u0011BAQ\u0003I\u0019\u0007.Z2l%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\u0007U\u000b\u0019\u000b\u0003\u0004j\u0003;\u0003\rA\u001b\u0005\u0007\u0003O\u0003A\u0011\u0001+\u0002'Q,7\u000f\u001e*fG>l\u0007O]3tg&|gN\u0016\u001a)\u0007\u0005\u0015\u0016\f\u0003\u0004\u0002.\u0002!\t\u0001V\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4\u0016\u0007K\u0002\u0002,fCq!a-\u0001\t\u0013\t),A\u0011dQ\u0016\u001c7n\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c$s_64\u0006\u0007F\u0002V\u0003oCq!!/\u00022\u0002\u0007!.A\u0004u_6\u000bw-[2\t\r\u0005u\u0006\u0001\"\u0001U\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o-B\"vN\u0016\u001a)\u0007\u0005m\u0016\f\u0003\u0004\u0002D\u0002!\t\u0001V\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,2)>4&\u0007K\u0002\u0002BfCa!!3\u0001\t\u0003!\u0016\u0001\u0005;fgR\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\r\t9-\u0017\u0005\b\u0003\u001f\u0004A\u0011BAi\u0003=\u0019\u0007.Z2l\u0007>l\u0007O]3tg\u0016$GcA+\u0002T\"1\u0011.!4A\u0002)Da!a6\u0001\t\u0003!\u0016\u0001\u0005;fgR\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r\t).\u0017\u0005\u0007\u0003;\u0004A\u0011\u0001+\u0002IQ,7\u000f^%om\u0006d\u0017\u000eZ\"sK\u0006$X\rV5nK:{gnQ8naJ,7o]3e-FBs!a7Z\u0003C\f\u0019/\u0001\u0005fqB,7\r^3eG\t\t)\u000f\u0005\u0003\u0002h\u0006-XBAAu\u0015\tYB!\u0003\u0003\u0002n\u0006%(!\u0007*fG>\u0014HMV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:Da!!=\u0001\t\u0003!\u0016\u0001\n;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u000f\u0005=\u0018,!9\u0002d\"1\u0011q\u001f\u0001\u0005\u0002Q\u000b\u0011\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWmQ8naJ,7o]3e-FBs!!>Z\u0003C\f\u0019\u000f\u0003\u0004\u0002~\u0002!\t\u0001V\u0001\"i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7f\u0007>l\u0007O]3tg\u0016$gK\r\u0015\b\u0003wL\u0016\u0011]Ar\u0011\u0019\u0011\u0019\u0001\u0001C\u0001)\u0006IC/Z:u\u0003\n\u001cx\u000e\\;uK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u0012D3A!\u0001Z\u0011\u0019\u0011I\u0001\u0001C\u0001)\u00061C/Z:u\u0003\n\u001cx\u000e\\;uK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$8i\\7qe\u0016\u001c8/\u001a3)\u0007\t\u001d\u0011\f\u0003\u0004\u0003\u0010\u0001!\t\u0001V\u0001,i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3Wc!\u001a!QB-\t\r\tU\u0001\u0001\"\u0001U\u0003-\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fIZ\u0013\u0004f\u0001B\n3\"1!1\u0004\u0001\u0005\u0002Q\u000b\u0001\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3e-FB3A!\u0007Z\u0011\u0019\u0011\t\u0003\u0001C\u0001)\u0006AC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$8i\\7qe\u0016\u001c8/\u001a3We!\u001a!qD-\t\r\t\u001d\u0002\u0001\"\u0001U\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3A!\nZ\u0011\u0019\u0011i\u0003\u0001C\u0001)\u0006AD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,1)>4&GT8o\u0007>l\u0007O]3tg\u0016$\u0007f\u0001B\u00163\"1!1\u0007\u0001\u0005\u0002Q\u000bQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{g+M\"p[B\u0014Xm]:fI\"\u001a!\u0011G-\t\r\te\u0002\u0001\"\u0001U\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u00134i\\7qe\u0016\u001c8/\u001a3)\u0007\t]\u0012\f\u0003\u0004\u0003@\u0001!\t\u0001V\u0001(i\u0016\u001cHoQ8oiJ|GNU3d_J$7OT8u\u00032dwn^3e\rJ|Wn\u00117jK:$8\u000fK\u0004\u0003>e\u000b\tOa\u0011$\u0005\t\u0015\u0003cA\u0015\u0003H%\u0019!\u0011\n\u000e\u0003-%sg/\u00197jIJ+7m\u001c:e\u000bb\u001cW\r\u001d;j_:DaA!\u0014\u0001\t\u0003!\u0016a\b;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^\"p[B\u0014Xm]:fI\"\u001a!1J-\t\r\tM\u0003\u0001\"\u0001U\u0003i\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WcQ{g\u000b\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002\u0003ReCaA!\u0017\u0001\t\u0003!\u0016a\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4\u0016\u0007V8Wa\r{W\u000e\u001d:fgN,G\rK\u0002\u0003XeCaAa\u0018\u0001\t\u0003!\u0016\u0001\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-F\"vN\u0016\u001aO_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0005;J\u0006B\u0002B3\u0001\u0011\u0005A+A\u001buKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3\u0007>l\u0007O]3tg\u0016$\u0007f\u0001B23\"1!1\u000e\u0001\u0005\u0002Q\u000b!\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,2\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\t%\u0014\f\u0003\u0004\u0003r\u0001!\t\u0001V\u00018i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u000b4i\\7qe\u0016\u001c8/\u001a3)\u0007\t=\u0014\f\u0003\u0004\u0003x\u0001!\t\u0001V\u00015i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gn\u00144Ue\u0006t7/Y2uS>t\u0017\r\u001c*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007f\u0002B;3\u0006\u0005(1P\u0012\u0003\u0005{\u0002BAa \u0003\u00066\u0011!\u0011\u0011\u0006\u0004\u0005\u0007S\u0012AB3se>\u00148/\u0003\u0003\u0003\b\n\u0005%\u0001J+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fG/\u0012=dKB$\u0018n\u001c8\t\r\t-\u0005\u0001\"\u0001U\u0003E\"Xm\u001d;E_^t7i\u001c8wKJ\u001c\u0018n\u001c8PM&#W-\u001c9pi\u0016tGOU3d_J$7OT8u!\u0016\u0014X.\u001b;uK\u0012DsA!#Z\u0003C\u0014Y\b\u0003\u0004\u0003\u0012\u0002!\t\u0001V\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D3Aa$Z\u0011\u0019\u00119\n\u0001C\u0001)\u00069D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3A!&Z\u0011\u0019\u0011i\n\u0001C\u0001)\u0006\u0011D/Z:u\u001d>t\u0017J\\2sK\u0006\u001c\u0018N\\4PM\u001a\u001cX\r\u001e*fG>\u0014HMQ1uG\"D\u0015m]'fiJL7m\u001d'pO\u001e,G\rK\u0002\u0003\u001cfCaAa)\u0001\t\u0003!\u0016a\u000b;fgR\u001cu.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u000f\t\u0005\u0016,!9\u0003D!1!\u0011\u0016\u0001\u0005\u0002Q\u000b1\u0006^3tij\u001bF\u000fZ\"p[B\u0014Xm]:fI^KG\u000f[+oCZ\f\u0017\u000e\\1cY\u0016L%\t\u0015,feNLwN\u001c\u0015\b\u0005OK\u0016\u0011\u001dBWG\t\u0011y\u000b\u0005\u0003\u0003\u0000\tE\u0016\u0002\u0002BZ\u0005\u0003\u00131%\u00168tkB\u0004xN\u001d;fI\u000e{W\u000e\u001d:fgNLwN\u001c+za\u0016,\u0005pY3qi&|g\u000e\u0003\u0004\u00038\u0002!\t\u0001V\u0001.i\u0016\u001cH/\u00168d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007f\u0002B[3\u0006\u0005(1\t\u0005\u0007\u0005{\u0003A\u0011\u0001+\u0002[Q,7\u000f\u001e*fG>l\u0007O]3tg\u0016$')\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rK\u0004\u0003<f\u000b\tOa\u0011\t\r\t\r\u0007\u0001\"\u0001U\u0003)\"Xm\u001d;J]Z\fG.\u001b3US6,7\u000f^1na\u0016C8-\u001a9uS>t\u0007*Y:CCR\u001c\u0007.\u00138eKbD3A!1Z\u0011\u0019\u0011I\r\u0001C\u0001)\u00069C/Z:u\u0013:4\u0018\r\\5e%\u0016\u001cwN\u001d3Fq\u000e,\u0007\u000f^5p]\"\u000b7OQ1uG\"Le\u000eZ3yQ\r\u00119-\u0017\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0003\u0005\"Xm\u001d;CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3e)\u0015)&1\u001bBr\u0011!\u0011)N!4A\u0002\t]\u0017aC:pkJ\u001cWmQ8eK\u000e\u0004BA!7\u0003`6\u0011!1\u001c\u0006\u0004\u0005;$\u0011aB7fgN\fw-Z\u0005\u0005\u0005C\u0014YN\u0001\tD_6\u0004(/Z:tS>t7i\u001c3fG\"A!Q\u001dBg\u0001\u0004\u00119.A\u0006uCJ<W\r^\"pI\u0016\u001c\u0007b\u0002Bu\u0001\u0011%!1^\u0001\u000eGJ,\u0017\r^3SK\u000e|'\u000fZ:\u0015\u0011\u0005]!Q\u001eBy\u0005wDqAa<\u0003h\u0002\u0007!.\u0001\u0006nC\u001eL7MV1mk\u0016D!Ba=\u0003hB\u0005\t\u0019\u0001B{\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002\n\u0005oL1A!?\u000b\u0005\u0011auN\\4\t\u000f\tu(q\u001da\u0001_\u0006)1m\u001c3fG\"91\u0011\u0001\u0001\u0005\n\r\r\u0011\u0001I2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$\u0002\"a\u0006\u0004\u0006\r\u001d1\u0011\u0002\u0005\b\u0005_\u0014y\u00101\u0001k\u0011)\u0011\u0019Pa@\u0011\u0002\u0003\u0007!Q\u001f\u0005\n\u0005{\u0014y\u0010%AA\u0002=Dqa!\u0004\u0001\t\u0013\u0019y!A\fde\u0016\fG/\u001a+x_\n\u000bGo\u00195fIJ+7m\u001c:egRA\u0011qCB\t\u0007'\u0019)\u0002C\u0004\u0003p\u000e-\u0001\u0019\u00016\t\u0011\tM81\u0002a\u0001\u0005kDqA!@\u0004\f\u0001\u0007q\u000eC\u0004\u0004\u001a\u0001!\taa\u0007\u0002\u0019\rDWmY6PM\u001a\u001cX\r^:\u0015\u000bU\u001biba\b\t\u0011\u0005U1q\u0003a\u0001\u0003/A\u0001b!\t\u0004\u0018\u0001\u0007!Q_\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bbBB\u0013\u0001\u0011%1qE\u0001\u001de\u0016\u001cwN\u001d3t/&$\b.\u00138wC2LG-\u00138oKJl\u0015mZ5d)!\t9b!\u000b\u0004.\rE\u0002bBB\u0016\u0007G\u0001\rA[\u0001\u0010E\u0006$8\r['bO&\u001cg+\u00197vK\"91qFB\u0012\u0001\u0004Q\u0017\u0001\u0005:fG>\u0014H-T1hS\u000e4\u0016\r\\;f\u0011\u001d\u0011ipa\tA\u0002=Dqa!\u000e\u0001\t\u0003\u00199$A\fnCf\u0014Wm\u00115fG.\u0014\u0015m]3US6,7\u000f^1naR)Qk!\u000f\u0004<!A\u0011\u0011]B\u001a\u0001\u0004\u0011)\u0010\u0003\u0005\u0004>\rM\u0002\u0019AB \u0003\u0015\u0011\u0017\r^2i!\r\u00018\u0011I\u0005\u0004\u0007\u0007\n(a\u0003*fG>\u0014HMQ1uG\"Dqaa\u0012\u0001\t\u0003\u0019I%A\u000bwC2LG-\u0019;f\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3\u0015\u000fU\u001bYea\u0014\u0004T!A1QJB#\u0001\u0004\u0011)0A\u000bfqB,7\r^3e\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3\t\u0011\rE3Q\ta\u0001\u0005k\fQ#\u001a=qK\u000e$X\r\u001a\"bg\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0004>\r\u0015\u0003\u0019AB \u0011\u001d\u00199\u0006\u0001C\u0001\u00073\n1D^3sS\u001aL(+Z2pe\u0012\u001cuN\u001c<feNLwN\\*uCR\u001cH#C+\u0004\\\r\u00154\u0011NB6\u0011!\u0019if!\u0016A\u0002\r}\u0013!B:uCR\u001c\bc\u00019\u0004b%\u001911M9\u0003+I+7m\u001c:e\u0007>tg/\u001a:tS>t7\u000b^1ug\"A1qMB+\u0001\u0004\tI'A\nok6\u001cuN\u001c<feR,GMU3d_J$7\u000f\u0003\u0005\u0002\u0016\rU\u0003\u0019AA\f\u0011!\u0019ig!\u0016A\u0002\r=\u0014AC2p[B\u0014Xm]:fIB\u0019\u0011b!\u001d\n\u0007\rM$BA\u0004C_>dW-\u00198\t\u0013\r]\u0004!%A\u0005\n\re\u0014aF2sK\u0006$XMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019YH\u000b\u0003\u0003v\u000eu4FAB@!\u0011\u0019\tia#\u000e\u0005\r\r%\u0002BBC\u0007\u000f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r%%\"\u0001\u0006b]:|G/\u0019;j_:LAa!$\u0004\u0004\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\rE\u0005!%A\u0005\n\re\u0014AK2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$C-\u001a4bk2$HE\r\u0005\n\u0007+\u0003\u0011\u0013!C\u0005\u0007/\u000b!f\u0019:fCR,gj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\u001a*\u001aqn! ")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, magic, sourceCompressionType, targetCompressionType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final byte magic$1;
            private final CompressionType sourceCompressionType$1;
            private final CompressionType targetCompressionType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.$outer.kafka$log$LogValidatorTest$$createTwoBatchedRecords(this.magic$1, 0L, this.sourceCompressionType$1), this.magic$1, this.sourceCompressionType$1, this.targetCompressionType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.magic$1 = magic$1;
                this.sourceCompressionType$1 = sourceCompressionType$1;
                this.targetCompressionType$1 = targetCompressionType$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.kafka$log$LogValidatorTest$$validateMessages(this.kafka$log$LogValidatorTest$$createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, batchMagic, recordMagic, compressionType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final byte batchMagic$1;
            private final byte recordMagic$1;
            private final CompressionType compressionType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.$outer.kafka$log$LogValidatorTest$$recordsWithInvalidInnerMagic(this.batchMagic$1, this.recordMagic$1, this.compressionType$1), this.batchMagic$1, this.compressionType$1, this.compressionType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchMagic$1 = batchMagic$1;
                this.recordMagic$1 = recordMagic$1;
                this.compressionType$1 = compressionType$1;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$1) {
                return x$1.getMBeanName().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()})));
            }
        }), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()}))) > 0L ? 1 : 0) != 0);
    }

    public void kafka$log$LogValidatorTest$$validateMessages(MemoryRecords records2, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$1;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$1, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$11 = 0;
        CompressionType x$12 = CompressionType.GZIP;
        long x$13 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$11, x$13, x$12);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$2;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$2, -1L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$2 = now$2;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records2, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$3;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$3, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$3 = now$3;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, lastOffsetDelta, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final int lastOffsetDelta$1;
            private final int count$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(this.lastOffsetDelta$1, this.count$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastOffsetDelta$1 = lastOffsetDelta$1;
                this.count$1 = count$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
    }

    public void kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records2.buffer().putInt(57, count);
        records2.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, isTransactional2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$1;
                private final long producerId$1;
                private final short producerEpoch$1;
                private final int baseSequence$1;
                private final boolean isTransactional$1;
                private final int partitionLeaderEpoch$1;
                public final IntRef i$1;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$3) {
                            return x$3.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$1, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$1, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$1, (long)batch.baseSequence());
                    Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
                    Assert.assertEquals((long)this.partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkNonCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$1.apply(this.$outer.i$1.elem)), (long)record.timestamp());
                            ++this.$outer.i$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$1 = timestampSeq$1;
                    this.producerId$1 = producerId$1;
                    this.producerEpoch$1 = producerEpoch$1;
                    this.baseSequence$1 = baseSequence$1;
                    this.isTransactional$1 = isTransactional$1;
                    this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                    this.i$1 = i$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records2, false);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$2;
                private final long producerId$2;
                private final short producerEpoch$2;
                private final int baseSequence$2;
                private final int partitionLeaderEpoch$2;
                public final IntRef i$2;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$2.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$5) {
                            return x$5.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$2, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$2, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$2, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkRecompression$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$2.apply(this.$outer.i$2.elem)), (long)record.timestamp());
                            ++this.$outer.i$2.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$2 = timestampSeq$2;
                    this.producerId$2 = producerId$2;
                    this.producerEpoch$2 = producerEpoch$2;
                    this.baseSequence$2 = baseSequence$2;
                    this.partitionLeaderEpoch$2 = partitionLeaderEpoch$2;
                    this.i$2 = i$2;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        MemoryRecords records2;
        byte x$14 = 0;
        CompressionType x$15 = CompressionType.GZIP;
        long x$16 = this.createRecords$default$2();
        MemoryRecords x$17 = records2 = this.createRecords(x$14, x$16, x$15);
        TopicPartition x$18 = this.topicPartition();
        kafka.common.LongRef x$19 = new kafka.common.LongRef(0L);
        Time x$20 = this.time();
        long x$21 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$22 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$23 = DefaultCompressionCodec$.MODULE$;
        byte x$24 = toMagic;
        boolean x$25 = false;
        TimestampType x$26 = TimestampType.CREATE_TIME;
        long x$27 = 1000L;
        int x$28 = -1;
        AppendOrigin.Client$ x$29 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$30 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$31 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$17, x$18, x$19, x$20, x$21, (CompressionCodec)x$22, (CompressionCodec)x$23, x$25, x$24, x$26, x$27, x$28, (AppendOrigin)x$29, x$30, x$31);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
                Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        MemoryRecords records2;
        long timestamp = System.currentTimeMillis();
        byte x$32 = 1;
        CompressionType x$33 = CompressionType.GZIP;
        long x$34 = timestamp;
        MemoryRecords x$35 = records2 = this.createRecords(x$32, x$34, x$33);
        TopicPartition x$36 = this.topicPartition();
        kafka.common.LongRef x$37 = new kafka.common.LongRef(0L);
        Time x$38 = this.time();
        long x$39 = timestamp;
        DefaultCompressionCodec$ x$40 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$41 = DefaultCompressionCodec$.MODULE$;
        byte x$42 = 2;
        boolean x$43 = false;
        TimestampType x$44 = TimestampType.CREATE_TIME;
        long x$45 = 1000L;
        int x$46 = -1;
        AppendOrigin.Client$ x$47 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$48 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$49 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$35, x$36, x$37, x$38, x$39, (CompressionCodec)x$40, (CompressionCodec)x$41, x$43, x$42, x$44, x$45, x$46, (AppendOrigin)x$47, x$48, x$49);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long timestamp$1;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(this.timestamp$1, (RecordBatch)batch);
                Assert.assertEquals((long)this.timestamp$1, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
            }
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            MemoryRecords records2;
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords x$50 = records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            TopicPartition x$51 = this.topicPartition();
            kafka.common.LongRef x$52 = new kafka.common.LongRef(0L);
            Time x$53 = this.time();
            long x$54 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$55 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$56 = DefaultCompressionCodec$.MODULE$;
            byte x$57 = magic;
            boolean x$58 = false;
            TimestampType x$59 = TimestampType.CREATE_TIME;
            long x$60 = 1000L;
            int x$61 = partitionLeaderEpoch2;
            AppendOrigin.Client$ x$62 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$63 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$64 = this.brokerTopicStats();
            LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$50, x$51, x$52, x$53, x$54, (CompressionCodec)x$55, (CompressionCodec)x$56, x$58, x$57, x$59, x$60, x$61, (AppendOrigin)x$62, x$63, x$64);
            MemoryRecords validatedRecords = validatedResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$3;
                private final long producerId$3;
                private final short producerEpoch$3;
                private final int baseSequence$3;
                private final int partitionLeaderEpoch$3;
                public final IntRef i$3;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$3.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$7) {
                            return x$7.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$3, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$3, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$3, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$3.apply(this.$outer.i$3.elem)), (long)record.timestamp());
                            ++this.$outer.i$3.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$3 = timestampSeq$3;
                    this.producerId$3 = producerId$3;
                    this.producerEpoch$3 = producerEpoch$3;
                    this.baseSequence$3 = baseSequence$3;
                    this.partitionLeaderEpoch$3 = partitionLeaderEpoch$3;
                    this.i$3 = i$3;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatedResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV1() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$65 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        TopicPartition x$66 = this.topicPartition();
        kafka.common.LongRef x$67 = new kafka.common.LongRef(0L);
        Time x$68 = this.time();
        long x$69 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$70 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$71 = DefaultCompressionCodec$.MODULE$;
        byte x$72 = 1;
        boolean x$73 = false;
        TimestampType x$74 = TimestampType.CREATE_TIME;
        long x$75 = 1000L;
        int x$76 = -1;
        AppendOrigin.Client$ x$77 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$78 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$79 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$65, x$66, x$67, x$68, x$69, (CompressionCodec)x$70, (CompressionCodec)x$71, x$73, x$72, x$74, x$75, x$76, (AppendOrigin)x$77, x$78, x$79);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV2() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$80 = records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        TopicPartition x$81 = this.topicPartition();
        kafka.common.LongRef x$82 = new kafka.common.LongRef(0L);
        Time x$83 = this.time();
        long x$84 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$85 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$86 = DefaultCompressionCodec$.MODULE$;
        byte x$87 = 1;
        boolean x$88 = false;
        TimestampType x$89 = TimestampType.CREATE_TIME;
        long x$90 = 1000L;
        int x$91 = -1;
        AppendOrigin.Client$ x$92 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$93 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$94 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$80, x$81, x$82, x$83, x$84, (CompressionCodec)x$85, (CompressionCodec)x$86, x$88, x$87, x$89, x$90, x$91, (AppendOrigin)x$92, x$93, x$94);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$95 = 0;
        CompressionType x$96 = CompressionType.NONE;
        long x$97 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$95, x$97, x$96);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$98 = records2;
        TopicPartition x$99 = this.topicPartition();
        kafka.common.LongRef x$100 = new kafka.common.LongRef((long)offset);
        Time x$101 = this.time();
        long x$102 = System.currentTimeMillis();
        NoCompressionCodec$ x$103 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$104 = NoCompressionCodec$.MODULE$;
        byte x$105 = 0;
        boolean x$106 = false;
        TimestampType x$107 = TimestampType.CREATE_TIME;
        long x$108 = 1000L;
        int x$109 = -1;
        AppendOrigin.Client$ x$110 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$111 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$112 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$98, x$99, x$100, x$101, x$102, (CompressionCodec)x$103, (CompressionCodec)x$104, x$106, x$105, x$107, x$108, x$109, (AppendOrigin)x$110, x$111, x$112).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$113 = 0;
        CompressionType x$114 = CompressionType.GZIP;
        long x$115 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$113, x$115, x$114);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$116 = 0;
        CompressionType x$117 = CompressionType.NONE;
        long x$118 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$116, x$118, x$117);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$119 = 0;
        CompressionType x$120 = CompressionType.NONE;
        long x$121 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$119, x$121, x$120);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$122 = 0;
        CompressionType x$123 = CompressionType.GZIP;
        long x$124 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$122, x$124, x$123);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$125 = 0;
        CompressionType x$126 = CompressionType.GZIP;
        long x$127 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$125, x$127, x$126);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator.ValidationAndOffsetAssignResult result = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        List batches = TestUtils.toList((Iterable)result.validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertFalse((boolean)batch.isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$128 = 1;
        CompressionType x$129 = CompressionType.NONE;
        long x$130 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$128, x$130, x$129);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$131 = 1;
        CompressionType x$132 = CompressionType.GZIP;
        long x$133 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$131, x$133, x$132);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records2 = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).head()).setLastOffset(2L);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords records$1;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(this.records$1, this.$outer.topicPartition(), new kafka.common.LongRef(0L), this.$outer.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.$outer.brokerTopicStats());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.records$1 = records$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1195));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$8) {
                return x$8.getMBeanName().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()})));
            }
        }), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()}))) > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords records$2;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                MemoryRecords x$134 = this.records$2;
                TopicPartition x$135 = this.$outer.topicPartition();
                kafka.common.LongRef x$136 = new kafka.common.LongRef(0L);
                Time x$137 = this.$outer.time();
                long x$138 = System.currentTimeMillis();
                DefaultCompressionCodec$ x$139 = DefaultCompressionCodec$.MODULE$;
                DefaultCompressionCodec$ x$140 = DefaultCompressionCodec$.MODULE$;
                byte x$141 = 1;
                boolean x$142 = false;
                TimestampType x$143 = TimestampType.CREATE_TIME;
                long x$144 = 1000L;
                int x$145 = -1;
                AppendOrigin.Client$ x$146 = AppendOrigin.Client$.MODULE$;
                ApiVersion x$147 = ApiVersion$.MODULE$.latestVersion();
                BrokerTopicStats x$148 = this.$outer.brokerTopicStats();
                return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$134, x$135, x$136, x$137, x$138, (CompressionCodec)x$139, (CompressionCodec)x$140, x$142, x$141, x$143, x$144, x$145, (AppendOrigin)x$146, x$147, x$148);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.records$2 = records$2;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1258));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)1L);
        Assert.assertEquals((long)((ProduceResponse.RecordError)e.recordErrors().head()).batchIndex, (long)0L);
        Assert.assertNull((Object)((ProduceResponse.RecordError)e.recordErrors().head()).message);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.$outer.kafka$log$LogValidatorTest$$recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1286));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)1L);
        Assert.assertEquals((long)((ProduceResponse.RecordError)e.recordErrors().head()).batchIndex, (long)0L);
        Assert.assertNull((Object)((ProduceResponse.RecordError)e.recordErrors().head()).message);
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40));
        if (tuple5 != null) {
            Tuple5 tuple52;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple53._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple53._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple53._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
            ByteBuffer buffer = ByteBuffer.allocate(61);
            DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (long)0L, (long)5L, (int)partitionLeaderEpoch2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)isTransactional2, (boolean)false);
            buffer.flip();
            MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    public MemoryRecords kafka$log$LogValidatorTest$$createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(Record entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    public MemoryRecords kafka$log$LogValidatorTest$$recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this, recordMagicValue){
            public static final long serialVersionUID = 0L;
            private final byte recordMagicValue$1;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)this.recordMagicValue$1, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
            {
                this.recordMagicValue$1 = recordMagicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$10) {
                return x$10.sizeInBytes();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final IntRef offset$2;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset((long)this.offset$2.elem, record);
                ++this.offset$2.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$2 = offset$2;
            }
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        RecordBatch recordBatch = batch;
        if (recordBatch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)recordBatch;
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected base timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected max timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, expectedLogAppendTime){
            public static final long serialVersionUID = 0L;
            private final long expectedLogAppendTime$1;

            public final void apply(Record record) {
                Assert.assertTrue((boolean)record.isValid());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected timestamp of record ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})), (long)this.expectedLogAppendTime$1, (long)record.timestamp());
            }
            {
                this.expectedLogAppendTime$1 = expectedLogAppendTime$1;
            }
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records2, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not valid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records2.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temp bytes too small, orig=", " actual=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)originalSize), BoxesRunTime.boxToLong((long)tempBytes)})), (tempBytes > (long)originalSize ? 1 : 0) != 0);
        } else if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)tempBytes);
        }
    }
}

