/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u000f\t!BK]1og\u0006\u001cG/[8o\u0013:$W\r\u001f+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u00035\u00198-\u00197bi\u0016\u001cH\u000f\u001d7vg*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!I\u0001\u0004\u0001a\u0001\u0002\u0004%\t!G\u0001\u0005M&dW-F\u0001\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0002j_*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005\u00111\u0015\u000e\\3\t\u0013\r\u0002\u0001\u0019!a\u0001\n\u0003!\u0013\u0001\u00034jY\u0016|F%Z9\u0015\u0005\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001B+oSRDq\u0001\f\u0012\u0002\u0002\u0003\u0007!$A\u0002yIEBaA\f\u0001!B\u0013Q\u0012!\u00024jY\u0016\u0004\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u0003\u0015Ig\u000eZ3y+\u0005\u0011\u0004C\u0001\f4\u0013\t!$A\u0001\tUe\u0006t7/Y2uS>t\u0017J\u001c3fq\"Ia\u0007\u0001a\u0001\u0002\u0004%\taN\u0001\nS:$W\r_0%KF$\"!\n\u001d\t\u000f1*\u0014\u0011!a\u0001e!1!\b\u0001Q!\nI\na!\u001b8eKb\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0007_\u001a47/\u001a;\u0016\u0003y\u0002\"AJ \n\u0005\u0001;#\u0001\u0002'p]\u001eDaA\u0011\u0001!\u0002\u0013q\u0014aB8gMN,G\u000f\t\u0005\u0006\t\u0002!\t!R\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002K!\u00121i\u0012\t\u0003\u0011*k\u0011!\u0013\u0006\u0003\u00179I!aS%\u0003\r\t+gm\u001c:f\u0011\u0015i\u0005\u0001\"\u0001F\u0003!!X-\u0019:e_^t\u0007F\u0001'P!\tA\u0005+\u0003\u0002R\u0013\n)\u0011I\u001a;fe\")1\u000b\u0001C\u0001\u000b\u0006\u0011C/Z:u!>\u001c\u0018\u000e^5p]N+GoQ8se\u0016\u001cG\u000f\\=XQ\u0016tw\n]3oK\u0012D#AU+\u0011\u0005!3\u0016BA,J\u0005\u0011!Vm\u001d;\t\u000be\u0003A\u0011A#\u0002\u001fQ,7\u000f^*b]&$\u0018p\u00115fG.DC\u0001W+\\9\u0006AQ\r\u001f9fGR,GmI\u0001^!\t1b,\u0003\u0002`\u0005\t)2i\u001c:skB$\u0018J\u001c3fq\u0016C8-\u001a9uS>t\u0007\"B1\u0001\t\u0003)\u0015A\u0007;fgRd\u0015m\u001d;PM\u001a\u001cX\r^'vgRLen\u0019:fCN,\u0007\u0006\u00021V7\u000e\u001c\u0013\u0001\u001a\t\u0003K6t!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%4\u0011A\u0002\u001fs_>$h(C\u0001)\u0013\taw%A\u0004qC\u000e\\\u0017mZ3\n\u00059|'\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011An\n\u0005\u0006c\u0002!\t!R\u0001\u001di\u0016\u001cH\u000fT1ti>3gm]3u\u0007\u0006tgn\u001c;EK\u000e\u0014X-Y:fQ\u0011\u0001XkW2\t\u000bQ\u0004A\u0011A#\u0002=Q,7\u000f^\"pY2,7\r^!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\bFA:V\u0011\u00159\b\u0001\"\u0001F\u00031!Xm\u001d;UeVt7-\u0019;fQ\t1X\u000bC\u0003{\u0001\u0011\u0005Q)A\nuKN$\u0018IY8si\u0016$G\u000b\u001f8TKJ$W\r\u000b\u0002z+\")Q\u0010\u0001C\u0001\u000b\u0006yA/Z:u%\u0016t\u0017-\\3J]\u0012,\u0007\u0010\u000b\u0002}+\u0002")
public class TransactionIndexTest
extends JUnitSuite {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @Before
    public void setup() {
        this.file_$eq(TestUtils$.MODULE$.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @After
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$1$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$1$1.append(abortedTxn);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assert.assertEquals((Object)abortedTxns.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{anotherAbortedTxn})), List$.MODULE$.canBuildFrom()), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test(expected=CorruptIndexException.class)
    public void testSanityCheck() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$2$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$2$1.append(abortedTxn);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        reopenedIndex.sanityCheck();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 15L, 11L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
    }

    @Test
    public void testCollectAbortedTransactions() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$3$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$3$1.append(abortedTxn);
            }
            {
                this.eta$0$3$1 = eta$0$3$1;
            }
        });
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assert.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assert.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 2L), new AbortedTxn(1L, 5L, 15L, 16L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1)new Serializable(this, transactionIndex){
            public static final long serialVersionUID = 0L;
            private final TransactionIndex eta$0$4$1;

            public final void apply(AbortedTxn abortedTxn) {
                this.eta$0$4$1.append(abortedTxn);
            }
            {
                this.eta$0$4$1 = eta$0$4$1;
            }
        });
        this.index().truncateTo(51L);
        Assert.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().reset();
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assert.assertEquals((long)AbortedTxn$.MODULE$.CurrentVersion(), (long)abortedTxn.version());
        Assert.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assert.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils$.MODULE$.tempFile();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assert.assertEquals((long)2L, (long)abortedTxns.size());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assert.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }
}

