/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u000f\tQB)Z:de&\u0014W\rT8h\t&\u00148OU3rk\u0016\u001cH\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005##A\u0006m_\u001e$\u0015N]\"pk:$X#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\u0007%sG\u000f\u0003\u0004\u001b\u0001\u0001\u0006IaE\u0001\rY><G)\u001b:D_VtG\u000f\t\u0005\b9\u0001\u0011\r\u0011\"\u0011\u0013\u0003-\u0011'o\\6fe\u000e{WO\u001c;\t\ry\u0001\u0001\u0015!\u0003\u0014\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011\u001d\u0001\u0003A1A\u0005\u0002\u0005\nQ\u0001^8qS\u000e,\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019\u0019FO]5oO\"11\u0006\u0001Q\u0001\n\t\na\u0001^8qS\u000e\u0004\u0003bB\u0017\u0001\u0005\u0004%\tAE\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\u0007_\u0001\u0001\u000b\u0011B\n\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0011\u001d\t\u0004A1A\u0005\u0002I\n1\u0001\u001e91+\u0005\u0019\u0004C\u0001\u001b=\u001b\u0005)$B\u0001\u001c8\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u000f\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>k\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB \u0001A\u0003%1'\u0001\u0003uaB\u0002\u0003bB!\u0001\u0005\u0004%\tAM\u0001\u0004iB\f\u0004BB\"\u0001A\u0003%1'\u0001\u0003uaF\u0002\u0003\"B#\u0001\t\u00031\u0015A\u0007;fgR$Um]2sS\n,Gj\\4ESJ\u001c(+Z9vKN$H#A$\u0011\u0005QA\u0015BA%\u0016\u0005\u0011)f.\u001b;)\u0005\u0011[\u0005C\u0001'P\u001b\u0005i%B\u0001(;\u0003\u0015QWO\\5u\u0013\t\u0001VJ\u0001\u0003UKN$\b")
public class DescribeLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionNum() {
        return this.partitionNum;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    @Test
    public void testDescribeLogDirsRequest() {
        String onlineDir = new File((String)((KafkaServer)this.servers().head()).config().logDirs().head()).getAbsolutePath();
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        ReplicaManager qual$1 = ((KafkaServer)this.servers().head()).replicaManager();
        String x$1 = offlineDir;
        boolean x$2 = qual$1.handleLogDirFailure$default$2();
        qual$1.handleLogDirFailure(x$1, x$2);
        this.createTopic(this.topic(), this.partitionNum(), 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        DescribeLogDirsRequest request = (DescribeLogDirsRequest)new DescribeLogDirsRequest.Builder(null).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.DESCRIBE_LOG_DIRS, this.controllerSocketServer(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        Map logDirInfos = DescribeLogDirsResponse.parse((ByteBuffer)response, (short)request.version()).logDirInfos();
        Assert.assertEquals((long)this.logDirCount(), (long)logDirInfos.size());
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).error);
        Assert.assertEquals((long)0L, (long)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).replicaInfos.size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).error);
        DescribeLogDirsResponse.ReplicaInfo replicaInfo0 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp0());
        DescribeLogDirsResponse.ReplicaInfo replicaInfo1 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp1());
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$3 = this.tp0();
        boolean x$4 = qual$2.getLog$default$2();
        Log log0 = (Log)qual$2.getLog(x$3, x$4).get();
        LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$5 = this.tp1();
        boolean x$6 = qual$3.getLog$default$2();
        Log log1 = (Log)qual$3.getLog(x$5, x$6).get();
        Assert.assertEquals((long)log0.size(), (long)replicaInfo0.size);
        Assert.assertEquals((long)log1.size(), (long)replicaInfo1.size);
        LogManager qual$4 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$7 = this.tp0();
        boolean x$8 = qual$4.getLog$default$2();
        long logEndOffset = ((Log)qual$4.getLog(x$7, x$8).get()).logEndOffset();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogEndOffset '", "' should be > 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)logEndOffset)})), (logEndOffset > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp0(), log0.logEndOffset(), false), (long)replicaInfo0.offsetLag);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp1(), log1.logEndOffset(), false), (long)replicaInfo1.offsetLag);
    }

    public DescribeLogDirsRequestTest() {
        this.logDirCount = 2;
        this.brokerCount = 1;
        this.topic = "topic";
        this.partitionNum = 2;
    }
}

