/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004S5hQ^\fG/\u001a:nCJ\\\u0007+\u001a:tSN$XM\\2f)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#A\u0004d_:4\u0017nZ:\u0016\u0003Y\u00012a\u0006\u000e\u001d\u001b\u0005A\"BA\r\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037a\u00111aU3r!\t\u0011R$\u0003\u0002\u001f\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u0019\u0001\u0003\u0001)A\u0005-\u0005A1m\u001c8gS\u001e\u001c\b\u0005C\u0004#\u0001\t\u0007I\u0011A\u0012\u0002\u000bQ|\u0007/[2\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0013\u0002\rQ|\u0007/[2!\u0011\u001dy\u0003A1A\u0005\u0002A\n\u0001B_6DY&,g\u000e^\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0003u.L!AN\u001a\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u0019A\u0004\u0001)A\u0005c\u0005I!p[\"mS\u0016tG\u000f\t\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0003-awnZ'b]\u0006<WM]:\u0016\u0003q\u00022a\u0006\u000e>!\tq\u0014)D\u0001@\u0015\t\u0001E!A\u0002m_\u001eL!AQ \u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0004E\u0001\u0001\u0006I\u0001P\u0001\rY><W*\u00198bO\u0016\u00148\u000f\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYN,\u0012\u0001\u0013\t\u0004/iI\u0005C\u0001\nK\u0013\tY%A\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002%\u0002-1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mg\u0002BQa\u0014\u0001\u0005\u0002A\u000b\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002#B\u0011\u0011BU\u0005\u0003'*\u0011A!\u00168ji\"\u0012a*\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bQA[;oSRT\u0011AW\u0001\u0004_J<\u0017B\u0001/X\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003-\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016\u001c\u0016N\\4mKB\u000b'\u000f^5uS>t\u0007FA/a!\t1\u0016-\u0003\u0002c/\n!A+Z:u\u0011\u0015!\u0007\u0001\"\u0001Q\u00039\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016lU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:)\u0005\r\u0004\u0007\"B4\u0001\t\u0013A\u0017AB1qa\u0016tG\rF\u0002RSFDQA\u001b4A\u0002-\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u00051|W\"A7\u000b\u00059$\u0011aB2mkN$XM]\u0005\u0003a6\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000bI4\u0007\u0019A:\u0002\u000b\r|WO\u001c;\u0011\u0005%!\u0018BA;\u000b\u0005\rIe\u000e\u001e\u0005\u0006o\u0002!I\u0001_\u0001\u0007Q^lgi\u001c:\u0015\red\u00181AA\t!\tI!0\u0003\u0002|\u0015\t!Aj\u001c8h\u0011\u0015ih\u000f1\u0001\u007f\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AE@\n\u0007\u0005\u0005!A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\r\t2\b\u0019AA\u0003!\u0011\t9!!\u0004\u000f\u0007%\tI!C\u0002\u0002\f)\ta\u0001\u0015:fI\u00164\u0017bA\u0016\u0002\u0010)\u0019\u00111\u0002\u0006\t\u000b)4\b\u0019A:")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties props) {
            return KafkaConfig$.MODULE$.fromProps(props);
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LogManager apply(KafkaConfig config) {
            Seq x$2 = (Seq)config.logDirs().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final File apply(String x$1) {
                    return new File(x$1);
                }
            }, Seq$.MODULE$.canBuildFrom());
            CleanerConfig x$3 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
            LogConfig x$4 = TestUtils$.MODULE$.createLogManager$default$2();
            MockTime x$5 = TestUtils$.MODULE$.createLogManager$default$4();
            return TestUtils$.MODULE$.createLogManager((Seq<File>)x$2, x$4, x$3, x$5);
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LogDirFailureChannel apply(KafkaConfig config) {
            return new LogDirFailureChannel(config.logDirs().size());
        }
    }, Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogManager manager) {
                manager.liveLogDirs().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File dir) {
                        Utils.delete((File)dir);
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.createPartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$6 = new TopicPartition(this.topic(), 0);
            LogConfig x$7 = LogConfig$.MODULE$.apply();
            boolean x$8 = qual$1.getOrCreateLog$default$3();
            boolean x$9 = qual$1.getOrCreateLog$default$4();
            Log log0 = qual$1.getOrCreateLog(x$6, x$7, x$8, x$9);
            partition0.setLog(log0, false);
            partition0.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().last()).brokerId()})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        catch (Throwable throwable) {
            void var1_1;
            void var2_2;
            void var4_4;
            var4_4.shutdown(false);
            var2_2.close();
            var1_1.shutdown();
            throw throwable;
        }
        replicaManager.shutdown(false);
        metrics.close();
        scheduler.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.createPartition(t1p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            TopicPartition x$10 = t1p0;
            LogConfig x$11 = LogConfig$.MODULE$.apply();
            boolean x$12 = qual$2.getOrCreateLog$default$3();
            boolean x$13 = qual$2.getOrCreateLog$default$4();
            Log topic1Log0 = qual$2.getOrCreateLog(x$10, x$11, x$12, x$13);
            topic1Partition0.setLog(topic1Log0, false);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)topic1Log0.highWatermark(), (long)topic1Partition0Hw);
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)topic1Log0.highWatermark());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.createPartition(t2p0);
            LogManager qual$3 = (LogManager)this.logManagers().head();
            TopicPartition x$14 = t2p0;
            LogConfig x$15 = LogConfig$.MODULE$.apply();
            boolean x$16 = qual$3.getOrCreateLog$default$3();
            boolean x$17 = qual$3.getOrCreateLog$default$4();
            Log topic2Log0 = qual$3.getOrCreateLog(x$14, x$15, x$16, x$17);
            topic2Partition0.setLog(topic2Log0, false);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)topic2Log0.highWatermark(), (long)topic2Partition0Hw);
            this.append(topic2Partition0, 15);
            topic2Partition0.localLogOrException().updateHighWatermark(15L);
            Assert.assertEquals((long)15L, (long)topic2Log0.highWatermark());
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(10L);
            Assert.assertEquals((long)10L, (long)topic1Log0.highWatermark());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            void var6_6;
            var6_6.shutdown(false);
            var4_4.close();
            var3_3.shutdown();
            throw throwable;
        }
        replicaManager.shutdown(false);
        metrics.close();
        scheduler.shutdown();
    }

    private void append(Partition partition, int count) {
        MemoryRecords records2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Log qual$4 = partition.localLogOrException();
        MemoryRecords x$18 = records2;
        int x$19 = 0;
        AppendOrigin x$20 = qual$4.appendAsLeader$default$3();
        ApiVersion x$21 = qual$4.appendAsLeader$default$4();
        qual$4.appendAsLeader(x$18, x$19, x$20, x$21);
    }

    private long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

