/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0002ba&L!!\u0004\u0006\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C\u0001+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0001\u0016\u0003-\u0011'o\\6fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011\u001d9\u0003A1A\u0005\n!\nQ\u0001^8qS\u000e,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!\u0007\u0001Q\u0001\n%\na\u0001^8qS\u000e\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%I!F\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\f\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0011\u001dA\u0004A1A\u0005BU\t1\u0002\\8h\t&\u00148i\\;oi\"1!\b\u0001Q\u0001\nY\tA\u0002\\8h\t&\u00148i\\;oi\u0002BQ\u0001\u0010\u0001\u0005Bu\nQa]3u+B$\u0012A\u0010\t\u0003/}J!\u0001\u0011\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003w\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u000b),h.\u001b;\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tIEI\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u0017\u0002!\t!P\u0001%i\u0016\u001cH\u000f\u0015:pIV\u001cW-\u0012:s_J4%o\\7GC&dWO]3P]2{wMU8mY\"\u0012!*\u0014\t\u0003\u0007:K!a\u0014#\u0003\tQ+7\u000f\u001e\u0005\u0006#\u0002!\t!P\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\t\u0001V\nC\u0003U\u0001\u0011\u0005Q(A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\u0019V\nC\u0003X\u0001\u0011\u0005Q(A\u0014uKN$\bK]8ek\u000e,WI\u001d:pe\u001a\u0013x.\u001c$bS2,(/Z(o\u0007\",7m\u001b9pS:$\bF\u0001,N\u0011\u0015Q\u0006\u0001\"\u0001>\u0003}!Xm\u001d;J\u001f\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u000336CQ!\u0018\u0001\u0005\u0002u\nA\u0007^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148G_2dwn^3sQ\taV\nC\u0003a\u0001\u0011\u0005\u0011-\u0001\u0016uKN$\bK]8ek\u000e,WI\u001d:peN4%o\\7M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0005y\u0012\u0007\"B2`\u0001\u0004!\u0017a\u00034bS2,(/\u001a+za\u0016\u0004\"!Z<\u000f\u0005\u0019lgBA4m\u001d\tA7.D\u0001j\u0015\tQg!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0004\u0006]\nA\ta\\\u0001\u0012\u0019><G)\u001b:GC&dWO]3UKN$\bC\u0001\nq\r\u0015\t!\u0001#\u0001r'\t\u0001(\u000f\u0005\u0002\u0018g&\u0011A\u000f\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001H\u0011\u0001<\u0015\u0003=4q\u0001\u001f9\u0011\u0002G\u0005\u0012PA\tM_\u001e$\u0015N\u001d$bS2,(/\u001a+za\u0016\u001c\"a\u001e:*\t]\\\u00181\r\u0004\u0006yBD\t) \u0002\u000b\u0007\",7m\u001b9pS:$8cB>s}\u0006\u0005\u0011q\u0001\t\u0003\u007f^l\u0011\u0001\u001d\t\u0004/\u0005\r\u0011bAA\u00031\t9\u0001K]8ek\u000e$\bcA\f\u0002\n%\u0019\u00111\u0002\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\r=YH\u0011AA\b)\t\t\t\u0002\u0005\u0002\u0000w\"A\u0011QC>\u0002\u0002\u0013\u0005\u0003&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\t\u00033Y\u0018\u0011!C\u0001+\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011QD>\u0002\u0002\u0013\u0005\u0011qD\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t#a\n\u0011\u0007]\t\u0019#C\u0002\u0002&a\u00111!\u00118z\u0011%\tI#a\u0007\u0002\u0002\u0003\u0007a#A\u0002yIEB\u0011\"!\f|\u0003\u0003%\t%a\f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\r\u0011\r\u0005M\u0012\u0011HA\u0011\u001b\t\t)DC\u0002\u00028a\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY$!\u000e\u0003\u0011%#XM]1u_JD\u0011\"a\u0010|\u0003\u0003%\t!!\u0011\u0002\u0011\r\fg.R9vC2$B!a\u0011\u0002JA\u0019q#!\u0012\n\u0007\u0005\u001d\u0003DA\u0004C_>dW-\u00198\t\u0015\u0005%\u0012QHA\u0001\u0002\u0004\t\t\u0003C\u0005\u0002Nm\f\t\u0011\"\u0011\u0002P\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u0017\u0011%\t\u0019f_A\u0001\n\u0003\n)&\u0001\u0005u_N#(/\u001b8h)\u0005I\u0003\"CA-w\u0006\u0005I\u0011BA.\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0003c\u0001\u0016\u0002`%\u0019\u0011\u0011M\u0016\u0003\r=\u0013'.Z2u\r\u001d\t)\u0007\u001dEA\u0003O\u0012AAU8mYNA\u00111\r:\u007f\u0003\u0003\t9\u0001C\u0004\u0010\u0003G\"\t!a\u001b\u0015\u0005\u00055\u0004cA@\u0002d!I\u0011QCA2\u0003\u0003%\t\u0005\u000b\u0005\n\u00033\t\u0019'!A\u0005\u0002UA!\"!\b\u0002d\u0005\u0005I\u0011AA;)\u0011\t\t#a\u001e\t\u0013\u0005%\u00121OA\u0001\u0002\u00041\u0002BCA\u0017\u0003G\n\t\u0011\"\u0011\u00020!Q\u0011qHA2\u0003\u0003%\t!! \u0015\t\u0005\r\u0013q\u0010\u0005\u000b\u0003S\tY(!AA\u0002\u0005\u0005\u0002BCA'\u0003G\n\t\u0011\"\u0011\u0002P!Q\u00111KA2\u0003\u0003%\t%!\u0016\t\u0015\u0005e\u00131MA\u0001\n\u0013\tYfB\u0004\u0002\nBD\t)!\u001c\u0002\tI{G\u000e\\\u0004\b\u0003\u001b\u0003\b\u0012QA\t\u0003)\u0019\u0005.Z2la>Lg\u000e\u001e\u0005\b\u0003#\u0003A\u0011AAJ\u0003\u0015\"Xm\u001d;Qe>$WoY3BMR,'\u000fT8h\t&\u0014h)Y5mkJ,wJ\u001c'fC\u0012,'\u000fF\u0002?\u0003+CaaYAH\u0001\u0004!\u0007bBAM\u0001\u0011%\u00111T\u0001\u0013G\u0006,8/\u001a'pO\u0012K'OR1jYV\u0014X\rF\u0004?\u0003;\u000by*!+\t\r\r\f9\n1\u0001e\u0011!\t\t+a&A\u0002\u0005\r\u0016\u0001\u00047fC\u0012,'oU3sm\u0016\u0014\bc\u0001\n\u0002&&\u0019\u0011q\u0015\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\t\u0003W\u000b9\n1\u0001\u0002.\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0003_\u000bY,\u0004\u0002\u00022*!\u00111WA[\u0003\u0019\u0019w.\\7p]*\u0019Q!a.\u000b\u0007\u0005ef)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003{\u000b\tL\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\u0006i2/\u001e2tGJL'-Z!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000fF\u0003?\u0003\u000b\f\u0019\u000eC\u0004(\u0003\u007f\u0003\r!a2\u0011\t\u0005%\u0017q\u001a\b\u0004/\u0005-\u0017bAAg1\u00051\u0001K]3eK\u001aL1\u0001MAi\u0015\r\ti\r\u0007\u0005\t\u0003+\fy\f1\u0001\u0002X\u0006A1m\u001c8tk6,'\u000f\u0005\u0005\u0002Z\u0006\u0005\u0018Q]As\u001b\t\tYN\u0003\u0003\u0002V\u0006u'\u0002BAp\u0003k\u000bqa\u00197jK:$8/\u0003\u0003\u0002d\u0006m'!D&bM.\f7i\u001c8tk6,'\u000fE\u0003\u0018\u0003O\fY/C\u0002\u0002jb\u0011Q!\u0011:sCf\u00042aFAw\u0013\r\ty\u000f\u0007\u0002\u0005\u0005f$X\r")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String kafka$server$LogDirFailureTest$$topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String kafka$server$LogDirFailureTest$$topic() {
        return this.kafka$server$LogDirFailureTest$$topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.kafka$server$LogDirFailureTest$$topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4());
    }

    @Test
    public void testProduceErrorFromFailureOnLogRoll() {
        this.testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setHaltProcedure((Function2)new Serializable(this, statusCodeOption){
            public static final long serialVersionUID = 0L;
            private final VolatileObjectRef statusCodeOption$1;

            public final Nothing$ apply(int statusCode, Option<String> x$1) {
                this.statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
                throw new IllegalArgumentException();
            }
            {
                this.statusCodeOption$1 = statusCodeOption$1;
            }
        });
        KafkaServer server = null;
        try {
            int x$14 = this.brokerCount();
            String x$15 = this.zkConnect();
            int x$16 = 3;
            boolean x$17 = TestUtils$.MODULE$.createBrokerConfig$default$3();
            boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$4();
            int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$5();
            Option<SecurityProtocol> x$20 = TestUtils$.MODULE$.createBrokerConfig$default$6();
            Option<File> x$21 = TestUtils$.MODULE$.createBrokerConfig$default$7();
            Option<Properties> x$22 = TestUtils$.MODULE$.createBrokerConfig$default$8();
            boolean x$23 = TestUtils$.MODULE$.createBrokerConfig$default$9();
            boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$10();
            int x$25 = TestUtils$.MODULE$.createBrokerConfig$default$11();
            boolean x$26 = TestUtils$.MODULE$.createBrokerConfig$default$12();
            int x$27 = TestUtils$.MODULE$.createBrokerConfig$default$13();
            boolean x$28 = TestUtils$.MODULE$.createBrokerConfig$default$14();
            int x$29 = TestUtils$.MODULE$.createBrokerConfig$default$15();
            Option<String> x$30 = TestUtils$.MODULE$.createBrokerConfig$default$16();
            boolean x$31 = TestUtils$.MODULE$.createBrokerConfig$default$18();
            int x$32 = TestUtils$.MODULE$.createBrokerConfig$default$19();
            short x$33 = TestUtils$.MODULE$.createBrokerConfig$default$20();
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$14, x$15, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$16, x$31, x$32, x$33);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)new Serializable(this, logDir){
                public static final long serialVersionUID = 0L;
                private final File logDir$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Utils.delete((File)this.logDir$1);
                }
                {
                    this.logDir$1 = logDir$1;
                }
            }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            logDir.createNewFile();
            Assert.assertTrue((boolean)logDir.isFile());
            server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, statusCodeOption){
                public static final long serialVersionUID = 0L;
                private final VolatileObjectRef statusCodeOption$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return ((Option)this.statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
                }
                {
                    this.statusCodeOption$1 = statusCodeOption$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "timed out waiting for broker to halt";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            Exit$.MODULE$.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
            }
            throw throwable;
        }
        Exit$.MODULE$.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
        }
    }

    @Test
    public void testProduceErrorFromFailureOnCheckpoint() {
        this.testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$2) {
                return x$2.partition() == 0;
            }
        }).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$1;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() == this.leaderServerId$1;
            }
            {
                this.leaderServerId$1 = leaderServerId$1;
            }
        }).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$1;

            public final boolean apply(int x$5) {
                return this.apply$mcZI$sp(x$5);
            }

            public boolean apply$mcZI$sp(int x$5) {
                return x$5 != this.leaderServerId$1;
            }
            {
                this.leaderServerId$1 = leaderServerId$1;
            }
        }).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, followerServerId){
            public static final long serialVersionUID = 0L;
            private final int followerServerId$1;

            public final boolean apply(KafkaServer x$6) {
                return x$6.config().brokerId() == this.followerServerId$1;
            }
            {
                this.followerServerId$1 = followerServerId$1;
            }
        }).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)new Serializable(this, leaderServer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogDirFailureTest $outer;
            private final KafkaServer leaderServer$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.leaderServer$1.replicaManager().nonOfflinePartition(new TopicPartition(this.$outer.kafka$server$LogDirFailureTest$$topic(), i)).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Log> apply(Partition x$7) {
                        return x$7.leaderLogIfLocal();
                    }
                }).isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderServer$1 = leaderServer$1;
            }
        }).get());
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.kafka$server$LogDirFailureTest$$topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.brokerCount(), (long)((Partition)leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ReplicaFetcherThread thread) {
                Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
            }
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(0), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$8) {
                return x$8.partition() == 0;
            }
        }).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$2;

            public final boolean apply(KafkaServer x$9) {
                return x$9.config().brokerId() == this.leaderServerId$2;
            }
            {
                this.leaderServerId$2 = leaderServerId$2;
            }
        }).get();
        this.causeLogDirFailure(failureType, leaderServer, partition);
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw Assertions$.MODULE$.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        catch (ExecutionException executionException) {
            Throwable throwable;
            block8: {
                block7: {
                    block6: {
                        throwable = executionException.getCause();
                        if (!(throwable instanceof KafkaStorageException)) break block6;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(throwable instanceof NotLeaderForPartitionException)) break block8;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable2.toString()})), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            throw new MatchError((Object)throwable);
        }
    }

    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.kafka$server$LogDirFailureTest$$topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(0), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$10) {
                return x$10.partition() == 0;
            }
        }).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$3;

            public final boolean apply(KafkaServer x$11) {
                return x$11.config().brokerId() == this.leaderServerId$3;
            }
            {
                this.leaderServerId$3 = leaderServerId$3;
            }
        }).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        this.causeLogDirFailure(failureType, leaderServer, partition);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, producer, record, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogDirFailureTest $outer;
            private final KafkaProducer producer$1;
            private final ProducerRecord record$1;
            private final int leaderServerId$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.producer$1.send(this.record$1);
                return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.producer$1.partitionsFor(this.$outer.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(PartitionInfo x$12) {
                        return x$12.partition() == 0;
                    }
                }).get()).leader().id() != this.leaderServerId$3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.record$1 = record$1;
                this.leaderServerId$3 = leaderServerId$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected new leader for the partition";
            }
        }, 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$13) {
                return x$13.kafkaController().isActive();
            }
        }).get();
        Set offlineReplicas = controllerServer.kafkaController().controllerContext().replicasInState(this.kafka$server$LogDirFailureTest$$topic(), (ReplicaState)OfflineReplica$.MODULE$);
        Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0), leaderServerId)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void causeLogDirFailure(LogDirFailureType failureType, KafkaServer leaderServer, TopicPartition partition) {
        Log localLog = leaderServer.replicaManager().localLogOrException(partition);
        File logDir = localLog.dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)new Serializable(this, logDir){
            public static final long serialVersionUID = 0L;
            private final File logDir$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils.delete((File)this.logDir$2);
            }
            {
                this.logDir$2 = logDir$2;
            }
        }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$34 = qual$1.roll$default$1();
                qual$1.roll(x$34);
                throw Assertions$.MODULE$.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            }
            catch (KafkaStorageException kafkaStorageException) {
                // empty catch block
            }
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, leaderServer, logDir){
            public static final long serialVersionUID = 0L;
            private final KafkaServer leaderServer$2;
            private final File logDir$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.leaderServer$2.logManager().isLogDirOnline(this.logDir$2.getAbsolutePath());
            }
            {
                this.leaderServer$2 = leaderServer$2;
                this.logDir$2 = logDir$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected log directory offline";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)leaderServer.replicaManager().localLog(partition).isEmpty());
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.consumer$1.assignment().isEmpty();
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.kafka$server$LogDirFailureTest$$topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

