/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.cluster.Broker;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.MetadataCacheTest$$anonfun$getTopicMetadata$1$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#T3uC\u0012\fG/Y\"bG\",G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0016\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001\u0002'p]\u001eDaA\u0007\u0001!\u0002\u00131\u0012\u0001\u00042s_.,'/\u00129pG\"\u0004\u0003\"\u0002\u000f\u0001\t\u0003i\u0012!I4fiR{\u0007/[2NKR\fG-\u0019;b\u001d>tW\t_5ti&tw\rV8qS\u000e\u001cH#\u0001\u0010\u0011\u0005%y\u0012B\u0001\u0011\u000b\u0005\u0011)f.\u001b;)\u0005m\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015QWO\\5u\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\n\u0002\u0005)\u0016\u001cH\u000fC\u0003,\u0001\u0011\u0005Q$\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"\u0012!F\t\u0005\u0006]\u0001!\t!H\u0001,O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mK\"\u0012QF\t\u0005\u0006c\u0001!\t!H\u00016O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM\u001d(pi\u00063\u0018-\u001b7bE2,wJ\u001c'fC\u0012,'\u000f\u000b\u00021E!)A\u0007\u0001C\u0001;\u00059u-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019&\u001cH/\u001a8fe:{G/\u0011<bS2\f'\r\\3P]2+\u0017\rZ3s\u001f2$W*\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u000b\u00024E!)q\u0007\u0001C\u0005q\u0005Ad/\u001a:jMf$v\u000e]5d\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*Z1eKJ|%/\u00128ea>Lg\u000e\u001e(pi\u00063\u0018-\u001b7bE2,GC\u0002\u0010:?\u001edG\u000fC\u0003;m\u0001\u00071(A\u0004ce>\\WM]:\u0011\u0007q\"uI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IB\u0001\u0007yI|w\u000e\u001e \n\u0003-I!a\u0011\u0006\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u0004'\u0016\f(BA\"\u000b!\tAEL\u0004\u0002J3:\u0011!J\u0016\b\u0003\u0017Ns!\u0001T)\u000f\u00055{eB\u0001 O\u0013\u00059\u0013B\u0001)'\u0003\u0019\t\u0007/Y2iK&\u0011QA\u0015\u0006\u0003!\u001aJ!\u0001V+\u0002\r\r|W.\\8o\u0015\t)!+\u0003\u0002X1\u00069Q.Z:tC\u001e,'B\u0001+V\u0013\tQ6,A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f'BA,Y\u0013\tifL\u0001\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1Ce>\\WM\u001d\u0006\u00035nCQ\u0001\u0019\u001cA\u0002\u0005\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004\"AY3\u000e\u0003\rT!\u0001\u001a-\u0002\u000f9,Go^8sW&\u0011am\u0019\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\u0006QZ\u0002\r![\u0001\u0007Y\u0016\fG-\u001a:\u0011\u0005%Q\u0017BA6\u000b\u0005\rIe\u000e\u001e\u0005\u0006[Z\u0002\rA\\\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0011\u0005=\u0014X\"\u00019\u000b\u0005ED\u0016\u0001\u00039s_R|7m\u001c7\n\u0005M\u0004(AB#se>\u00148\u000fC\u0003vm\u0001\u0007a/A\rfeJ|'/\u00168bm\u0006LG.\u00192mK2K7\u000f^3oKJ\u001c\bCA\u0005x\u0013\tA(BA\u0004C_>dW-\u00198\t\u000bi\u0004A\u0011A\u000f\u0002G\u001d,G\u000fV8qS\u000elU\r^1eCR\f'+\u001a9mS\u000e\fgj\u001c;Bm\u0006LG.\u00192mK\"\u0012\u0011P\t\u0005\u0006{\u0002!\t!H\u0001 O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006L5O\u001d(pi\u00063\u0018-\u001b7bE2,\u0007F\u0001?#\u0011\u0019\t\t\u0001\u0001C\u0001;\u0005\u0001t-\u001a;U_BL7-T3uC\u0012\fG/Y,ji\"tuN\\*vaB|'\u000f^3e'\u0016\u001cWO]5usB\u0013x\u000e^8d_2D#a \u0012\t\r\u0005\u001d\u0001\u0001\"\u0001\u001e\u00039:W\r^!mSZ,'I]8lKJ\u001c8\u000b[8vY\u0012tu\u000e\u001e\"f\u001bV$\u0018\r^3e\u0005f,\u0006\u000fZ1uK\u000e\u000b7\r[3)\u0007\u0005\u0015!\u0005")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Test
    public void getTopicMetadataNonExistingTopics() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertTrue((boolean)topicMetadata.isEmpty());
    }

    @Test
    public void getTopicMetadata() {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;

            public final UpdateMetadataRequestData.UpdateMetadataBroker apply(int brokerId) {
                return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.$outer.kafka$server$MetadataCacheTest$$endpoints$1(brokerId)).asJava()).setRack("rack1");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4)})), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}))).foreach((Function1)new Serializable(this, topic0, topic1, cache, partitionStates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;
            private final String topic0$1;
            private final String topic1$1;
            private final MetadataCache cache$1;
            private final Seq partitionStates$1;

            public final void apply(SecurityProtocol securityProtocol) {
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                this.checkTopicMetadata$1(this.topic0$1, listenerName);
                this.checkTopicMetadata$1(this.topic1$1, listenerName);
            }

            public /* synthetic */ MetadataCacheTest kafka$server$MetadataCacheTest$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkTopicMetadata$1(String topic, ListenerName listenerName$1) {
                Seq topicMetadatas = this.cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, this.cache$1.getTopicMetadata$default$3(), this.cache$1.getTopicMetadata$default$4());
                Assert.assertEquals((long)1L, (long)topicMetadatas.size());
                MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
                Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
                Assert.assertEquals((Object)topic, (Object)topicMetadata.topic());
                Seq topicPartitionStates = (Seq)this.partitionStates$1.filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final boolean apply(UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
                        String string = ps.topicName();
                        String string2 = this.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                });
                Buffer partitionMetadatas = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MetadataResponse.PartitionMetadata x$1) {
                        return x$1.partition();
                    }
                }, (Ordering)Ordering.Int$.MODULE$);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected partition count for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), (long)topicPartitionStates.size(), (long)partitionMetadatas.size());
                ((IterableLike)partitionMetadatas.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, listenerName$1, topicPartitionStates){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTopicMetadata$1 $outer;
                    public final ListenerName listenerName$1;
                    private final Seq topicPartitionStates$1;

                    public final void apply(Tuple2<MetadataResponse.PartitionMetadata, Object> x0$1) {
                        Tuple2<MetadataResponse.PartitionMetadata, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)tuple2._1();
                            int partitionId = tuple2._2$mcI$sp();
                            Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
                            Assert.assertEquals((long)partitionId, (long)partitionMetadata.partition());
                            Node leader2 = partitionMetadata.leader();
                            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)this.topicPartitionStates$1.find((Function1)new Serializable(this, partitionId){
                                public static final long serialVersionUID = 0L;
                                private final int partitionId$1;

                                public final boolean apply(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
                                    return x$2.partitionIndex() == this.partitionId$1;
                                }
                                {
                                    this.partitionId$1 = partitionId$1;
                                }
                            }).getOrElse((Function0)new Serializable(this, partitionId){
                                public static final long serialVersionUID = 0L;
                                private final int partitionId$1;

                                public final Nothing$ apply() {
                                    return Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find partition state for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitionId$1)})), new Position("MetadataCacheTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                                }
                                {
                                    this.partitionId$1 = partitionId$1;
                                }
                            });
                            Assert.assertEquals((long)partitionState.leader(), (long)leader2.id());
                            Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)partitionState.leaderEpoch())), (Object)partitionMetadata.leaderEpoch());
                            Assert.assertEquals((Object)partitionState.isr(), (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Node x$3) {
                                    return x$3.id();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).asJava());
                            Assert.assertEquals((Object)partitionState.replicas(), (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Node x$4) {
                                    return x$4.id();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).asJava());
                            UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint = (UpdateMetadataRequestData.UpdateMetadataEndpoint)this.$outer.kafka$server$MetadataCacheTest$$anonfun$$$outer().kafka$server$MetadataCacheTest$$endpoints$1(partitionMetadata.leader().id()).find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getTopicMetadata$1$$anonfun$checkTopicMetadata$1$1 $outer;

                                public final boolean apply(UpdateMetadataRequestData.UpdateMetadataEndpoint x$5) {
                                    String string = x$5.listener();
                                    String string2 = this.$outer.listenerName$1.value();
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).get();
                            Assert.assertEquals((Object)endpoint.host(), (Object)leader2.host());
                            Assert.assertEquals((long)endpoint.port(), (long)leader2.port());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.listenerName$1 = listenerName$1;
                        this.topicPartitionStates$1 = topicPartitionStates$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic0$1 = topic0$1;
                this.topic1$1 = topic1$1;
                this.cache$1 = cache$1;
                this.partitionStates$1 = partitionStates$1;
            }
        });
    }

    @Test
    public void getTopicMetadataPartitionLeaderNotAvailable() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}))).asJava())}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value())}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value())}));
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava()), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava())}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeaderOldMetadataVersion() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value())}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value())}));
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava()), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava())}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader2, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        scala.collection.immutable.Set x$15 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        ListenerName x$16 = listenerName;
        boolean x$17 = errorUnavailableListeners;
        boolean x$18 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$15, x$16, x$18, x$17);
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)expectedError, (Object)partitionMetadata.error());
        Assert.assertFalse((boolean)partitionMetadata.isr().isEmpty());
        Assert.assertEquals((long)1L, (long)partitionMetadata.replicas().size());
        Assert.assertEquals((long)0L, (long)((Node)partitionMetadata.replicas().get(0)).id());
    }

    @Test
    public void getTopicMetadataReplicaNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}))).asJava())}));
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$6) {
                return x$6.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$7) {
                return x$7.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$8) {
                return x$8.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$9) {
                return x$9.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataIsrNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}))).asJava())}));
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$10) {
                return x$10.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$11) {
                return x$11.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$12) {
                return x$12.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$13) {
                return x$13.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataWithNonSupportedSecurityProtocol() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value())}))).asJava())}));
        int controllerEpoch = 1;
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadata.size());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().size());
        Assert.assertEquals((long)-1L, (long)((MetadataResponse.PartitionMetadata)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().get(0)).leaderId());
    }

    @Test
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Seq aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assert.assertEquals((Object)initialBrokerIds.toSet(), (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$14) {
                return x$14.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public final Seq kafka$server$MetadataCacheTest$$endpoints$1(int brokerId) {
        String host = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)}));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value())}));
    }

    private final void updateCache$1(Seq brokerIds, String topic$2, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UpdateMetadataRequestData.UpdateMetadataBroker apply(int brokerId) {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value())}))).asJava());
            }
        }, Seq$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$2).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader2).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache$2.updateMetadata(15, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }
}

