/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u000f\t\u0001\"+\u001a9mS\u000e\fg)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012a\u00022s_.,'o]\u000b\u0002-A\u0019q\u0003\b\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002DA\u0002TKF\u0004\"AE\u0010\n\u0005\u0001\u0012!aC&bM.\f7+\u001a:wKJDqA\t\u0001A\u0002\u0013\u00051%A\u0006ce>\\WM]:`I\u0015\fHC\u0001\u0013)!\t)c%D\u0001\u001b\u0013\t9#D\u0001\u0003V]&$\bbB\u0015\"\u0003\u0003\u0005\rAF\u0001\u0004q\u0012\n\u0004BB\u0016\u0001A\u0003&a#\u0001\u0005ce>\\WM]:!\u0011\u001di\u0003A1A\u0005\u00029\na\u0001^8qS\u000e\fT#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001\u00027b]\u001eT\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\t11\u000b\u001e:j]\u001eDa\u0001\u000f\u0001!\u0002\u0013y\u0013a\u0002;pa&\u001c\u0017\u0007\t\u0005\bu\u0001\u0011\r\u0011\"\u0001/\u0003\u0019!x\u000e]5de!1A\b\u0001Q\u0001\n=\nq\u0001^8qS\u000e\u0014\u0004\u0005C\u0003?\u0001\u0011\u0005s(A\u0003tKR,\u0006\u000fF\u0001%Q\ti\u0014\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)!.\u001e8ji*\ta)A\u0002pe\u001eL!\u0001S\"\u0003\r\t+gm\u001c:f\u0011\u0015Q\u0005\u0001\"\u0011@\u0003!!X-\u0019:E_^t\u0007FA%M!\t\u0011U*\u0003\u0002O\u0007\n)\u0011I\u001a;fe\")\u0001\u000b\u0001C\u0001\u007f\u0005AB/Z:u%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193)\u0005=\u0013\u0006C\u0001\"T\u0013\t!6I\u0001\u0003UKN$\b")
public class ReplicaFetchTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> brokers = null;
    private final String topic1;
    private final String topic2;

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> props = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.brokers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)props.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$1) {
                return TestUtils$.MODULE$.createServer(x$1, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void testReplicaFetcherThread() {
        int partition = 0;
        List testMessageList1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"}));
        List testMessageList2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test5", "test6", "test7", "test8"}));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;

            public final Map<Object, Object> apply(String topic) {
                return TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, 1, 2, this.$outer.brokers(), TestUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String x$3 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$4 = new StringSerializer();
        StringSerializer x$5 = new StringSerializer();
        int x$6 = TestUtils$.MODULE$.createProducer$default$2();
        long x$7 = TestUtils$.MODULE$.createProducer$default$3();
        long x$8 = TestUtils$.MODULE$.createProducer$default$4();
        int x$9 = TestUtils$.MODULE$.createProducer$default$5();
        int x$10 = TestUtils$.MODULE$.createProducer$default$6();
        int x$11 = TestUtils$.MODULE$.createProducer$default$7();
        int x$12 = TestUtils$.MODULE$.createProducer$default$8();
        String x$13 = TestUtils$.MODULE$.createProducer$default$9();
        int x$14 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$15 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$16 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$17 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$4, x$5);
        List records2 = (List)((List)testMessageList1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;

            public final ProducerRecord<String, String> apply(String m) {
                return new ProducerRecord(this.$outer.topic1(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testMessageList2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;

            public final ProducerRecord<String, String> apply(String m) {
                return new ProducerRecord(this.$outer.topic2(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        ((List)records2.map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(ProducerRecord<String, String> x$1) {
                return this.producer$1.send(x$1);
            }
            {
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                return x$2.get();
            }
        });
        producer.close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;
            private final int partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$server$ReplicaFetchTest$$logsMatch$1(this.partition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Broker logs should be identical";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public final boolean kafka$server$ReplicaFetchTest$$logsMatch$1(int partition$1) {
        BooleanRef result = BooleanRef.create((boolean)true);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this, partition$1, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;
            private final int partition$1;
            private final BooleanRef result$1;

            public final void apply(String topic) {
                TopicPartition tp = new TopicPartition(topic, this.partition$1);
                LogManager qual$1 = ((KafkaServer)this.$outer.brokers().head()).getLogManager();
                TopicPartition x$18 = tp;
                boolean x$19 = qual$1.getLog$default$2();
                long expectedOffset = ((Log)qual$1.getLog(x$18, x$19).get()).logEndOffset();
                this.result$1.elem = this.result$1.elem && expectedOffset > 0L && this.$outer.brokers().forall((Function1)new Serializable(this, tp, expectedOffset){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition tp$1;
                    private final long expectedOffset$1;

                    public final boolean apply(KafkaServer item) {
                        boolean x$21;
                        TopicPartition x$20;
                        LogManager qual$2 = item.getLogManager();
                        return this.expectedOffset$1 == ((Log)qual$2.getLog(x$20 = this.tp$1, x$21 = qual$2.getLog$default$2()).get()).logEndOffset();
                    }
                    {
                        this.tp$1 = tp$1;
                        this.expectedOffset$1 = expectedOffset$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        });
        return result.elem;
    }

    public ReplicaFetchTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
    }
}

