/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\tY\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\tA\u0001^5nKV\ta\u0003\u0005\u0002\u0018C5\t\u0001D\u0003\u0002\u001a5\u0005)Q\u000f^5mg*\u00111\u0004H\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i\"B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001eL!A\t\r\u0003\u00115{7m\u001b+j[\u0016Da\u0001\n\u0001!\u0002\u00131\u0012!\u0002;j[\u0016\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%IaJ\u0001\b[\u0016$(/[2t+\u0005A\u0003CA\u0015,\u001b\u0005Q#B\u0001\u0014\u001b\u0013\ta#FA\u0004NKR\u0014\u0018nY:\t\r9\u0002\u0001\u0015!\u0003)\u0003!iW\r\u001e:jGN\u0004\u0003\"\u0002\u0019\u0001\t\u0003\t\u0014\u0001\u0003;fCJ$un\u001e8\u0015\u0003I\u0002\"!C\u001a\n\u0005QR!\u0001B+oSRD#a\f\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ez\u0012!\u00026v]&$\u0018BA\u001e9\u0005\u0015\te\r^3s\u0011\u0015i\u0004\u0001\"\u00012\u0003\u0005\u001a\bn\\;mIRC'o\u001c;uY\u0016|e\u000e\\=EK\u001aLg.\u001a3SKBd\u0017nY1tQ\tat\b\u0005\u00028\u0001&\u0011\u0011\t\u000f\u0002\u0005)\u0016\u001cH\u000fC\u0003D\u0001\u0011\u0005\u0011'A\u001btQ>,H\u000eZ#yG\u0016,G-U;pi\u0006$\u0006.\u001a8SKR,(O\u001c\"bG.\u0014U\r\\8x\u0005>,h\u000eZ!t)&lW\rU1tg\u0016\u001c\bF\u0001\"@\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0011\u0011\u0018\r^3\u0015\u0005![\u0005CA\u0005J\u0013\tQ%B\u0001\u0004E_V\u0014G.\u001a\u0005\u0006M\u0015\u0003\r\u0001\u000b\u0005\u0006\u001b\u0002!\t!M\u0001'g\"|W\u000f\u001c3TkB\u0004xN\u001d;XS2$7-\u0019:e)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c\bF\u0001'@\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0003\r!\b/\r\u000b\u0003%Z\u0003\"a\u0015+\u000e\u0003iI!!\u0016\u000e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")qk\u0014a\u00011\u0006\u0011\u0011\u000e\u001a\t\u0003\u0013eK!A\u0017\u0006\u0003\u0007%sG\u000f")
public class ReplicationQuotaManagerTest {
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void shouldThrottleOnlyDefinedReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time());
        quota.markThrottled("topic1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(1)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(2)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(3)));
        Assert.assertFalse((boolean)quota.isThrottled(this.tp1(4)));
    }

    @Test
    public void shouldExceedQuotaThenReturnBackBelowBoundAsTimePasses() {
        int x$1 = 10;
        int x$2 = 1;
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(x$3, x$1, x$2), this.metrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.updateQuota(new Quota(100.0, true));
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        this.time().sleep(1000L);
        this.time().sleep(500L);
        quota.record(1L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(149L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertEquals((double)100.66666666666667, (double)this.rate(this.metrics()), (double)0.0);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        this.time().sleep(500L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)75.5, (double)this.rate(this.metrics()), (double)0.1);
        this.time().sleep(500L);
        quota.record(99L);
        Assert.assertEquals((double)100.0, (double)this.rate(this.metrics()), (double)0.0);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)100.4, (double)this.rate(this.metrics()), (double)0.0);
        this.time().sleep(2000L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)55.77777777777778, (double)this.rate(this.metrics()), (double)0.0);
    }

    /*
     * WARNING - void declaration
     */
    public double rate(Metrics metrics) {
        void var3_3;
        MetricName metricName = metrics.metricName("byte-rate", QuotaType.LeaderReplication$.MODULE$.toString(), new StringBuilder().append((Object)"Tracking byte-rate for ").append((Object)QuotaType.LeaderReplication$.MODULE$).toString());
        double leaderThrottledRate = BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).apply((Object)metricName)).metricValue());
        return (double)var3_3;
    }

    @Test
    public void shouldSupportWildcardThrottledReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.markThrottled("MyTopic");
        Assert.assertTrue((boolean)quota.isThrottled(new TopicPartition("MyTopic", 0)));
        Assert.assertFalse((boolean)quota.isThrottled(new TopicPartition("MyOtherTopic", 0)));
    }

    private TopicPartition tp1(int id) {
        return new TopicPartition("topic1", id);
    }
}

