/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.InconsistentClusterIdException;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.ServerGenerateClusterIdTest$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u00111dU3sm\u0016\u0014x)\u001a8fe\u0006$Xm\u00117vgR,'/\u00133UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\tQ8.\u0003\u0002\u000e\u0015\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001\u0001\u0019!C\u0001+\u000591m\u001c8gS\u001e\fT#\u0001\f\u0011\u0005I9\u0012B\u0001\r\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000fi\u0001\u0001\u0019!C\u00017\u0005Y1m\u001c8gS\u001e\ft\fJ3r)\ta\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0003V]&$\bbB\u0012\u001a\u0003\u0003\u0005\rAF\u0001\u0004q\u0012\n\u0004BB\u0013\u0001A\u0003&a#\u0001\u0005d_:4\u0017nZ\u0019!\u0011\u001d9\u0003\u00011A\u0005\u0002U\tqaY8oM&<'\u0007C\u0004*\u0001\u0001\u0007I\u0011\u0001\u0016\u0002\u0017\r|gNZ5he}#S-\u001d\u000b\u00039-Bqa\t\u0015\u0002\u0002\u0003\u0007a\u0003\u0003\u0004.\u0001\u0001\u0006KAF\u0001\tG>tg-[43A!9q\u0006\u0001a\u0001\n\u0003)\u0012aB2p]\u001aLwm\r\u0005\bc\u0001\u0001\r\u0011\"\u00013\u0003-\u0019wN\u001c4jONzF%Z9\u0015\u0005q\u0019\u0004bB\u00121\u0003\u0003\u0005\rA\u0006\u0005\u0007k\u0001\u0001\u000b\u0015\u0002\f\u0002\u0011\r|gNZ5hg\u0001Bqa\u000e\u0001A\u0002\u0013\u0005\u0001(A\u0004tKJ4XM]:\u0016\u0003e\u00022AO\u001f@\u001b\u0005Y$B\u0001\u001f\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003}m\u00121aU3r!\t\u0011\u0002)\u0003\u0002B\u0005\tY1*\u00194lCN+'O^3s\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000b1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011A$\u0012\u0005\bG\t\u000b\t\u00111\u0001:\u0011\u00199\u0005\u0001)Q\u0005s\u0005A1/\u001a:wKJ\u001c\b\u0005C\u0004J\u0001\t\u0007I\u0011\u0001&\u0002'\t\u0014xn[3s\u001b\u0016$\u0018\r\u0015:paN4\u0015\u000e\\3\u0016\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\t1\fgn\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0004TiJLgn\u001a\u0005\u0007)\u0002\u0001\u000b\u0011B&\u0002)\t\u0014xn[3s\u001b\u0016$\u0018\r\u0015:paN4\u0015\u000e\\3!\u0011\u00151\u0006\u0001\"\u0011X\u0003\u0015\u0019X\r^+q)\u0005a\u0002FA+Z!\tQv,D\u0001\\\u0015\taV,A\u0003kk:LGOC\u0001_\u0003\ry'oZ\u0005\u0003An\u0013aAQ3g_J,\u0007\"\u00022\u0001\t\u0003:\u0016\u0001\u0003;fCJ$un\u001e8)\u0005\u0005$\u0007C\u0001.f\u0013\t17LA\u0003BMR,'\u000fC\u0003i\u0001\u0011\u0005q+A\ruKN$\u0018)\u001e;p\u000f\u0016tWM]1uK\u000ecWo\u001d;fe&#\u0007FA4k!\tQ6.\u0003\u0002m7\n!A+Z:u\u0011\u0015q\u0007\u0001\"\u0001X\u0003I\"Xm\u001d;BkR|w)\u001a8fe\u0006$Xm\u00117vgR,'/\u00133G_J\\\u0015MZ6b\u00072,8\u000f^3s'\u0016\fX/\u001a8uS\u0006d\u0007FA7k\u0011\u0015\t\b\u0001\"\u0001X\u0003A\"Xm\u001d;BkR|w)\u001a8fe\u0006$Xm\u00117vgR,'/\u00133G_J\\\u0015MZ6b\u00072,8\u000f^3s!\u0006\u0014\u0018\r\u001c7fY\"\u0012\u0001O\u001b\u0005\u0006i\u0002!\taV\u00015i\u0016\u001cHoQ8og&\u001cH/\u001a8u\u00072,8\u000f^3s\u0013\u00124%o\\7[_>\\W-\u001a9fe\u0006sGM\u0012:p[6+G/\u0019)s_B\u001c\bFA:k\u0011\u00159\b\u0001\"\u0001X\u0003Y\"Xm\u001d;J]\u000e|gn]5ti\u0016tGo\u00117vgR,'/\u00133Ge>l'l\\8lK\u0016\u0004XM]!oI\u001a\u0013x.\\'fi\u0006\u0004&o\u001c9tQ\t1(\u000eC\u0003{\u0001\u0011\u0005q+\u0001\u001buKN$\u0018J\\2p]NL7\u000f^3oi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\n+Go^3f]6+H\u000e^5qY\u0016dun\u001a#jeND#!\u001f6\t\u000bu\u0004A\u0011\u0001@\u0002'\u0019|'oZ3Ce>\\WM]'fi\u0006$\u0017\r^1\u0015\rqy\u0018\u0011CA\u000e\u0011\u001d\t\t\u0001 a\u0001\u0003\u0007\tq\u0001\\8h\t&\u00148\u000f\u0005\u0003;{\u0005\u0015\u0001\u0003BA\u0004\u0003\u001bq1!HA\u0005\u0013\r\tYAH\u0001\u0007!J,G-\u001a4\n\u0007I\u000byAC\u0002\u0002\fyAq!a\u0005}\u0001\u0004\t)\"\u0001\u0005ce>\\WM]%e!\ri\u0012qC\u0005\u0004\u00033q\"aA%oi\"9\u0011Q\u0004?A\u0002\u0005\u0015\u0011!C2mkN$XM]%e\u0011\u0019i\b\u0001\"\u0001\u0002\"Q9A$a\t\u0002(\u0005%\u0002\u0002CA\u0013\u0003?\u0001\r!!\u0002\u0002\r1|w\rR5s\u0011!\t\u0019\"a\bA\u0002\u0005U\u0001\u0002CA\u000f\u0003?\u0001\r!!\u0002\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u0005!b/\u001a:jMf\u0014%o\\6fe6+G/\u00193bi\u0006$b!!\r\u00028\u0005e\u0002cA\u000f\u00024%\u0019\u0011Q\u0007\u0010\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011AA\u0016\u0001\u0004\t\u0019\u0001\u0003\u0005\u0002\u001e\u0005-\u0002\u0019AA\u0003\u0001")
public class ServerGenerateClusterIdTest
extends ZooKeeperTestHarness {
    private KafkaConfig config1 = null;
    private KafkaConfig config2 = null;
    private KafkaConfig config3 = null;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String brokerMetaPropsFile;

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assert.assertFalse((boolean)this.zkClient().getClusterId().isDefined());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assert.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assert.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assert.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3}))));
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        server1.startup();
        Assert.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assert.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assert.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.shutdown();
            }
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        Future firstBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2(), this.config3()})), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerGenerateClusterIdTest $outer;

            public final Future<KafkaServer> apply(KafkaConfig config) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, config){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final KafkaConfig config$1;

                    public final KafkaServer apply() {
                        return TestUtils$.MODULE$.createServer(this.config$1, (Option<String>)Option$.MODULE$.apply((Object)this.$outer.kafka$server$ServerGenerateClusterIdTest$$anonfun$$$outer().getClass().getName()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.config$1 = config$1;
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            }

            public /* synthetic */ ServerGenerateClusterIdTest kafka$server$ServerGenerateClusterIdTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        Seq<KafkaServer> seq = this.servers();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
            Tuple3 tuple3;
            KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
            KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
            KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)server1, (Object)server2, (Object)server3);
            KafkaServer server12 = (KafkaServer)tuple32._1();
            KafkaServer server22 = (KafkaServer)tuple32._2();
            KafkaServer server32 = (KafkaServer)tuple32._3();
            String clusterIdFromServer1 = server12.clusterId();
            String clusterIdFromServer2 = server22.clusterId();
            String clusterIdFromServer3 = server32.clusterId();
            this.servers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$4) {
                    x$4.shutdown();
                }
            });
            TestUtils.isValidClusterId((String)clusterIdFromServer1);
            Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
            Future secondBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server12, server22, server32})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Future<KafkaServer> apply(KafkaServer server) {
                    return Future$.MODULE$.apply((Function0)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$3;

                        public final KafkaServer apply() {
                            this.server$3.startup();
                            return this.server$3;
                        }
                        {
                            this.server$3 = server$3;
                        }
                    }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                }
            }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
            this.servers().foreach((Function1)new Serializable(this, clusterIdFromServer1){
                public static final long serialVersionUID = 0L;
                private final String clusterIdFromServer1$1;

                public final void apply(KafkaServer server) {
                    Assert.assertEquals((Object)this.clusterIdFromServer1$1, (Object)server.clusterId());
                }
                {
                    this.clusterIdFromServer1$1 = clusterIdFromServer1$1;
                }
            });
            this.servers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$5) {
                    x$5.shutdown();
                }
            });
            TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
            return;
        }
        throw new MatchError(seq);
    }

    @Test
    public void testConsistentClusterIdFromZookeeperAndFromMetaProps() {
        KafkaServer server = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterId = server.clusterId();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), clusterId));
        server.shutdown();
        server.startup();
        Assert.assertEquals((Object)clusterId, (Object)server.clusterId());
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), server.clusterId()));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentClusterIdFromZookeeperAndFromMetaProps() {
        this.forgeBrokerMetadata((Seq<String>)this.config1().logDirs(), this.config1().brokerId(), "aclusterid");
        KafkaConfig x$6 = this.config1();
        Option x$7 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$9 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$6, x$8, x$7, x$9);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final KafkaServer server$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$1.startup();
            }
            {
                this.server$1 = server$1;
            }
        }, ClassTag$.MODULE$.apply(InconsistentClusterIdException.class), new Position("ServerGenerateClusterIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentBrokerMetadataBetweenMultipleLogDirs() {
        KafkaConfig config;
        String logDir1 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDir2 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDirs = new StringBuilder().append((Object)logDir1).append((Object)",").append((Object)logDir2).toString();
        this.forgeBrokerMetadata(logDir1, 1, "ebwOKU-zSieInaFQh_qP4g");
        this.forgeBrokerMetadata(logDir2, 1, "blaOKU-zSieInaFQh_qP4g");
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.setProperty("log.dir", logDirs);
        KafkaConfig x$10 = config = KafkaConfig$.MODULE$.fromProps(props);
        Option x$11 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$12 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$13 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$10, x$12, x$11, x$13);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final KafkaServer server$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$2.startup();
            }
            {
                this.server$2 = server$2;
            }
        }, ClassTag$.MODULE$.apply(InconsistentBrokerMetadataException.class), new Position("ServerGenerateClusterIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public void forgeBrokerMetadata(Seq<String> logDirs, int brokerId, String clusterId) {
        logDirs.foreach((Function1)new Serializable(this, brokerId, clusterId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerGenerateClusterIdTest $outer;
            private final int brokerId$1;
            private final String clusterId$2;

            public final void apply(String logDir) {
                this.$outer.forgeBrokerMetadata(logDir, this.brokerId$1, this.clusterId$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.clusterId$2 = clusterId$2;
            }
        });
    }

    public void forgeBrokerMetadata(String logDir, int brokerId, String clusterId) {
        BrokerMetadataCheckpoint checkpoint = new BrokerMetadataCheckpoint(new File(new StringBuilder().append((Object)logDir).append((Object)File.separator).append((Object)this.brokerMetaPropsFile()).toString()));
        checkpoint.write(new BrokerMetadata(brokerId, Option$.MODULE$.apply((Object)clusterId)));
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, String clusterId) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                logDirs.foreach((Function1)new Serializable(this, clusterId, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ServerGenerateClusterIdTest $outer;
                    private final String clusterId$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String logDir) {
                        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder().append((Object)logDir).append((Object)File.separator).append((Object)this.$outer.brokerMetaPropsFile()).toString())).read();
                        Option option = brokerMetadataOpt;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            BrokerMetadata brokerMetadata = (BrokerMetadata)some.x();
                            if (brokerMetadata.clusterId().isDefined()) {
                                Object object = brokerMetadata.clusterId().get();
                                String string = this.clusterId$1;
                                if (object == null ? string != null : !object.equals(string)) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                                }
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.clusterId$1 = clusterId$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public ServerGenerateClusterIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

