/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u000f\tQR*\u001b:s_Jl\u0015m[3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u0015!\u0002\u0001\"\u0011\u0016\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001\f\u0011\u0007]ab$D\u0001\u0019\u0015\tI\"$\u0001\u0006d_2dWm\u0019;j_:T\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;a\u00111aU3r!\ty\"%D\u0001!\u0015\t\tC!\u0001\u0004tKJ4XM]\u0005\u0003G\u0001\u00121bS1gW\u0006\u001cuN\u001c4jO\")Q\u0005\u0001C\u0001M\u00051C/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^:UQJ|w\u000fV5nK>,H/\u0012=dKB$\u0018n\u001c8\u0015\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003iI!A\u000b\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0005I1\"T\u0007\u0005\u0002.e5\taF\u0003\u00020a\u0005)!.\u001e8ji*\t\u0011'A\u0002pe\u001eL!a\r\u0018\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\na\u0007\u0005\u00028\u007f5\t\u0001H\u0003\u0002:u\u00051QM\u001d:peNT!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t)QH\u0003\u0002?a\u00051\u0011\r]1dQ\u0016L!\u0001\u0011\u001d\u0003!QKW.Z8vi\u0016C8-\u001a9uS>t\u0007\"\u0002\"\u0001\t\u00031\u0013\u0001\u000b;fgR\u001cu.\\7ji>3gm]3ugJ+Wn\u001c<f\u001d>tW\t_5ti\u0016tG\u000fV8qS\u000e\u001c\bFA!-\u0011\u0015)\u0005\u0001\"\u0001'\u0003]!Xm\u001d;D_6l\u0017mU3qCJ\fG/\u001a3SK\u001e,\u0007\u0010\u000b\u0002EY\u0001")
public class MirrorMakerIntegrationTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, new Properties());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test(expected=TimeoutException.class)
    public void testCommitOffsetsThrowTimeoutException() {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.brokerList());
        consumerProps.put("default.api.timeout.ms", "1");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("test", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        mirrorMakerConsumer.commit();
    }

    @Test
    public void testCommitOffsetsRemoveNonExistentTopics() {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.brokerList());
        consumerProps.put("default.api.timeout.ms", "2000");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic1", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic2", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        MirrorMaker$.MODULE$.commitOffsets(mirrorMakerConsumer);
        Assert.assertTrue((String)"Offsets for non-existent topics should be removed", (boolean)mirrorMakerConsumer.offsets().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCommaSeparatedRegex() {
        String topic = "new-topic";
        String msg = "a test message";
        String brokerList = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        MirrorMaker.MirrorMakerProducer producer = new MirrorMaker.MirrorMakerProducer(true, producerProps);
        MirrorMaker$.MODULE$.producer_$eq(producer);
        MirrorMaker$.MODULE$.producer().send(new ProducerRecord(topic, (Object)msg.getBytes()));
        MirrorMaker$.MODULE$.producer().close();
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", brokerList);
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"another_topic,new.*,foo"));
        mirrorMakerConsumer.init();
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, msg, mirrorMakerConsumer){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final String msg$1;
                private final MirrorMaker.ConsumerWrapper mirrorMakerConsumer$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean apply$mcZ$sp() {
                    try {
                        ConsumerRecord data = this.mirrorMakerConsumer$1.receive();
                        String string = data.topic();
                        String string2 = this.topic$1;
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        String string3 = new String((byte[])data.value());
                        String string4 = this.msg$1;
                        if (string3 == null) {
                            if (string4 == null) return true;
                            return false;
                        } else {
                            if (!string3.equals(string4)) return false;
                            return true;
                        }
                    }
                    catch (MirrorMaker.NoRecordsException noRecordsException) {
                        return false;
                    }
                }
                {
                    this.topic$1 = topic$1;
                    this.msg$1 = msg$1;
                    this.mirrorMakerConsumer$1 = mirrorMakerConsumer$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "MirrorMaker consumer should read the expected message from the expected topic within the timeout";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.close();
            throw throwable;
        }
        consumer.close();
    }
}

