/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005UtAB\u0001\u0003\u0011\u0003\u0011a!\u0001\nQe>$WoY3s'R\fG/Z#oiJL(BA\u0002\u0005\u0003\rawn\u001a\u0006\u0002\u000b\u0005)1.\u00194lCB\u0011q\u0001C\u0007\u0002\u0005\u00191\u0011B\u0001E\u0001\u0005)\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ssN\u0011\u0001b\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bIAA\u0011\u0001\u000b\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0002\u0005\t-!\u0011\r\u0011\"\u0001\u0003/\u0005\u0011b*^7CCR\u001c\u0007.Z:U_J+G/Y5o+\u0005A\u0002C\u0001\u0007\u001a\u0013\tQRBA\u0002J]RDa\u0001\b\u0005!\u0002\u0013A\u0012a\u0005(v[\n\u000bGo\u00195fgR{'+\u001a;bS:\u0004\u0003\"\u0002\u0010\t\t\u0003y\u0012!B3naRLHc\u0001\u0011\u0002tA\u0011q!\t\u0004\u0006\u0013\t\u0001!AI\n\u0003C-A\u0001\u0002J\u0011\u0003\u0006\u0004%\t!J\u0001\u000baJ|G-^2fe&#W#\u0001\u0014\u0011\u000519\u0013B\u0001\u0015\u000e\u0005\u0011auN\\4\t\u0011)\n#\u0011!Q\u0001\n\u0019\n1\u0002\u001d:pIV\u001cWM]%eA!AA&\tBC\u0002\u0013\u0005Q&A\u0007cCR\u001c\u0007.T3uC\u0012\fG/Y\u000b\u0002]A\u0019q\u0006\u000e\u001c\u000e\u0003AR!!\r\u001a\u0002\u000f5,H/\u00192mK*\u00111'D\u0001\u000bG>dG.Z2uS>t\u0017BA\u001b1\u0005\u0015\tV/Z;f!\t9q'\u0003\u00029\u0005\ti!)\u0019;dQ6+G/\u00193bi\u0006D\u0001BO\u0011\u0003\u0002\u0003\u0006IAL\u0001\u000fE\u0006$8\r['fi\u0006$\u0017\r^1!\u0011!a\u0014E!a\u0001\n\u0003i\u0014!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.F\u0001?!\taq(\u0003\u0002A\u001b\t)1\u000b[8si\"A!)\tBA\u0002\u0013\u00051)A\tqe>$WoY3s\u000bB|7\r[0%KF$\"\u0001R$\u0011\u00051)\u0015B\u0001$\u000e\u0005\u0011)f.\u001b;\t\u000f!\u000b\u0015\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\t\u0011)\u000b#\u0011!Q!\ny\na\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007\u0005\u0003\u0005MC\t\u0005\r\u0011\"\u0001\u0018\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0005OC\t\u0005\r\u0011\"\u0001P\u0003Q\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u0018\u0013fcR\u0011A\t\u0015\u0005\b\u00116\u000b\t\u00111\u0001\u0019\u0011!\u0011\u0016E!A!B\u0013A\u0012!E2p_J$\u0017N\\1u_J,\u0005o\\2iA!AA+\tBA\u0002\u0013\u0005Q%A\u0007mCN$H+[7fgR\fW\u000e\u001d\u0005\t-\u0006\u0012\t\u0019!C\u0001/\u0006\tB.Y:u)&lWm\u001d;b[B|F%Z9\u0015\u0005\u0011C\u0006b\u0002%V\u0003\u0003\u0005\rA\n\u0005\t5\u0006\u0012\t\u0011)Q\u0005M\u0005qA.Y:u)&lWm\u001d;b[B\u0004\u0003\u0002\u0003/\"\u0005\u0003\u0007I\u0011A/\u0002+\r,(O]3oiRChNR5sgR|eMZ:fiV\ta\fE\u0002\r?\u001aJ!\u0001Y\u0007\u0003\r=\u0003H/[8o\u0011!\u0011\u0017E!a\u0001\n\u0003\u0019\u0017!G2veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^0%KF$\"\u0001\u00123\t\u000f!\u000b\u0017\u0011!a\u0001=\"Aa-\tB\u0001B\u0003&a,\u0001\fdkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;!\u0011\u0015\u0011\u0012\u0005\"\u0001i)\u001d\u0001\u0013N[6m[:DQ\u0001J4A\u0002\u0019BQ\u0001L4A\u00029BQ\u0001P4A\u0002yBQ\u0001T4A\u0002aAQ\u0001V4A\u0002\u0019BQ\u0001X4A\u0002yCQ\u0001]\u0011\u0005\u0002]\t\u0001BZ5sgR\u001cV-\u001d\u0005\u0006e\u0006\"\t!J\u0001\u0010M&\u00148\u000f\u001e#bi\u0006|eMZ:fi\")A/\tC\u0001/\u00059A.Y:u'\u0016\f\b\"\u0002<\"\t\u0003)\u0013A\u00047bgR$\u0015\r^1PM\u001a\u001cX\r\u001e\u0005\u0006q\u0006\"\taF\u0001\u0010Y\u0006\u001cHo\u00144gg\u0016$H)\u001a7uC\")!0\tC\u0001w\u00069\u0011n]#naRLX#\u0001?\u0011\u00051i\u0018B\u0001@\u000e\u0005\u001d\u0011un\u001c7fC:Dq!!\u0001\"\t\u0003\t\u0019!\u0001\u0005bI\u0012\u0014\u0015\r^2i)-!\u0015QAA\u0004\u0003\u0013\ti!!\u0005\t\u000bqz\b\u0019\u0001 \t\u000bQ|\b\u0019\u0001\r\t\r\u0005-q\u00101\u0001'\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003\u001fy\b\u0019\u0001\r\u0002\u0017=4gm]3u\t\u0016dG/\u0019\u0005\u0007\u0003'y\b\u0019\u0001\u0014\u0002\u0013QLW.Z:uC6\u0004\bbBA\fC\u0011\u0005\u0011\u0011D\u0001\u0019[\u0006L(-Z+qI\u0006$X\r\u0015:pIV\u001cWM]#q_\u000eDGc\u0001?\u0002\u001c!1A(!\u0006A\u0002yBq!a\b\"\t\u0013\t\t#\u0001\tbI\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR\u0019A)a\t\t\u000f\u0005\u0015\u0012Q\u0004a\u0001m\u0005)!-\u0019;dQ\"9\u0011\u0011F\u0011\u0005\u0002\u0005-\u0012AB;qI\u0006$X\rF\u0002E\u0003[Aq!a\f\u0002(\u0001\u0007\u0001%A\u0005oKb$XI\u001c;ss\"9\u00111G\u0011\u0005\u0002\u0005U\u0012A\u00054j]\u0012$U\u000f\u001d7jG\u0006$XMQ1uG\"$B!a\u000e\u0002:A\u0019Ab\u0018\u001c\t\u0011\u0005\u0015\u0012\u0011\u0007a\u0001\u0003w\u0001B!!\u0010\u0002R5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0003\u000b\n9%\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005%#\u0002BA&\u0003\u001b\na!\u00199bG\",'BAA(\u0003\ry'oZ\u0005\u0005\u0003'\nyDA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007bBA,C\u0011\u0005\u0011\u0011L\u0001\u0017E\u0006$8\r[,ji\"\u001cV-];f]\u000e,'+\u00198hKR1\u0011qGA.\u0003;Ba\u0001]A+\u0001\u0004A\u0002B\u0002;\u0002V\u0001\u0007\u0001\u0004C\u0004\u0002b\u0005\"\t%a\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001a\u0011\t\u0005\u001d\u0014Q\u000e\b\u0004\u0019\u0005%\u0014bAA6\u001b\u00051\u0001K]3eK\u001aLA!a\u001c\u0002r\t11\u000b\u001e:j]\u001eT1!a\u001b\u000e\u0011\u0015!S\u00041\u0001'\u0001")
public class ProducerStateEntry {
    private final long producerId;
    private final Queue<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private long lastTimestamp;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long l) {
        return ProducerStateEntry$.MODULE$.empty(l);
    }

    public long producerId() {
        return this.producerId;
    }

    public Queue<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public long lastTimestamp() {
        return this.lastTimestamp;
    }

    public void lastTimestamp_$eq(long x$1) {
        this.lastTimestamp = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().front()).firstSeq();
    }

    public long firstDataOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().front()).firstOffset();
    }

    public int lastSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().last()).lastSeq();
    }

    public long lastDataOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().last()).lastOffset();
    }

    public int lastOffsetDelta() {
        return this.isEmpty() ? 0 : ((BatchMetadata)this.batchMetadata().last()).offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateProducerEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
        this.lastTimestamp_$eq(timestamp);
    }

    public boolean maybeUpdateProducerEpoch(short producerEpoch) {
        boolean bl;
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        Object object = this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain() ? this.batchMetadata().dequeue() : BoxedUnit.UNIT;
        this.batchMetadata().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{batch}));
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateProducerEpoch(nextEntry.producerEpoch());
        while (nextEntry.batchMetadata().nonEmpty()) {
            this.addBatchMetadata((BatchMetadata)nextEntry.batchMetadata().dequeue());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
        this.lastTimestamp_$eq(nextEntry.lastTimestamp());
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        return batch.producerEpoch() != this.producerEpoch() ? None$.MODULE$ : this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        Queue duplicate = (Queue)this.batchMetadata().filter((Function1)new Serializable(this, firstSeq, lastSeq){
            public static final long serialVersionUID = 0L;
            private final int firstSeq$1;
            private final int lastSeq$1;

            public final boolean apply(BatchMetadata metadata) {
                return this.firstSeq$1 == metadata.firstSeq() && this.lastSeq$1 == metadata.lastSeq();
            }
            {
                this.firstSeq$1 = firstSeq$1;
                this.lastSeq$1 = lastSeq$1;
            }
        });
        return duplicate.headOption();
    }

    public String toString() {
        return new StringBuilder().append((Object)"ProducerStateEntry(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentTxnFirstOffset()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastTimestamp=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastTimestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"batchMetadata=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchMetadata()}))).toString();
    }

    public ProducerStateEntry(long producerId, Queue<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, long lastTimestamp, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.lastTimestamp = lastTimestamp;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

