/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.VersionInfo$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class CommandLineUtils$
implements Logging {
    public static final CommandLineUtils$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new CommandLineUtils$();
    }

    private Logger logger$lzycompute() {
        CommandLineUtils$ commandLineUtils$ = this;
        synchronized (commandLineUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public boolean isPrintHelpNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.args().length == 0 || commandOpts.options().has(commandOpts.helpOpt());
    }

    public boolean isPrintVersionNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.options().has(commandOpts.versionOpt());
    }

    public void printHelpAndExitIfNeeded(CommandDefaultOptions commandOpts, String message) {
        if (this.isPrintHelpNeeded(commandOpts)) {
            throw this.printUsageAndDie(commandOpts.parser(), message);
        }
        if (this.isPrintVersionNeeded(commandOpts)) {
            throw this.printVersionAndDie();
        }
    }

    public void checkRequiredArgs(OptionParser parser, OptionSet options, Seq<OptionSpec<?>> required) {
        required.foreach((Function1)new Serializable(parser, options){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(OptionSpec<?> arg) {
                if (this.options$1.has(arg)) {
                    return;
                }
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser$1, new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
            }
            {
                this.parser$1 = parser$1;
                this.options$1 = options$1;
            }
        });
    }

    public void checkInvalidArgs(OptionParser parser, OptionSet options, OptionSpec<?> usedOption, Set<OptionSpec<?>> invalidOptions) {
        if (options.has(usedOption)) {
            invalidOptions.foreach((Function1)new Serializable(parser, options, usedOption){
                public static final long serialVersionUID = 0L;
                private final OptionParser parser$2;
                private final OptionSet options$2;
                private final OptionSpec usedOption$1;

                public final void apply(OptionSpec<?> arg) {
                    if (this.options$2.has(arg)) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser$2, new StringBuilder().append((Object)"Option \"").append((Object)this.usedOption$1).append((Object)"\" can't be used with option \"").append(arg).append((Object)"\"").toString());
                    }
                }
                {
                    this.parser$2 = parser$2;
                    this.options$2 = options$2;
                    this.usedOption$1 = usedOption$1;
                }
            });
        }
    }

    public void checkInvalidArgsSet(OptionParser parser, OptionSet options, Set<OptionSpec<?>> usedOptions, Set<OptionSpec<?>> invalidOptions) {
        if (usedOptions.count((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final OptionSet options$3;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.options$3.has(x$1);
            }
            {
                this.options$3 = options$3;
            }
        }) == usedOptions.size()) {
            invalidOptions.foreach((Function1)new Serializable(parser, options, usedOptions){
                public static final long serialVersionUID = 0L;
                private final OptionParser parser$3;
                private final OptionSet options$3;
                private final Set usedOptions$1;

                public final void apply(OptionSpec<?> arg) {
                    if (this.options$3.has(arg)) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser$3, new StringBuilder().append((Object)"Option combination \"").append((Object)this.usedOptions$1.mkString(",")).append((Object)"\" can't be used with option \"").append(arg).append((Object)"\"").toString());
                    }
                }
                {
                    this.parser$3 = parser$3;
                    this.options$3 = options$3;
                    this.usedOptions$1 = usedOptions$1;
                }
            });
        }
    }

    public Nothing$ printUsageAndDie(OptionParser parser, String message) {
        System.err.println(message);
        parser.printHelpOn((OutputStream)System.err);
        return Exit$.MODULE$.exit(1, (Option<String>)new Some((Object)message));
    }

    public Nothing$ printVersionAndDie() {
        System.out.println(VersionInfo$.MODULE$.getVersionString());
        return Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    public Properties parseKeyValueArgs(Iterable<String> args, boolean acceptMissingValue) {
        Iterable splits = (Iterable)((TraversableLike)args.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split("=", 2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$2) {
                return x$2.length == 0;
            }
        });
        Properties props = new Properties();
        splits.foreach((Function1)new Serializable(acceptMissingValue, props){
            public static final long serialVersionUID = 0L;
            private final boolean acceptMissingValue$1;
            private final Properties props$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(String[] a) {
                Object object;
                if (a.length == 1 || a.length == 2 && a[1].isEmpty()) {
                    if (!this.acceptMissingValue$1) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing value for key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a[0]})));
                    object = this.props$1.put(a[0], "");
                    return object;
                } else {
                    object = this.props$1.put(a[0], a[1]);
                }
                return object;
            }
            {
                this.acceptMissingValue$1 = acceptMissingValue$1;
                this.props$1 = props$1;
            }
        });
        return props;
    }

    public boolean parseKeyValueArgs$default$2() {
        return true;
    }

    public <V> void maybeMergeOptions(Properties props, String key, OptionSet options, OptionSpec<V> spec) {
        if (options.has(spec) || !props.containsKey(key)) {
            Object value2 = options.valueOf(spec);
            if (value2 == null) {
                props.remove(key);
            } else {
                props.put(key, value2.toString());
            }
        }
    }

    private CommandLineUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

