/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        try (ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());){
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkUtils, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkUtils, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkUtils, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)("Partitions reassignment failed due to " + e.getMessage()));
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
    }

    public void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils.readFileAsString((String)jsonFile);
        this.verifyAssignment(zkUtils, jsonString);
    }

    public void verifyAssignment(ZkUtils zkUtils, String jsonString) {
        Predef$.MODULE$.println((Object)"Status of partition reassignment: ");
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(jsonString);
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkUtils, partitionsToBeReassigned);
        reassignedPartitionsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.removeThrottle(zkUtils, partitionsToBeReassigned, reassignedPartitionsStatus, this.removeThrottle$default$4());
    }

    public void removeThrottle(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus, AdminUtilities admin) {
        block1: {
            BooleanRef changed = BooleanRef.create((boolean)false);
            if (!reassignedPartitionsStatus.forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$removeThrottle$1(x0$2)))) break block1;
            ((IterableLike)zkUtils.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
                block0: {
                    Properties configs = admin.fetchEntityConfig(zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                    if (!(configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null)) break block0;
                    admin.changeBrokerConfig(zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                    changed$1.elem = true;
                }
            });
            Seq topics = (Seq)((SetLike)partitionsToBeReassigned.keySet().map((Function1 & Serializable & scala.Serializable)tp -> tp.topic(), Set$.MODULE$.canBuildFrom())).toSeq().distinct();
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ReassignPartitionsCommand$.$anonfun$removeThrottle$5(zkUtils, admin, changed, topic);
                return BoxedUnit.UNIT;
            });
            if (changed.elem) {
                Predef$.MODULE$.println((Object)"Throttle was removed.");
            }
        }
    }

    public AdminUtilities removeThrottle$default$4() {
        return AdminUtils$.MODULE$;
    }

    public void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt()))).split(','))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$generateAssignment$1(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString((String)topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkUtils, (Seq<Object>)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map proposedAssignments = (Map)tuple2._1();
        Map currentAssignments = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)proposedAssignments, (Object)currentAssignments);
        Tuple2 tuple23 = tuple22;
        Map proposedAssignments2 = (Map)tuple23._1();
        Map currentAssignments2 = (Map)tuple23._2();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)currentAssignments2)})));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)proposedAssignments2)})));
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentAssignment = zkUtils.getReplicaAssignmentForTopics(topicsToReassign);
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            String string = tp.topic();
            return string;
        });
        Product rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        Seq<BrokerMetadata> brokerMetadatas = AdminUtils$.MODULE$.getBrokerMetadatas(zkUtils, (RackAwareMode)rackAwareMode, (Option<Seq<Object>>)new Some(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Seq seq;
            scala.collection.mutable.Map assignment;
            String topic;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Seq replicas;
                topic = (String)tuple2._1();
                assignment = (scala.collection.mutable.Map)tuple2._2();
                Tuple2 tuple22 = (Tuple2)assignment.head();
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                seq = replicas = (Seq)tuple22._2();
            } else {
                throw new MatchError((Object)tuple2);
            }
            Seq replicas = seq;
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), replicas.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionsToBeReassigned.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)replicas);
                return tuple22;
            }, scala.collection.Map$.MODULE$.canBuildFrom()));
            return map;
        });
        return new Tuple2((Object)partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String reassignmentJsonString = Utils.readFileAsString((String)reassignmentJsonFile);
        long throttle = opts.options().has(opts.throttleOpt()) ? BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.throttleOpt())) : -1L;
        this.executeAssignment(zkUtils, reassignmentJsonString, throttle);
    }

    public void executeAssignment(ZkUtils zkUtils, String reassignmentJsonString, long throttle) {
        Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned = this.parseAndValidate(zkUtils, reassignmentJsonString);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkUtils, (Map<TopicAndPartition, Seq<Object>>)partitionsToBeReassigned.toMap(Predef$.MODULE$.$conforms()), this.$lessinit$greater$default$3());
        if (zkUtils.pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath())) {
            Predef$.MODULE$.println((Object)"There is an existing assignment running.");
            reassignPartitionsCommand.maybeLimit(throttle);
        } else {
            this.printCurrentAssignment(zkUtils, partitionsToBeReassigned);
            if (throttle >= 0L) {
                Predef$.MODULE$.println((Object)String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
            }
            if (reassignPartitionsCommand.reassignPartitions(throttle)) {
                Predef$.MODULE$.println((Object)"Successfully started reassignment of partitions.");
            } else {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeReassigned})));
            }
        }
    }

    public long executeAssignment$default$3() {
        return -1L;
    }

    public void printCurrentAssignment(ZkUtils zkUtils, Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned) {
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = zkUtils.getReplicaAssignmentForTopics((Seq<String>)((Seq)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x$4 -> ((TopicAndPartition)x$4._1()).topic(), Seq$.MODULE$.canBuildFrom())));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<TopicAndPartition, Seq<Object>>> parseAndValidate(ZkUtils zkUtils, String reassignmentJsonString) {
        void var3_3;
        Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentDataWithoutDedup(reassignmentJsonString);
        if (partitionsToBeReassigned.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            TopicAndPartition tp;
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
            return topicAndPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$3(x0$8)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                Iterable duplicateReplicas = (Iterable)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            String string = tp.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> existingAssignment = zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
        Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$11 -> {
            TopicAndPartition tp;
            Tuple2 tuple2 = x0$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
            return topicAndPartition;
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)existingAssignment.contains((Object)key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException("The proposed assignment contains non-existent partitions: " + nonExistentPartitions);
        }
        return var3_3;
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        Map partitionsBeingReassigned = zkUtils.getPartitionsBeingReassigned().mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.newReplicas());
        return ((TraversableOnce)partitionsToBeReassigned.keys().map((Function1 & Serializable & scala.Serializable)topicAndPartition -> new Tuple2(topicAndPartition, (Object)this.checkIfPartitionReassignmentSucceeded(zkUtils, (TopicAndPartition)topicAndPartition, partitionsToBeReassigned, (Map<TopicAndPartition, Seq<Object>>)partitionsBeingReassigned)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Product product;
        Seq newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
        Option option = partitionsBeingReassigned.get((Object)topicAndPartition);
        if (option instanceof Some) {
            product = ReassignmentInProgress$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            Product product2;
            Seq<Object> assignedReplicas;
            Seq<Object> seq = assignedReplicas = zkUtils.getReplicasForPartition(topicAndPartition.topic(), topicAndPartition.partition());
            Seq seq2 = newReplicas;
            if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                product2 = ReassignmentCompleted$.MODULE$;
            } else {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                product2 = ReassignmentFailed$.MODULE$;
            }
            product = product2;
        } else {
            throw new MatchError((Object)option);
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        block6: {
            ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts;
            block7: {
                block5: {
                    opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
                    if (args.length == 0) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "This command moves topic partitions between replicas.");
                    }
                    int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1(opts, x$1)));
                    if (actions != 1) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
                    }
                    CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
                    if (!opts.options().has((OptionSpec)opts.verifyOpt())) break block5;
                    if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
                    }
                    CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.throttleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
                    break block6;
                }
                if (!opts.options().has((OptionSpec)opts.generateOpt())) break block7;
                if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
                }
                CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.throttleOpt(), opts.reassignmentJsonFileOpt()}))));
                break block6;
            }
            if (!opts.options().has((OptionSpec)opts.executeOpt())) break block6;
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        }
        return var2_2;
    }

    public AdminUtilities $lessinit$greater$default$3() {
        return AdminUtils$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError((Object)reassignmentStatus);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$1(Tuple2 x0$2) {
        ReassignmentStatus status;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeThrottle$5(ZkUtils zkUtils$2, AdminUtilities admin$1, BooleanRef changed$1, String topic) {
        block0: {
            Properties configs = admin$1.fetchEntityConfig(zkUtils$2, ConfigType$.MODULE$.Topic(), topic);
            if (!(configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null)) break block0;
            admin$1.changeTopicConfig(zkUtils$2, topic, configs);
            changed$1.elem = true;
        }
    }

    public static final /* synthetic */ int $anonfun$generateAssignment$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$3(Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable duplicatedReplicas = (Iterable)tuple2._2();
        boolean bl = duplicatedReplicas.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$validateAndParseArgs$1(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1, OptionSpec x$1) {
        return opts$1.options().has(x$1);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

