/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Cluster;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherThread;
import kafka.consumer.PartitionTopicInfo;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndInitialOffset;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001\u001d\u0011acQ8ogVlWM\u001d$fi\u000eDWM]'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t\u0001bY8ogVlWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0004tKJ4XM]\u0005\u0003\u001b)\u0011a#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\u0005\t\u001f\u0001\u0011)\u0019!C\u0005!\u0005\u00012m\u001c8tk6,'/\u00133TiJLgnZ\u000b\u0002#A\u0011!c\u0007\b\u0003'e\u0001\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A$\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i9\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002#\r|gn];nKJLEm\u0015;sS:<\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0003#\u0003\u0019\u0019wN\u001c4jOV\t1\u0005\u0005\u0002%K5\t!!\u0003\u0002'\u0005\tq1i\u001c8tk6,'oQ8oM&<\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000f\r|gNZ5hA!A!\u0006\u0001BC\u0002\u0013%1&A\u0004{WV#\u0018\u000e\\:\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!a\f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Er#a\u0002.l+RLGn\u001d\u0005\tg\u0001\u0011\t\u0011)A\u0005Y\u0005A!p[+uS2\u001c\b\u0005C\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u0005oaJ$\b\u0005\u0002%\u0001!)q\u0002\u000ea\u0001#!)\u0011\u0005\u000ea\u0001G!)!\u0006\u000ea\u0001Y!9A\b\u0001a\u0001\n\u0013i\u0014\u0001\u00049beRLG/[8o\u001b\u0006\u0004X#\u0001 \u0011\t}\"e)U\u0007\u0002\u0001*\u0011\u0011IQ\u0001\nS6lW\u000f^1cY\u0016T!aQ\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002F\u0001\n\u0019Q*\u00199\u0011\u0005\u001d{U\"\u0001%\u000b\u0005%S\u0015AB2p[6|gN\u0003\u0002\u0006\u0017*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001\u0006J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005\u0011\u0012\u0016BA*\u0003\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006\u0001\u0002/\u0019:uSRLwN\\'ba~#S-\u001d\u000b\u0003/n\u0003\"\u0001W-\u000e\u0003]I!AW\f\u0003\tUs\u0017\u000e\u001e\u0005\b9R\u000b\t\u00111\u0001?\u0003\rAH%\r\u0005\u0007=\u0002\u0001\u000b\u0015\u0002 \u0002\u001bA\f'\u000f^5uS>tW*\u00199!\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005\fqa\u00197vgR,'/F\u0001c!\t\u0019W-D\u0001e\u0015\t\u0001G!\u0003\u0002gI\n91\t\\;ti\u0016\u0014\bb\u00025\u0001\u0001\u0004%I![\u0001\fG2,8\u000f^3s?\u0012*\u0017\u000f\u0006\u0002XU\"9AlZA\u0001\u0002\u0004\u0011\u0007B\u00027\u0001A\u0003&!-\u0001\u0005dYV\u001cH/\u001a:!\u0011\u001dq\u0007A1A\u0005\n=\fAC\\8MK\u0006$WM\u001d)beRLG/[8o'\u0016$X#\u00019\u0011\u0007E$h)D\u0001s\u0015\t\u0019()A\u0004nkR\f'\r\\3\n\u0005U\u0014(a\u0002%bg\"\u001cV\r\u001e\u0005\u0007o\u0002\u0001\u000b\u0011\u00029\u0002+9|G*Z1eKJ\u0004\u0016M\u001d;ji&|gnU3uA!9\u0011\u0010\u0001b\u0001\n\u0013Q\u0018\u0001\u00027pG.,\u0012a\u001f\t\u0004y\u0006-Q\"A?\u000b\u0005y|\u0018!\u00027pG.\u001c(\u0002BA\u0001\u0003\u0007\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)!a\u0002\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0013\tAA[1wC&\u0019\u0011QB?\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u001d\t\t\u0002\u0001Q\u0001\nm\fQ\u0001\\8dW\u0002B\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\u0002\t\r|g\u000eZ\u000b\u0003\u00033\u00012\u0001`A\u000e\u0013\r\ti\" \u0002\n\u0007>tG-\u001b;j_:D\u0001\"!\t\u0001A\u0003%\u0011\u0011D\u0001\u0006G>tG\r\t\u0005\n\u0003K\u0001\u0001\u0019!C\u0005\u0003O\t!\u0003\\3bI\u0016\u0014h)\u001b8eKJ$\u0006N]3bIV\u0011\u0011\u0011\u0006\t\u0004[\u0005-\u0012bAA\u0017]\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019$\u0001\fmK\u0006$WM\u001d$j]\u0012,'\u000f\u00165sK\u0006$w\fJ3r)\r9\u0016Q\u0007\u0005\n9\u0006=\u0012\u0011!a\u0001\u0003SA\u0001\"!\u000f\u0001A\u0003&\u0011\u0011F\u0001\u0014Y\u0016\fG-\u001a:GS:$WM\u001d+ie\u0016\fG\r\t\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007f\tQbY8se\u0016d\u0017\r^5p]&#WCAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$\u007f\u00061\u0011\r^8nS\u000eLA!a\u0013\u0002F\ti\u0011\t^8nS\u000eLe\u000e^3hKJD\u0001\"a\u0014\u0001A\u0003%\u0011\u0011I\u0001\u000fG>\u0014(/\u001a7bi&|g.\u00133!\r\u0019\t\u0019\u0006\u0001\u0003\u0002V\t\u0011B*Z1eKJ4\u0015N\u001c3feRC'/Z1e'\u0011\t\t&!\u000b\t\u0019\u0005e\u0013\u0011\u000bB\u0001B\u0003%\u0011#a\u0017\u0002\t9\fW.Z\u0005\u0005\u00033\nY\u0003C\u00046\u0003#\"\t!a\u0018\u0015\t\u0005\u0005\u0014Q\r\t\u0005\u0003G\n\t&D\u0001\u0001\u0011\u001d\tI&!\u0018A\u0002EA\u0001\"!\u001b\u0002R\u0011\u0005\u00131N\u0001\u0007I><vN]6\u0015\u0003]Cq!a\u001c\u0001\t\u0003\n\t(A\nde\u0016\fG/\u001a$fi\u000eDWM\u001d+ie\u0016\fG\r\u0006\u0004\u0002t\u0005e\u00141\u0011\t\u0004\u0013\u0005U\u0014bAA<\u0015\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007\u0002CA>\u0003[\u0002\r!! \u0002\u0013\u0019,Go\u00195fe&#\u0007c\u0001-\u0002\u0000%\u0019\u0011\u0011Q\f\u0003\u0007%sG\u000f\u0003\u0005\u0002\u0006\u00065\u0004\u0019AAD\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\r\u0019\u0017\u0011R\u0005\u0004\u0003\u0017#'A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u0005\b\u0003\u001f\u0003A\u0011AAI\u0003A\u0019H/\u0019:u\u0007>tg.Z2uS>t7\u000fF\u0003X\u0003'\u000bI\u000b\u0003\u0005\u0002\u0016\u00065\u0005\u0019AAL\u0003)!x\u000e]5d\u0013:4wn\u001d\t\u0006\u00033\u000b\u0019+\u0015\b\u0005\u00037\u000byJD\u0002\u0015\u0003;K\u0011\u0001G\u0005\u0004\u0003C;\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003K\u000b9K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\tk\u0006\u0005\u0007A\u00065\u0005\u0019\u00012\t\u000f\u00055\u0006\u0001\"\u0001\u0002l\u0005y1\u000f^8q\u0007>tg.Z2uS>t7\u000fC\u0004\u00022\u0002!\t!a-\u0002-\u0005$G\rU1si&$\u0018n\u001c8t/&$\b.\u0012:s_J$2aVA[\u0011!\t9,a,A\u0002\u0005e\u0016!\u00049beRLG/[8o\u0019&\u001cH\u000fE\u0003\u0002\u001a\u0006\rf\t")
public class ConsumerFetcherManager
extends AbstractFetcherManager {
    private final String consumerIdString;
    private final ConsumerConfig kafka$consumer$ConsumerFetcherManager$$config;
    private final ZkUtils kafka$consumer$ConsumerFetcherManager$$zkUtils;
    private scala.collection.immutable.Map<TopicPartition, PartitionTopicInfo> kafka$consumer$ConsumerFetcherManager$$partitionMap;
    private Cluster cluster;
    private final HashSet<TopicPartition> kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet;
    private final ReentrantLock kafka$consumer$ConsumerFetcherManager$$lock;
    private final Condition kafka$consumer$ConsumerFetcherManager$$cond;
    private ShutdownableThread leaderFinderThread;
    private final AtomicInteger kafka$consumer$ConsumerFetcherManager$$correlationId;

    private String consumerIdString() {
        return this.consumerIdString;
    }

    public ConsumerConfig kafka$consumer$ConsumerFetcherManager$$config() {
        return this.kafka$consumer$ConsumerFetcherManager$$config;
    }

    public ZkUtils kafka$consumer$ConsumerFetcherManager$$zkUtils() {
        return this.kafka$consumer$ConsumerFetcherManager$$zkUtils;
    }

    public scala.collection.immutable.Map<TopicPartition, PartitionTopicInfo> kafka$consumer$ConsumerFetcherManager$$partitionMap() {
        return this.kafka$consumer$ConsumerFetcherManager$$partitionMap;
    }

    private void kafka$consumer$ConsumerFetcherManager$$partitionMap_$eq(scala.collection.immutable.Map<TopicPartition, PartitionTopicInfo> x$1) {
        this.kafka$consumer$ConsumerFetcherManager$$partitionMap = x$1;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    private void cluster_$eq(Cluster x$1) {
        this.cluster = x$1;
    }

    public HashSet<TopicPartition> kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet() {
        return this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet;
    }

    public ReentrantLock kafka$consumer$ConsumerFetcherManager$$lock() {
        return this.kafka$consumer$ConsumerFetcherManager$$lock;
    }

    public Condition kafka$consumer$ConsumerFetcherManager$$cond() {
        return this.kafka$consumer$ConsumerFetcherManager$$cond;
    }

    private ShutdownableThread leaderFinderThread() {
        return this.leaderFinderThread;
    }

    private void leaderFinderThread_$eq(ShutdownableThread x$1) {
        this.leaderFinderThread = x$1;
    }

    public AtomicInteger kafka$consumer$ConsumerFetcherManager$$correlationId() {
        return this.kafka$consumer$ConsumerFetcherManager$$correlationId;
    }

    @Override
    public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        return new ConsumerFetcherThread(new StringOps(Predef$.MODULE$.augmentString("ConsumerFetcherThread-%s-%d-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerIdString(), BoxesRunTime.boxToInteger((int)fetcherId), BoxesRunTime.boxToInteger((int)sourceBroker.id())})), this.kafka$consumer$ConsumerFetcherManager$$config(), sourceBroker, (Map<TopicPartition, PartitionTopicInfo>)this.kafka$consumer$ConsumerFetcherManager$$partitionMap(), this);
    }

    public void startConnections(Iterable<PartitionTopicInfo> topicInfos, Cluster cluster) {
        this.leaderFinderThread_$eq(new LeaderFinderThread(this.consumerIdString() + "-leader-finder-thread"));
        this.leaderFinderThread().start();
        CoreUtils$.MODULE$.inLock(this.kafka$consumer$ConsumerFetcherManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.kafka$consumer$ConsumerFetcherManager$$partitionMap_$eq((scala.collection.immutable.Map<TopicPartition, PartitionTopicInfo>)((TraversableOnce)topicInfos.map((Function1 & Serializable & scala.Serializable)tpi -> new Tuple2((Object)new TopicPartition(tpi.topic(), tpi.partitionId()), tpi), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.cluster_$eq(cluster);
            this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$plus$plus$eq((TraversableOnce)topicInfos.map((Function1 & Serializable & scala.Serializable)tpi -> new TopicPartition(tpi.topic(), tpi.partitionId()), Iterable$.MODULE$.canBuildFrom()));
            this.kafka$consumer$ConsumerFetcherManager$$cond().signalAll();
        });
    }

    public void stopConnections() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping leader finder thread");
        if (this.leaderFinderThread() != null) {
            this.leaderFinderThread().shutdown();
            this.leaderFinderThread_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping all fetchers");
        this.closeAllFetchers();
        this.kafka$consumer$ConsumerFetcherManager$$partitionMap_$eq(null);
        this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All connections stopped");
    }

    public void addPartitionsWithError(Iterable<TopicPartition> partitionList) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("adding partitions with error %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionList})));
        CoreUtils$.MODULE$.inLock(this.kafka$consumer$ConsumerFetcherManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.kafka$consumer$ConsumerFetcherManager$$partitionMap() == null) break block0;
                this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$plus$plus$eq((TraversableOnce)partitionList);
                this.kafka$consumer$ConsumerFetcherManager$$cond().signalAll();
            }
        });
    }

    public ConsumerFetcherManager(String consumerIdString, ConsumerConfig config, ZkUtils zkUtils) {
        this.consumerIdString = consumerIdString;
        this.kafka$consumer$ConsumerFetcherManager$$config = config;
        this.kafka$consumer$ConsumerFetcherManager$$zkUtils = zkUtils;
        super(new StringOps(Predef$.MODULE$.augmentString("ConsumerFetcherManager-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Time.SYSTEM.milliseconds())})), config.clientId(), config.numConsumerFetchers());
        this.kafka$consumer$ConsumerFetcherManager$$partitionMap = null;
        this.cluster = null;
        this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet = new HashSet();
        this.kafka$consumer$ConsumerFetcherManager$$lock = new ReentrantLock();
        this.kafka$consumer$ConsumerFetcherManager$$cond = this.kafka$consumer$ConsumerFetcherManager$$lock().newCondition();
        this.leaderFinderThread = null;
        this.kafka$consumer$ConsumerFetcherManager$$correlationId = new AtomicInteger(0);
    }

    public class LeaderFinderThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            HashMap leaderForPartitionsMap = new HashMap();
            this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().lock();
            try {
                try {
                    while (this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().isEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No partition for leader election.");
                        this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$cond().await();
                    }
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partitions without leader %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet()})));
                    Seq<BrokerEndPoint> brokers = ClientUtils$.MODULE$.getPlaintextBrokerEndPoints(this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$zkUtils());
                    Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((TraversableOnce)this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().map((Function1 & Serializable & scala.Serializable)m -> m.topic(), HashSet$.MODULE$.canBuildFrom())).toSet(), brokers, this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$config().clientId(), this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$config().socketTimeoutMs(), this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$correlationId().getAndIncrement()).topicsMetadata();
                    if (this.logger().isDebugEnabled()) {
                        topicsMetadata.foreach((Function1 & Serializable & scala.Serializable)topicMetadata -> {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> topicMetadata.toString());
                            return BoxedUnit.UNIT;
                        });
                    }
                    topicsMetadata.foreach((Function1 & Serializable & scala.Serializable)tmd -> {
                        LeaderFinderThread.$anonfun$doWork$6(this, leaderForPartitionsMap, tmd);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    if (!this.isRunning().get()) {
                        throw t;
                    }
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to find leader for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                }
            }
            finally {
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().unlock();
            }
            try {
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().addFetcherForPartitions((Map<TopicPartition, BrokerAndInitialOffset>)((Map)leaderForPartitionsMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    BrokerEndPoint broker = (BrokerEndPoint)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new BrokerAndInitialOffset(broker, ((PartitionTopicInfo)this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$partitionMap().apply((Object)topicPartition)).getFetchOffset()));
                    return tuple22;
                }, HashMap$.MODULE$.canBuildFrom())));
            }
            catch (Throwable t) {
                if (!this.isRunning().get()) {
                    throw t;
                }
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to add leader for partitions %s; will retry")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leaderForPartitionsMap.keySet().mkString(",")})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().lock();
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$plus$plus$eq((TraversableOnce)leaderForPartitionsMap.keySet());
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().unlock();
            }
            this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().shutdownIdleFetcherThreads();
            Thread.sleep(this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$config().refreshLeaderBackoffMs());
        }

        public /* synthetic */ ConsumerFetcherManager kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer() {
            return ConsumerFetcherManager.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$6(LeaderFinderThread $this, HashMap leaderForPartitionsMap$1, TopicMetadata tmd) {
            String topic = tmd.topic();
            tmd.partitionsMetadata().foreach((Function1 & Serializable & scala.Serializable)pmd -> {
                BoxedUnit boxedUnit;
                TopicPartition topicAndPartition = new TopicPartition(topic, pmd.partitionId());
                if (pmd.leader().isDefined() && $this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().contains((Object)topicAndPartition)) {
                    BrokerEndPoint leaderBroker = (BrokerEndPoint)pmd.leader().get();
                    leaderForPartitionsMap$1.put((Object)topicAndPartition, (Object)leaderBroker);
                    boxedUnit = $this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$minus$eq((Object)topicAndPartition);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }

        public LeaderFinderThread(String name) {
            if (ConsumerFetcherManager.this == null) {
                throw null;
            }
            super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }
}

