/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Au\u00111aU3u!\t\u0011\u0013F\u0004\u0002$OA\u0011AEC\u0007\u0002K)\u0011aEB\u0001\u0007yI|w\u000e\u001e \n\u0005!R\u0011A\u0002)sK\u0012,g-\u0003\u0002+W\t11\u000b\u001e:j]\u001eT!\u0001\u000b\u0006\t\u00115\u0002!\u0011!Q\u0001\nm\t!%\u001b8ji&\fG\u000eV8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00032eM\"\u0004C\u0001\f\u0001\u0011\u0015\u0019a\u00061\u0001\u0016\u0011\u001dQb\u0006%AA\u0002mAq!\f\u0018\u0011\u0002\u0003\u00071\u0004C\u00047\u0001\t\u0007I\u0011A\u001c\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u00019!\t1\u0012(\u0003\u0002;\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\rq\u0002\u0001\u0015!\u00039\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005)\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,W#\u0001!\u0011\u0005Y\t\u0015B\u0001\"\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016Da\u0001\u0012\u0001!\u0002\u0013\u0001\u0015A\u00069beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0011\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\u0006\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKV\t\u0001\n\u0005\u0002\u0017\u0013&\u0011!J\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002%\u0002)I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3!\u0011\u001dq\u0005A1A\u0005\u0002=\u000b!\u0002Z3mKR,Gj\\2l+\u0005\u0001\u0006CA)[\u001b\u0005\u0011&BA*U\u0003\u0015awnY6t\u0015\t)f+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0016-\u0002\tU$\u0018\u000e\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tY&KA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\u0007;\u0002\u0001\u000b\u0011\u0002)\u0002\u0017\u0011,G.\u001a;f\u0019>\u001c7\u000e\t\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0003A!W\r\\3uKR{\u0007/[2t\u0007>tG-F\u0001b!\t\t&-\u0003\u0002d%\nI1i\u001c8eSRLwN\u001c\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002#\u0011,G.\u001a;f)>\u0004\u0018nY:D_:$\u0007\u0005C\u0004h\u0001\t\u0007I\u0011\u00015\u0002/\u0011,G.\u001a;f)>\u0004\u0018nY*uCR,7\t[1oO\u0016$W#A5\u0011\u0005)lW\"A6\u000b\u00051$\u0016AB1u_6L7-\u0003\u0002oW\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Da\u0001\u001d\u0001!\u0002\u0013I\u0017\u0001\u00073fY\u0016$X\rV8qS\u000e\u001cF/\u0019;f\u0007\"\fgnZ3eA!9!\u000f\u0001a\u0001\n\u0003\u0019\u0018A\u00053fY\u0016$X\rV8qS\u000e\u001cH\u000b\u001b:fC\u0012,\u0012\u0001\u001e\t\u0003kZl\u0011\u0001\u0001\u0004\u0005o\u0002\u0001\u0001P\u0001\nEK2,G/\u001a+pa&\u001c7\u000f\u00165sK\u0006$7C\u0001<z!\ty!0\u0003\u0002|!\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0011\u0015yc\u000f\"\u0001~)\u0005!\b\u0002C@w\u0005\u0004%\t!!\u0001\u0002\u000fi\\W\u000b^5mgV\u0011\u00111\u0001\t\u0004\u001f\u0005\u0015\u0011bAA\u0004!\t9!l[+uS2\u001c\b\u0002CA\u0006m\u0002\u0006I!a\u0001\u0002\u0011i\\W\u000b^5mg\u0002Bq!a\u0004w\t\u0003\n\t\"\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003'\u00012!CA\u000b\u0013\r\t9B\u0003\u0002\u0005+:LG\u000fC\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0001\u0002\u001e\u00051B-\u001a7fi\u0016$v\u000e]5dgRC'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005}\u0001\"CA\u0011\u00033\t\t\u00111\u0001u\u0003\rAH%\r\u0005\b\u0003K\u0001\u0001\u0015)\u0003u\u0003M!W\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193!\u0011%\tI\u0003\u0001b\u0001\n\u0003\tY#\u0001\u000bjg\u0012+G.\u001a;f)>\u0004\u0018nY#oC\ndW\rZ\u000b\u0003\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gA\u0016\u0001\u00027b]\u001eLA!a\u000e\u00022\t9!i\\8mK\u0006t\u0007\u0002CA\u001e\u0001\u0001\u0006I!!\f\u0002+%\u001cH)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3eA!I\u0011q\b\u0001C\u0002\u0013\u0005\u0011\u0011I\u0001\u0012i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$WCAA\"!\u0015\t)%a\u0013\"\u001b\t\t9EC\u0002\u0002Ju\tq!\\;uC\ndW-C\u0002!\u0003\u000fB\u0001\"a\u0014\u0001A\u0003%\u00111I\u0001\u0013i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0001\u0002B\u0005YBo\u001c9jGNLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:D\u0001\"a\u0016\u0001A\u0003%\u00111I\u0001\u001di>\u0004\u0018nY:J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8!\u0011%\tY\u0006\u0001b\u0001\n\u0003\ti&A\u000bqCJ$\u0018\u000e^5p]N$vNQ3EK2,G/\u001a3\u0016\u0005\u0005}\u0003CBA#\u0003\u0017\n\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9\u0007B\u0001\u0007G>lWn\u001c8\n\t\u0005-\u0014Q\r\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002CA8\u0001\u0001\u0006I!a\u0018\u0002-A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fI\u0002Bq!a\u001d\u0001\t\u0003\t\t\"A\u0003ti\u0006\u0014H\u000fC\u0004\u0002x\u0001!\t!!\u0005\u0002\u0011MDW\u000f\u001e3po:Dq!a\u001f\u0001\t\u0003\ti(\u0001\rf]F,X-^3U_BL7m\u001d$pe\u0012+G.\u001a;j_:$B!a\u0005\u0002\u0000!9\u0011\u0011QA=\u0001\u0004Y\u0012A\u0002;pa&\u001c7\u000fC\u0004\u0002\u0006\u0002!\t!a\"\u0002/I,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cH\u0003BA\n\u0003\u0013C\u0011\"!!\u0002\u0004B\u0005\t\u0019A\u000e\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006\u0019b-Y5m%\u0016\u0004H.[2b\t\u0016dW\r^5p]R!\u00111CAI\u0011!\t\u0019*a#A\u0002\u0005U\u0015\u0001\u0003:fa2L7-Y:\u0011\tqy\u0012q\u0013\t\u0004-\u0005e\u0015bAAN\u0005\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016AH7be.$v\u000e]5d\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o)\u0011\t\u0019\"a)\t\u000f\u0005\u0005\u0015Q\u0014a\u00017!9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0016\u0001H5t)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u0003W\u000by\u000bE\u0002\n\u0003[K1!a\u000e\u000b\u0011\u001d\t\t,!*A\u0002\u0005\nQ\u0001^8qS\u000eDq!!.\u0001\t\u0003\t9,A\rjgR{\u0007/[2EK2,G/[8o\u0013:\u0004&o\\4sKN\u001cH\u0003BAV\u0003sCq!!-\u00024\u0002\u0007\u0011\u0005C\u0004\u0002>\u0002!\t!a0\u0002-%\u001c\b+\u0019:uSRLwN\u001c+p\u0005\u0016$U\r\\3uK\u0012$B!a+\u0002B\"A\u00111YA^\u0001\u0004\t\t'A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!a2\u0001\t\u0003\tI-\u0001\u000ejgR{\u0007/[2Rk\u0016,X\rZ+q\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002,\u0006-\u0007bBAY\u0003\u000b\u0004\r!\t\u0005\b\u0003\u001f\u0004A\u0011BA\t\u0003y\tw/Y5u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8O_RLg-[2bi&|g\u000eC\u0004\u0002T\u0002!I!!\u0005\u00023I,7/^7f)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8UQJ,\u0017\r\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000e\u0006\u0003\u0002\u0014\u0005m\u0007\u0002CAJ\u0003+\u0004\r!!&\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\u0006Q\u0012n\u001d+pa&\u001cW\t\\5hS\ndWMR8s\t\u0016dW\r^5p]R!\u00111VAr\u0011\u001d\t\t,!8A\u0002\u0005Bq!a:\u0001\t\u0013\tI/A\rnCJ\\Gk\u001c9jG\u001a{'\u000fR3mKRLwN\u001c*fiJLH\u0003BA\n\u0003WDq!!-\u0002f\u0002\u0007\u0011\u0005C\u0004\u0002p\u0002!I!!=\u0002'\r|W\u000e\u001d7fi\u0016$U\r\\3uKR{\u0007/[2\u0015\t\u0005M\u00111\u001f\u0005\b\u0003c\u000bi\u000f1\u0001\"\u0011\u001d\t9\u0010\u0001C\u0005\u0003s\fqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u0005\u0003'\tY\u0010C\u0004\u0002\u0002\u0006U\b\u0019A\u000e\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u0005!2\u000f^1siJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:$B!a\u0005\u0003\u0004!A!QAA\u007f\u0001\u0004\t)*\u0001\u000fsKBd\u0017nY1t\r>\u0014Hk\u001c9jGN$vNQ3EK2,G/\u001a3\t\u000f\t%\u0001\u0001\"\u0003\u0003\f\u0005\u0019rN\u001c)beRLG/[8o\t\u0016dW\r^5p]R!\u00111\u0003B\u0007\u0011!\tYFa\u0002A\u0002\t=\u0001\u0003\u0002\u000f \u0003CBqAa\u0005\u0001\t\u0013\u0011)\"\u0001\u0010eK2,G/\u001a+pa&\u001c7\u000b^8q%\u0016\u0004H.[2b\u0007\u0006dGNY1dWR1\u00111\u0003B\f\u0005gA\u0001B!\u0007\u0003\u0012\u0001\u0007!1D\u0001\u0017gR|\u0007OU3qY&\u001c\u0017MU3ta>t7/Z(cUB!!Q\u0004B\u0018\u001b\t\u0011yB\u0003\u0003\u0003\"\t\r\u0012\u0001\u0003:fcV,7\u000f^:\u000b\t\u0005\u001d$Q\u0005\u0006\u0004\u000b\t\u001d\"\u0002\u0002B\u0015\u0005W\ta!\u00199bG\",'B\u0001B\u0017\u0003\ry'oZ\u0005\u0005\u0005c\u0011yB\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\"A!Q\u0007B\t\u0001\u0004\u00119$A\u0005sKBd\u0017nY1JIB\u0019\u0011B!\u000f\n\u0007\tm\"BA\u0002J]RD\u0011Ba\u0010\u0001#\u0003%\tA!\u0011\u0002CI,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\r#fA\u000e\u0003F-\u0012!q\t\t\u0005\u0005\u0013\u0012\u0019&\u0004\u0002\u0003L)!!Q\nB(\u0003%)hn\u00195fG.,GMC\u0002\u0003R)\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Fa\u0013\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0005\u0003Z\t\t\t\u0011#\u0001\u0003\\\u0005!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u00042A\u0006B/\r!\t!!!A\t\u0002\t}3c\u0001B/\u0011!9qF!\u0018\u0005\u0002\t\rDC\u0001B.\u0011)\u00119G!\u0018\u0012\u0002\u0013\u0005!\u0011I\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\t-$QLI\u0001\n\u0003\u0011\t%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final ReentrantLock deleteLock;
    private final Condition deleteTopicsCond;
    private final AtomicBoolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Set<String> $lessinit$greater$default$3() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> $lessinit$greater$default$2() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public ReentrantLock deleteLock() {
        return this.deleteLock;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public AtomicBoolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread x$1) {
        this.deleteTopicsThread = x$1;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public void start() {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            this.deleteTopicsThread_$eq(new DeleteTopicsThread());
            if (this.topicsToBeDeleted().nonEmpty()) {
                this.deleteTopicStateChanged().set(true);
            }
            this.deleteTopicsThread().start();
        }
    }

    public void shutdown() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !this.deleteTopicsThread().initiateShutdown()) break block0;
            this.resumeTopicDeletionThread();
            this.deleteTopicsThread().awaitShutdown();
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom()));
            this.resumeTopicDeletionThread();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasThatFailedToDelete.mkString(","), topics})));
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newTopicsToHaltDeletion.mkString(",")})));
            }
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        CoreUtils$.MODULE$.inLock(this.deleteLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (this.deleteTopicsThread().isRunning().get() && !this.deleteTopicStateChanged().compareAndSet(true, false)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for signal to start or continue topic deletion");
                this.deleteTopicsCond().await();
            }
        });
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged().set(true);
        CoreUtils$.MODULE$.inLock(this.deleteLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteTopicsCond().signal());
    }

    private void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{successfullyDeletedReplicas.mkString(",")})));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, failedReplicas.mkString(",")})));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$completeDeleteTopic$1(topic, x$2)));
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.mkString(",")})));
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicAndPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1 & Serializable & scala.Serializable)p -> ((TopicAndPartition)p._1()).topic());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion((Set<TopicAndPartition>)((MapLike)partitionReplicaAssignmentByTopic.apply((Object)topic)).keySet());
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic()).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeDeleted.mkString(",")})));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void deleteTopicStopReplicaCallback(AbstractResponse stopReplicaResponseObj, int replicaId) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Delete topic callback invoked for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stopReplicaResponse})));
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaResponse.responses()).asScala();
        Set partitionsInError = stopReplicaResponse.errorCode() != Errors.NONE.code() ? responseMap.keySet() : ((MapLike)responseMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$deleteTopicStopReplicaCallback$2(x0$1)))).keySet();
        Set replicasInError = (Set)partitionsInError.map((Function1 & Serializable & scala.Serializable)p -> new PartitionAndReplica(p.topic(), p.partition(), replicaId), Set$.MODULE$.canBuildFrom());
        CoreUtils$.MODULE$.inLock(this.controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.failReplicaDeletion((Set<PartitionAndReplica>)replicasInError);
                if (replicasInError.size() == responseMap.size()) break block0;
                Set deletedReplicas = (Set)responseMap.keySet().$minus$minus((GenTraversableOnce)partitionsInError);
                this.completeReplicaDeletion((Set<PartitionAndReplica>)((Set)deletedReplicas.map((Function1 & Serializable & scala.Serializable)p -> new PartitionAndReplica(p.topic(), p.partition(), replicaId), Set$.MODULE$.canBuildFrom())));
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$topicsToBeDeleted$1(TopicDeletionManager $this, ZkUtils zkUtils$1, String topic) {
        String deleteTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath(topic);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Removing " + deleteTopicPath + " since delete topic is disabled");
        return zkUtils$1.zkClient().delete(deleteTopicPath);
    }

    public static final /* synthetic */ boolean $anonfun$completeDeleteTopic$1(String topic$2, TopicAndPartition x$2) {
        String string = x$2.topic();
        String string2 = topic$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$3, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, $this.replicaStateMachine().handleStateChanges$default$3());
            $this.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, OfflineReplica$.MODULE$, $this.replicaStateMachine().handleStateChanges$default$3());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasForDeletionRetry.mkString(",")})));
            $this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.deleteTopicStopReplicaCallback(stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId));
                return BoxedUnit.UNIT;
            }).build());
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadReplicasForTopic.mkString(","), topic})));
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopicStopReplicaCallback$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Short error = (Short)tuple2._2();
        boolean bl = !BoxesRunTime.equalsNumObject((Number)error, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
        return bl;
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        scala.collection.mutable.Set set;
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging.$init$(this);
        this.logIdent_$eq("[Topic Deletion Manager " + controller.config().brokerId() + "], ");
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.deleteLock = new ReentrantLock();
        this.deleteTopicsCond = this.deleteLock().newCondition();
        this.deleteTopicStateChanged = new AtomicBoolean(false);
        this.deleteTopicsThread = null;
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            set = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        } else {
            ZkUtils zkUtils = this.controllerContext().zkUtils();
            initialTopicsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$topicsToBeDeleted$1(this, zkUtils, topic)));
            set = scala.collection.mutable.Set$.MODULE$.empty();
        }
        this.topicsToBeDeleted = set;
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        this.partitionsToBeDeleted = (scala.collection.mutable.Set)this.topicsToBeDeleted().flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
    }

    public class DeleteTopicsThread
    extends ShutdownableThread {
        private final ZkUtils zkUtils;

        public ZkUtils zkUtils() {
            return this.zkUtils;
        }

        @Override
        public void doWork() {
            this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
            if (!this.isRunning().get()) {
                return;
            }
            CoreUtils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                if (topicsQueuedForDeletion.nonEmpty()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handling deletion for topics " + topicsQueuedForDeletion.mkString(","));
                }
                topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                    DeleteTopicsThread.$anonfun$doWork$3(this, topic);
                    return BoxedUnit.UNIT;
                });
            });
        }

        public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return TopicDeletionManager.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$3(DeleteTopicsThread $this, String topic) {
            block6: {
                block5: {
                    if ($this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                        $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    } else if ($this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                        Set<PartitionAndReplica> replicasInDeletionStartedState = $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                        Set replicaIds = (Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.replica()), Set$.MODULE$.canBuildFrom());
                        Set partitions = (Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)r -> new TopicAndPartition(r.topic(), r.partition()), Set$.MODULE$.canBuildFrom());
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaIds.mkString(","), partitions.mkString(","), topic})));
                    } else if ($this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                        $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                    }
                    if (!$this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) break block5;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                    break block6;
                }
                if (!$this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic)) break block6;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
        }

        public DeleteTopicsThread() {
            if (TopicDeletionManager.this == null) {
                throw null;
            }
            super("delete-topics-thread-" + TopicDeletionManager.this.kafka$controller$TopicDeletionManager$$controller.config().brokerId(), false);
            this.zkUtils = TopicDeletionManager.this.controllerContext().zkUtils();
        }
    }
}

