/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\t\u0019LG.\u001a\t\u00031ui\u0011!\u0007\u0006\u00035m\t!![8\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0005\r&dW\rC\u0005!\u0001\t\u0005\t\u0015!\u0003\rC\u0005Q!-Y:f\u001f\u001a47/\u001a;\n\u0005\u0001R\u0001\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n%\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0013\t\u0019#\u0002C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0005Q%R3\u0006\u0005\u0002\n\u0001!)a#\na\u0001/!)\u0001%\na\u0001\u0019!91%\nI\u0001\u0002\u0004\u0011\u0002\"B\u0017\u0001\t\u0003r\u0013!C3oiJL8+\u001b>f+\u0005\u0011\u0002B\u0002\u0019\u0001A\u0003&A\"A\u0006`Y\u0006\u001cHo\u00144gg\u0016$\b\"\u0002\u001a\u0001\t\u0013\u0019\u0014!\u00037bgR,e\u000e\u001e:z+\u0005!\u0004CA\u00056\u0013\t1$A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000ba\u0002A\u0011A\u001d\u0002\u00151\f7\u000f^(gMN,G/F\u0001\r\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u0019awn\\6vaR\u0011A'\u0010\u0005\u0006}i\u0002\r\u0001D\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\u0006\u0001\u0002!I!Q\u0001\u000fe\u0016d\u0017\r^5wK>3gm]3u)\r\u0011\"I\u0013\u0005\u0006\u0007~\u0002\r\u0001R\u0001\u0007EV4g-\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d[\u0012a\u00018j_&\u0011\u0011J\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B&@\u0001\u0004\u0011\u0012!\u00018\t\u000b5\u0003A\u0011\u0002(\u0002\u0011AD\u0017p]5dC2$2AE(Q\u0011\u0015\u0019E\n1\u0001E\u0011\u0015YE\n1\u0001\u0013\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003)\u0001\u0018M]:f\u000b:$(/\u001f\u000b\u0004)^C\u0006CA\u0005V\u0013\t1&A\u0001\u0006J]\u0012,\u00070\u00128uefDQaQ)A\u0002\u0011CQaS)A\u0002IAQA\u0017\u0001\u0005\u0002m\u000bQ!\u001a8uef$\"\u0001\u000e/\t\u000b-K\u0006\u0019\u0001\n\t\u000by\u0003A\u0011A0\u0002\r\u0005\u0004\b/\u001a8e)\r\u00017-\u001a\t\u0003\u001b\u0005L!A\u0019\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Iv\u0003\r\u0001D\u0001\u0007_\u001a47/\u001a;\t\u000b\u0019l\u0006\u0019\u0001\n\u0002\u0011A|7/\u001b;j_:DQ\u0001\u001b\u0001\u0005B%\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0002A\")1\u000e\u0001C!Y\u0006QAO];oG\u0006$X\rV8\u0015\u0005\u0001l\u0007\"\u00023k\u0001\u0004a\u0001\"B8\u0001\t\u0013\u0001\u0018!\u0005;sk:\u001c\u0017\r^3U_\u0016sGO]5fgR\u0011\u0001-\u001d\u0005\u0006e:\u0004\rAE\u0001\bK:$(/[3t\u0011\u0015!\b\u0001\"\u0011j\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u0017Y\u0004\u0001\u0013aA\u0001\u0002\u0013%a\u0006J\u0001\u0013gV\u0004XM\u001d\u0013nCbLe\u000eZ3y'&TX\rC\u0006y\u0001A\u0005\u0019\u0011!A\u0005\ne\n\u0013\u0001E:va\u0016\u0014HEY1tK>3gm]3u\u000f\u001dQ(!!A\t\u0002m\f1b\u00144gg\u0016$\u0018J\u001c3fqB\u0011\u0011\u0002 \u0004\b\u0003\t\t\t\u0011#\u0001~'\tah\u0010\u0005\u0002\u000e\u007f&\u0019\u0011\u0011\u0001\b\u0003\r\u0005s\u0017PU3g\u0011\u00191C\u0010\"\u0001\u0002\u0006Q\t1\u0010C\u0005\u0002\nq\f\n\u0011\"\u0001\u0002\f\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!\u0004+\u0007I\tya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tYBD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    private final File file;
    private long _lastOffset;

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    private OffsetPosition lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & java.io.Serializable & Serializable)() -> {
            OffsetPosition offsetPosition;
            int n = this._entries();
            switch (n) {
                case 0: {
                    offsetPosition = new OffsetPosition(this.super$baseOffset(), 0);
                    break;
                }
                default: {
                    offsetPosition = (OffsetPosition)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return offsetPosition;
        });
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & java.io.Serializable & Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.indexSlotFor(idx, targetOffset, IndexSearchType$.MODULE$.KEY());
            return slot == -1 ? new OffsetPosition(this.super$baseOffset(), 0) : (OffsetPosition)this.parseEntry(idx, slot);
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & java.io.Serializable & Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new OffsetPosition(this.relativeOffset(idx, n), this.physical(idx, n));
        });
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Predef$.MODULE$.require(!this.isFull(), (Function0 & java.io.Serializable & Serializable)() -> "Attempt to append to a full index (size = " + this._entries() + ").");
            if (this._entries() != 0 && offset <= $this._lastOffset) {
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.entries()), BoxesRunTime.boxToLong((long)$this._lastOffset), $this.file.getAbsolutePath()})));
            }
            this.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)position), $this.file.getName()})));
            this.mmap().putInt((int)(offset - this.super$baseOffset()));
            this.mmap().putInt(position);
            this._entries_$eq(this._entries() + 1);
            $this._lastOffset = offset;
            Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & java.io.Serializable & Serializable)() -> this.entries() + " entries but file position in index is " + this.mmap().position() + ".");
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.indexSlotFor(idx, offset, IndexSearchType$.MODULE$.KEY());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            $this._lastOffset = this.lastEntry().offset();
        });
    }

    @Override
    public void sanityCheck() {
        Predef$.MODULE$.require(this._entries() == 0 || this._lastOffset > super.baseOffset(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this._lastOffset), BoxesRunTime.boxToLong((long)this.super$baseOffset())})));
        long len = this.file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0 & java.io.Serializable & Serializable)() -> "Index file " + $this.file.getAbsolutePath() + " is corrupt, found " + len + " bytes which is not positive or not a multiple of 8.");
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize) {
        this.file = file;
        super(file, baseOffset, maxIndexSize);
        this._lastOffset = this.lastEntry().offset();
        this.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.maxEntries()), BoxesRunTime.boxToInteger((int)this.super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)$this._lastOffset), BoxesRunTime.boxToInteger((int)this.mmap().position())})));
    }
}

