/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.producer.KeyedMessage;
import kafka.producer.async.EventHandler;
import kafka.producer.async.IllegalQueueStateException;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001%\u0011!\u0003\u0015:pIV\u001cWM]*f]\u0012$\u0006N]3bI*\u00111\u0001B\u0001\u0006CNLhn\u0019\u0006\u0003\u000b\u0019\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0006C\u001bN!\u0001aC\n\u001a!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011a\u0001\u00165sK\u0006$\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003\u0015)H/\u001b7t\u0013\tARCA\u0004M_\u001e<\u0017N\\4\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011aB7fiJL7m]\u0005\u0003=m\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!\u0001\u0003A!b\u0001\n\u0003\t\u0013A\u0003;ie\u0016\fGMT1nKV\t!\u0005\u0005\u0002$Y9\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0003O!\ta\u0001\u0010:p_Rt$\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B\u0013A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u0015\t\u0011A\u0002!\u0011!Q\u0001\n\t\n1\u0002\u001e5sK\u0006$g*Y7fA!A!\u0007\u0001BC\u0002\u0013\u00051'A\u0003rk\u0016,X-F\u00015!\r)$\bP\u0007\u0002m)\u0011q\u0007O\u0001\u000bG>t7-\u001e:sK:$(BA\u001d\u0010\u0003\u0011)H/\u001b7\n\u0005m2$!\u0004\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0003>}\u0001cU\"\u0001\u0003\n\u0005}\"!\u0001D&fs\u0016$W*Z:tC\u001e,\u0007CA!C\u0019\u0001!Qa\u0011\u0001C\u0002\u0011\u0013\u0011aS\t\u0003\u000b&\u0003\"AR$\u000e\u0003!J!\u0001\u0013\u0015\u0003\u000f9{G\u000f[5oOB\u0011aIS\u0005\u0003\u0017\"\u00121!\u00118z!\t\tU\nB\u0003O\u0001\t\u0007AIA\u0001W\u0011!\u0001\u0006A!A!\u0002\u0013!\u0014AB9vKV,\u0007\u0005\u0003\u0005S\u0001\t\u0015\r\u0011\"\u0001T\u0003\u001dA\u0017M\u001c3mKJ,\u0012\u0001\u0016\t\u0005+Z\u0003E*D\u0001\u0003\u0013\t9&A\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003U\u0003!A\u0017M\u001c3mKJ\u0004\u0003\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\u0002\u0013E,X-^3US6,W#A/\u0011\u0005\u0019s\u0016BA0)\u0005\u0011auN\\4\t\u0011\u0005\u0004!\u0011!Q\u0001\nu\u000b!\"];fk\u0016$\u0016.\\3!\u0011!\u0019\u0007A!b\u0001\n\u0003!\u0017!\u00032bi\u000eD7+\u001b>f+\u0005)\u0007C\u0001$g\u0013\t9\u0007FA\u0002J]RD\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006I!Z\u0001\u000bE\u0006$8\r[*ju\u0016\u0004\u0003\u0002C6\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IAI\u0001\nG2LWM\u001c;JI\u0002BQa\u001c\u0001\u0005\u0002A\fa\u0001P5oSRtDcB9sgR,ho\u001e\t\u0005+\u0002\u0001E\nC\u0003!]\u0002\u0007!\u0005C\u00033]\u0002\u0007A\u0007C\u0003S]\u0002\u0007A\u000bC\u0003\\]\u0002\u0007Q\fC\u0003d]\u0002\u0007Q\rC\u0003l]\u0002\u0007!\u0005C\u0004z\u0001\t\u0007I\u0011\u0002>\u0002\u001bMDW\u000f\u001e3po:d\u0015\r^2i+\u0005Y\bCA\u001b}\u0013\tihG\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\r}\u0004\u0001\u0015!\u0003|\u00039\u0019\b.\u001e;e_^tG*\u0019;dQ\u0002B\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\u0002\u001fMDW\u000f\u001e3po:\u001cu.\\7b]\u0012,\u0012\u0001\u0010\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003=\u0003A\u0019\b.\u001e;e_^t7i\\7nC:$\u0007\u0005C\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0007I,h\u000e\u0006\u0002\u0002\u0012A\u0019a)a\u0005\n\u0007\u0005U\u0001F\u0001\u0003V]&$\bbBA\r\u0001\u0011\u0005\u00111D\u0001\tg\",H\u000fZ8x]V\u0011\u0011\u0011\u0003\u0005\b\u0003?\u0001A\u0011BA\b\u00035\u0001(o\\2fgN,e/\u001a8ug\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012a\u0003;ssR{\u0007*\u00198eY\u0016$B!!\u0005\u0002(!A\u0011\u0011FA\u0011\u0001\u0004\tY#\u0001\u0004fm\u0016tGo\u001d\t\u0006\u0003[\t9\u0004\u0010\b\u0005\u0003_\t\u0019DD\u0002&\u0003cI\u0011!K\u0005\u0004\u0003kA\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYDA\u0002TKFT1!!\u000e)Q\u001d\u0001\u0011qHA#\u0003\u0013\u00022ARA!\u0013\r\t\u0019\u0005\u000b\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA$\u0003\u001d#\u0006.[:!G2\f7o\u001d\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016t\u0013EAA&\u0003!\u0001d&\r\u0019/a9\u0002\u0004")
public class ProducerSendThread<K, V>
extends Thread
implements KafkaMetricsGroup {
    private final String threadName;
    private final BlockingQueue<KeyedMessage<K, V>> queue;
    private final EventHandler<K, V> handler;
    private final long queueTime;
    private final int batchSize;
    private final String clientId;
    private final CountDownLatch shutdownLatch;
    private final KeyedMessage<K, V> shutdownCommand;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerSendThread producerSendThread = this;
        synchronized (producerSendThread) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String threadName() {
        return this.threadName;
    }

    public BlockingQueue<KeyedMessage<K, V>> queue() {
        return this.queue;
    }

    public EventHandler<K, V> handler() {
        return this.handler;
    }

    public long queueTime() {
        return this.queueTime;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public String clientId() {
        return this.clientId;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private KeyedMessage<K, V> shutdownCommand() {
        return this.shutdownCommand;
    }

    @Override
    public void run() {
        try {
            try {
                this.processEvents();
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in sending events: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
        finally {
            this.shutdownLatch().countDown();
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Begin shutting down ProducerSendThread");
        this.queue().put(this.shutdownCommand());
        this.shutdownLatch().await();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown ProducerSendThread complete");
    }

    private void processEvents() {
        LongRef lastSend = LongRef.create((long)Time.SYSTEM.milliseconds());
        ObjectRef events = ObjectRef.create((Object)new ArrayBuffer());
        BooleanRef full = BooleanRef.create((boolean)false);
        scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.queue().poll(package$.MODULE$.max(0L, lastSend$1.elem + this.queueTime() - Time.SYSTEM.milliseconds()), TimeUnit.MILLISECONDS)).takeWhile((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ProducerSendThread.$anonfun$processEvents$2(this, item))).foreach((Function1 & Serializable & scala.Serializable)currentQueueItem -> {
            ProducerSendThread.$anonfun$processEvents$3(this, lastSend, events, full, currentQueueItem);
            return BoxedUnit.UNIT;
        });
        this.tryToHandle((Seq<KeyedMessage<K, V>>)((ArrayBuffer)events.elem));
        if (this.queue().size() > 0) {
            throw new IllegalQueueStateException(new StringOps(Predef$.MODULE$.augmentString("Invalid queue state! After queue shutdown, %d remaining items in the queue")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.queue().size())})));
        }
    }

    public void tryToHandle(Seq<KeyedMessage<K, V>> events) {
        int size = events.size();
        try {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handling " + size + " events");
            if (size > 0) {
                this.handler().handle(events);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in handling batch of " + size + " events", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$processEvents$2(ProducerSendThread $this, KeyedMessage item) {
        return item != null ? item != $this.shutdownCommand() : true;
    }

    public static final /* synthetic */ void $anonfun$processEvents$3(ProducerSendThread $this, LongRef lastSend$1, ObjectRef events$1, BooleanRef full$1, KeyedMessage currentQueueItem) {
        block4: {
            BoxedUnit boxedUnit;
            boolean expired;
            long elapsed = Time.SYSTEM.milliseconds() - lastSend$1.elem;
            boolean bl = expired = currentQueueItem == null;
            if (currentQueueItem != null) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Dequeued item for topic %s, partition key: %s, data: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentQueueItem.topic(), currentQueueItem.key(), currentQueueItem.message()})));
                boxedUnit = ((ArrayBuffer)events$1.elem).$plus$eq((Object)currentQueueItem);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean bl2 = full$1.elem = ((ArrayBuffer)events$1.elem).size() >= $this.batchSize();
            if (!full$1.elem && !expired) break block4;
            if (expired) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> elapsed + " ms elapsed. Queue time reached. Sending..");
            }
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Batch full. Sending..");
            }
            $this.tryToHandle((Seq)((ArrayBuffer)events$1.elem));
            lastSend$1.elem = Time.SYSTEM.milliseconds();
            events$1.elem = new ArrayBuffer();
        }
    }

    public ProducerSendThread(String threadName, BlockingQueue<KeyedMessage<K, V>> queue, EventHandler<K, V> handler, long queueTime, int batchSize, String clientId) {
        this.threadName = threadName;
        this.queue = queue;
        this.handler = handler;
        this.queueTime = queueTime;
        this.batchSize = batchSize;
        this.clientId = clientId;
        super(threadName);
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.shutdownLatch = new CountDownLatch(1);
        this.shutdownCommand = new KeyedMessage<Object, Object>("shutdown", null, null);
        this.newGauge("ProducerQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ProducerSendThread $outer;

            public int value() {
                return this.$outer.queue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
    }
}

