/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t]b!B\u0001\u0003\u0001\t1!!D'fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0004\u0001\u001di\u0001C\u0001\u0005\f\u001b\u0005I!\"\u0001\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00051I!AB!osJ+g\r\u0005\u0002\u000f#5\tqB\u0003\u0002\u0011\t\u0005)Q\u000f^5mg&\u0011!c\u0004\u0002\b\u0019><w-\u001b8h\u0011!!\u0002A!A!\u0002\u00131\u0012\u0001\u00032s_.,'/\u00133\u0004\u0001A\u0011\u0001bF\u0005\u00031%\u00111!\u00138u\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011AD\b\t\u0003;\u0001i\u0011A\u0001\u0005\u0006)e\u0001\rA\u0006\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002EA\u00111%\u000b\b\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\t!bY8oiJ|G\u000e\\3s\u0013\tAS%A\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0013\tQ3FA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJT!\u0001K\u0013\t\r5\u0002\u0001\u0015!\u0003#\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005)1-Y2iKV\t\u0011\u0007\u0005\u00033oe\"U\"A\u001a\u000b\u0005Q*\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003m%\t!bY8mY\u0016\u001cG/[8o\u0013\tA4GA\u0002NCB\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f\n\u001b\u0005i$B\u0001 \u0016\u0003\u0019a$o\\8u}%\u0011\u0001)C\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A\u0013A!!g\u000e\fF!\t1\u0015*D\u0001H\u0015\tAE!A\u0002ba&L!AS$\u0003%A\u000b'\u000f^5uS>t7\u000b^1uK&sgm\u001c\u0005\u0007\u0019\u0002\u0001\u000b\u0011B\u0019\u0002\r\r\f7\r[3!\u0011\u001dq\u0005\u00011A\u0005\n=\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012\u0001\u0015\t\u0004\u0011E3\u0012B\u0001*\n\u0005\u0019y\u0005\u000f^5p]\"9A\u000b\u0001a\u0001\n\u0013)\u0016\u0001E2p]R\u0014x\u000e\u001c7fe&#w\fJ3r)\t1\u0016\f\u0005\u0002\t/&\u0011\u0001,\u0003\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019\u0001)\u0002\u0007a$\u0013\u0007\u0003\u0004]\u0001\u0001\u0006K\u0001U\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000fy\u0003!\u0019!C\u0005?\u0006a\u0011\r\\5wK\n\u0013xn[3sgV\t\u0001\r\u0005\u00033oY\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u0005\u0003\u001d\u0019G.^:uKJL!AZ2\u0003\r\t\u0013xn[3s\u0011\u0019A\u0007\u0001)A\u0005A\u0006i\u0011\r\\5wK\n\u0013xn[3sg\u0002BqA\u001b\u0001C\u0002\u0013%1.\u0001\u0006bY&4XMT8eKN,\u0012\u0001\u001c\t\u0005e]2R\u000e\u0005\u0003o_BlX\"A\u001b\n\u0005a*\u0004CA9|\u001b\u0005\u0011(BA:u\u0003\u001dqW\r^<pe.T!!\u001e<\u0002\r\r|W.\\8o\u0015\t)qO\u0003\u0002ys\u00061\u0011\r]1dQ\u0016T\u0011A_\u0001\u0004_J<\u0017B\u0001?s\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\tqx0D\u0001u\u0013\r\t\t\u0001\u001e\u0002\u0005\u001d>$W\rC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u00027\u0002\u0017\u0005d\u0017N^3O_\u0012,7\u000f\t\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017\tQ\u0003]1si&$\u0018n\u001c8NKR\fG-\u0019;b\u0019>\u001c7.\u0006\u0002\u0002\u000eA!\u0011qBA\u0011\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011!\u00027pG.\u001c(\u0002BA\f\u00033\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\tY\"!\b\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\t\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0007\u0002CA\u0014\u0001\u0001\u0006I!!\u0004\u0002-A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dW\u0002Bq!a\u000b\u0001\t\u0013\ti#\u0001\u0007hKR,e\u000e\u001a9pS:$8\u000f\u0006\u0005\u00020\u0005U\u00121JA(!\u0011q\u0017\u0011G?\n\u0007\u0005MRGA\u0002TKFD\u0001\"a\u000e\u0002*\u0001\u0007\u0011\u0011H\u0001\bEJ|7.\u001a:t!\u0015\tY$!\u0012\u0017\u001d\u0011\ti$!\u0011\u000f\u0007q\ny$C\u0001\u000b\u0013\r\t\u0019%C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u0011%#XM]1cY\u0016T1!a\u0011\n\u0011\u001d\ti%!\u000bA\u0002A\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016D\u0001\"!\u0015\u0002*\u0001\u0007\u00111K\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\t\u0004\u0011\u0005U\u0013bAA,\u0013\t9!i\\8mK\u0006t\u0007bBA.\u0001\u0011%\u0011QL\u0001\u0011O\u0016$\u0018\t\\5wK\u0016sG\r]8j]R$b!a\u0018\u0002b\u0005\r\u0004c\u0001\u0005R{\"1A#!\u0017A\u0002YAq!!\u0014\u0002Z\u0001\u0007\u0001\u000fC\u0004\u0002h\u0001!I!!\u001b\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8NKR\fG-\u0019;b)!\tY'a!\u0002\b\u0006%\u0005\u0003\u0002\u0005R\u0003[\u0002b!a\u000f\u0002F\u0005=\u0004\u0003BA9\u0003{rA!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\"\u0018\u0001\u0003:fcV,7\u000f^:\n\t\u0005m\u0014QO\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016LA!a \u0002\u0002\n\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u000b\t\u0005m\u0014Q\u000f\u0005\b\u0003\u000b\u000b)\u00071\u0001:\u0003\u0015!x\u000e]5d\u0011\u001d\ti%!\u001aA\u0002AD\u0001\"a#\u0002f\u0001\u0007\u00111K\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000fC\u0004\u0002\u0010\u0002!\t!!%\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0003CAJ\u00037\u000b)+a*\u0011\u000b9\f\t$!&\u0011\t\u0005E\u0014qS\u0005\u0005\u00033\u000b\tIA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\t\u0003;\u000bi\t1\u0001\u0002 \u00061Ao\u001c9jGN\u0004BA\\AQs%\u0019\u00111U\u001b\u0003\u0007M+G\u000fC\u0004\u0002N\u00055\u0005\u0019\u00019\t\u0015\u0005-\u0015Q\u0012I\u0001\u0002\u0004\t\u0019\u0006C\u0004\u0002,\u0002!\t!!,\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\u0005}\u0005bBAY\u0001\u0011\u0005\u00111W\u0001\u0015O\u0016$hj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY:\u0015\t\u0005}\u0015Q\u0017\u0005\t\u0003;\u000by\u000b1\u0001\u0002 \"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0016aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0016\u0005\u0005u\u0006\u0003\u00028\u00022\u0005Dq!!1\u0001\t\u0013\t\u0019-\u0001\rbI\u0012|%/\u00169eCR,\u0007+\u0019:uSRLwN\\%oM>$rAVAc\u0003\u000f\fY\rC\u0004\u0002\u0006\u0006}\u0006\u0019A\u001d\t\u000f\u0005%\u0017q\u0018a\u0001-\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\ti-a0A\u0002\u0015\u000b\u0011b\u001d;bi\u0016LeNZ8\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u0007\u0003+\f9.!7\u0011\u0007!\tV\tC\u0004\u0002\u0006\u0006=\u0007\u0019A\u001d\t\u000f\u0005%\u0017q\u001aa\u0001-!1\u0011Q\u001c\u0001\u0005\u0002=\u000bqbZ3u\u0007>tGO]8mY\u0016\u0014\u0018\n\u001a\u0005\b\u0003C\u0004A\u0011AAr\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\r\u0005\u0015\u0018Q^Ay!\u0015q\u0017\u0011GAt!\rq\u0018\u0011^\u0005\u0004\u0003W$(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003_\fy\u000e1\u0001\u0017\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\"A\u00111_Ap\u0001\u0004\t)0A\u000bva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0011\t\u0005M\u0014q_\u0005\u0005\u0003s\f)HA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\u0006\u0011\u0003/\u0019:uSRLwN\\*uCR,Gk\u001c)beRLG/[8o'R\fG/Z%oM>$2!\u0012B\u0001\u0011!\u0011\u0019!a?A\u0002\t\u0015\u0011A\u00049beRLG/[8o'R\fG/\u001a\t\u0005\u0003g\u00129!\u0003\u0003\u0003\n\u0005U$A\u0004)beRLG/[8o'R\fG/\u001a\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0003!\u0019wN\u001c;bS:\u001cH\u0003BA*\u0005#Aq!!\"\u0003\f\u0001\u0007\u0011\bC\u0004\u0003\u0016\u0001!IAa\u0006\u0002'I,Wn\u001c<f!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\u0005M#\u0011\u0004B\u000e\u0011\u001d\t)Ia\u0005A\u0002eBq!!3\u0003\u0014\u0001\u0007a\u0003C\u0005\u0003 \u0001\t\n\u0011\"\u0001\u0003\"\u0005Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0005\u0016\u0005\u0003'\u0012)c\u000b\u0002\u0003(A!!\u0011\u0006B\u001a\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012!C;oG\",7m[3e\u0015\r\u0011\t$C\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001b\u0005W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class MetadataCache
implements Logging {
    private final int brokerId;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, PartitionStateInfo>> cache;
    private Option<Object> controllerId;
    private final scala.collection.mutable.Map<Object, Broker> aliveBrokers;
    private final scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, PartitionStateInfo>> cache() {
        return this.cache;
    }

    private Option<Object> controllerId() {
        return this.controllerId;
    }

    private void controllerId_$eq(Option<Object> x$1) {
        this.controllerId = x$1;
    }

    private scala.collection.mutable.Map<Object, Broker> aliveBrokers() {
        return this.aliveBrokers;
    }

    private scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes() {
        return this.aliveNodes;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private Seq<Node> getEndpoints(Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(this.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Node> getAliveEndpoint(int brokerId, ListenerName listenerName) {
        return this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)brokerId)).map((Function1 & Serializable & scala.Serializable)nodeMap -> (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker `", "` does not have listener with name `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), listenerName})));
        }));
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(String topic, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int partitionId = tuple2._1$mcI$sp();
            PartitionStateInfo partitionState = (PartitionStateInfo)tuple2._2();
            TopicAndPartition topicPartition = new TopicAndPartition(topic, partitionId);
            LeaderAndIsr leaderAndIsr = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            Option<Node> maybeLeader = this.getAliveEndpoint(leaderAndIsr.leader(), listenerName);
            Set<Object> replicas = partitionState.allReplicas();
            Seq<Node> replicaInfo = this.getEndpoints((Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": leader not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, partitionId, Node.noNode(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                List<Object> isr = leaderAndIsr.isr();
                Seq<Node> isrInfo = this.getEndpoints((Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": in sync replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata((String)topic, listenerName, errorUnavailableEndpoints).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic$.MODULE$.isInternal((String)topic), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom()));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public Set<String> getAllTopics() {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().keySet().toSet());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Set)topics.$minus$minus((GenTraversableOnce)this.cache().keySet()));
    }

    public Seq<Broker> getAliveBrokers() {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveBrokers().values().toBuffer());
    }

    private void addOrUpdatePartitionInfo(String topic, int partitionId, PartitionStateInfo stateInfo) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map infos = (scala.collection.mutable.Map)this.cache().getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            infos.update((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)stateInfo);
        });
    }

    public Option<PartitionStateInfo> getPartitionInfo(String topic, int partitionId) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public Option<Object> getControllerId() {
        return this.controllerId();
    }

    public Seq<TopicPartition> updateCache(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            this.controllerId_$eq((Option<Object>)(n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n))));
            this.aliveNodes().clear();
            this.aliveBrokers().clear();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateCache$2(this, broker);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ArrayBuffer arrayBuffer;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    PartitionState info = (PartitionState)tuple2._2();
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    if (info.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo(tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker ", " deleted partition ", " from metadata cache in response to UpdateMetadata "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        arrayBuffer = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        PartitionStateInfo partitionInfo = this.partitionStateToPartitionStateInfo(info);
                        this.addOrUpdatePartitionInfo(tp.topic(), tp.partition(), partitionInfo);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker ", " cached leader info ", " for partition ", " in response to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), partitionInfo, tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UpdateMetadata request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        arrayBuffer = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer arrayBuffer2 = arrayBuffer;
                return arrayBuffer2;
            });
            return deletedPartitions;
        });
    }

    private PartitionStateInfo partitionStateToPartitionStateInfo(PartitionState partitionState) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(partitionState.leader, partitionState.leaderEpoch, (List<Object>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4)), Buffer$.MODULE$.canBuildFrom())).toList(), partitionState.zkVersion);
        LeaderIsrAndControllerEpoch leaderInfo = new LeaderIsrAndControllerEpoch(leaderAndIsr, partitionState.controllerEpoch);
        return new PartitionStateInfo(leaderInfo, (Set<Object>)((Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$5)), Set$.MODULE$.canBuildFrom())));
    }

    public boolean contains(String topic) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cache().contains((Object)topic)));
    }

    private boolean removePartitionInfo(String topic, int partitionId) {
        return BoxesRunTime.unboxToBoolean((Object)this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(this, topic, partitionId, infos))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ void $anonfun$updateCache$2(MetadataCache $this, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        $this.aliveBrokers().update((Object)BoxesRunTime.boxToInteger((int)broker.id), (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        $this.aliveNodes().update((Object)BoxesRunTime.boxToInteger((int)broker.id), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(MetadataCache $this, String topic$5, int partitionId$3, scala.collection.mutable.Map infos) {
        infos.remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        Object object = infos.isEmpty() ? $this.cache().remove((Object)topic$5) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.cache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.controllerId = None$.MODULE$;
        this.aliveBrokers = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aliveNodes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Kafka Metadata Cache on broker ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
    }
}

