/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.OffsetCheckpoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001u<Q!\u0001\u0002\t\u0002\u001d\t\u0001c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011\u0001c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00139\u0012AE,iSR,7\u000b]1dKN\u0004\u0016\r\u001e;fe:,\u0012\u0001\u0007\t\u00033\u0001j\u0011A\u0007\u0006\u00037q\tQA]3hKbT!!\b\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0005!!.\u0019<b\u0013\t\t#DA\u0004QCR$XM\u001d8\t\r\rJ\u0001\u0015!\u0003\u0019\u0003M9\u0006.\u001b;f'B\f7-Z:QCR$XM\u001d8!\u0011\u001d)\u0013B1A\u0005\n\u0019\nabQ;se\u0016tGOV3sg&|g.F\u0001(!\ti\u0001&\u0003\u0002*\u001d\t\u0019\u0011J\u001c;\t\r-J\u0001\u0015!\u0003(\u0003=\u0019UO\u001d:f]R4VM]:j_:\u0004c\u0001\u0002\u0006\u0003\u00015\u001a2\u0001\f\u0007/!\ty#'D\u00011\u0015\t\tD!A\u0003vi&d7/\u0003\u00024a\t9Aj\\4hS:<\u0007\u0002C\u001b-\u0005\u000b\u0007I\u0011\u0001\u001c\u0002\t\u0019LG.Z\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\u0011!HH\u0001\u0003S>L!\u0001P\u001d\u0003\t\u0019KG.\u001a\u0005\t}1\u0012\t\u0011)A\u0005o\u0005)a-\u001b7fA!)1\u0003\fC\u0001\u0001R\u0011\u0011I\u0011\t\u0003\u00111BQ!N A\u0002]Bq\u0001\u0012\u0017C\u0002\u0013%Q)\u0001\u0003qCRDW#\u0001$\u0011\u0005\u001d[U\"\u0001%\u000b\u0005UJ%B\u0001&\u001f\u0003\rq\u0017n\\\u0005\u0003\u0019\"\u0013A\u0001U1uQ\"1a\n\fQ\u0001\n\u0019\u000bQ\u0001]1uQ\u0002Bq\u0001\u0015\u0017C\u0002\u0013%Q)\u0001\u0005uK6\u0004\b+\u0019;i\u0011\u0019\u0011F\u0006)A\u0005\r\u0006IA/Z7q!\u0006$\b\u000e\t\u0005\b)2\u0012\r\u0011\"\u0003V\u0003\u0011awnY6\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0010\u0002\t1\fgnZ\u0005\u00037b\u0013aa\u00142kK\u000e$\bBB/-A\u0003%a+A\u0003m_\u000e\\\u0007\u0005C\u0003`Y\u0011\u0005\u0001-A\u0003xe&$X\r\u0006\u0002bIB\u0011QBY\u0005\u0003G:\u0011A!\u00168ji\")QM\u0018a\u0001M\u00069qN\u001a4tKR\u001c\b\u0003B4kY^l\u0011\u0001\u001b\u0006\u0003S:\t!bY8mY\u0016\u001cG/[8o\u0013\tY\u0007NA\u0002NCB\u0004\"!\\;\u000e\u00039T!a\u001c9\u0002\r\r|W.\\8o\u0015\t)\u0011O\u0003\u0002sg\u00061\u0011\r]1dQ\u0016T\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<o\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!\u0004=\n\u0005et!\u0001\u0002'p]\u001eDQa\u001f\u0017\u0005\u0002q\fAA]3bIR\ta\r")
public class OffsetCheckpoint
implements Logging {
    private final File file;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetCheckpoint offsetCheckpoint = this;
        synchronized (offsetCheckpoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Map<TopicPartition, Object> offsets) {
        Object object = this.lock();
        synchronized (object) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            this.liftedTree1$1(offsets, fileOutputStream, writer);
            Utils.atomicMoveWithFallback((Path)this.tempPath(), (Path)this.path());
        }
    }

    public Map<TopicPartition, Object> read() {
        Map map;
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                BufferedReader reader = new BufferedReader(new FileReader(this.file()));
                ObjectRef line = ObjectRef.create(null);
                Map map2 = OffsetCheckpoint.liftedTree2$1(reader, line, object);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                map = map2;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                map = (Map)ex.value();
            }
            throw ex;
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$write$1(BufferedWriter writer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPart = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        writer$1.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPart.topic(), BoxesRunTime.boxToInteger((int)topicPart.partition()), BoxesRunTime.boxToLong((long)offset)})));
        writer$1.newLine();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void liftedTree1$1(Map offsets$1, FileOutputStream fileOutputStream$1, BufferedWriter writer$1) {
        try {
            try {
                writer$1.write(((Object)BoxesRunTime.boxToInteger((int)OffsetCheckpoint$.MODULE$.kafka$server$OffsetCheckpoint$$CurrentVersion())).toString());
                writer$1.newLine();
                writer$1.write(((Object)BoxesRunTime.boxToInteger((int)offsets$1.size())).toString());
                writer$1.newLine();
                offsets$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    OffsetCheckpoint.$anonfun$write$1(writer$1, x0$1);
                    return BoxedUnit.UNIT;
                });
                writer$1.flush();
                fileOutputStream$1.getFD().sync();
            }
            catch (FileNotFoundException e) {
                if (FileSystems.getDefault().isReadOnly()) {
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Halting writes to offset checkpoint file because the underlying file system is inaccessible : ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    Runtime.getRuntime().halt(1);
                }
                throw e;
            }
        }
        finally {
            writer$1.close();
        }
    }

    private static final IOException malformedLineException$1(String line) {
        return new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed line in offset checkpoint file: ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})));
    }

    private static final Map liftedTree2$1(BufferedReader reader$1, ObjectRef line$1, Object nonLocalReturnKey1$1) {
        scala.collection.mutable.Map map;
        try {
            try {
                scala.collection.mutable.Map offsets;
                int version;
                line$1.elem = reader$1.readLine();
                if ((String)line$1.elem == null) {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Map$.MODULE$.empty());
                }
                int n = version = new StringOps(Predef$.MODULE$.augmentString((String)line$1.elem)).toInt();
                if (OffsetCheckpoint$.MODULE$.kafka$server$OffsetCheckpoint$$CurrentVersion() == n) {
                    line$1.elem = reader$1.readLine();
                    if ((String)line$1.elem == null) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Map$.MODULE$.empty());
                    }
                    int expectedSize = new StringOps(Predef$.MODULE$.augmentString((String)line$1.elem)).toInt();
                    offsets = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    line$1.elem = reader$1.readLine();
                    while ((String)line$1.elem != null) {
                        String[] stringArray = OffsetCheckpoint$.MODULE$.kafka$server$OffsetCheckpoint$$WhiteSpacesPattern().split((String)line$1.elem);
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                            String topic = (String)((SeqLike)option.get()).apply(0);
                            String partition = (String)((SeqLike)option.get()).apply(1);
                            String offset = (String)((SeqLike)option.get()).apply(2);
                            offsets.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())), (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(offset)).toLong())));
                            line$1.elem = reader$1.readLine();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw OffsetCheckpoint.malformedLineException$1((String)line$1.elem);
                    }
                    if (offsets.size() != expectedSize) {
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " entries but found only ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedSize), BoxesRunTime.boxToInteger((int)offsets.size())})));
                    }
                } else {
                    throw new IOException("Unrecognized version of the highwatermark checkpoint file: " + version);
                }
                scala.collection.mutable.Map map2 = offsets;
                map = map2;
            }
            catch (NumberFormatException numberFormatException) {
                throw OffsetCheckpoint.malformedLineException$1((String)line$1.elem);
            }
        }
        finally {
            reader$1.close();
        }
        return map;
    }

    public OffsetCheckpoint(File file) {
        this.file = file;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(((Object)this.path()).toString() + ".tmp", new String[0]);
        this.lock = new Object();
        file.createNewFile();
    }
}

