/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t%t!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u0001tG\u0004\u00022kA\u0011!GD\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0005Yr\u0011A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\b\t\u000bmJA\u0011\u0001\u001f\u0002\u000f\r|gn];nKRQq%P&W7v\u000b\t/!>\t\u000byR\u0004\u0019A \u0002\u0011\r|gn];nKJ\u0004B\u0001Q#H\u000f6\t\u0011I\u0003\u0002?\u0005*\u00111\tR\u0001\bG2LWM\u001c;t\u0015\t)A$\u0003\u0002G\u0003\ni1*\u00194lC\u000e{gn];nKJ\u00042!D\u0017I!\ti\u0011*\u0003\u0002K\u001d\t!!)\u001f;f\u0011\u0015a%\b1\u0001N\u0003\u0019!x\u000e]5dgB\u0019ajU\u0018\u000f\u0005=\u000bfB\u0001\u001aQ\u0013\u0005y\u0011B\u0001*\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\t1K7\u000f\u001e\u0006\u0003%:AQa\u0016\u001eA\u0002a\u000bQaY8v]R\u0004\"!D-\n\u0005is!\u0001\u0002'p]\u001eDQ\u0001\u0018\u001eA\u0002a\u000bq\u0001^5nK>,H\u000fC\u0003_u\u0001\u0007q,\u0001\u0004d_:4\u0017n\u001a\t\u0003A\u0006l\u0011!\u0003\u0004\u0005E&\u00011M\u0001\nD_:\u001cX/\\3s!\u0016\u0014hmQ8oM&<7CA1e!\tAQ-\u0003\u0002g\u0005\tQ\u0001+\u001a:g\u0007>tg-[4\t\u0011-\n'\u0011!Q\u0001\n1BQaE1\u0005\u0002%$\"a\u00186\t\u000b-B\u0007\u0019\u0001\u0017\t\u000f1\f'\u0019!C\u0001[\u0006a!p[\"p]:,7\r^(qiV\ta\u000eE\u0002pe>j\u0011\u0001\u001d\u0006\u0002c\u0006Q!n\u001c9ug&l\u0007\u000f\\3\n\u0005M\u0004(aG!sOVlWM\u001c;BG\u000e,\u0007\u000f^5oO>\u0003H/[8o'B,7\r\u0003\u0004vC\u0002\u0006IA\\\u0001\u000eu.\u001cuN\u001c8fGR|\u0005\u000f\u001e\u0011\t\u000f]\f'\u0019!C\u0001[\u0006\u0019\"m\\8ugR\u0014\u0018\r]*feZ,'o](qi\"1\u00110\u0019Q\u0001\n9\fACY8piN$(/\u00199TKJ4XM]:PaR\u0004\u0003bB>b\u0005\u0004%\t!\\\u0001\ti>\u0004\u0018nY(qi\"1Q0\u0019Q\u0001\n9\f\u0011\u0002^8qS\u000e|\u0005\u000f\u001e\u0011\t\u000f}\f'\u0019!C\u0001[\u0006QqM]8va&#w\n\u001d;\t\u000f\u0005\r\u0011\r)A\u0005]\u0006YqM]8va&#w\n\u001d;!\u0011%\t9!\u0019b\u0001\n\u0003\tI!\u0001\u0007gKR\u001c\u0007nU5{K>\u0003H/\u0006\u0002\u0002\fA!qN]A\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!aB%oi\u0016<WM\u001d\u0005\t\u0003?\t\u0007\u0015!\u0003\u0002\f\u0005ia-\u001a;dQNK'0Z(qi\u0002B\u0011\"a\tb\u0005\u0004%\t!!\n\u0002/I,7/\u001a;CK\u001eLgN\\5oO>3gm]3u\u001fB$XCAA\u0014!\ry\u0017\u0011F\u0005\u0004\u0003W\u0001(!E(qi&|gn\u00159fG\n+\u0018\u000e\u001c3fe\"A\u0011qF1!\u0002\u0013\t9#\u0001\rsKN,GOQ3hS:t\u0017N\\4PM\u001a\u001cX\r^(qi\u0002B\u0011\"a\rb\u0005\u0004%\t!!\u0003\u0002'M|7m[3u\u0005V4g-\u001a:TSj,w\n\u001d;\t\u0011\u0005]\u0012\r)A\u0005\u0003\u0017\tAc]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaR\u0004\u0003\"CA\u001eC\n\u0007I\u0011AA\u0005\u00035qW/\u001c+ie\u0016\fGm](qi\"A\u0011qH1!\u0002\u0013\tY!\u0001\bok6$\u0006N]3bIN|\u0005\u000f\u001e\u0011\t\u0013\u0005\r\u0013M1A\u0005\u0002\u0005%\u0011A\u00048v[\u001a+Go\u00195feN|\u0005\u000f\u001e\u0005\t\u0003\u000f\n\u0007\u0015!\u0003\u0002\f\u0005ya.^7GKR\u001c\u0007.\u001a:t\u001fB$\b\u0005C\u0005\u0002L\u0005\u0014\r\u0011\"\u0001\u0002&\u0005qa.Z<D_:\u001cX/\\3s\u001fB$\b\u0002CA(C\u0002\u0006I!a\n\u0002\u001f9,woQ8ogVlWM](qi\u0002B\u0001\"a\u0015b\u0005\u0004%\t!\\\u0001\u0012G>t7/^7fe\u000e{gNZ5h\u001fB$\bbBA,C\u0002\u0006IA\\\u0001\u0013G>t7/^7fe\u000e{gNZ5h\u001fB$\b\u0005C\u0005\u0002\\\u0005\u0014\r\u0011\"\u0001\u0002^\u00059q\u000e\u001d;j_:\u001cXCAA0!\ry\u0017\u0011M\u0005\u0004\u0003G\u0002(!C(qi&|gnU3u\u0011!\t9'\u0019Q\u0001\n\u0005}\u0013\u0001C8qi&|gn\u001d\u0011\t\u0013\u0005-\u0014M1A\u0005\u0002\u00055\u0014AD;tK>cGmQ8ogVlWM]\u000b\u0003\u0003_\u00022!DA9\u0013\r\t\u0019H\u0004\u0002\b\u0005>|G.Z1o\u0011!\t9(\u0019Q\u0001\n\u0005=\u0014aD;tK>cGmQ8ogVlWM\u001d\u0011\t\u0013\u0005m\u0014M1A\u0005\u0002\u0005u\u0014!\u00029s_B\u001cXCAA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%\u0002BAC\u0003+\tA!\u001e;jY&!\u0011\u0011RAB\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\t\u0003\u001b\u000b\u0007\u0015!\u0003\u0002\u0000\u00051\u0001O]8qg\u0002B\u0011\"!%b\u0005\u0004%\t!a%\u0002\u00159,X\u000e\u00165sK\u0006$7/\u0006\u0002\u0002\u0016B\u0019Q\"a&\n\u0007\u0005eeBA\u0002J]RD\u0001\"!(bA\u0003%\u0011QS\u0001\f]VlG\u000b\u001b:fC\u0012\u001c\b\u0005C\u0005\u0002\"\u0006\u0014\r\u0011\"\u0001\u0002$\u0006)Ao\u001c9jGV\tq\u0006C\u0004\u0002(\u0006\u0004\u000b\u0011B\u0018\u0002\rQ|\u0007/[2!\u0011%\tY+\u0019b\u0001\n\u0003\ti+A\u0006ok6lUm]:bO\u0016\u001cX#\u0001-\t\u000f\u0005E\u0016\r)A\u00051\u0006aa.^7NKN\u001c\u0018mZ3tA!I\u0011QW1C\u0002\u0013\u0005\u00111S\u0001\u0012e\u0016\u0004xN\u001d;j]\u001eLe\u000e^3sm\u0006d\u0007\u0002CA]C\u0002\u0006I!!&\u0002%I,\u0007o\u001c:uS:<\u0017J\u001c;feZ\fG\u000e\t\u0005\n\u0003{\u000b'\u0019!C\u0001\u0003[\n\u0011c\u001d5po\u0012+G/Y5mK\u0012\u001cF/\u0019;t\u0011!\t\t-\u0019Q\u0001\n\u0005=\u0014AE:i_^$U\r^1jY\u0016$7\u000b^1ug\u0002B\u0011\"!2b\u0005\u0004%\t!a2\u0002\u0015\u0011\fG/\u001a$pe6\fG/\u0006\u0002\u0002JB!\u00111ZAi\u001b\t\tiM\u0003\u0003\u0002P\u0006U\u0011\u0001\u0002;fqRLA!a5\u0002N\n\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r\u001e\u0005\t\u0003/\f\u0007\u0015!\u0003\u0002J\u0006YA-\u0019;f\r>\u0014X.\u0019;!\u0011%\tY.\u0019b\u0001\n\u0003\ti'\u0001\u0006iS\u0012,\u0007*Z1eKJD\u0001\"a8bA\u0003%\u0011qN\u0001\fQ&$W\rS3bI\u0016\u0014\b\u0005C\u0004\u0002dj\u0002\r!!:\u0002#Q|G/\u00197NKN\u001c\u0018mZ3t%\u0016\fG\r\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\r\u0005$x.\\5d\u0015\u0011\ty/a!\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002t\u0006%(AC!u_6L7\rT8oO\"9\u0011q\u001f\u001eA\u0002\u0005\u0015\u0018A\u0004;pi\u0006d')\u001f;fgJ+\u0017\r\u001a\u0005\b\u0003wLA\u0011AA\u007f\u0003Q\u0001(/\u001b8u!J|wM]3tg6+7o]1hKR\tr%a@\u0003\u0004\t\u001d!1\u0002B\b\u0005'\u00119Ba\u0007\t\u0011\t\u0005\u0011\u0011 a\u0001\u0003+\u000b!!\u001b3\t\u000f\t\u0015\u0011\u0011 a\u00011\u0006I!-\u001f;fgJ+\u0017\r\u001a\u0005\b\u0005\u0013\tI\u00101\u0001Y\u00035a\u0017m\u001d;CsR,7OU3bI\"9!QBA}\u0001\u0004A\u0016\u0001D7fgN\fw-Z:SK\u0006$\u0007b\u0002B\t\u0003s\u0004\r\u0001W\u0001\u0011Y\u0006\u001cH/T3tg\u0006<Wm\u001d*fC\u0012DqA!\u0006\u0002z\u0002\u0007\u0001,A\u0004ti\u0006\u0014H/T:\t\u000f\te\u0011\u0011 a\u00011\u0006)QM\u001c3Ng\"A\u0011QYA}\u0001\u0004\tIM\u0002\u0004\u0003 %\u0001!\u0011\u0005\u0002\u0013\u0007>t7/^7feB+'O\u001a+ie\u0016\fGm\u0005\u0003\u0003\u001e\t\r\u0002\u0003BA\b\u0005KIAAa\n\u0002\u0012\t1A\u000b\u001b:fC\u0012D1Ba\u000b\u0003\u001e\t\u0005\t\u0015!\u0003\u0002\u0016\u0006AA\u000f\u001b:fC\u0012LE\r\u0003\u0006\u00030\tu!\u0011!Q\u0001\n=\nAA\\1nK\"Y!1\u0007B\u000f\u0005\u0003\u0005\u000b\u0011\u0002B\u001b\u0003\u0019\u0019HO]3b[B1!q\u0007B\u001e\u000f\u001ek!A!\u000f\u000b\u0005y\"\u0011\u0002\u0002B\u001f\u0005s\u00111bS1gW\u0006\u001cFO]3b[\"IaL!\b\u0003\u0002\u0003\u0006Ia\u0018\u0005\f\u0003G\u0014iB!A!\u0002\u0013\t)\u000fC\u0006\u0002x\nu!\u0011!Q\u0001\n\u0005\u0015\bb\u0003B$\u0005;\u0011\t\u0011)A\u0005\u0005\u0013\nqbY8ogVlWM\u001d+j[\u0016|W\u000f\u001e\t\u0005\u0003O\u0014Y%\u0003\u0003\u0003N\u0005%(!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004\u0014\u0005;!\tA!\u0015\u0015!\tM#Q\u000bB,\u00053\u0012YF!\u0018\u0003`\t\u0005\u0004c\u00011\u0003\u001e!A!1\u0006B(\u0001\u0004\t)\nC\u0004\u00030\t=\u0003\u0019A\u0018\t\u0011\tM\"q\na\u0001\u0005kAaA\u0018B(\u0001\u0004y\u0006\u0002CAr\u0005\u001f\u0002\r!!:\t\u0011\u0005](q\na\u0001\u0003KD\u0001Ba\u0012\u0003P\u0001\u0007!\u0011\n\u0005\t\u0005K\u0012i\u0002\"\u0011\u0003h\u0005\u0019!/\u001e8\u0015\u0003\u001d\u0002")
public final class ConsumerPerformance {
    public static void printProgressMessage(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printProgressMessage(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)("perf-consumer-" + new Random().nextInt(100000)), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps((String)((String)this.options().valueOf(this.consumerConfigOpt()))) : new Properties();
            if (!this.useOldConsumer()) {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("max.partition.fetch.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            } else {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            }
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            block7: {
                long startMs;
                long bytesRead = 0L;
                long messagesRead = 0L;
                long lastReportTime = startMs = System.currentTimeMillis();
                long lastBytesRead = 0L;
                long lastMessagesRead = 0L;
                try {
                    Iterator iter = this.stream.iterator();
                    while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                        Object messageAndMetadata = iter.next();
                        ++messagesRead;
                        bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                        if (this.config.showDetailedStats()) {
                            ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                        }
                        lastReportTime = currentTimeMillis;
                        lastMessagesRead = messagesRead;
                        lastBytesRead = bytesRead;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                }
                catch (ConsumerTimeoutException consumerTimeoutException) {
                    this.consumerTimeout.set(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.totalMessagesRead.addAndGet(messagesRead);
                this.totalBytesRead.addAndGet(bytesRead);
                if (!this.config.showDetailedStats()) break block7;
                ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

