/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.Message$;
import kafka.server.KafkaConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.mutable.SetLike;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LogConfig$
implements scala.Serializable {
    public static LogConfig$ MODULE$;
    private final String Delete;
    private final String Compact;
    private final String SegmentBytesProp;
    private final String SegmentMsProp;
    private final String SegmentJitterMsProp;
    private final String SegmentIndexBytesProp;
    private final String FlushMessagesProp;
    private final String FlushMsProp;
    private final String RetentionBytesProp;
    private final String RetentionMsProp;
    private final String MaxMessageBytesProp;
    private final String IndexIntervalBytesProp;
    private final String DeleteRetentionMsProp;
    private final String MinCompactionLagMsProp;
    private final String FileDeleteDelayMsProp;
    private final String MinCleanableDirtyRatioProp;
    private final String CleanupPolicyProp;
    private final String UncleanLeaderElectionEnableProp;
    private final String MinInSyncReplicasProp;
    private final String CompressionTypeProp;
    private final String PreAllocateEnableProp;
    private final String MessageFormatVersionProp;
    private final String MessageTimestampTypeProp;
    private final String MessageTimestampDifferenceMaxMsProp;
    private final String LeaderReplicationThrottledReplicasProp;
    private final String FollowerReplicationThrottledReplicasProp;
    private final String SegmentSizeDoc;
    private final String SegmentMsDoc;
    private final String SegmentJitterMsDoc;
    private final String FlushIntervalDoc;
    private final String FlushMsDoc;
    private final String RetentionSizeDoc;
    private final String RetentionMsDoc;
    private final String MaxIndexSizeDoc;
    private final String MaxMessageSizeDoc;
    private final String IndexIntervalDoc;
    private final String FileDeleteDelayMsDoc;
    private final String DeleteRetentionMsDoc;
    private final String MinCompactionLagMsDoc;
    private final String MinCleanableRatioDoc;
    private final String CompactDoc;
    private final String UncleanLeaderElectionEnableDoc;
    private final String MinInSyncReplicasDoc;
    private final String CompressionTypeDoc;
    private final String PreAllocateEnableDoc;
    private final String MessageFormatVersionDoc;
    private final String MessageTimestampTypeDoc;
    private final String MessageTimestampDifferenceMaxMsDoc;
    private final String LeaderReplicationThrottledReplicasDoc;
    private final String FollowerReplicationThrottledReplicasDoc;
    private final LogConfig.LogConfigDef kafka$log$LogConfig$$configDef;

    static {
        new LogConfig$();
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)this.kafka$log$LogConfig$$configDef().toHtmlTable());
    }

    public String Delete() {
        return this.Delete;
    }

    public String Compact() {
        return this.Compact;
    }

    public String SegmentBytesProp() {
        return this.SegmentBytesProp;
    }

    public String SegmentMsProp() {
        return this.SegmentMsProp;
    }

    public String SegmentJitterMsProp() {
        return this.SegmentJitterMsProp;
    }

    public String SegmentIndexBytesProp() {
        return this.SegmentIndexBytesProp;
    }

    public String FlushMessagesProp() {
        return this.FlushMessagesProp;
    }

    public String FlushMsProp() {
        return this.FlushMsProp;
    }

    public String RetentionBytesProp() {
        return this.RetentionBytesProp;
    }

    public String RetentionMsProp() {
        return this.RetentionMsProp;
    }

    public String MaxMessageBytesProp() {
        return this.MaxMessageBytesProp;
    }

    public String IndexIntervalBytesProp() {
        return this.IndexIntervalBytesProp;
    }

    public String DeleteRetentionMsProp() {
        return this.DeleteRetentionMsProp;
    }

    public String MinCompactionLagMsProp() {
        return this.MinCompactionLagMsProp;
    }

    public String FileDeleteDelayMsProp() {
        return this.FileDeleteDelayMsProp;
    }

    public String MinCleanableDirtyRatioProp() {
        return this.MinCleanableDirtyRatioProp;
    }

    public String CleanupPolicyProp() {
        return this.CleanupPolicyProp;
    }

    public String UncleanLeaderElectionEnableProp() {
        return this.UncleanLeaderElectionEnableProp;
    }

    public String MinInSyncReplicasProp() {
        return this.MinInSyncReplicasProp;
    }

    public String CompressionTypeProp() {
        return this.CompressionTypeProp;
    }

    public String PreAllocateEnableProp() {
        return this.PreAllocateEnableProp;
    }

    public String MessageFormatVersionProp() {
        return this.MessageFormatVersionProp;
    }

    public String MessageTimestampTypeProp() {
        return this.MessageTimestampTypeProp;
    }

    public String MessageTimestampDifferenceMaxMsProp() {
        return this.MessageTimestampDifferenceMaxMsProp;
    }

    public String LeaderReplicationThrottledReplicasProp() {
        return this.LeaderReplicationThrottledReplicasProp;
    }

    public String FollowerReplicationThrottledReplicasProp() {
        return this.FollowerReplicationThrottledReplicasProp;
    }

    public String SegmentSizeDoc() {
        return this.SegmentSizeDoc;
    }

    public String SegmentMsDoc() {
        return this.SegmentMsDoc;
    }

    public String SegmentJitterMsDoc() {
        return this.SegmentJitterMsDoc;
    }

    public String FlushIntervalDoc() {
        return this.FlushIntervalDoc;
    }

    public String FlushMsDoc() {
        return this.FlushMsDoc;
    }

    public String RetentionSizeDoc() {
        return this.RetentionSizeDoc;
    }

    public String RetentionMsDoc() {
        return this.RetentionMsDoc;
    }

    public String MaxIndexSizeDoc() {
        return this.MaxIndexSizeDoc;
    }

    public String MaxMessageSizeDoc() {
        return this.MaxMessageSizeDoc;
    }

    public String IndexIntervalDoc() {
        return this.IndexIntervalDoc;
    }

    public String FileDeleteDelayMsDoc() {
        return this.FileDeleteDelayMsDoc;
    }

    public String DeleteRetentionMsDoc() {
        return this.DeleteRetentionMsDoc;
    }

    public String MinCompactionLagMsDoc() {
        return this.MinCompactionLagMsDoc;
    }

    public String MinCleanableRatioDoc() {
        return this.MinCleanableRatioDoc;
    }

    public String CompactDoc() {
        return this.CompactDoc;
    }

    public String UncleanLeaderElectionEnableDoc() {
        return this.UncleanLeaderElectionEnableDoc;
    }

    public String MinInSyncReplicasDoc() {
        return this.MinInSyncReplicasDoc;
    }

    public String CompressionTypeDoc() {
        return this.CompressionTypeDoc;
    }

    public String PreAllocateEnableDoc() {
        return this.PreAllocateEnableDoc;
    }

    public String MessageFormatVersionDoc() {
        return this.MessageFormatVersionDoc;
    }

    public String MessageTimestampTypeDoc() {
        return this.MessageTimestampTypeDoc;
    }

    public String MessageTimestampDifferenceMaxMsDoc() {
        return this.MessageTimestampDifferenceMaxMsDoc;
    }

    public String LeaderReplicationThrottledReplicasDoc() {
        return this.LeaderReplicationThrottledReplicasDoc;
    }

    public String FollowerReplicationThrottledReplicasDoc() {
        return this.FollowerReplicationThrottledReplicasDoc;
    }

    public LogConfig.LogConfigDef kafka$log$LogConfig$$configDef() {
        return this.kafka$log$LogConfig$$configDef;
    }

    public LogConfig apply() {
        return new LogConfig(new Properties());
    }

    public Seq<String> configNames() {
        return (Seq)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.kafka$log$LogConfig$$configDef().names()).asScala()).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Option<String> serverConfigName(String configName) {
        return this.kafka$log$LogConfig$$configDef().serverConfigName(configName);
    }

    public LogConfig fromProps(Map<?, ?> defaults, Properties overrides) {
        Properties props = new Properties();
        props.putAll(defaults);
        props.putAll((Map<?, ?>)overrides);
        return new LogConfig(props);
    }

    public void validateNames(Properties props) {
        Seq<String> names = this.configNames();
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfig$.$anonfun$validateNames$1(names, name);
            return BoxedUnit.UNIT;
        });
    }

    public void validate(Properties props) {
        this.validateNames(props);
        this.kafka$log$LogConfig$$configDef().parse(props);
    }

    public LogConfig apply(Map<?, ?> props) {
        return new LogConfig(props);
    }

    public Option<Map<?, ?>> unapply(LogConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.props());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$validateNames$1(Seq names$1, String name) {
        if (!names$1.contains((Object)name)) {
            throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown Log configuration ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
    }

    private LogConfig$() {
        MODULE$ = this;
        this.Delete = "delete";
        this.Compact = "compact";
        this.SegmentBytesProp = "segment.bytes";
        this.SegmentMsProp = "segment.ms";
        this.SegmentJitterMsProp = "segment.jitter.ms";
        this.SegmentIndexBytesProp = "segment.index.bytes";
        this.FlushMessagesProp = "flush.messages";
        this.FlushMsProp = "flush.ms";
        this.RetentionBytesProp = "retention.bytes";
        this.RetentionMsProp = "retention.ms";
        this.MaxMessageBytesProp = "max.message.bytes";
        this.IndexIntervalBytesProp = "index.interval.bytes";
        this.DeleteRetentionMsProp = "delete.retention.ms";
        this.MinCompactionLagMsProp = "min.compaction.lag.ms";
        this.FileDeleteDelayMsProp = "file.delete.delay.ms";
        this.MinCleanableDirtyRatioProp = "min.cleanable.dirty.ratio";
        this.CleanupPolicyProp = "cleanup.policy";
        this.UncleanLeaderElectionEnableProp = "unclean.leader.election.enable";
        this.MinInSyncReplicasProp = "min.insync.replicas";
        this.CompressionTypeProp = "compression.type";
        this.PreAllocateEnableProp = "preallocate";
        this.MessageFormatVersionProp = "message.format.version";
        this.MessageTimestampTypeProp = "message.timestamp.type";
        this.MessageTimestampDifferenceMaxMsProp = "message.timestamp.difference.max.ms";
        this.LeaderReplicationThrottledReplicasProp = "leader.replication.throttled.replicas";
        this.FollowerReplicationThrottledReplicasProp = "follower.replication.throttled.replicas";
        this.SegmentSizeDoc = "This configuration controls the segment file size for the log. Retention and cleaning is always done a file at a time so a larger segment size means fewer files but less granular control over retention.";
        this.SegmentMsDoc = "This configuration controls the period of time after which Kafka will force the log to roll even if the segment file isn't full to ensure that retention can delete or compact old data.";
        this.SegmentJitterMsDoc = "The maximum random jitter subtracted from the scheduled segment roll time to avoid thundering herds of segment rolling";
        this.FlushIntervalDoc = "This setting allows specifying an interval at which we will force an fsync of data written to the log. For example if this was set to 1 we would fsync after every message; if it were 5 we would fsync after every five messages. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient. This setting can be overridden on a per-topic basis (see <a href=\"#topic-config\">the per-topic configuration section</a>).";
        this.FlushMsDoc = "This setting allows specifying a time interval at which we will force an fsync of data written to the log. For example if this was set to 1000 we would fsync after 1000 ms had passed. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient.";
        this.RetentionSizeDoc = "This configuration controls the maximum size a log can grow to before we will discard old log segments to free up space if we are using the \"delete\" retention policy. By default there is no size limit only a time limit.";
        this.RetentionMsDoc = "This configuration controls the maximum time we will retain a log before we will discard old log segments to free up space if we are using the \"delete\" retention policy. This represents an SLA on how soon consumers must read their data.";
        this.MaxIndexSizeDoc = "This configuration controls the size of the index that maps offsets to file positions. We preallocate this index file and shrink it only after log rolls. You generally should not need to change this setting.";
        this.MaxMessageSizeDoc = "This is largest message size Kafka will allow to be appended. Note that if you increase this size you must also increase your consumer's fetch size so they can fetch messages this large.";
        this.IndexIntervalDoc = "This setting controls how frequently Kafka adds an index entry to it's offset index. The default setting ensures that we index a message roughly every 4096 bytes. More indexing allows reads to jump closer to the exact position in the log but makes the index larger. You probably don't need to change this.";
        this.FileDeleteDelayMsDoc = "The time to wait before deleting a file from the filesystem";
        this.DeleteRetentionMsDoc = "The amount of time to retain delete tombstone markers for <a href=\"#compaction\">log compacted</a> topics. This setting also gives a bound on the time in which a consumer must complete a read if they begin from offset 0 to ensure that they get a valid snapshot of the final stage (otherwise delete tombstones may be collected before they complete their scan).";
        this.MinCompactionLagMsDoc = "The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.";
        this.MinCleanableRatioDoc = "This configuration controls how frequently the log compactor will attempt to clean the log (assuming <a href=\"#compaction\">log compaction</a> is enabled). By default we will avoid cleaning a log where more than 50% of the log has been compacted. This ratio bounds the maximum space wasted in the log by duplicates (at 50% at most 50% of the log could be duplicates). A higher ratio will mean fewer, more efficient cleanings but will mean more wasted space in the log.";
        this.CompactDoc = "A string that is either \"delete\" or \"compact\". This string designates the retention policy to use on old log segments. The default policy (\"delete\") will discard old segments when their retention time or size limit has been reached. The \"compact\" setting will enable <a href=\"#compaction\">log compaction</a> on the topic.";
        this.UncleanLeaderElectionEnableDoc = "Indicates whether to enable replicas not in the ISR set to be elected as leader as a last resort, even though doing so may result in data loss";
        this.MinInSyncReplicasDoc = KafkaConfig$.MODULE$.MinInSyncReplicasDoc();
        this.CompressionTypeDoc = "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', lz4). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.";
        this.PreAllocateEnableDoc = "Should pre allocate file when create new segment?";
        this.MessageFormatVersionDoc = KafkaConfig$.MODULE$.LogMessageFormatVersionDoc();
        this.MessageTimestampTypeDoc = KafkaConfig$.MODULE$.LogMessageTimestampTypeDoc();
        this.MessageTimestampDifferenceMaxMsDoc = "The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message. If message.timestamp.type=CreateTime, a message will be rejected if the difference in timestamp exceeds this threshold. This configuration is ignored if message.timestamp.type=LogAppendTime.";
        this.LeaderReplicationThrottledReplicasDoc = "A list of replicas for which log replication should be throttled on the leader side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
        this.FollowerReplicationThrottledReplicasDoc = "A list of replicas for which log replication should be throttled on the follower side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
        this.kafka$log$LogConfig$$configDef = new LogConfig.LogConfigDef().define(this.SegmentBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.SegmentSize()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(Message$.MODULE$.MinMessageOverhead())), ConfigDef.Importance.MEDIUM, this.SegmentSizeDoc(), KafkaConfig$.MODULE$.LogSegmentBytesProp()).define(this.SegmentMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.SegmentMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.SegmentMsDoc(), KafkaConfig$.MODULE$.LogRollTimeMillisProp()).define(this.SegmentJitterMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.SegmentJitterMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.SegmentJitterMsDoc(), KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp()).define(this.SegmentIndexBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MaxIndexSize()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MaxIndexSizeDoc(), KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp()).define(this.FlushMessagesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FlushInterval()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FlushIntervalDoc(), KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp()).define(this.FlushMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FlushMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FlushMsDoc(), KafkaConfig$.MODULE$.LogFlushIntervalMsProp()).define(this.RetentionBytesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.RetentionSize()), ConfigDef.Importance.MEDIUM, this.RetentionSizeDoc(), KafkaConfig$.MODULE$.LogRetentionBytesProp()).define(this.RetentionMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.RetentionMs()), ConfigDef.Importance.MEDIUM, this.RetentionMsDoc(), KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()).define(this.MaxMessageBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MaxMessageSize()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MaxMessageSizeDoc(), KafkaConfig$.MODULE$.MessageMaxBytesProp()).define(this.IndexIntervalBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.IndexInterval()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.IndexIntervalDoc(), KafkaConfig$.MODULE$.LogIndexIntervalBytesProp()).define(this.DeleteRetentionMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.DeleteRetentionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.DeleteRetentionMsDoc(), KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp()).define(this.MinCompactionLagMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.MinCompactionLagMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MinCompactionLagMsDoc(), KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp()).define(this.FileDeleteDelayMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.FileDeleteDelayMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FileDeleteDelayMsDoc(), KafkaConfig$.MODULE$.LogDeleteDelayMsProp()).define(this.MinCleanableDirtyRatioProp(), ConfigDef.Type.DOUBLE, BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.MinCleanableDirtyRatio()), (ConfigDef.Validator)ConfigDef.Range.between((Number)Predef$.MODULE$.int2Integer(0), (Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MinCleanableRatioDoc(), KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp()).define(this.CleanupPolicyProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.Compact(), (ConfigDef.Validator)ConfigDef.ValidList.in((String[])new String[]{this.Compact(), this.Delete()}), ConfigDef.Importance.MEDIUM, this.CompactDoc(), KafkaConfig$.MODULE$.LogCleanupPolicyProp()).define(this.UncleanLeaderElectionEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.UncleanLeaderElectionEnable()), ConfigDef.Importance.MEDIUM, this.UncleanLeaderElectionEnableDoc(), KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()).define(this.MinInSyncReplicasProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MinInSyncReplicasDoc(), KafkaConfig$.MODULE$.MinInSyncReplicasProp()).define(this.CompressionTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.CompressionType(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])BrokerCompressionCodec$.MODULE$.brokerCompressionOptions().toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.MEDIUM, this.CompressionTypeDoc(), KafkaConfig$.MODULE$.CompressionTypeProp()).define(this.PreAllocateEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.PreAllocateEnable()), ConfigDef.Importance.MEDIUM, this.PreAllocateEnableDoc(), KafkaConfig$.MODULE$.LogPreAllocateProp()).define(this.MessageFormatVersionProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.MessageFormatVersion(), ConfigDef.Importance.MEDIUM, this.MessageFormatVersionDoc(), KafkaConfig$.MODULE$.LogMessageFormatVersionProp()).define(this.MessageTimestampTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.MessageTimestampType(), ConfigDef.Importance.MEDIUM, this.MessageTimestampTypeDoc(), KafkaConfig$.MODULE$.LogMessageTimestampTypeProp()).define(this.MessageTimestampDifferenceMaxMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong((long)Defaults$.MODULE$.MessageTimestampDifferenceMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MessageTimestampDifferenceMaxMsDoc(), KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp()).define(this.LeaderReplicationThrottledReplicasProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.LeaderReplicationThrottledReplicas(), ThrottledReplicaListValidator$.MODULE$, ConfigDef.Importance.MEDIUM, this.LeaderReplicationThrottledReplicasDoc(), this.LeaderReplicationThrottledReplicasProp()).define(this.FollowerReplicationThrottledReplicasProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.FollowerReplicationThrottledReplicas(), ThrottledReplicaListValidator$.MODULE$, ConfigDef.Importance.MEDIUM, this.FollowerReplicationThrottledReplicasDoc(), this.FollowerReplicationThrottledReplicasProp());
    }
}

