/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.common.KafkaException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.TooManyConnectionsException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\u0001\u0003\u0001\u00111!\u0001C!dG\u0016\u0004Ho\u001c:\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lCN\u0019\u0001aB\u0006\u0011\u0005!IQ\"\u0001\u0002\n\u0005)\u0011!\u0001F!cgR\u0014\u0018m\u0019;TKJ4XM\u001d+ie\u0016\fG\r\u0005\u0002\r\u001f5\tQB\u0003\u0002\u000f\t\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001\t\u000e\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0005\t%\u0001\u0011)\u0019!C\u0001)\u0005AQM\u001c3Q_&tGo\u0001\u0001\u0016\u0003U\u0001\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u000f\rdWo\u001d;fe&\u0011!d\u0006\u0002\t\u000b:$\u0007k\\5oi\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0005f]\u0012\u0004v.\u001b8uA!Aa\u0004\u0001BC\u0002\u0013\u0005q$\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011!9\u0003A!A!\u0002\u0013\u0001\u0013aD:f]\u0012\u0014UO\u001a4feNK'0\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002}\taB]3dm\n+hMZ3s'&TX\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003!\u0003=\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\u0004\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u000baJ|7-Z:t_J\u001c\bcA\u00112g%\u0011!G\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0011QJ!!\u000e\u0002\u0003\u0013A\u0013xnY3tg>\u0014\b\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002!\r|gN\\3di&|g.U;pi\u0006\u001c\bC\u0001\u0005:\u0013\tQ$A\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\")A\b\u0001C\u0001{\u00051A(\u001b8jiz\"rAP A\u0003\n\u001bE\t\u0005\u0002\t\u0001!)!c\u000fa\u0001+!)ad\u000fa\u0001A!)\u0011f\u000fa\u0001A!)Qf\u000fa\u0001A!)qf\u000fa\u0001a!)qg\u000fa\u0001q!9a\t\u0001b\u0001\n\u00139\u0015a\u00038j_N+G.Z2u_J,\u0012\u0001\u0013\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000b\u0001b\u00195b]:,Gn\u001d\u0006\u0003\u001b:\u000b1A\\5p\u0015\u0005y\u0015\u0001\u00026bm\u0006L!!\u0015&\u0003\u0011M+G.Z2u_JDaa\u0015\u0001!\u0002\u0013A\u0015\u0001\u00048j_N+G.Z2u_J\u0004\u0003bB+\u0001\u0005\u0004%\tAV\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0003]\u0003\"!\u0013-\n\u0005eS%aE*feZ,'oU8dW\u0016$8\t[1o]\u0016d\u0007BB.\u0001A\u0003%q+\u0001\btKJ4XM]\"iC:tW\r\u001c\u0011\t\u000bu\u0003A\u0011\u00010\u0002\u0007I,h\u000eF\u0001`!\t\t\u0003-\u0003\u0002bE\t!QK\\5u\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003Ay\u0007/\u001a8TKJ4XM]*pG.,G\u000fF\u0002XKJDQA\u001a2A\u0002\u001d\fA\u0001[8tiB\u0011\u0001n\u001c\b\u0003S6\u0004\"A\u001b\u0012\u000e\u0003-T!\u0001\\\n\u0002\rq\u0012xn\u001c;?\u0013\tq'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018#\u0011\u0015\u0019(\r1\u0001!\u0003\u0011\u0001xN\u001d;\t\u000bU\u0004A\u0011\u0001<\u0002\r\u0005\u001c7-\u001a9u)\ryv\u000f \u0005\u0006qR\u0004\r!_\u0001\u0004W\u0016L\bCA%{\u0013\tY(J\u0001\u0007TK2,7\r^5p].+\u0017\u0010C\u0003~i\u0002\u00071'A\u0005qe>\u001cWm]:pe\")q\u0010\u0001C\u0001=\u00061q/Y6fkBD3A`A\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\u001d\u0006!A.\u00198h\u0013\u0011\ti!a\u0002\u0003\u0011=3XM\u001d:jI\u0016\u0004")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int brokerId;
    private final Processor[] processors;
    private final ConnectionQuotas connectionQuotas;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            int currentProcessor = 0;
            while (this.isRunning()) {
                try {
                    int ready = this.nioSelector().select(500L);
                    if (ready <= 0) continue;
                    Set<SelectionKey> keys = this.nioSelector().selectedKeys();
                    Iterator<SelectionKey> iter = keys.iterator();
                    while (iter.hasNext() && this.isRunning()) {
                        try {
                            SelectionKey key = iter.next();
                            iter.remove();
                            if (!key.isAcceptable()) {
                                throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                            }
                            this.accept(key, this.processors[currentProcessor]);
                            currentProcessor = (currentProcessor + 1) % this.processors.length;
                        }
                        catch (Throwable e) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof ControlThrowable) {
                        ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                        throw (Throwable)controlThrowable;
                    }
                    if (throwable2 == null) throw throwable;
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket and selector.");
            this.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close());
            this.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close());
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Awaiting socket connections on %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress.getHostString(), BoxesRunTime.boxToInteger((int)serverChannel.socket().getLocalPort())})));
        }
        catch (SocketException e) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Socket server failed to bind to %s:%d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress.getHostString(), BoxesRunTime.boxToInteger((int)port), e.getMessage()})), e);
        }
        return serverChannel;
    }

    public void accept(SelectionKey key, Processor processor) {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverSocketChannel.accept();
        try {
            this.connectionQuotas.inc(socketChannel.socket().getInetAddress());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Accepted connection from %s on %s and assigned it to processor %d, sendBufferSize [actual|requested]: [%d|%d] recvBufferSize [actual|requested]: [%d|%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketChannel.socket().getRemoteSocketAddress(), socketChannel.socket().getLocalSocketAddress(), BoxesRunTime.boxToInteger((int)processor.id()), BoxesRunTime.boxToInteger((int)socketChannel.socket().getSendBufferSize()), BoxesRunTime.boxToInteger((int)this.sendBufferSize()), BoxesRunTime.boxToInteger((int)socketChannel.socket().getReceiveBufferSize()), BoxesRunTime.boxToInteger((int)this.recvBufferSize())})));
            processor.accept(socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Rejected connection from %s, address already has the configured maximum of %d connections.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.ip(), BoxesRunTime.boxToInteger((int)e.count())})));
            this.close(socketChannel);
        }
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public static final /* synthetic */ void $anonfun$new$2(Acceptor $this, Processor processor) {
        Utils.newThread((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-network-thread-", "-", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), $this.endPoint().listenerName(), $this.endPoint().securityProtocol(), BoxesRunTime.boxToInteger((int)processor.id())})), (Runnable)processor, (boolean)false).start();
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int brokerId, Processor[] processors, ConnectionQuotas connectionQuotas) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.brokerId = brokerId;
        this.processors = processors;
        this.connectionQuotas = connectionQuotas;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        Acceptor acceptor = this;
        synchronized (acceptor) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])processors)).foreach((Function1 & Serializable & scala.Serializable)processor -> {
                Acceptor.$anonfun$new$2(this, processor);
                return BoxedUnit.UNIT;
            });
        }
    }
}

