/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConfigCommand$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.server.QuotaId$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rEs!B\u0001\u0003\u0011\u00039\u0011!D\"p]\u001aLwmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001b\r{gNZ5h\u0007>lW.\u00198e'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011AB2p[6|g.\u0003\u0002\u0018)\t11i\u001c8gS\u001eDQ!G\u0005\u0005\u0002i\ta\u0001P5oSRtD#A\u0004\t\u000fqI!\u0019!C\u0001;\u00051B)\u001a4bk2$8k\u0019:b[&#XM]1uS>t7/F\u0001\u001f!\tiq$\u0003\u0002!\u001d\t\u0019\u0011J\u001c;\t\r\tJ\u0001\u0015!\u0003\u001f\u0003]!UMZ1vYR\u001c6M]1n\u0013R,'/\u0019;j_:\u001c\b\u0005C\u0003%\u0013\u0011\u0005Q%\u0001\u0003nC&tGC\u0001\u0014*!\tiq%\u0003\u0002)\u001d\t!QK\\5u\u0011\u0015Q3\u00051\u0001,\u0003\u0011\t'oZ:\u0011\u00075ac&\u0003\u0002.\u001d\t)\u0011I\u001d:bsB\u0011qF\u000e\b\u0003aQ\u0002\"!\r\b\u000e\u0003IR!a\r\u0004\u0002\rq\u0012xn\u001c;?\u0013\t)d\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u000f\u0011\u0019Q\u0014\u0002\"\u0001\u0003w\u0005Y\u0011\r\u001c;fe\u000e{gNZ5h)\u00151C\bRA<\u0011\u0015i\u0014\b1\u0001?\u0003\u001dQ8.\u0016;jYN\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005\r\u0003%a\u0002.l+RLGn\u001d\u0005\u0006\u000bf\u0002\rAR\u0001\u0005_B$8\u000f\u0005\u0002H\u00116\t\u0011B\u0002\u0003J\u0013\u0001Q%\u0001F\"p]\u001aLwmQ8n[\u0006tGm\u00149uS>t7o\u0005\u0002I\u0019!A!\u0006\u0013B\u0001B\u0003%1\u0006C\u0003\u001a\u0011\u0012\u0005Q\n\u0006\u0002G\u001d\")!\u0006\u0014a\u0001W!9\u0001\u000b\u0013b\u0001\n\u0003\t\u0016A\u00029beN,'/F\u0001S!\t\u0019f+D\u0001U\u0015\u0005)\u0016A\u00036paR\u001c\u0018.\u001c9mK&\u0011q\u000b\u0016\u0002\r\u001fB$\u0018n\u001c8QCJ\u001cXM\u001d\u0005\u00073\"\u0003\u000b\u0011\u0002*\u0002\u000fA\f'o]3sA!91\f\u0013b\u0001\n\u0003a\u0016\u0001\u0004>l\u0007>tg.Z2u\u001fB$X#A/\u0011\u0007Msf&\u0003\u0002`)\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDa!\u0019%!\u0002\u0013i\u0016!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005C\u0004d\u0011\n\u0007I\u0011\u00013\u0002\u0011\u0005dG/\u001a:PaR,\u0012!\u001a\t\u0003'\u001aL!a\u001a+\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000f\u0003\u0004j\u0011\u0002\u0006I!Z\u0001\nC2$XM](qi\u0002Bqa\u001b%C\u0002\u0013\u0005A-A\u0006eKN\u001c'/\u001b2f\u001fB$\bBB7IA\u0003%Q-\u0001\u0007eKN\u001c'/\u001b2f\u001fB$\b\u0005C\u0004p\u0011\n\u0007I\u0011\u0001/\u0002\u0015\u0015tG/\u001b;z)f\u0004X\r\u0003\u0004r\u0011\u0002\u0006I!X\u0001\fK:$\u0018\u000e^=UsB,\u0007\u0005C\u0004t\u0011\n\u0007I\u0011\u0001/\u0002\u0015\u0015tG/\u001b;z\u001d\u0006lW\r\u0003\u0004v\u0011\u0002\u0006I!X\u0001\fK:$\u0018\u000e^=OC6,\u0007\u0005C\u0004x\u0011\n\u0007I\u0011\u00013\u0002\u001b\u0015tG/\u001b;z\t\u00164\u0017-\u001e7u\u0011\u0019I\b\n)A\u0005K\u0006qQM\u001c;jif$UMZ1vYR\u0004\u0003bB>I\u0005\u0004%\t\u0001`\u0001\u0003]2,\u0012! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\t9t\u0010C\u0004\u0002\f!\u0003\u000b\u0011B?\u0002\u00079d\u0007\u0005\u0003\u0005\u0002\u0010!\u0013\r\u0011\"\u0001]\u0003%\tG\rZ\"p]\u001aLw\rC\u0004\u0002\u0014!\u0003\u000b\u0011B/\u0002\u0015\u0005$GmQ8oM&<\u0007\u0005\u0003\u0005\u0002\u0018!\u0013\r\u0011\"\u0001]\u00031!W\r\\3uK\u000e{gNZ5h\u0011\u001d\tY\u0002\u0013Q\u0001\nu\u000bQ\u0002Z3mKR,7i\u001c8gS\u001e\u0004\u0003\u0002CA\u0010\u0011\n\u0007I\u0011\u00013\u0002\u000f!,G\u000e](qi\"9\u00111\u0005%!\u0002\u0013)\u0017\u0001\u00035fYB|\u0005\u000f\u001e\u0011\t\u0011\u0005\u001d\u0002J1A\u0005\u0002\u0011\f\u0001BZ8sG\u0016|\u0005\u000f\u001e\u0005\b\u0003WA\u0005\u0015!\u0003f\u0003%1wN]2f\u001fB$\b\u0005C\u0005\u00020!\u0013\r\u0011\"\u0001\u00022\u00059q\u000e\u001d;j_:\u001cXCAA\u001a!\r\u0019\u0016QG\u0005\u0004\u0003o!&!C(qi&|gnU3u\u0011!\tY\u0004\u0013Q\u0001\n\u0005M\u0012\u0001C8qi&|gn\u001d\u0011\t\u0013\u0005}\u0002J1A\u0005\u0002\u0005\u0005\u0013aB1mY>\u0003Ho]\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002L\u0005=SBAA$\u0015\r\tIED\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u00121aU3ua\u0011\t\t&a\u0017\u0011\u000bM\u000b\u0019&a\u0016\n\u0007\u0005UCK\u0001\u0006PaRLwN\\*qK\u000e\u0004B!!\u0017\u0002\\1\u0001A\u0001DA/\u0003?\n\t\u0011!A\u0003\u0002\u0005\r$aA0%c!A\u0011\u0011\r%!\u0002\u0013\t\u0019%\u0001\u0005bY2|\u0005\u000f^:!#\u0011\t)'a\u001b\u0011\u00075\t9'C\u0002\u0002j9\u0011qAT8uQ&tw\rE\u0002\u000e\u0003[J1!a\u001c\u000f\u0005\r\te.\u001f\u0005\b\u0003gBE\u0011AA;\u0003%\u0019\u0007.Z2l\u0003J<7\u000fF\u0001'\u0011!\t\u0015\b%AA\u0002\u0005e\u0004c\u0001\u0005\u0002|%\u0019\u0011Q\u0010\u0002\u0003\u001d\u0005#W.\u001b8Vi&d\u0017\u000e^5fg\"9\u0011\u0011Q\u0005\u0005\n\u0005\r\u0015A\u00079sKB\u0013xnY3tgN\u001b'/Y7De\u0016$WM\u001c;jC2\u001cHc\u0001\u0014\u0002\u0006\"A\u0011qQA@\u0001\u0004\tI)\u0001\td_:4\u0017nZ:U_\n+\u0017\t\u001a3fIB!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006\r\u0011\u0001B;uS2LA!a%\u0002\u000e\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005]\u0015\u0002\"\u0003\u0002\u001a\u0006Y\u0001/\u0019:tK\n\u0013xn[3s)\rq\u00121\u0014\u0005\b\u0003;\u000b)\n1\u0001/\u0003\u0019\u0011'o\\6fe\"9\u0011\u0011U\u0005\u0005\n\u0005\r\u0016A\u00043fg\u000e\u0014\u0018NY3D_:4\u0017n\u001a\u000b\u0006M\u0005\u0015\u0016q\u0015\u0005\u0007{\u0005}\u0005\u0019\u0001 \t\r\u0015\u000by\n1\u0001G\u0011!\tY+\u0003C\u0001\u0005\u00055\u0016!\u00069beN,7i\u001c8gS\u001e\u001cHk\u001c\"f\u0003\u0012$W\r\u001a\u000b\u0005\u0003\u0013\u000by\u000b\u0003\u0004F\u0003S\u0003\rA\u0012\u0005\t\u0003gKA\u0011\u0001\u0002\u00026\u00069\u0002/\u0019:tK\u000e{gNZ5hgR{')\u001a#fY\u0016$X\r\u001a\u000b\u0005\u0003o\u000bi\fE\u0003\u0002F\u0005ef&\u0003\u0003\u0002<\u0006\u001d#aA*fc\"1Q)!-A\u0002\u00193a!!1\n\u0001\u0006\r'AB#oi&$\u0018pE\u0004\u0002@2\t)-a3\u0011\u00075\t9-C\u0002\u0002J:\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002\u000e\u0003\u001bL1!a4\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011)y\u0017q\u0018BK\u0002\u0013\u0005\u00111[\u000b\u0002]!I\u0011/a0\u0003\u0012\u0003\u0006IA\f\u0005\f\u00033\fyL!f\u0001\n\u0003\tY.A\u0007tC:LG/\u001b>fI:\u000bW.Z\u000b\u0003\u0003;\u0004B!DAp]%\u0019\u0011\u0011\u001d\b\u0003\r=\u0003H/[8o\u0011-\t)/a0\u0003\u0012\u0003\u0006I!!8\u0002\u001dM\fg.\u001b;ju\u0016$g*Y7fA!9\u0011$a0\u0005\u0002\u0005%HCBAv\u0003[\fy\u000fE\u0002H\u0003\u007fCaa\\At\u0001\u0004q\u0003\u0002CAm\u0003O\u0004\r!!8\t\u0013\u0005M\u0018q\u0018b\u0001\n\u0003a\u0018AC3oi&$\u0018\u0010U1uQ\"A\u0011q_A`A\u0003%Q0A\u0006f]RLG/\u001f)bi\"\u0004\u0003\u0002CA~\u0003\u007f#\t%!@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\f\u0005\u000b\u0005\u0003\ty,!A\u0005\u0002\t\r\u0011\u0001B2paf$b!a;\u0003\u0006\t\u001d\u0001\u0002C8\u0002\u0000B\u0005\t\u0019\u0001\u0018\t\u0015\u0005e\u0017q I\u0001\u0002\u0004\ti\u000e\u0003\u0006\u0003\f\u0005}\u0016\u0013!C\u0001\u0005\u001b\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0010)\u001aaF!\u0005,\u0005\tM\u0001\u0003\u0002B\u000b\u0005?i!Aa\u0006\u000b\t\te!1D\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\b\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005C\u00119BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!B!\n\u0002@F\u0005I\u0011\u0001B\u0014\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u000b+\t\u0005u'\u0011\u0003\u0005\n\u0005[\ty,!A\u0005Bq\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\"\u0003B\u0019\u0003\u007f\u000b\t\u0011\"\u0001\u001e\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\u0011)$a0\u0002\u0002\u0013\u0005!qG\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tYG!\u000f\t\u0013\tm\"1GA\u0001\u0002\u0004q\u0012a\u0001=%c!Q!qHA`\u0003\u0003%\tE!\u0011\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0011\u0011\r\u0005\u0015#QIA6\u0013\u0011\u00119%a\u0012\u0003\u0011%#XM]1u_JD!Ba\u0013\u0002@\u0006\u0005I\u0011\u0001B'\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B(\u0005+\u00022!\u0004B)\u0013\r\u0011\u0019F\u0004\u0002\b\u0005>|G.Z1o\u0011)\u0011YD!\u0013\u0002\u0002\u0003\u0007\u00111\u000e\u0005\u000b\u00053\ny,!A\u0005B\tm\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003yA!Ba\u0018\u0002@\u0006\u0005I\u0011\tB1\u0003\u0019)\u0017/^1mgR!!q\nB2\u0011)\u0011YD!\u0018\u0002\u0002\u0003\u0007\u00111N\u0004\n\u0005OJ\u0011\u0011!E\u0001\u0005S\na!\u00128uSRL\bcA$\u0003l\u0019I\u0011\u0011Y\u0005\u0002\u0002#\u0005!QN\n\u0007\u0005W\u0012y'a3\u0011\u0013\tE$q\u000f\u0018\u0002^\u0006-XB\u0001B:\u0015\r\u0011)HD\u0001\beVtG/[7f\u0013\u0011\u0011IHa\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\u001a\u0005W\"\tA! \u0015\u0005\t%\u0004BCA~\u0005W\n\t\u0011\"\u0012\u0003\u0002R\tQ\u0010\u0003\u0006\u0003\u0006\n-\u0014\u0011!CA\u0005\u000f\u000bQ!\u00199qYf$b!a;\u0003\n\n-\u0005BB8\u0003\u0004\u0002\u0007a\u0006\u0003\u0005\u0002Z\n\r\u0005\u0019AAo\u0011)\u0011yIa\u001b\u0002\u0002\u0013\u0005%\u0011S\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ja'\u0011\u000b5\tyN!&\u0011\r5\u00119JLAo\u0013\r\u0011IJ\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\tu%QRA\u0001\u0002\u0004\tY/A\u0002yIAB!B!)\u0003l\u0005\u0005I\u0011\u0002BR\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0006c\u0001@\u0003(&\u0019!\u0011V@\u0003\r=\u0013'.Z2u\r\u0019\u0011i+\u0003!\u00030\na1i\u001c8gS\u001e,e\u000e^5usN9!1\u0016\u0007\u0002F\u0006-\u0007b\u0003BZ\u0005W\u0013)\u001a!C\u0001\u0005k\u000bAA]8piV\u0011\u00111\u001e\u0005\f\u0005s\u0013YK!E!\u0002\u0013\tY/A\u0003s_>$\b\u0005C\u0006\u0003>\n-&Q3A\u0005\u0002\t}\u0016!B2iS2$WC\u0001Ba!\u0015i\u0011q\\Av\u0011-\u0011)Ma+\u0003\u0012\u0003\u0006IA!1\u0002\r\rD\u0017\u000e\u001c3!\u0011\u001dI\"1\u0016C\u0001\u0005\u0013$bAa3\u0003N\n=\u0007cA$\u0003,\"A!1\u0017Bd\u0001\u0004\tY\u000f\u0003\u0005\u0003>\n\u001d\u0007\u0019\u0001Ba\u0011%\u0011\u0019Na+C\u0002\u0013\u0005A0A\tgk2d7+\u00198ji&TX\r\u001a(b[\u0016D\u0001Ba6\u0003,\u0002\u0006I!`\u0001\u0013MVdGnU1oSRL'0\u001a3OC6,\u0007\u0005\u0003\u0005\u0003\\\n-F\u0011\u0001Bo\u000399W\r^!mY\u0016sG/\u001b;jKN$BAa8\u0003bB1\u0011QIA]\u0005\u0017Da!\u0010Bm\u0001\u0004q\u0004\u0002CA~\u0005W#\t%!@\t\u0015\t\u0005!1VA\u0001\n\u0003\u00119\u000f\u0006\u0004\u0003L\n%(1\u001e\u0005\u000b\u0005g\u0013)\u000f%AA\u0002\u0005-\bB\u0003B_\u0005K\u0004\n\u00111\u0001\u0003B\"Q!1\u0002BV#\u0003%\tAa<\u0016\u0005\tE(\u0006BAv\u0005#A!B!\n\u0003,F\u0005I\u0011\u0001B{+\t\u00119P\u000b\u0003\u0003B\nE\u0001\"\u0003B\u0017\u0005W\u000b\t\u0011\"\u0011}\u0011%\u0011\tDa+\u0002\u0002\u0013\u0005Q\u0004\u0003\u0006\u00036\t-\u0016\u0011!C\u0001\u0005\u007f$B!a\u001b\u0004\u0002!I!1\bB\u007f\u0003\u0003\u0005\rA\b\u0005\u000b\u0005\u007f\u0011Y+!A\u0005B\t\u0005\u0003B\u0003B&\u0005W\u000b\t\u0011\"\u0001\u0004\bQ!!qJB\u0005\u0011)\u0011Yd!\u0002\u0002\u0002\u0003\u0007\u00111\u000e\u0005\u000b\u00053\u0012Y+!A\u0005B\tm\u0003B\u0003B0\u0005W\u000b\t\u0011\"\u0011\u0004\u0010Q!!qJB\t\u0011)\u0011Yd!\u0004\u0002\u0002\u0003\u0007\u00111N\u0004\n\u0007+I\u0011\u0011!E\u0001\u0007/\tAbQ8oM&<WI\u001c;jif\u00042aRB\r\r%\u0011i+CA\u0001\u0012\u0003\u0019Yb\u0005\u0004\u0004\u001a\ru\u00111\u001a\t\u000b\u0005c\u00129(a;\u0003B\n-\u0007bB\r\u0004\u001a\u0011\u00051\u0011\u0005\u000b\u0003\u0007/A!\"a?\u0004\u001a\u0005\u0005IQ\tBA\u0011)\u0011)i!\u0007\u0002\u0002\u0013\u00055q\u0005\u000b\u0007\u0005\u0017\u001cIca\u000b\t\u0011\tM6Q\u0005a\u0001\u0003WD\u0001B!0\u0004&\u0001\u0007!\u0011\u0019\u0005\u000b\u0005\u001f\u001bI\"!A\u0005\u0002\u000e=B\u0003BB\u0019\u0007k\u0001R!DAp\u0007g\u0001r!\u0004BL\u0003W\u0014\t\r\u0003\u0006\u0003\u001e\u000e5\u0012\u0011!a\u0001\u0005\u0017D!B!)\u0004\u001a\u0005\u0005I\u0011\u0002BR\u0011!\u0019Y$\u0003C\u0001\u0005\ru\u0012a\u00039beN,WI\u001c;jif$BAa3\u0004@!1Qi!\u000fA\u0002\u0019Cqaa\u0011\n\t\u0013\u0019)%\u0001\tqCJ\u001cX-U;pi\u0006,e\u000e^5usR!!1ZB$\u0011\u0019)5\u0011\ta\u0001\r\"Q11J\u0005\u0012\u0002\u0013\u0005!a!\u0014\u0002+\u0005dG/\u001a:D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\n\u0016\u0005\u0003s\u0012\t\u0002")
public final class ConfigCommand {
    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.fatal(function0, function02);
    }

    public static Object fatal(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.fatal(function0);
    }

    public static void fatal(Function0<String> function0) {
        ConfigCommand$.MODULE$.fatal(function0);
    }

    public static void swallowError(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowError(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.error(function0, function02);
    }

    public static Object error(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.error(function0);
    }

    public static void error(Function0<String> function0) {
        ConfigCommand$.MODULE$.error(function0);
    }

    public static void swallow(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallow(function0);
    }

    public static void swallowWarn(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowWarn(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.warn(function0, function02);
    }

    public static Object warn(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.warn(function0);
    }

    public static void warn(Function0<String> function0) {
        ConfigCommand$.MODULE$.warn(function0);
    }

    public static void swallowInfo(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowInfo(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.info(function0, function02);
    }

    public static Object info(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.info(function0);
    }

    public static void info(Function0<String> function0) {
        ConfigCommand$.MODULE$.info(function0);
    }

    public static void swallowDebug(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowDebug(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.debug(function0, function02);
    }

    public static Object debug(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.debug(function0);
    }

    public static void debug(Function0<String> function0) {
        ConfigCommand$.MODULE$.debug(function0);
    }

    public static boolean isDebugEnabled() {
        return ConfigCommand$.MODULE$.isDebugEnabled();
    }

    public static void swallowTrace(Function0<BoxedUnit> function0) {
        ConfigCommand$.MODULE$.swallowTrace(function0);
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.trace(function0, function02);
    }

    public static Object trace(Function0<Throwable> function0) {
        return ConfigCommand$.MODULE$.trace(function0);
    }

    public static void trace(Function0<String> function0) {
        ConfigCommand$.MODULE$.trace(function0);
    }

    public static void validateChars(String string, String string2) {
        ConfigCommand$.MODULE$.validateChars(string, string2);
    }

    public static Logger logger() {
        return ConfigCommand$.MODULE$.logger();
    }

    public static String loggerName() {
        return ConfigCommand$.MODULE$.loggerName();
    }

    public static void main(String[] stringArray) {
        ConfigCommand$.MODULE$.main(stringArray);
    }

    public static int DefaultScramIterations() {
        return ConfigCommand$.MODULE$.DefaultScramIterations();
    }

    public static void logIdent_$eq(String string) {
        ConfigCommand$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return ConfigCommand$.MODULE$.logIdent();
    }

    public static class ConfigCommandOptions {
        private final OptionParser parser = new OptionParser();
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final OptionSpecBuilder alterOpt = this.parser().accepts("alter", "Alter the configuration for the entity.");
        private final OptionSpecBuilder describeOpt = this.parser().accepts("describe", "List configs for the given entity.");
        private final ArgumentAcceptingOptionSpec<String> entityType = this.parser().accepts("entity-type", "Type of entity (topics/clients/users/brokers)").withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> entityName = this.parser().accepts("entity-name", "Name of entity (topic name/client id/user principal name/broker id)").withRequiredArg().ofType(String.class);
        private final OptionSpecBuilder entityDefault = this.parser().accepts("entity-default", "Default entity name for clients/users (applies to corresponding entity type in command line)");
        private final String nl = System.getProperty("line.separator");
        private final ArgumentAcceptingOptionSpec<String> addConfig = this.parser().accepts("add-config", "Key Value pairs of configs to add. Square brackets can be used to group values which contain commas: 'k1=v1,k2=[v1,v2,v2],k3=v3'. The following is a list of valid configurations: For entity_type '" + ConfigType$.MODULE$.Topic() + "': " + ((TraversableOnce)LogConfig$.MODULE$.configNames().map((Function1 & Serializable & scala.Serializable)x$7 -> "\t" + x$7, Seq$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.Broker() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Broker$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> "\t" + x$8, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.User() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$User$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> "\t" + x$9, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.Client() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Client$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> "\t" + x$10, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Entity types '", "' and '", "' may be specified together to update config for clients of a specific user."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()}))).withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> deleteConfig = this.parser().accepts("delete-config", "config keys to remove 'k1,k2'").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        private final OptionSpecBuilder helpOpt = this.parser().accepts("help", "Print usage information.");
        private final OptionSpecBuilder forceOpt = this.parser().accepts("force", "Suppress console prompts");
        private final OptionSet options;
        private final Set<OptionSpec<?>> allOpts;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public OptionSpecBuilder alterOpt() {
            return this.alterOpt;
        }

        public OptionSpecBuilder describeOpt() {
            return this.describeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> entityType() {
            return this.entityType;
        }

        public ArgumentAcceptingOptionSpec<String> entityName() {
            return this.entityName;
        }

        public OptionSpecBuilder entityDefault() {
            return this.entityDefault;
        }

        public String nl() {
            return this.nl;
        }

        public ArgumentAcceptingOptionSpec<String> addConfig() {
            return this.addConfig;
        }

        public ArgumentAcceptingOptionSpec<String> deleteConfig() {
            return this.deleteConfig;
        }

        public OptionSpecBuilder helpOpt() {
            return this.helpOpt;
        }

        public OptionSpecBuilder forceOpt() {
            return this.forceOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Set<OptionSpec<?>> allOpts() {
            return this.allOpts;
        }

        public void checkArgs() {
            int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{this.alterOpt(), this.describeOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommandOptions.$anonfun$checkArgs$1(this, x$1)));
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Command must include exactly one action: --describe, --alter");
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.entityType()}));
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.alterOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.describeOpt()}))));
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.describeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.addConfig(), this.deleteConfig()}))));
            Buffer entityTypeVals = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.entityType())).asScala();
            if (this.options().has((OptionSpec)this.alterOpt())) {
                if (entityTypeVals.contains((Object)ConfigType$.MODULE$.User()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Client())) {
                    if (!this.options().has(this.entityName()) && !this.options().has((OptionSpec)this.entityDefault())) {
                        throw new IllegalArgumentException("--entity-name or --entity-default must be specified with --alter of users/clients");
                    }
                } else if (!this.options().has(this.entityName())) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name must be specified with --alter of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypeVals})));
                }
                boolean isAddConfigPresent = this.options().has(this.addConfig());
                boolean isDeleteConfigPresent = this.options().has(this.deleteConfig());
                if (!isAddConfigPresent && !isDeleteConfigPresent) {
                    throw new IllegalArgumentException("At least one of --add-config or --delete-config must be specified with --alter");
                }
            }
            entityTypeVals.foreach((Function1 & Serializable & scala.Serializable)entityTypeVal -> {
                ConfigCommandOptions.$anonfun$checkArgs$2(entityTypeVal);
                return BoxedUnit.UNIT;
            });
            if (entityTypeVals.isEmpty()) {
                throw new IllegalArgumentException("At least one --entity-type must be specified");
            }
            if (entityTypeVals.size() > 1 && !entityTypeVals.toSet().equals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})))) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only '", "' and '", "' entity types may be specified together"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})));
            }
        }

        public static final /* synthetic */ boolean $anonfun$checkArgs$1(ConfigCommandOptions $this, OptionSpec x$1) {
            return $this.options().has(x$1);
        }

        public static final /* synthetic */ void $anonfun$checkArgs$2(String entityTypeVal) {
            if (!ConfigType$.MODULE$.all().contains((Object)entityTypeVal)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity-type ", ", --entity-type must be one of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypeVal, ConfigType$.MODULE$.all()})));
            }
        }

        public ConfigCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
            this.allOpts = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.describeOpt(), this.entityType(), this.entityName(), this.addConfig(), this.deleteConfig(), this.helpOpt()}));
        }
    }

    public static class ConfigEntity
    implements Product,
    scala.Serializable {
        private final Entity root;
        private final Option<Entity> child;
        private final String fullSanitizedName;

        public Entity root() {
            return this.root;
        }

        public Option<Entity> child() {
            return this.child;
        }

        public String fullSanitizedName() {
            return this.fullSanitizedName;
        }

        public Seq<ConfigEntity> getAllEntities(ZkUtils zkUtils) {
            Option option;
            Option option2;
            Seq seq;
            Option option3;
            Tuple2 tuple2 = new Tuple2(this.root().sanitizedName(), this.child());
            if (tuple2 != null && None$.MODULE$.equals(option3 = (Option)tuple2._1())) {
                Seq seq2;
                Seq rootEntities = (Seq)zkUtils.getAllEntitiesWithConfig(this.root().entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(new Entity(this.root().entityType(), (Option<String>)new Some(name)), this.child()), Seq$.MODULE$.canBuildFrom());
                Option<Entity> option4 = this.child();
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    Entity s = (Entity)some.value();
                    seq2 = (Seq)rootEntities.flatMap((Function1 & Serializable & scala.Serializable)rootEntity -> new ConfigEntity(rootEntity.root(), (Option<Entity>)new Some((Object)new Entity(s.entityType(), (Option<String>)None$.MODULE$))).getAllEntities(zkUtils), Seq$.MODULE$.canBuildFrom());
                } else if (None$.MODULE$.equals(option4)) {
                    seq2 = rootEntities;
                } else {
                    throw new MatchError(option4);
                }
                seq = seq2;
            } else if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some) {
                Seq seq3;
                Some some = (Some)option2;
                Entity childEntity = (Entity)some.value();
                Option<String> option5 = childEntity.sanitizedName();
                if (option5 instanceof Some) {
                    seq3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
                } else if (None$.MODULE$.equals(option5)) {
                    seq3 = (Seq)zkUtils.getAllEntitiesWithConfig(this.root().entityPath() + "/" + childEntity.entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(this.root(), (Option<Entity>)new Some((Object)new Entity(childEntity.entityType(), (Option<String>)new Some(name)))), Seq$.MODULE$.canBuildFrom());
                } else {
                    throw new MatchError(option5);
                }
                seq = seq3;
            } else if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._2())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
            } else {
                throw new MatchError((Object)tuple2);
            }
            return seq;
        }

        public String toString() {
            return this.root().toString() + this.child().map((Function1 & Serializable & scala.Serializable)s -> ", " + s.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        }

        public ConfigEntity copy(Entity root, Option<Entity> child) {
            return new ConfigEntity(root, child);
        }

        public Entity copy$default$1() {
            return this.root();
        }

        public Option<Entity> copy$default$2() {
            return this.child();
        }

        public String productPrefix() {
            return "ConfigEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Entity> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.root();
                    break;
                }
                case 1: {
                    option = this.child();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConfigEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConfigEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConfigEntity configEntity = (ConfigEntity)x$1;
            Entity entity = this.root();
            Entity entity2 = configEntity.root();
            if (entity == null) {
                if (entity2 != null) {
                    return false;
                }
            } else if (!((Object)entity).equals(entity2)) return false;
            Option<Entity> option = this.child();
            Option<Entity> option2 = configEntity.child();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!configEntity.canEqual(this)) return false;
            return true;
        }

        public ConfigEntity(Entity root, Option<Entity> child) {
            this.root = root;
            this.child = child;
            Product.$init$((Product)this);
            this.fullSanitizedName = (String)root.sanitizedName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + child.map((Function1 & Serializable & scala.Serializable)s -> "/" + s.entityPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        }
    }

    public static class Entity
    implements Product,
    scala.Serializable {
        private final String entityType;
        private final Option<String> sanitizedName;
        private final String entityPath;

        public String entityType() {
            return this.entityType;
        }

        public Option<String> sanitizedName() {
            return this.sanitizedName;
        }

        public String entityPath() {
            return this.entityPath;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            String string;
            String string2 = this.entityType();
            String string3 = ConfigType$.MODULE$.User();
            String string4 = string2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                string = "user-principal";
            } else {
                String string5 = ConfigType$.MODULE$.Client();
                String string6 = string2;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    string = "client-id";
                } else {
                    String string7 = ConfigType$.MODULE$.Topic();
                    String string8 = string2;
                    string = !(string7 != null ? !string7.equals(string8) : string8 != null) ? "topic" : string2;
                }
            }
            String typeName = string;
            boolean bl = false;
            Some some = null;
            Option<String> option = this.sanitizedName();
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                String string9 = (String)some.value();
                String string10 = ConfigEntityName$.MODULE$.Default();
                String string11 = string9;
                if (string10 == null) {
                    if (string11 == null) return "default " + typeName;
                } else if (string10.equals(string11)) {
                    return "default " + typeName;
                }
            }
            if (bl) {
                String n = (String)some.value();
                String string12 = this.entityType();
                String string13 = ConfigType$.MODULE$.User();
                String desanitized = !(string12 != null ? !string12.equals(string13) : string13 != null) ? QuotaId$.MODULE$.desanitize(n) : n;
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, desanitized}));
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            return this.entityType();
        }

        public Entity copy(String entityType, Option<String> sanitizedName) {
            return new Entity(entityType, sanitizedName);
        }

        public String copy$default$1() {
            return this.entityType();
        }

        public Option<String> copy$default$2() {
            return this.sanitizedName();
        }

        public String productPrefix() {
            return "Entity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.entityType();
                    break;
                }
                case 1: {
                    option = this.sanitizedName();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Entity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Entity)) return false;
            boolean bl = true;
            if (!bl) return false;
            Entity entity = (Entity)x$1;
            String string = this.entityType();
            String string2 = entity.entityType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.sanitizedName();
            Option<String> option2 = entity.sanitizedName();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!entity.canEqual(this)) return false;
            return true;
        }

        public Entity(String entityType, Option<String> sanitizedName) {
            String string;
            this.entityType = entityType;
            this.sanitizedName = sanitizedName;
            Product.$init$((Product)this);
            Option<String> option = sanitizedName;
            if (option instanceof Some) {
                Some some = (Some)option;
                String n = (String)some.value();
                string = entityType + "/" + n;
            } else if (None$.MODULE$.equals(option)) {
                string = entityType;
            } else {
                throw new MatchError(option);
            }
            this.entityPath = string;
        }
    }
}

