/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.OffsetCheckpoint;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5c!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]AZ\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005EJT\"\u0001\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ$G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005qjT\"\u0001\u0002\n\u0005y\u0012!a\u0001'pO\"A\u0001\t\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005C\u0001\u001f\u0001\u0011\u0015Q\u0012\t1\u0001\u001e\u0011\u0015Y\u0013\t1\u0001.\u0011\u001dA\u0005A1A\u0005B%\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005Q\u0005CA&O\u001b\u0005a%BA'%\u0003\u0011a\u0017M\\4\n\u0005=c%AB*ue&tw\r\u0003\u0004R\u0001\u0001\u0006IAS\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005T\u0001\t\u0007I\u0011\u0001\u0002J\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1Q\u000b\u0001Q\u0001\n)\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004X\u0001\t\u0007I\u0011\u0002-\u0002\u0017\rDWmY6q_&tGo]\u000b\u00023B!!l\u0018\u0011b\u001b\u0005Y&B\u0001/^\u0003%IW.\\;uC\ndWM\u0003\u0002_\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001\\&aA'baB\u0011!-Z\u0007\u0002G*\u0011A\rB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0019\u001c'\u0001E(gMN,Go\u00115fG.\u0004x.\u001b8u\u0011\u0019A\u0007\u0001)A\u00053\u0006a1\r[3dWB|\u0017N\u001c;tA!9!\u000e\u0001b\u0001\n\u0013Y\u0017AC5o!J|wM]3tgV\tA\u000e\u0005\u0003naB\u0012X\"\u00018\u000b\u0005=l\u0016aB7vi\u0006\u0014G.Z\u0005\u0003c:\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002=g&\u0011AO\u0001\u0002\u0011\u0019><7\t\\3b]&twm\u0015;bi\u0016DaA\u001e\u0001!\u0002\u0013a\u0017aC5o!J|wM]3tg\u0002Bq\u0001\u001f\u0001C\u0002\u0013%\u00110\u0001\u0003m_\u000e\\W#\u0001>\u0011\u0007m\f)!D\u0001}\u0015\tih0A\u0003m_\u000e\\7OC\u0002\u0000\u0003\u0003\t!bY8oGV\u0014(/\u001a8u\u0015\r\t\u0019\u0001J\u0001\u0005kRLG.C\u0002\u0002\bq\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007bBA\u0006\u0001\u0001\u0006IA_\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#\t!\u0003]1vg\u0016$7\t\\3b]&twmQ8oIV\u0011\u00111\u0003\t\u0004w\u0006U\u0011bAA\fy\nI1i\u001c8eSRLwN\u001c\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0014\u0005\u0019\u0002/Y;tK\u0012\u001cE.Z1oS:<7i\u001c8eA!I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011E\u0001\u001aI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw.\u0006\u0002\u0002$A\u0019\u0001\"!\n\n\u0007\u0005\u001d\u0012B\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0003W\u0001\u0001\u0019!C\u0005\u0003[\tQ\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_~#S-\u001d\u000b\u0005\u0003_\t)\u0004E\u0002\t\u0003cI1!a\r\n\u0005\u0011)f.\u001b;\t\u0015\u0005]\u0012\u0011FA\u0001\u0002\u0004\t\u0019#A\u0002yIEB\u0001\"a\u000f\u0001A\u0003&\u00111E\u0001\u001bI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw\u000e\t\u0015\u0005\u0003s\ty\u0004E\u0002\t\u0003\u0003J1!a\u0011\n\u0005!1x\u000e\\1uS2,\u0007\"CA$\u0001\u0001\u0007I\u0011BA%\u00035!\u0018.\\3PM2\u000b7\u000f\u001e*v]V\u0011\u00111\n\t\u0004\u0011\u00055\u0013bAA(\u0013\t!Aj\u001c8h\u0011%\t\u0019\u0006\u0001a\u0001\n\u0013\t)&A\tuS6,wJ\u001a'bgR\u0014VO\\0%KF$B!a\f\u0002X!Q\u0011qGA)\u0003\u0003\u0005\r!a\u0013\t\u0011\u0005m\u0003\u0001)Q\u0005\u0003\u0017\na\u0002^5nK>3G*Y:u%Vt\u0007\u0005\u000b\u0003\u0002Z\u0005}\u0002bBA1\u0001\u0011\u0005\u00111M\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\t)\u0007E\u0004\u0002h\u0005U\u0004'a\u0013\u000f\t\u0005%\u0014\u0011\u000f\t\u0004\u0003WJQBAA7\u0015\r\tygG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\u0014\"\u0001\u0004Qe\u0016$WMZ\u0005\u0004A\u0006]$bAA:\u0013!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!G4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$B!a \u0002\fB)\u0001\"!!\u0002\u0006&\u0019\u00111Q\u0005\u0003\r=\u0003H/[8o!\ra\u0014qQ\u0005\u0004\u0003\u0013\u0013!A\u0003'pOR{7\t\\3b]\"A\u0011QRA=\u0001\u0004\ty)\u0001\u0003uS6,\u0007\u0003BAI\u0003+k!!a%\u000b\u0005A\u0011\u0014\u0002BAL\u0003'\u0013A\u0001V5nK\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015!\u00043fY\u0016$\u0018M\u00197f\u0019><7\u000f\u0006\u0002\u0002 B1\u0011\u0011UAV\u0003csA!a)\u0002(:!\u00111NAS\u0013\u0005Q\u0011bAAU\u0013\u00059\u0001/Y2lC\u001e,\u0017\u0002BAW\u0003_\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003SK\u0001#\u0002\u0005\u00024BZ\u0014bAA[\u0013\t1A+\u001e9mKJBq!!/\u0001\t\u0003\tY,A\u0007bE>\u0014Ho\u00117fC:Lgn\u001a\u000b\u0005\u0003_\ti\fC\u0004\u0002@\u0006]\u0006\u0019\u0001\u0019\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0017!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003_\t9\rC\u0004\u0002@\u0006\u0005\u0007\u0019\u0001\u0019\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA\u0018\u0003\u001fDq!a0\u0002J\u0002\u0007\u0001\u0007C\u0004\u0002T\u0002!I!!6\u0002#%\u001c8\t\\3b]&tw-\u00138Ti\u0006$X\r\u0006\u0004\u0002X\u0006u\u0017q\u001c\t\u0004\u0011\u0005e\u0017bAAn\u0013\t9!i\\8mK\u0006t\u0007bBA`\u0003#\u0004\r\u0001\r\u0005\b\u0003C\f\t\u000e1\u0001s\u00035)\u0007\u0010]3di\u0016$7\u000b^1uK\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\u0018\u0001F2iK\u000e\\7\t\\3b]&tw-\u00112peR,G\r\u0006\u0003\u00020\u0005%\bbBA`\u0003G\u0004\r\u0001\r\u0005\b\u0003[\u0004A\u0011AAx\u0003E)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u000b\u0007\u0003_\t\t0!>\t\u000f\u0005M\u00181\u001ea\u0001A\u00059A-\u0019;b\t&\u0014\b\u0002CA|\u0003W\u0004\r!!?\u0002\rU\u0004H-\u0019;f!\u0015A\u0011\u0011QA~!\u0019A\u00111\u0017\u0019\u0002L!9\u0011q \u0001\u0005\u0002\t\u0005\u0011aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\tyCa\u0001\u0003\u0006\t\u001d\u0001bBAz\u0003{\u0004\r\u0001\t\u0005\b\u0003\u007f\u000bi\u00101\u00011\u0011!\u0011I!!@A\u0002\u0005-\u0013AB8gMN,G\u000fC\u0004\u0003\u000e\u0001!\tAa\u0004\u0002\u0019\u0011|g.Z\"mK\u0006t\u0017N\\4\u0015\u0011\u0005=\"\u0011\u0003B\n\u0005+Aq!a0\u0003\f\u0001\u0007\u0001\u0007C\u0004\u0002t\n-\u0001\u0019\u0001\u0011\t\u0011\t]!1\u0002a\u0001\u0003\u0017\n\u0011\"\u001a8e\u001f\u001a47/\u001a;\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\u0005aAm\u001c8f\t\u0016dW\r^5oOR!\u0011q\u0006B\u0010\u0011\u001d\tyL!\u0007A\u0002A:\u0001Ba\t\u0003\u0011\u0003\u0011!QE\u0001\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\bc\u0001\u001f\u0003(\u00199\u0011A\u0001E\u0001\u0005\t%2\u0003\u0002B\u0014\u000f5AqA\u0011B\u0014\t\u0003\u0011i\u0003\u0006\u0002\u0003&!A!\u0011\u0007B\u0014\t\u0003\u0011\u0019$\u0001\njg\u000e{W\u000e]1di\u0006sG\rR3mKR,G\u0003BAl\u0005kAaa\u0001B\u0018\u0001\u0004Y\u0004\u0002\u0003B\u001d\u0005O!\tAa\u000f\u0002!\rdW-\u00198bE2,wJ\u001a4tKR\u001cHC\u0003B\u001f\u0005\u007f\u0011\tEa\u0011\u0003JA9\u0001\"a-\u0002L\u0005-\u0003BB\u0002\u00038\u0001\u00071\bC\u0004\u0002@\n]\u0002\u0019\u0001\u0019\t\u0011\t\u0015#q\u0007a\u0001\u0005\u000f\n\u0011\u0002\\1ti\u000ecW-\u00198\u0011\u000bi{\u0006'a\u0013\t\u0011\t-#q\u0007a\u0001\u0003\u0017\n1A\\8x\u0001")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpoint> checkpoints() {
        return this.checkpoints;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.read(), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$4)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning(topicPartition);
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                option = this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
                }
                Option option3 = this.inProgress().put((Object)topicPartition, (Object)LogCleaningAborted$.MODULE$);
                option = option3;
            } else {
                throw new MatchError((Object)option2);
            }
            while (!this.isCleaningInState(topicPartition, LogCleaningPaused$.MODULE$)) {
                this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
                }
                option = this.inProgress().remove((Object)topicPartition);
            } else {
                throw new MatchError((Object)option2);
            }
            Option option3 = option;
            return option3;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.checkpoints().apply((Object)dataDir);
            Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
            checkpoint.write((Map<TopicPartition, Object>)existing);
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                OffsetCheckpoint checkpoint;
                Map<TopicPartition, Object> existing;
                if (!this.logs().get(topicPartition).config().compact() || BoxesRunTime.unboxToLong((Object)(existing = (checkpoint = (OffsetCheckpoint)this.checkpoints().apply((Object)dataDir)).read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            LogCleaningState logCleaningState = (LogCleaningState)this.inProgress().apply((Object)topicPartition);
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                option = this.inProgress().remove((Object)topicPartition);
            } else if (LogCleaningAborted$.MODULE$.equals(logCleaningState)) {
                this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
                this.pausedCleaningCond().signalAll();
                option = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
            }
            return option;
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().remove((Object)topicPartition));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
        return bl;
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDirs)).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpoint(new File((File)dir, this.offsetCheckpointFile()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

