/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedCreateTopics;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u00059!p[+uS2\u001cX#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u001dQ6.\u0016;jYND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\tu.,F/\u001b7tA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"A\b\u0001\t\u000bm\u0019\u0005\u0019A\u000f\t\u000b]\u0019\u0005\u0019A\u0013\t\u000bQ\u001a\u0005\u0019\u0001\u001c\t\u000bq\u001a\u0005\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0005\u001b\u0006qAo\u001c9jGB+(oZ1u_JLX#\u0001(\u0011\u0007yy\u0015+\u0003\u0002Q\u0005\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\tq\"+\u0003\u0002T\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002Bqa\u0016\u0001C\u0002\u0013%\u0001,A\tde\u0016\fG/\u001a+pa&\u001c\u0007k\u001c7jGf,\u0012!\u0017\t\u0004\u0013ic\u0016BA.\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q,Y\u0007\u0002=*\u0011q\fY\u0001\u0007a>d\u0017nY=\u000b\u0005\rQ\u0013B\u00012_\u0005E\u0019%/Z1uKR{\u0007/[2Q_2L7-\u001f\u0005\u0007I\u0002\u0001\u000b\u0011B-\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u0017\u0010\t\u0005\u0006M\u0002!\taZ\u0001\u001aQ\u0006\u001cH)\u001a7bs\u0016$Gk\u001c9jG>\u0003XM]1uS>t7/F\u0001i!\tI\u0011.\u0003\u0002k\u0015\t9!i\\8mK\u0006t\u0007\"\u00027\u0001\t\u0003i\u0017!\t;ss\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012$v\u000e]5d\u001fB,'/\u0019;j_:\u001cHC\u00018r!\tIq.\u0003\u0002q\u0015\t!QK\\5u\u0011\u0015\u00118\u000e1\u0001t\u0003\u0015!x\u000e]5d!\t!8P\u0004\u0002vsB\u0011aOC\u0007\u0002o*\u0011\u0001PB\u0001\u0007yI|w\u000e\u001e \n\u0005iT\u0011A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A\u001f\u0006\t\r}\u0004A\u0011AA\u0001\u00031\u0019'/Z1uKR{\u0007/[2t)%q\u00171AA\u0007\u0003#\t9\u0005C\u0004\u0002\u0006y\u0004\r!a\u0002\u0002\u000fQLW.Z8viB\u0019\u0011\"!\u0003\n\u0007\u0005-!BA\u0002J]RDa!a\u0004\u007f\u0001\u0004A\u0017\u0001\u0004<bY&$\u0017\r^3P]2L\bbBA\n}\u0002\u0007\u0011QC\u0001\u000bGJ,\u0017\r^3J]\u001a|\u0007cBA\f\u0003;\u0019\u0018\u0011E\u0007\u0003\u00033Q1!a\u0007\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\tIBA\u0002NCB\u0004B!a\t\u0002B9!\u0011QEA\u001e\u001d\u0011\t9#a\u000e\u000f\t\u0005%\u0012Q\u0007\b\u0005\u0003W\t\u0019D\u0004\u0003\u0002.\u0005Ebb\u0001<\u00020%\ta&\u0003\u0002-[%\u0011QaK\u0005\u0003S)J1!!\u000f)\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u001f\u0003\u007f\t1c\u0011:fCR,Gk\u001c9jGN\u0014V-];fgRT1!!\u000f)\u0013\u0011\t\u0019%!\u0012\u0003\u0019Q{\u0007/[2EKR\f\u0017\u000e\\:\u000b\t\u0005u\u0012q\b\u0005\b\u0003\u0013r\b\u0019AA&\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0004\n\u0003\u001b\n\tF\\\u0005\u0004\u0003\u001fR!!\u0003$v]\u000e$\u0018n\u001c82!\u001d\t9\"!\bt\u0003'\u0002B!!\u0016\u0002^9!\u0011qKA-\u001b\t\ty$\u0003\u0003\u0002\\\u0005}\u0012\u0001F\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX-\u0003\u0003\u0002`\u0005\u0005$!B#se>\u0014(\u0002BA.\u0003\u007fAq!!\u001a\u0001\t\u0003\t9'\u0001\u0007eK2,G/\u001a+pa&\u001c7\u000fF\u0004o\u0003S\nY'!\u001e\t\u0011\u0005\u0015\u00111\ra\u0001\u0003\u000fA\u0001\"!\u001c\u0002d\u0001\u0007\u0011qN\u0001\u0007i>\u0004\u0018nY:\u0011\u000b\u0005]\u0011\u0011O:\n\t\u0005M\u0014\u0011\u0004\u0002\u0004'\u0016$\b\u0002CA%\u0003G\u0002\r!a\u001e\u0011\r%\ti%!\u001fo!\u001d\t9\"!\bt\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003C\u0013\u0001\u00039s_R|7m\u001c7\n\t\u0005\u0015\u0015q\u0010\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\u0006A1\u000f[;uI><h\u000eF\u0001o\u0001")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final ZkUtils zkUtils;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.keyLabel(), BoxesRunTime.boxToInteger((int)completed)})));
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, CreateTopicsResponse.Error>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreateTopicMetadata createTopicMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = configs.setProperty(key, value);
                        return object;
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map<Object, Seq<Object>> assignments = !arguments.replicasAssignments.isEmpty() ? (Map<Object, Seq<Object>>)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Integer partitionId = (Integer)tuple2._1();
                        List replicas = (List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1), Buffer$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()) : AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, assignments})));
                    Option<CreateTopicPolicy> option = this.createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.value();
                        AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.zkUtils(), topic, assignments, configs, false);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (!validateOnly) {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (validateOnly) {
                            AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.zkUtils(), topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    } else {
                        throw new MatchError(option);
                    }
                    createTopicMetadata = new CreateTopicMetadata(topic, assignments, new CreateTopicsResponse.Error(Errors.NONE, null));
                }
                catch (Throwable throwable) {
                    CreateTopicMetadata createTopicMetadata2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof PolicyViolationException ? true : throwable2 instanceof ApiException;
                    if (bl) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, arguments})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                        createTopicMetadata2 = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), new CreateTopicsResponse.Error(Errors.forException((Throwable)throwable2), throwable2.getMessage()));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, arguments})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        createTopicMetadata2 = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), new CreateTopicsResponse.Error(Errors.forException((Throwable)throwable3), throwable3.getMessage()));
                    } else {
                        throw throwable;
                    }
                    createTopicMetadata = createTopicMetadata2;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreateTopicMetadata createTopicMetadata3 = createTopicMetadata;
            return createTopicMetadata3;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$11(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> createTopicMetadata.error().is(Errors.NONE) && !validateOnly ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new CreateTopicsResponse.Error(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedCreateTopics delayedCreate = new DelayedCreateTopics(timeout, (Seq<CreateTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), (String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$5 -> new TopicKey((String)x$5), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$11(CreateTopicMetadata x$2) {
        return x$2.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$4) {
        Errors errors = x$4.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, ZkUtils zkUtils) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkUtils = zkUtils;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq("[Admin Manager on Broker " + config.brokerId() + "]: ");
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3());
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
    }
}

