/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.NotAssignedReplicaException;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionOperationKey;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r-b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!\u0002;pa&\u001cW#A\u000f\u0011\u0005y)cBA\u0010$!\t\u0001#\"D\u0001\"\u0015\t\u0011c!\u0001\u0004=e>|GOP\u0005\u0003I)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011AE\u0003\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u00051Ao\u001c9jG\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001.!\tIa&\u0003\u00020\u0015\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\n5\nA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0005i&lW\r\u0005\u00026}5\taG\u0003\u0002\u0012o)\u0011\u0001(O\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Q$BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!a\u0010\u001c\u0003\tQKW.\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\"G\u001b\u0005!%BA#\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\t\u0012\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015I\u0005\u0001\"\u0001K\u0003\u0019a\u0014N\\5u}Q)1*\u0014(P!B\u0011A\nA\u0007\u0002\u0005!)1\u0004\u0013a\u0001;!)1\u0006\u0013a\u0001[!)1\u0007\u0013a\u0001i!)\u0011\t\u0013a\u0001\u0005\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0016A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002)B\u0011QKV\u0007\u0002o%\u0011qk\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019I\u0006\u0001)A\u0005)\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004\\\u0001\t\u0007I\u0011\u0002\u0017\u0002\u001b1|7-\u00197Ce>\\WM]%e\u0011\u0019i\u0006\u0001)A\u0005[\u0005qAn\\2bY\n\u0013xn[3s\u0013\u0012\u0004\u0003bB0\u0001\u0005\u0004%I\u0001Y\u0001\u000bY><W*\u00198bO\u0016\u0014X#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011$\u0011a\u00017pO&\u0011am\u0019\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\bB\u00025\u0001A\u0003%\u0011-A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0003b\u00026\u0001\u0005\u0004%Ia[\u0001\bu.,F/\u001b7t+\u0005a\u0007CA\bn\u0013\tq\u0007CA\u0004[WV#\u0018\u000e\\:\t\rA\u0004\u0001\u0015!\u0003m\u0003!Q8.\u0016;jYN\u0004\u0003b\u0002:\u0001\u0005\u0004%Ia]\u0001\u0013CN\u001c\u0018n\u001a8fIJ+\u0007\u000f\\5dC6\u000b\u0007/F\u0001u!\u0011yQ/L<\n\u0005Y\u0004\"\u0001\u0002)p_2\u0004\"\u0001\u0014=\n\u0005e\u0014!a\u0002*fa2L7-\u0019\u0005\u0007w\u0002\u0001\u000b\u0011\u0002;\u0002'\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006l\u0015\r\u001d\u0011\t\u000fu\u0004!\u0019!C\u0005}\u0006\u0019B.Z1eKJL5O]+qI\u0006$X\rT8dWV\tq\u0010\u0005\u0003\u0002\u0002\u0005MQBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u000b1|7m[:\u000b\t\u0005%\u00111B\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0007\u0003\u001f\tA!\u001e;jY*\u0011\u0011\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005\r!A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\u000f\u0005e\u0001\u0001)A\u0005\u007f\u0006!B.Z1eKJL5O]+qI\u0006$X\rT8dW\u0002B\u0001\"!\b\u0001\u0001\u0004%I\u0001L\u0001\nu.4VM]:j_:D\u0011\"!\t\u0001\u0001\u0004%I!a\t\u0002\u001bi\\g+\u001a:tS>tw\fJ3r)\u0011\t)#a\u000b\u0011\u0007%\t9#C\u0002\u0002*)\u0011A!\u00168ji\"I\u0011QFA\u0010\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0004bBA\u0019\u0001\u0001\u0006K!L\u0001\u000bu.4VM]:j_:\u0004\u0003\u0002CA\u001b\u0001\u0001\u0007I\u0011\u0002\u0017\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003w\tq\u0002\\3bI\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0005\u0003K\ti\u0004C\u0005\u0002.\u0005]\u0012\u0011!a\u0001[!9\u0011\u0011\t\u0001!B\u0013i\u0013\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0003\u0006BA \u0003\u000b\u00022!CA$\u0013\r\tIE\u0003\u0002\tm>d\u0017\r^5mK\"I\u0011Q\n\u0001A\u0002\u0013\u0005\u0011qJ\u0001\u0013Y\u0016\fG-\u001a:SKBd\u0017nY1JI>\u0003H/\u0006\u0002\u0002RA!\u0011\"a\u0015.\u0013\r\t)F\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005e\u0003\u00011A\u0005\u0002\u0005m\u0013A\u00067fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR|F%Z9\u0015\t\u0005\u0015\u0012Q\f\u0005\u000b\u0003[\t9&!AA\u0002\u0005E\u0003\u0002CA1\u0001\u0001\u0006K!!\u0015\u0002'1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u0012|\u0005\u000f\u001e\u0011)\t\u0005}\u0013Q\t\u0005\n\u0003O\u0002\u0001\u0019!C\u0001\u0003S\na\"\u001b8Ts:\u001c'+\u001a9mS\u000e\f7/\u0006\u0002\u0002lA!a$!\u001cx\u0013\r\tyg\n\u0002\u0004'\u0016$\b\"CA:\u0001\u0001\u0007I\u0011AA;\u0003IIgnU=oGJ+\u0007\u000f\\5dCN|F%Z9\u0015\t\u0005\u0015\u0012q\u000f\u0005\u000b\u0003[\t\t(!AA\u0002\u0005-\u0004\u0002CA>\u0001\u0001\u0006K!a\u001b\u0002\u001f%t7+\u001f8d%\u0016\u0004H.[2bg\u0002BC!!\u001f\u0002F!A\u0011\u0011\u0011\u0001A\u0002\u0013%A&A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0011%\t)\t\u0001a\u0001\n\u0013\t9)A\nd_:$(o\u001c7mKJ,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005%\u0005\"CA\u0017\u0003\u0007\u000b\t\u00111\u0001.\u0011\u001d\ti\t\u0001Q!\n5\n\u0001cY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\u0006q\u0011n\u001d*fa2L7-\u0019'pG\u0006dG\u0003BAK\u00037\u00032!CAL\u0013\r\tIJ\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\ti*a$A\u00025\n\u0011B]3qY&\u001c\u0017-\u00133\t\u0013\u0005\u0005\u0006A1A\u0005\u0002\u0005\r\u0016\u0001\u0002;bON,\"!!*\u0011\u0011\u0005\u001d\u0016\u0011WA[\u0003kk!!!+\u000b\t\u0005-\u0016QV\u0001\nS6lW\u000f^1cY\u0016T1!a,\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\u000bIKA\u0002NCB\u0004B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000by!\u0001\u0003mC:<\u0017b\u0001\u0014\u0002:\"A\u0011\u0011\u0019\u0001!\u0002\u0013\t)+A\u0003uC\u001e\u001c\b\u0005C\u0004\u0002F\u0002!I!a2\u0002)%\u001cH*Z1eKJ\u0014V\r\u001d7jG\u0006dunY1m+\t\t)\nC\u0004\u0002L\u0002!\t!a2\u0002#%\u001cXK\u001c3feJ+\u0007\u000f\\5dCR,G\rC\u0004\u0002P\u0002!\t!!5\u0002%\u001d,Go\u0014:De\u0016\fG/\u001a*fa2L7-\u0019\u000b\u0004o\u0006M\u0007\"CAO\u0003\u001b\u0004\n\u00111\u0001.\u0011\u001d\t9\u000e\u0001C\u0001\u00033\f!bZ3u%\u0016\u0004H.[2b)\u0011\tY.!8\u0011\t%\t\u0019f\u001e\u0005\n\u0003;\u000b)\u000e%AA\u00025Bq!!9\u0001\t\u0003\t\u0019/\u0001\u000bmK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\\\u000b\u0003\u00037Dq!a:\u0001\t\u0003\tI/A\u000bbI\u0012\u0014V\r\u001d7jG\u0006LeMT8u\u000bbL7\u000f^:\u0015\u0007]\fY\u000fC\u0004\u0002n\u0006\u0015\b\u0019A<\u0002\u000fI,\u0007\u000f\\5dC\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005%\u0014\u0001E1tg&<g.\u001a3SKBd\u0017nY1t\u0011\u001d\t)\u0010\u0001C\u0005\u0003o\fQB]3n_Z,'+\u001a9mS\u000e\fG\u0003BA\u0013\u0003sDq!!(\u0002t\u0002\u0007Q\u0006C\u0004\u0002~\u0002!\t!a@\u0002\r\u0011,G.\u001a;f)\t\t)\u0003\u0003\u0004\u0003\u0004\u0001!\t\u0001L\u0001\u000fO\u0016$H*Z1eKJ,\u0005o\\2i\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013\t!\"\\1lK2+\u0017\rZ3s)!\t)Ja\u0003\u0003\u0010\t}\u0001b\u0002B\u0007\u0005\u000b\u0001\r!L\u0001\rG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0005\t\u0005#\u0011)\u00011\u0001\u0003\u0014\u0005\u0011\u0002/\u0019:uSRLwN\\*uCR,\u0017J\u001c4p!\u0011\u0011)Ba\u0007\u000e\u0005\t]!b\u0001B\ro\u0005A!/Z9vKN$8/\u0003\u0003\u0003\u001e\t]!A\u0004)beRLG/[8o'R\fG/\u001a\u0005\b\u0005C\u0011)\u00011\u0001.\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\"9!Q\u0005\u0001\u0005\u0002\t\u001d\u0012\u0001D7bW\u00164u\u000e\u001c7po\u0016\u0014H\u0003CAK\u0005S\u0011YC!\f\t\u000f\t5!1\u0005a\u0001[!A!\u0011\u0003B\u0012\u0001\u0004\u0011\u0019\u0002C\u0004\u0003\"\t\r\u0002\u0019A\u0017\t\u000f\tE\u0002\u0001\"\u0001\u00034\u0005QR\u000f\u001d3bi\u0016\u0014V\r\u001d7jG\u0006dun\u001a*fC\u0012\u0014Vm];miR1\u0011Q\u0005B\u001b\u0005oAq!!(\u00030\u0001\u0007Q\u0006\u0003\u0005\u0003:\t=\u0002\u0019\u0001B\u001e\u00035awn\u001a*fC\u0012\u0014Vm];miB\u00191I!\u0010\n\u0007\t}BIA\u0007M_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u00039i\u0017-\u001f2f\u000bb\u0004\u0018M\u001c3JgJ$b!!&\u0003H\t%\u0003bBAO\u0005\u0003\u0002\r!\f\u0005\t\u0005s\u0011\t\u00051\u0001\u0003<!9!Q\n\u0001\u0005\u0002\t=\u0013AH2iK\u000e\\WI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c(+Z1dQ>3gm]3u)\u0011\u0011\tFa\u0019\u0011\u000f%\u0011\u0019&!&\u0003X%\u0019!Q\u000b\u0006\u0003\rQ+\b\u000f\\33!\u0011\u0011IFa\u0018\u000e\u0005\tm#b\u0001B/o\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003b\tm#AB#se>\u00148\u000f\u0003\u0005\u0003f\t-\u0003\u0019\u0001B4\u00039\u0011X-];je\u0016$wJ\u001a4tKR\u00042!\u0003B5\u0013\r\u0011YG\u0003\u0002\u0005\u0019>tw\rC\u0004\u0003p\u0001!IA!\u001d\u0002-5\f\u0017PY3J]\u000e\u0014X-\\3oi2+\u0017\rZ3s\u0011^#b!!&\u0003t\t]\u0004b\u0002B;\u0005[\u0002\ra^\u0001\u000eY\u0016\fG-\u001a:SKBd\u0017nY1\t\u0015\te$Q\u000eI\u0001\u0002\u0004\u00119'A\u0004dkJ$\u0016.\\3\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0000\u0005!Bn\\<XCR,'/\\1sW&3G*Z1eKJ,\"Aa\u001a\t\u000f\t\r\u0005\u0001\"\u0003\u0002\u0000\u0006QBO]=D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e%\u0016\fX/Z:ug\"9!q\u0011\u0001\u0005\u0002\t%\u0015AD7bs\n,7\u000b\u001b:j].L5O\u001d\u000b\u0005\u0003K\u0011Y\t\u0003\u0005\u0003\u000e\n\u0015\u0005\u0019\u0001B4\u0003M\u0011X\r\u001d7jG\u0006l\u0015\r\u001f'bORKW.Z't\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'\u000bAcZ3u\u001fV$xJZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001cHCBA6\u0005+\u00139\nC\u0004\u0003v\t=\u0005\u0019A<\t\u0011\te%q\u0012a\u0001\u0005O\n\u0001\"\\1y\u0019\u0006<Wj\u001d\u0005\b\u0005;\u0003A\u0011\u0001BP\u0003U\t\u0007\u000f]3oIJ+7m\u001c:egR{G*Z1eKJ$\u0002B!)\u0003(\n]&1\u0018\t\u0004E\n\r\u0016b\u0001BSG\niAj\\4BaB,g\u000eZ%oM>D\u0001B!+\u0003\u001c\u0002\u0007!1V\u0001\be\u0016\u001cwN\u001d3t!\u0011\u0011iKa-\u000e\u0005\t=&b\u0001BYo\u00051!/Z2pe\u0012LAA!.\u00030\niQ*Z7pef\u0014VmY8sIND\u0001B!/\u0003\u001c\u0002\u0007\u0011QS\u0001\rSN4%o\\7DY&,g\u000e\u001e\u0005\n\u0005{\u0013Y\n%AA\u00025\nAB]3rk&\u0014X\rZ!dWNDqA!1\u0001\t\u0003\u0011\u0019-A\u000beK2,G/\u001a*fG>\u0014Hm](o\u0019\u0016\fG-\u001a:\u0015\t\t\u001d$Q\u0019\u0005\t\u0005\u000f\u0014y\f1\u0001\u0003h\u00051qN\u001a4tKRDqAa3\u0001\t\u0003\u0011i-\u0001\rmCN$xJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"$BAa4\u0003VB!!Q\u0003Bi\u0013\u0011\u0011\u0019Na\u0006\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"9\u0011Q\u0007Be\u0001\u0004i\u0003b\u0002Bm\u0001\u0011%!1\\\u0001\nkB$\u0017\r^3JgJ$B!!\n\u0003^\"A!q\u001cBl\u0001\u0004\tY'\u0001\u0004oK^L5O\u001d\u0005\b\u0005G\u0004A\u0011BA\u0000\u0003Y\u0011X-\\8wKB\u000b'\u000f^5uS>tW*\u001a;sS\u000e\u001c\bb\u0002Bt\u0001\u0011\u0005#\u0011^\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U%1\u001e\u0005\t\u0005[\u0014)\u000f1\u0001\u0003p\u0006!A\u000f[1u!\rI!\u0011_\u0005\u0004\u0005gT!aA!os\"9!q\u001f\u0001\u0005B\te\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u00035BqA!@\u0001\t\u0003\u0012y0\u0001\u0005u_N#(/\u001b8h)\u0005i\u0002\"CB\u0002\u0001E\u0005I\u0011AB\u0003\u0003q9W\r^(s\u0007J,\u0017\r^3SKBd\u0017nY1%I\u00164\u0017-\u001e7uIE*\"aa\u0002+\u00075\u001aIa\u000b\u0002\u0004\fA!1QBB\f\u001b\t\u0019yA\u0003\u0003\u0004\u0012\rM\u0011!C;oG\",7m[3e\u0015\r\u0019)BC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\r\u0007\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019i\u0002AI\u0001\n\u0003\u0019)!\u0001\u000bhKR\u0014V\r\u001d7jG\u0006$C-\u001a4bk2$H%\r\u0005\n\u0007C\u0001\u0011\u0013!C\u0005\u0007G\t\u0001%\\1zE\u0016Len\u0019:f[\u0016tG\u000fT3bI\u0016\u0014\bj\u0016\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0005\u0016\u0005\u0005O\u001aI\u0001C\u0005\u0004*\u0001\t\n\u0011\"\u0001\u0004\u0006\u0005y\u0012\r\u001d9f]\u0012\u0014VmY8sIN$v\u000eT3bI\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private final Time time;
    private final ReplicaManager replicaManager;
    private final TopicPartition topicPartition;
    private final int localBrokerId;
    private final LogManager logManager;
    private final ZkUtils zkUtils;
    private final Pool<Object, Replica> assignedReplicaMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int zkVersion;
    private volatile int leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile Set<Replica> inSyncReplicas;
    private int controllerEpoch;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Partition partition = this;
        synchronized (partition) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private int localBrokerId() {
        return this.localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Pool<Object, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    private int zkVersion() {
        return this.zkVersion;
    }

    private void zkVersion_$eq(int x$1) {
        this.zkVersion = x$1;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int x$1) {
        this.leaderEpoch = x$1;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> x$1) {
        this.leaderReplicaIdOpt = x$1;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> x$1) {
        this.inSyncReplicas = x$1;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.localBrokerId();
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public boolean kafka$cluster$Partition$$isLeaderReplicaLocal() {
        return this.leaderReplicaIfLocal().isDefined();
    }

    public boolean isUnderReplicated() {
        return this.kafka$cluster$Partition$$isLeaderReplicaLocal() && this.inSyncReplicas().size() < this.assignedReplicas().size();
    }

    public Replica getOrCreateReplica(int replicaId) {
        return this.assignedReplicaMap().getAndMaybePut(BoxesRunTime.boxToInteger((int)replicaId), (Function0<Replica>)(Function0 & Serializable & scala.Serializable)() -> {
            Replica replica;
            if (this.isReplicaLocal(replicaId)) {
                LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().defaultConfig().originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), this.topic()));
                Log log = this.logManager().createLog(this.topicPartition(), config);
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.replicaManager.highWatermarkCheckpoints().apply((Object)log.dir().getParentFile().getAbsolutePath());
                Map<TopicPartition, Object> offsetMap = checkpoint.read();
                if (!offsetMap.contains((Object)this.topicPartition())) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No checkpointed highwatermark is found for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
                long offset = package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), log.logEndOffset());
                replica = new Replica(replicaId, this.topicPartition(), $this.time, offset, (Option<Log>)new Some((Object)log));
            } else {
                replica = new Replica(replicaId, this.topicPartition(), $this.time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            return replica;
        });
    }

    public int getOrCreateReplica$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> getReplica(int replicaId) {
        return Option$.MODULE$.apply((Object)this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId)));
    }

    public int getReplica$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        return this.leaderReplicaIdOpt().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == this.localBrokerId()).flatMap((Function1 & Serializable & scala.Serializable)replicaId -> this.getReplica(BoxesRunTime.unboxToInt((Object)replicaId)));
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    private void removeReplica(int replicaId) {
        this.assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assignedReplicaMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            try {
                this.logManager().asyncDelete(this.topicPartition());
                this.removePartitionMetrics();
            }
            catch (IOException e) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting the log for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
            }
        });
    }

    public int getLeaderEpoch() {
        return this.leaderEpoch();
    }

    public boolean makeLeader(int controllerId, PartitionState partitionStateInfo, int correlationId) {
        boolean isNewLeader;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                boolean bl;
                Buffer allReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom());
                this.controllerEpoch_$eq(partitionStateInfo$1.controllerEpoch);
                Set newInSyncReplicas = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.isr).asScala()).map((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(Predef$.MODULE$.Integer2int(r)), Buffer$.MODULE$.canBuildFrom())).toSet();
                ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)allReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
                this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " starts at Leader Epoch ", " from offset ", ". Previous Leader Epoch was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)partitionStateInfo$1.leaderEpoch), BoxesRunTime.boxToLong((long)((Replica)this.getReplica(this.getReplica$default$1()).get()).logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.leaderEpoch())})));
                this.leaderEpoch_$eq(partitionStateInfo$1.leaderEpoch);
                allReplicas.foreach((Function1 & Serializable & scala.Serializable)id -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)id)));
                this.zkVersion_$eq(partitionStateInfo$1.zkVersion);
                if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == this.localBrokerId()) {
                    bl = false;
                } else {
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.localBrokerId())));
                    bl = true;
                }
                boolean isNewLeader = bl;
                Replica leaderReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
                long curLeaderLogEndOffset = leaderReplica.logEndOffset().messageOffset();
                long curTimeMs = $this.time.milliseconds();
                this.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                    Partition.$anonfun$makeLeader$8(this, curLeaderLogEndOffset, curTimeMs, replica);
                    return BoxedUnit.UNIT;
                });
                if (isNewLeader) {
                    leaderReplica.convertHWToLocalOffsetMetadata();
                    ((IterableLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$makeLeader$9(this, x$4)))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                        x$5.updateLogReadResult(LogReadResult$.MODULE$.UnknownLogReadResult());
                        return BoxedUnit.UNIT;
                    });
                }
                return new Tuple2.mcZZ.sp(this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2()), isNewLeader);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean leaderHWIncremented = tuple2._1$mcZ$sp();
            boolean isNewLeader2 = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(leaderHWIncremented, isNewLeader2);
            Tuple2.mcZZ.sp sp3 = sp2;
            boolean leaderHWIncremented2 = sp3._1$mcZ$sp();
            isNewLeader = sp3._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return isNewLeader;
    }

    public boolean makeFollower(int controllerId, PartitionState partitionStateInfo, int correlationId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Buffer allReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$2.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$7)), Buffer$.MODULE$.canBuildFrom());
            int newLeaderBrokerId = partitionStateInfo$2.leader;
            this.controllerEpoch_$eq(partitionStateInfo$2.controllerEpoch);
            allReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)r)));
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)allReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderEpoch_$eq(partitionStateInfo$2.leaderEpoch);
            this.zkVersion_$eq(partitionStateInfo$2.zkVersion);
            if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                bl = false;
            } else {
                this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId)));
                bl = true;
            }
            return bl;
        }));
    }

    public void updateReplicaLogReadResult(int replicaId, LogReadResult logReadResult) {
        Option<Replica> option = this.getReplica(replicaId);
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica replica = (Replica)some.value();
            long oldLeaderLW = this.replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
            replica.updateLogReadResult(logReadResult);
            long newLeaderLW = this.replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
            boolean leaderLWIncremented = newLeaderLW > oldLeaderLW;
            boolean leaderHWIncremented = this.maybeExpandIsr(replicaId, logReadResult);
            if (leaderLWIncremented || leaderHWIncremented) {
                this.tryCompleteDelayedRequests();
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NotAssignedReplicaException(new StringOps(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d since the replica is not recognized to be one of the assigned replicas %s for partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset()), ((TraversableOnce)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), this.topicPartition()})));
            }
            throw new MatchError(option);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Recorded replica %d log end offset (LEO) position %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset())})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean maybeExpandIsr(int replicaId, LogReadResult logReadResult) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                Replica replica = (Replica)this.getReplica(replicaId).get();
                LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                if (!this.inSyncReplicas().contains((Object)replica) && ((SetLike)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) && replica.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                    Set newInSyncReplicas = (Set)this.inSyncReplicas().$plus((Object)replica);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expanding ISR from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                    this.updateIsr((Set<Replica>)newInSyncReplicas);
                    $this.replicaManager.isrExpandRate().mark();
                }
                bl = this.maybeIncrementLeaderHW(leaderReplica, logReadResult.fetchTimeMs());
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        }));
    }

    public Tuple2<Object, Errors> checkEnoughReplicasReachOffset(long requiredOffset) {
        Tuple2 tuple2;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            Set<Replica> curInSyncReplicas = this.inSyncReplicas();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " acks satisfied with acks = -1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1(requiredOffset, curInSyncReplicas))})));
            Integer minIsr = ((Log)leaderReplica.log().get()).config().minInSyncReplicas();
            tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset ? (Predef$.MODULE$.Integer2int(minIsr) <= curInSyncReplicas.size() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NONE) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NONE);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    private boolean maybeIncrementLeaderHW(Replica leaderReplica, long curTime) {
        boolean bl;
        Set allLogEndOffsets = (Set)((SetLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$maybeIncrementLeaderHW$1(this, curTime, replica)))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.logEndOffset(), Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark = (LogOffsetMetadata)allLogEndOffsets.min((Ordering)new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark = leaderReplica.highWatermark();
        if (oldHighWatermark.messageOffset() < newHighWatermark.messageOffset() || oldHighWatermark.onOlderSegment(newHighWatermark)) {
            leaderReplica.highWatermark_$eq(newHighWatermark);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"High watermark updated to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHighWatermark})));
            bl = true;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping update high watermark since new hw ", " is not larger than old hw ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHighWatermark, oldHighWatermark})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All LEOs are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allLogEndOffsets.mkString(",")})));
            bl = false;
        }
        return bl;
    }

    private long maybeIncrementLeaderHW$default$2() {
        return this.time.milliseconds();
    }

    public long lowWatermarkIfLeader() {
        if (!this.kafka$cluster$Partition$$isLeaderReplicaLocal()) {
            throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((SetLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$lowWatermarkIfLeader$1(this, replica)))).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.logStartOffset()), Set$.MODULE$.canBuildFrom())).reduceOption((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$15, x$16) -> RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$15), x$16)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    private void tryCompleteDelayedRequests() {
        TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topicPartition());
        this.replicaManager.tryCompleteDelayedFetch(requestKey);
        this.replicaManager.tryCompleteDelayedProduce(requestKey);
        this.replicaManager.tryCompleteDelayedDeleteRecords(requestKey);
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs) {
        block0: {
            boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.value();
                    Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs);
                    if (outOfSyncReplicas.nonEmpty()) {
                        Set newInSyncReplicas = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                        Predef$.MODULE$.assert(newInSyncReplicas.nonEmpty());
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shrinking ISR from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                        this.updateIsr((Set<Replica>)newInSyncReplicas);
                        $this.replicaManager.isrShrinkRate().mark();
                        bl2 = this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2());
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }));
            if (!leaderHWIncremented) break block0;
            this.tryCompleteDelayedRequests();
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs) {
        Set laggingReplicas;
        block0: {
            Set candidateReplicas = (Set)this.inSyncReplicas().$minus((Object)leaderReplica);
            laggingReplicas = (Set)candidateReplicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$getOutOfSyncReplicas$1(this, maxLagMs, r)));
            if (!laggingReplicas.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Lagging replicas are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)laggingReplicas.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
        }
        return laggingReplicas;
    }

    public LogAppendInfo appendRecordsToLeader(MemoryRecords records, boolean isFromClient, int requiredAcks) {
        LogAppendInfo info;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Log log;
                Replica leaderReplica;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    leaderReplica = (Replica)some.value();
                    log = (Log)leaderReplica.log().get();
                    Integer minIsr = log.config().minInSyncReplicas();
                    int inSyncSize = this.inSyncReplicas().size();
                    if (inSyncSize < Predef$.MODULE$.Integer2int(minIsr) && requiredAcks == -1) {
                        throw new NotEnoughReplicasException(new StringOps(Predef$.MODULE$.augmentString("Number of insync replicas for partition %s is [%d], below required minimum [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)inSyncSize), minIsr})));
                    }
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                    }
                    throw new MatchError(option);
                }
                LogAppendInfo info = log.appendAsLeader(records, this.leaderEpoch(), isFromClient);
                $this.replicaManager.tryCompleteDelayedFetch(new TopicPartitionOperationKey(this.topic(), this.partitionId()));
                Tuple2 tuple2 = new Tuple2((Object)info, (Object)BoxesRunTime.boxToBoolean((boolean)this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2())));
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LogAppendInfo info2 = (LogAppendInfo)tuple2._1();
            boolean leaderHWIncremented = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)info2, (Object)BoxesRunTime.boxToBoolean((boolean)leaderHWIncremented));
            Tuple2 tuple23 = tuple22;
            info = (LogAppendInfo)tuple23._1();
            boolean leaderHWIncremented2 = tuple23._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return info;
    }

    public int appendRecordsToLeader$default$3() {
        return 0;
    }

    public long deleteRecordsOnLeader(long offset) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                leaderReplica.maybeIncrementLogStartOffset(offset);
                if (!((Log)leaderReplica.log().get()).config().delete()) {
                    throw new PolicyViolationException(new StringOps(Predef$.MODULE$.augmentString("Records of partition %s can not be deleted due to the configured policy")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                }
                throw new MatchError(option);
            }
            long l = this.lowWatermarkIfLeader();
            return l;
        }));
    }

    public EpochEndOffset lastOffsetForLeaderEpoch(int leaderEpoch) {
        return (EpochEndOffset)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            EpochEndOffset epochEndOffset;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                epochEndOffset = new EpochEndOffset(Errors.NONE, ((LeaderEpochCache)leaderReplica.epochs().get()).endOffsetFor(leaderEpoch));
            } else if (None$.MODULE$.equals(option)) {
                epochEndOffset = new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1L);
            } else {
                throw new MatchError(option);
            }
            return epochEndOffset;
        });
    }

    private void updateIsr(Set<Replica> newIsr) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.brokerId()), Set$.MODULE$.canBuildFrom())).toList(), this.zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), this.topic(), this.partitionId(), newLeaderAndIsr, this.controllerEpoch(), this.zkVersion());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
        Tuple2.mcZI.sp sp3 = sp2;
        boolean updateSucceeded2 = sp3._1$mcZ$sp();
        int newVersion2 = sp3._2$mcI$sp();
        if (updateSucceeded2) {
            this.replicaManager.recordIsrChange(this.topicPartition());
            this.inSyncReplicas_$eq(newIsr);
            this.zkVersion_$eq(newVersion2);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newIsr.mkString(","), BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        } else {
            this.replicaManager.failedIsrUpdatesRate().mark();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        }
    }

    private void removePartitionMetrics() {
        this.removeMetric("UnderReplicated", (Map<String, String>)this.tags());
        this.removeMetric("InSyncReplicasCount", (Map<String, String>)this.tags());
        this.removeMetric("ReplicasCount", (Map<String, String>)this.tags());
        this.removeMetric("LastStableOffsetLag", (Map<String, String>)this.tags());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Partition)) return false;
        Partition partition = (Partition)object;
        if (this.partitionId() != partition.partitionId()) return false;
        String string = this.topic();
        String string2 = partition.topic();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append("Topic: " + this.topic());
        partitionString.append("; Partition: " + this.partitionId());
        partitionString.append("; Leader: " + this.leaderReplicaIdOpt());
        partitionString.append("; AssignedReplicas: " + this.assignedReplicaMap().keys().mkString(","));
        partitionString.append("; InSyncReplicas: " + ((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToInteger((int)x$23.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","));
        return partitionString.toString();
    }

    public static final /* synthetic */ void $anonfun$makeLeader$8(Partition $this, long curLeaderLogEndOffset$1, long curTimeMs$1, Replica replica) {
        long lastCaughtUpTimeMs = $this.inSyncReplicas().contains((Object)replica) ? curTimeMs$1 : 0L;
        replica.resetLastCaughtUpTime(curLeaderLogEndOffset$1, curTimeMs$1, lastCaughtUpTimeMs);
    }

    public static final /* synthetic */ boolean $anonfun$makeLeader$9(Partition $this, Replica x$4) {
        return x$4.brokerId() != $this.localBrokerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkEnoughReplicasReachOffset$1(Partition $this, long requiredOffset$1, Replica r) {
        boolean bl;
        if (!r.isLocal()) {
            if (r.logEndOffset().messageOffset() >= requiredOffset$1) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " received offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r.brokerId()), BoxesRunTime.boxToLong((long)requiredOffset$1)})));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private final int numAcks$1(long requiredOffset$1, Set curInSyncReplicas$1) {
        return curInSyncReplicas$1.count((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$checkEnoughReplicasReachOffset$1(this, requiredOffset$1, r)));
    }

    public static final /* synthetic */ boolean $anonfun$maybeIncrementLeaderHW$1(Partition $this, long curTime$1, Replica replica) {
        return curTime$1 - replica.lastCaughtUpTimeMs() <= Predef$.MODULE$.Long2long($this.replicaManager.config().replicaLagTimeMaxMs()) || $this.inSyncReplicas().contains((Object)replica);
    }

    public static final /* synthetic */ boolean $anonfun$lowWatermarkIfLeader$1(Partition $this, Replica replica) {
        return $this.replicaManager.metadataCache().isBrokerAlive(replica.brokerId());
    }

    public static final /* synthetic */ boolean $anonfun$getOutOfSyncReplicas$1(Partition $this, long maxLagMs$1, Replica r) {
        return $this.time.milliseconds() - r.lastCaughtUpTimeMs() > maxLagMs$1;
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.time = time;
        this.replicaManager = replicaManager;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.topicPartition = new TopicPartition(topic, partitionId);
        this.localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.zkUtils = replicaManager.zkUtils();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Predef$.MODULE$.Set().empty();
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString())}));
        this.newGauge("UnderReplicated", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Partition $outer;

            public int value() {
                return this.$outer.isUnderReplicated() ? 1 : 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("InSyncReplicasCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Partition $outer;

            public int value() {
                return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.inSyncReplicas().size() : 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("ReplicasCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Partition $outer;

            public int value() {
                return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.assignedReplicas().size() : 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LastStableOffsetLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Partition $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToLong((long)$anon$4.$anonfun$value$1(replica))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            }

            public static final /* synthetic */ long $anonfun$value$1(Replica replica) {
                return replica.highWatermark().messageOffset() - replica.lastStableOffset().messageOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.cluster.Replica ), $anonfun$value$2()}, serializedLambda);
            }
        }, (Map<String, String>)this.tags());
    }
}

