/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u0011Q\"T3uC\u0012\fG/Y\"bG\",'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0005ce>\\WM]%e!\tIq#\u0003\u0002\u0019\u0015\t\u0019\u0011J\u001c;\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\tab\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003\u00163\u0001\u0007a\u0003C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/F\u0001#!\t\u0019\u0013F\u0004\u0002%O5\tQE\u0003\u0002'\t\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005!*\u0013aD&bM.\f7i\u001c8ue>dG.\u001a:\n\u0005)Z#!E*uCR,7\t[1oO\u0016dunZ4fe*\u0011\u0001&\n\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0012\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\u0015\u0019\u0017m\u00195f+\u0005\t\u0004\u0003\u0002\u001a8s\u0011k\u0011a\r\u0006\u0003iU\nq!\\;uC\ndWM\u0003\u00027\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001a$aA'baB\u0011!(\u0011\b\u0003w}\u0002\"\u0001\u0010\u0006\u000e\u0003uR!A\u0010\u0004\u0002\rq\u0012xn\u001c;?\u0013\t\u0001%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!\u000b!\u0011\u0011tGF#\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0011aA1qS&\u0011!j\u0012\u0002\u0013!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0013:4w\u000e\u0003\u0004M\u0001\u0001\u0006I!M\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u000f9\u0003\u0001\u0019!C\u0005\u001f\u0006a1m\u001c8ue>dG.\u001a:JIV\t\u0001\u000bE\u0002\n#ZI!A\u0015\u0006\u0003\r=\u0003H/[8o\u0011\u001d!\u0006\u00011A\u0005\nU\u000b\u0001cY8oiJ|G\u000e\\3s\u0013\u0012|F%Z9\u0015\u0005YK\u0006CA\u0005X\u0013\tA&B\u0001\u0003V]&$\bb\u0002.T\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0004B\u0002/\u0001A\u0003&\u0001+A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u00031\tG.\u001b<f\u0005J|7.\u001a:t+\u0005\u0001\u0007\u0003\u0002\u001a8-\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0003\u0002\u000f\rdWo\u001d;fe&\u0011am\u0019\u0002\u0007\u0005J|7.\u001a:\t\r!\u0004\u0001\u0015!\u0003a\u00035\tG.\u001b<f\u0005J|7.\u001a:tA!9!\u000e\u0001b\u0001\n\u0013Y\u0017AC1mSZ,gj\u001c3fgV\tA\u000e\u0005\u00033oYi\u0007\u0003\u00028pavl\u0011!N\u0005\u0003qU\u0002\"!]>\u000e\u0003IT!a\u001d;\u0002\u000f9,Go^8sW*\u0011QO^\u0001\u0007G>lWn\u001c8\u000b\u0005\u00159(B\u0001=z\u0003\u0019\t\u0007/Y2iK*\t!0A\u0002pe\u001eL!\u0001 :\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\u0005y|X\"\u0001;\n\u0007\u0005\u0005AO\u0001\u0003O_\u0012,\u0007bBA\u0003\u0001\u0001\u0006I\u0001\\\u0001\fC2Lg/\u001a(pI\u0016\u001c\b\u0005C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f\u0005)\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\WCAA\u0007!\u0011\ty!!\t\u000e\u0005\u0005E!\u0002BA\n\u0003+\tQ\u0001\\8dWNTA!a\u0006\u0002\u001a\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005m\u0011QD\u0001\u0005kRLGN\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u0005\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.D\u0001\"a\n\u0001A\u0003%\u0011QB\u0001\u0017a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2lA!9\u00111\u0006\u0001\u0005\n\u00055\u0012\u0001D4fi\u0016sG\r]8j]R\u001cH\u0003CA\u0018\u0003k\tY%a\u0014\u0011\t9\f\t$`\u0005\u0004\u0003g)$aA*fc\"A\u0011qGA\u0015\u0001\u0004\tI$A\u0004ce>\\WM]:\u0011\u000b\u0005m\u0012Q\t\f\u000f\t\u0005u\u0012\u0011\t\b\u0004y\u0005}\u0012\"A\u0006\n\u0007\u0005\r#\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\t\u0013R,'/\u00192mK*\u0019\u00111\t\u0006\t\u000f\u00055\u0013\u0011\u0006a\u0001a\u0006aA.[:uK:,'OT1nK\"A\u0011\u0011KA\u0015\u0001\u0004\t\u0019&\u0001\u000egS2$XM]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000fE\u0002\n\u0003+J1!a\u0016\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a\u0017\u0001\t\u0013\ti&\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\t\u0003?\n9(a\u001f\u0002~A!\u0011\"UA1!\u0019\tY$!\u0012\u0002dA!\u0011QMA9\u001d\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6i\u0006A!/Z9vKN$8/\u0003\u0003\u0002p\u0005%\u0014\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0013\u0011\t\u0019(!\u001e\u0003#A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018M\u0003\u0003\u0002p\u0005%\u0004bBA=\u00033\u0002\r!O\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003\u001b\nI\u00061\u0001q\u0011!\ty(!\u0017A\u0002\u0005M\u0013!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiNDq!a!\u0001\t\u0003\t))\u0001\thKR\fE.\u001b<f\u000b:$\u0007o\\5oiR1\u0011qQAE\u0003\u0017\u00032!C)~\u0011\u0019)\u0012\u0011\u0011a\u0001-!9\u0011QJAA\u0001\u0004\u0001\bbBAH\u0001\u0011\u0005\u0011\u0011S\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\u0002\"a%\u0002\u001c\u0006\u0015\u0016q\u0015\t\u0006]\u0006E\u0012Q\u0013\t\u0005\u0003K\n9*\u0003\u0003\u0002\u001a\u0006U$!\u0004+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002\u001e\u00065\u0005\u0019AAP\u0003\u0019!x\u000e]5dgB!a.!):\u0013\r\t\u0019+\u000e\u0002\u0004'\u0016$\bbBA'\u0003\u001b\u0003\r\u0001\u001d\u0005\u000b\u0003\u007f\ni\t%AA\u0002\u0005M\u0003bBAV\u0001\u0011\u0005\u0011QV\u0001\rO\u0016$\u0018\t\u001c7U_BL7m\u001d\u000b\u0003\u0003?Cq!!-\u0001\t\u0003\t\u0019,\u0001\u000bhKRtuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0005\u0003?\u000b)\f\u0003\u0005\u0002\u001e\u0006=\u0006\u0019AAP\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000bQ\"[:Ce>\\WM]!mSZ,G\u0003BA*\u0003{Ca!FA\\\u0001\u00041\u0002bBAa\u0001\u0011\u0005\u00111Y\u0001\u0010O\u0016$\u0018\t\\5wK\n\u0013xn[3sgV\u0011\u0011Q\u0019\t\u0005]\u0006E\u0012\rC\u0004\u0002J\u0002!I!a3\u00021\u0005$Gm\u0014:Va\u0012\fG/\u001a)beRLG/[8o\u0013:4w\u000eF\u0004W\u0003\u001b\fy-a5\t\u000f\u0005e\u0014q\u0019a\u0001s!9\u0011\u0011[Ad\u0001\u00041\u0012a\u00039beRLG/[8o\u0013\u0012Dq!!6\u0002H\u0002\u0007Q)A\u0005ti\u0006$X-\u00138g_\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0017\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\ti.a8\u0002bB\u0019\u0011\"U#\t\u000f\u0005e\u0014q\u001ba\u0001s!9\u0011\u0011[Al\u0001\u00041\u0002bBAs\u0001\u0011\u0005\u0011q]\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u0003\u000f\u000bI/a;\u0002n\"9\u0011\u0011PAr\u0001\u0004I\u0004bBAi\u0003G\u0004\rA\u0006\u0005\b\u0003\u001b\n\u0019\u000f1\u0001q\u0011\u0019\t\t\u0010\u0001C\u0001\u001f\u0006yq-\u001a;D_:$(o\u001c7mKJLE\rC\u0004\u0002v\u0002!\t!a>\u0002\u0017U\u0004H-\u0019;f\u0007\u0006\u001c\u0007.\u001a\u000b\u0007\u0003s\u0014\tA!\u0002\u0011\u000b9\f\t$a?\u0011\u0007y\fi0C\u0002\u0002\u0000R\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003\u0004\u0005M\b\u0019\u0001\f\u0002\u001b\r|'O]3mCRLwN\\%e\u0011!\u00119!a=A\u0002\t%\u0011!F;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\t\u0005\u0003O\u0012Y!\u0003\u0003\u0003\u000e\u0005%$!F+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0003\t\u0002\u0018M\u001d;ji&|gn\u0015;bi\u0016$v\u000eU1si&$\u0018n\u001c8Ti\u0006$X-\u00138g_R\u0019QI!\u0006\t\u0011\t]!q\u0002a\u0001\u00053\ta\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\u0005\u0003\u0002h\tm\u0011\u0002\u0002B\u000f\u0003S\u0012a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003\"\u0001!\tAa\t\u0002\u0011\r|g\u000e^1j]N$B!a\u0015\u0003&!9\u0011\u0011\u0010B\u0010\u0001\u0004I\u0004b\u0002B\u0011\u0001\u0011\u0005!\u0011\u0006\u000b\u0005\u0003'\u0012Y\u0003\u0003\u0005\u0003.\t\u001d\u0002\u0019AA~\u0003\t!\b\u000fC\u0004\u00032\u0001!IAa\r\u0002'I,Wn\u001c<f!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\u0005M#Q\u0007B\u001c\u0011\u001d\tIHa\fA\u0002eBq!!5\u00030\u0001\u0007a\u0003C\u0005\u0003<\u0001\t\n\u0011\"\u0001\u0003>\u0005Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\b\u0016\u0005\u0003'\u0012\te\u000b\u0002\u0003DA!!Q\tB(\u001b\t\u00119E\u0003\u0003\u0003J\t-\u0013!C;oG\",7m[3e\u0015\r\u0011iEC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B)\u0005\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class MetadataCache
implements Logging {
    private final int brokerId;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, PartitionStateInfo>> cache;
    private Option<Object> controllerId;
    private final scala.collection.mutable.Map<Object, Broker> aliveBrokers;
    private final scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, PartitionStateInfo>> cache() {
        return this.cache;
    }

    private Option<Object> controllerId() {
        return this.controllerId;
    }

    private void controllerId_$eq(Option<Object> x$1) {
        this.controllerId = x$1;
    }

    private scala.collection.mutable.Map<Object, Broker> aliveBrokers() {
        return this.aliveBrokers;
    }

    private scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes() {
        return this.aliveNodes;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private Seq<Node> getEndpoints(Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(this.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(String topic, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int partitionId = tuple2._1$mcI$sp();
            PartitionStateInfo partitionState = (PartitionStateInfo)tuple2._2();
            TopicAndPartition topicPartition = new TopicAndPartition(topic, partitionId);
            LeaderAndIsr leaderAndIsr = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            Option<Node> maybeLeader = this.getAliveEndpoint(leaderAndIsr.leader(), listenerName);
            Seq<Object> replicas = partitionState.allReplicas();
            Seq<Node> replicaInfo = this.getEndpoints((Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": leader not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, partitionId, Node.noNode(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                List<Object> isr = leaderAndIsr.isr();
                Seq<Node> isrInfo = this.getEndpoints((Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": in sync replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    public Option<Node> getAliveEndpoint(int brokerId, ListenerName listenerName) {
        return this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)brokerId)).map((Function1 & Serializable & scala.Serializable)nodeMap -> (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker `", "` does not have listener with name `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), listenerName})));
        }));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata((String)topic, listenerName, errorUnavailableEndpoints).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom()));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public Set<String> getAllTopics() {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().keySet().toSet());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Set)topics.$minus$minus((GenTraversableOnce)this.cache().keySet()));
    }

    public boolean isBrokerAlive(int brokerId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.aliveBrokers().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))));
    }

    public Seq<Broker> getAliveBrokers() {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveBrokers().values().toBuffer());
    }

    private void addOrUpdatePartitionInfo(String topic, int partitionId, PartitionStateInfo stateInfo) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map infos = (scala.collection.mutable.Map)this.cache().getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            infos.update((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)stateInfo);
        });
    }

    public Option<PartitionStateInfo> getPartitionInfo(String topic, int partitionId) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get((Object)BoxesRunTime.boxToInteger((int)partitionId))).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Option option = this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)leaderId));
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        }));
    }

    public Option<Object> getControllerId() {
        return this.controllerId();
    }

    public Seq<TopicPartition> updateCache(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            this.controllerId_$eq((Option<Object>)(n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n))));
            this.aliveNodes().clear();
            this.aliveBrokers().clear();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateCache$2(this, broker);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ArrayBuffer arrayBuffer;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    PartitionState info = (PartitionState)tuple2._2();
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    if (info.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo(tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker ", " deleted partition ", " from metadata cache in response to UpdateMetadata "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        arrayBuffer = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        PartitionStateInfo partitionInfo = this.partitionStateToPartitionStateInfo(info);
                        this.addOrUpdatePartitionInfo(tp.topic(), tp.partition(), partitionInfo);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker ", " cached leader info ", " for partition ", " in response to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), partitionInfo, tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UpdateMetadata request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        arrayBuffer = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer arrayBuffer2 = arrayBuffer;
                return arrayBuffer2;
            });
            return deletedPartitions;
        });
    }

    private PartitionStateInfo partitionStateToPartitionStateInfo(PartitionState partitionState) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(partitionState.leader, partitionState.leaderEpoch, (List<Object>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$5)), Buffer$.MODULE$.canBuildFrom())).toList(), partitionState.zkVersion);
        LeaderIsrAndControllerEpoch leaderInfo = new LeaderIsrAndControllerEpoch(leaderAndIsr, partitionState.controllerEpoch);
        return new PartitionStateInfo(leaderInfo, (Seq<Object>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$6)), Buffer$.MODULE$.canBuildFrom())));
    }

    public boolean contains(String topic) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cache().contains((Object)topic)));
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(String topic, int partitionId) {
        return BoxesRunTime.unboxToBoolean((Object)this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(this, topic, partitionId, infos))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ void $anonfun$updateCache$2(MetadataCache $this, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        $this.aliveBrokers().update((Object)BoxesRunTime.boxToInteger((int)broker.id), (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        $this.aliveNodes().update((Object)BoxesRunTime.boxToInteger((int)broker.id), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(MetadataCache $this, String topic$6, int partitionId$4, scala.collection.mutable.Map infos) {
        infos.remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        Object object = infos.isEmpty() ? $this.cache().remove((Object)topic$6) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.cache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.controllerId = None$.MODULE$;
        this.aliveBrokers = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aliveNodes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Kafka Metadata Cache on broker ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
    }
}

