/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001\u001d\u0011!DU3qY&\u001c\u0017MR3uG\",'O\u00117pG.LgnZ*f]\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ta!\t\\8dW&twmU3oI\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u000591\r\\;ti\u0016\u0014\u0018BA\r\u0017\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u001fuI!A\b\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0011%\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\b\u001b\u0016$(/[2t\u0011!q\u0003A!A!\u0002\u0013y\u0013\u0001\u0002;j[\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$\u0001\u0002+j[\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!\u0003\u001d\n\u0005eR!aA%oi\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0005dY&,g\u000e^%e!\tiDI\u0004\u0002?\u0005B\u0011qHC\u0007\u0002\u0001*\u0011\u0011IB\u0001\u0007yI|w\u000e\u001e \n\u0005\rS\u0011A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\u0006\t\u000b!\u0003A\u0011A%\u0002\rqJg.\u001b;?)\u001dQ5\nT'O\u001fB\u0003\"a\u0004\u0001\t\u000bM9\u0005\u0019\u0001\u000b\t\u000bm9\u0005\u0019\u0001\u000f\t\u000b\u0001:\u0005\u0019A\u0011\t\u000b9:\u0005\u0019A\u0018\t\u000bY:\u0005\u0019A\u001c\t\u000bm:\u0005\u0019\u0001\u001f\t\u000fI\u0003!\u0019!C\u0005'\u0006Q1o\\;sG\u0016tu\u000eZ3\u0016\u0003Q\u0003\"!\u0016,\u000e\u0003\u0011J!a\u0016\u0013\u0003\t9{G-\u001a\u0005\u00073\u0002\u0001\u000b\u0011\u0002+\u0002\u0017M|WO]2f\u001d>$W\r\t\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u00035\u0019xnY6fiRKW.Z8viV\tq\u0007\u0003\u0004_\u0001\u0001\u0006IaN\u0001\u000fg>\u001c7.\u001a;US6,w.\u001e;!\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\fQB\\3uo>\u00148n\u00117jK:$X#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u00154\u0013aB2mS\u0016tGo]\u0005\u0003O\u0012\u0014QBT3uo>\u00148n\u00117jK:$\bBB5\u0001A\u0003%!-\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\t\u000b-\u0004A\u0011\t7\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0003[B\u0004\"a\u00198\n\u0005=$'AD\"mS\u0016tGOU3ta>t7/\u001a\u0005\u0006c*\u0004\rA]\u0001\u000fe\u0016\fX/Z:u\u0005VLG\u000eZ3sa\r\u0019\u0018\u0011\u0003\t\u0006i\u0006\u001d\u0011Q\u0002\b\u0004k\u0006\u0005aB\u0001<\u007f\u001d\t9XP\u0004\u0002yy:\u0011\u0011p\u001f\b\u0003\u007fiL\u0011AK\u0005\u0003Q%J!!B\u0014\n\u0005\u00152\u0013BA@%\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0002\u0003\u000b\tq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0006\u0003\u007f\u0012JA!!\u0003\u0002\f\t9!)^5mI\u0016\u0014(\u0002BA\u0002\u0003\u000b\u0001B!a\u0004\u0002\u00121\u0001AaCA\na\u0006\u0005\t\u0011!B\u0001\u0003+\u00111a\u0018\u00133#\u0011\t9\"!\b\u0011\u0007%\tI\"C\u0002\u0002\u001c)\u0011qAT8uQ&tw\r\u0005\u0003\u0002 \u0005\u0005RBAA\u0003\u0013\u0011\t\u0019#!\u0002\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!a\n\u0001\t\u0003\tI#A\u0003dY>\u001cX\r\u0006\u0002\u0002,A\u0019\u0011\"!\f\n\u0007\u0005=\"B\u0001\u0003V]&$\b")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final Time time;
    private final Node sourceNode;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout())) {
                throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeout())})));
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceBroker.id())).toString());
            throw e;
        }
        return clientResponse;
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId) {
        this.sourceBroker = sourceBroker;
        this.time = time;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)brokerConfig.interBrokerListenerName(), (String)brokerConfig.saslMechanismInterBrokerProtocol(), (boolean)brokerConfig.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceBroker.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder);
        this.networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), time, false, new ApiVersions());
    }
}

