/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tet!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u0001tG\u0004\u00022kA\u0011!GD\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0005Yr\u0011A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\b\t\u000bmJA\u0011\u0001\u001f\u0002\u000f\r|gn];nKRQq%P&W7v\u000b\tP!\u0002\t\u000byR\u0004\u0019A \u0002\u0011\r|gn];nKJ\u0004B\u0001Q#H\u000f6\t\u0011I\u0003\u0002?\u0005*\u00111\tR\u0001\bG2LWM\u001c;t\u0015\t)A$\u0003\u0002G\u0003\ni1*\u00194lC\u000e{gn];nKJ\u00042!D\u0017I!\ti\u0011*\u0003\u0002K\u001d\t!!)\u001f;f\u0011\u0015a%\b1\u0001N\u0003\u0019!x\u000e]5dgB\u0019ajU\u0018\u000f\u0005=\u000bfB\u0001\u001aQ\u0013\u0005y\u0011B\u0001*\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\t1K7\u000f\u001e\u0006\u0003%:AQa\u0016\u001eA\u0002a\u000bQaY8v]R\u0004\"!D-\n\u0005is!\u0001\u0002'p]\u001eDQ\u0001\u0018\u001eA\u0002a\u000bq\u0001^5nK>,H\u000fC\u0003_u\u0001\u0007q,\u0001\u0004d_:4\u0017n\u001a\t\u0003A\u0006l\u0011!\u0003\u0004\u0005E&\u00011M\u0001\nD_:\u001cX/\\3s!\u0016\u0014hmQ8oM&<7CA1e!\tAQ-\u0003\u0002g\u0005\tQ\u0001+\u001a:g\u0007>tg-[4\t\u0011-\n'\u0011!Q\u0001\n1BQaE1\u0005\u0002%$\"a\u00186\t\u000b-B\u0007\u0019\u0001\u0017\t\u000f1\f'\u0019!C\u0001[\u0006a!p[\"p]:,7\r^(qiV\ta\u000eE\u0002pe>j\u0011\u0001\u001d\u0006\u0002c\u0006Q!n\u001c9ug&l\u0007\u000f\\3\n\u0005M\u0004(aG!sOVlWM\u001c;BG\u000e,\u0007\u000f^5oO>\u0003H/[8o'B,7\r\u0003\u0004vC\u0002\u0006IA\\\u0001\u000eu.\u001cuN\u001c8fGR|\u0005\u000f\u001e\u0011\t\u000f]\f'\u0019!C\u0001[\u0006\u0019\"m\\8ugR\u0014\u0018\r]*feZ,'o](qi\"1\u00110\u0019Q\u0001\n9\fACY8piN$(/\u00199TKJ4XM]:PaR\u0004\u0003bB>b\u0005\u0004%\t!\\\u0001\ti>\u0004\u0018nY(qi\"1Q0\u0019Q\u0001\n9\f\u0011\u0002^8qS\u000e|\u0005\u000f\u001e\u0011\t\u000f}\f'\u0019!C\u0001[\u0006QqM]8va&#w\n\u001d;\t\u000f\u0005\r\u0011\r)A\u0005]\u0006YqM]8va&#w\n\u001d;!\u0011%\t9!\u0019b\u0001\n\u0003\tI!\u0001\u0007gKR\u001c\u0007nU5{K>\u0003H/\u0006\u0002\u0002\fA!qN]A\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!aB%oi\u0016<WM\u001d\u0005\t\u0003?\t\u0007\u0015!\u0003\u0002\f\u0005ia-\u001a;dQNK'0Z(qi\u0002B\u0011\"a\tb\u0005\u0004%\t!!\n\u0002/I,7/\u001a;CK\u001eLgN\\5oO>3gm]3u\u001fB$XCAA\u0014!\ry\u0017\u0011F\u0005\u0004\u0003W\u0001(!E(qi&|gn\u00159fG\n+\u0018\u000e\u001c3fe\"A\u0011qF1!\u0002\u0013\t9#\u0001\rsKN,GOQ3hS:t\u0017N\\4PM\u001a\u001cX\r^(qi\u0002B\u0011\"a\rb\u0005\u0004%\t!!\u0003\u0002'M|7m[3u\u0005V4g-\u001a:TSj,w\n\u001d;\t\u0011\u0005]\u0012\r)A\u0005\u0003\u0017\tAc]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaR\u0004\u0003\"CA\u001eC\n\u0007I\u0011AA\u0005\u00035qW/\u001c+ie\u0016\fGm](qi\"A\u0011qH1!\u0002\u0013\tY!\u0001\bok6$\u0006N]3bIN|\u0005\u000f\u001e\u0011\t\u0013\u0005\r\u0013M1A\u0005\u0002\u0005%\u0011A\u00048v[\u001a+Go\u00195feN|\u0005\u000f\u001e\u0005\t\u0003\u000f\n\u0007\u0015!\u0003\u0002\f\u0005ya.^7GKR\u001c\u0007.\u001a:t\u001fB$\b\u0005C\u0005\u0002L\u0005\u0014\r\u0011\"\u0001\u0002&\u0005qa.Z<D_:\u001cX/\\3s\u001fB$\b\u0002CA(C\u0002\u0006I!a\n\u0002\u001f9,woQ8ogVlWM](qi\u0002B\u0001\"a\u0015b\u0005\u0004%\t!\\\u0001\u0012G>t7/^7fe\u000e{gNZ5h\u001fB$\bbBA,C\u0002\u0006IA\\\u0001\u0013G>t7/^7fe\u000e{gNZ5h\u001fB$\b\u0005C\u0005\u0002\\\u0005\u0014\r\u0011\"\u0001\u0002&\u0005y\u0001O]5oi6+GO]5dg>\u0003H\u000f\u0003\u0005\u0002`\u0005\u0004\u000b\u0011BA\u0014\u0003A\u0001(/\u001b8u\u001b\u0016$(/[2t\u001fB$\b\u0005C\u0005\u0002d\u0005\u0014\r\u0011\"\u0001\u0002f\u00059q\u000e\u001d;j_:\u001cXCAA4!\ry\u0017\u0011N\u0005\u0004\u0003W\u0002(!C(qi&|gnU3u\u0011!\ty'\u0019Q\u0001\n\u0005\u001d\u0014\u0001C8qi&|gn\u001d\u0011\t\u0013\u0005M\u0014M1A\u0005\u0002\u0005U\u0014AD;tK>cGmQ8ogVlWM]\u000b\u0003\u0003o\u00022!DA=\u0013\r\tYH\u0004\u0002\b\u0005>|G.Z1o\u0011!\ty(\u0019Q\u0001\n\u0005]\u0014aD;tK>cGmQ8ogVlWM\u001d\u0011\t\u0013\u0005\r\u0015M1A\u0005\u0002\u0005U\u0014\u0001\u00049sS:$X*\u001a;sS\u000e\u001c\b\u0002CADC\u0002\u0006I!a\u001e\u0002\u001bA\u0014\u0018N\u001c;NKR\u0014\u0018nY:!\u0011%\tY)\u0019b\u0001\n\u0003\ti)A\u0003qe>\u00048/\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006U\u0011\u0001B;uS2LA!!'\u0002\u0014\nQ\u0001K]8qKJ$\u0018.Z:\t\u0011\u0005u\u0015\r)A\u0005\u0003\u001f\u000ba\u0001\u001d:paN\u0004\u0003\"CAQC\n\u0007I\u0011AAR\u0003)qW/\u001c+ie\u0016\fGm]\u000b\u0003\u0003K\u00032!DAT\u0013\r\tIK\u0004\u0002\u0004\u0013:$\b\u0002CAWC\u0002\u0006I!!*\u0002\u00179,X\u000e\u00165sK\u0006$7\u000f\t\u0005\n\u0003c\u000b'\u0019!C\u0001\u0003g\u000bQ\u0001^8qS\u000e,\u0012a\f\u0005\b\u0003o\u000b\u0007\u0015!\u00030\u0003\u0019!x\u000e]5dA!I\u00111X1C\u0002\u0013\u0005\u0011QX\u0001\f]VlW*Z:tC\u001e,7/F\u0001Y\u0011\u001d\t\t-\u0019Q\u0001\na\u000bAB\\;n\u001b\u0016\u001c8/Y4fg\u0002B\u0011\"!2b\u0005\u0004%\t!a)\u0002#I,\u0007o\u001c:uS:<\u0017J\u001c;feZ\fG\u000e\u0003\u0005\u0002J\u0006\u0004\u000b\u0011BAS\u0003I\u0011X\r]8si&tw-\u00138uKJ4\u0018\r\u001c\u0011\t\u0013\u00055\u0017M1A\u0005\u0002\u0005U\u0014!E:i_^$U\r^1jY\u0016$7\u000b^1ug\"A\u0011\u0011[1!\u0002\u0013\t9(\u0001\ntQ><H)\u001a;bS2,Gm\u0015;biN\u0004\u0003\"CAkC\n\u0007I\u0011AAl\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0003\u00033\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f)\"\u0001\u0003uKb$\u0018\u0002BAr\u0003;\u0014\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\t\u0011\u0005\u001d\u0018\r)A\u0005\u00033\f1\u0002Z1uK\u001a{'/\\1uA!I\u00111^1C\u0002\u0013\u0005\u0011QO\u0001\u000bQ&$W\rS3bI\u0016\u0014\b\u0002CAxC\u0002\u0006I!a\u001e\u0002\u0017!LG-\u001a%fC\u0012,'\u000f\t\u0005\b\u0003gT\u0004\u0019AA{\u0003E!x\u000e^1m\u001b\u0016\u001c8/Y4fgJ+\u0017\r\u001a\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003\u0019\tGo\\7jG*!\u0011q`AJ\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005\u0007\tIP\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDqAa\u0002;\u0001\u0004\t)0\u0001\bu_R\fGNQ=uKN\u0014V-\u00193\t\u000f\t-\u0011\u0002\"\u0001\u0003\u000e\u0005!\u0002O]5oiB\u0013xn\u001a:fgNlUm]:bO\u0016$\u0012c\nB\b\u0005'\u00119Ba\u0007\u0003 \t\r\"q\u0005B\u0016\u0011!\u0011\tB!\u0003A\u0002\u0005\u0015\u0016AA5e\u0011\u001d\u0011)B!\u0003A\u0002a\u000b\u0011BY=uKN\u0014V-\u00193\t\u000f\te!\u0011\u0002a\u00011\u0006iA.Y:u\u0005f$Xm\u001d*fC\u0012DqA!\b\u0003\n\u0001\u0007\u0001,\u0001\u0007nKN\u001c\u0018mZ3t%\u0016\fG\rC\u0004\u0003\"\t%\u0001\u0019\u0001-\u0002!1\f7\u000f^'fgN\fw-Z:SK\u0006$\u0007b\u0002B\u0013\u0005\u0013\u0001\r\u0001W\u0001\bgR\f'\u000f^'t\u0011\u001d\u0011IC!\u0003A\u0002a\u000bQ!\u001a8e\u001bND\u0001\"!6\u0003\n\u0001\u0007\u0011\u0011\u001c\u0004\u0007\u0005_I\u0001A!\r\u0003%\r{gn];nKJ\u0004VM\u001d4UQJ,\u0017\rZ\n\u0005\u0005[\u0011\u0019\u0004\u0005\u0003\u0002\u0010\tU\u0012\u0002\u0002B\u001c\u0003#\u0011a\u0001\u00165sK\u0006$\u0007b\u0003B\u001e\u0005[\u0011\t\u0011)A\u0005\u0003K\u000b\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\u0005\u000b\u0005\u007f\u0011iC!A!\u0002\u0013y\u0013\u0001\u00028b[\u0016D1Ba\u0011\u0003.\t\u0005\t\u0015!\u0003\u0003F\u000511\u000f\u001e:fC6\u0004bAa\u0012\u0003L\u001d;UB\u0001B%\u0015\tqD!\u0003\u0003\u0003N\t%#aC&bM.\f7\u000b\u001e:fC6D\u0011B\u0018B\u0017\u0005\u0003\u0005\u000b\u0011B0\t\u0017\u0005M(Q\u0006B\u0001B\u0003%\u0011Q\u001f\u0005\f\u0005\u000f\u0011iC!A!\u0002\u0013\t)\u0010C\u0006\u0003X\t5\"\u0011!Q\u0001\n\te\u0013aD2p]N,X.\u001a:US6,w.\u001e;\u0011\t\u0005](1L\u0005\u0005\u0005;\nIPA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\b'\t5B\u0011\u0001B1)A\u0011\u0019G!\u001a\u0003h\t%$1\u000eB7\u0005_\u0012\t\bE\u0002a\u0005[A\u0001Ba\u000f\u0003`\u0001\u0007\u0011Q\u0015\u0005\b\u0005\u007f\u0011y\u00061\u00010\u0011!\u0011\u0019Ea\u0018A\u0002\t\u0015\u0003B\u00020\u0003`\u0001\u0007q\f\u0003\u0005\u0002t\n}\u0003\u0019AA{\u0011!\u00119Aa\u0018A\u0002\u0005U\b\u0002\u0003B,\u0005?\u0002\rA!\u0017\t\u0011\tU$Q\u0006C!\u0005o\n1A];o)\u00059\u0003")
public final class ConsumerPerformance {
    public static void printProgressMessage(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printProgressMessage(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)("perf-consumer-" + new Random().nextInt(100000)), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder printMetricsOpt = this.parser().accepts("print-metrics", "Print out the metrics. This only applies to new consumer.");
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final boolean printMetrics;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSpecBuilder printMetricsOpt() {
            return this.printMetricsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public boolean printMetrics() {
            return this.printMetrics;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            this.printMetrics = this.options().has((OptionSpec)this.printMetricsOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps((String)((String)this.options().valueOf(this.consumerConfigOpt()))) : new Properties();
            if (!this.useOldConsumer()) {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("max.partition.fetch.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            } else {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            }
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            block7: {
                long startMs;
                long bytesRead = 0L;
                long messagesRead = 0L;
                long lastReportTime = startMs = System.currentTimeMillis();
                long lastBytesRead = 0L;
                long lastMessagesRead = 0L;
                try {
                    Iterator iter = this.stream.iterator();
                    while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                        Object messageAndMetadata = iter.next();
                        ++messagesRead;
                        bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                        if (this.config.showDetailedStats()) {
                            ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                        }
                        lastReportTime = currentTimeMillis;
                        lastMessagesRead = messagesRead;
                        lastBytesRead = bytesRead;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                }
                catch (ConsumerTimeoutException consumerTimeoutException) {
                    this.consumerTimeout.set(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.totalMessagesRead.addAndGet(messagesRead);
                this.totalBytesRead.addAndGet(bytesRead);
                if (!this.config.showDetailedStats()) break block7;
                ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

