/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0015\r\u0011\"\u0003\u000f\u0003\u0019\u0019wN\u001c4jOV\tq\u0002\u0005\u0002\n!%\u0011\u0011C\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011B\b\u0002\u000f\r|gNZ5hA!AQ\u0003\u0001BC\u0002\u0013%a#A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!!\u0006\u000e\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0013DA\u0004NKR\u0014\u0018nY:\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005!A/[7f+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ti#F\u0001\u0003US6,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000bQLW.\u001a\u0011\t\u000bE\u0002A\u0011\u0001\u001a\u0002\rqJg.\u001b;?)\u0011\u0019D'\u000e\u001c\u0011\u0005%\u0001\u0001\"B\u00071\u0001\u0004y\u0001\"B\u000b1\u0001\u00049\u0002\"\u0002\u00141\u0001\u0004A\u0003b\u0002\u001d\u0001\u0005\u0004%\t!O\u0001\u0012[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001bX#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\t1{gn\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001e\u0002%5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u0005\u0006\u0007\u0002!\t\u0001R\u0001\rKb,W\u000e\u001d;TK:\u001cxN]\u000b\u0002\u000bB\u0011\u0001DR\u0005\u0003\u000ff\u0011aaU3og>\u0014\b\"B%\u0001\t\u0003Q\u0015\u0001\u0004:fG>\u0014H-\u0012=f[B$HCA&O!\tYD*\u0003\u0002Ny\t!QK\\5u\u0011\u0015y\u0005\n1\u0001Q\u0003\u00151\u0018\r\\;f!\tY\u0014+\u0003\u0002Sy\t1Ai\\;cY\u0016DQ\u0001\u0016\u0001\u0005\u0002U\u000ba#\\1zE\u0016\u0014VmY8sI\u0006sG\r\u00165s_R$H.\u001a\u000b\u0004\u0017Z\u0013\u0007\"B,T\u0001\u0004A\u0016a\u0002:fcV,7\u000f\u001e\t\u00033~s!AW/\u000e\u0003mS!\u0001\u0018\u0003\u0002\u000f9,Go^8sW&\u0011alW\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\t\u0001\u0017MA\u0004SKF,Xm\u001d;\u000b\u0005y[\u0006\"B2T\u0001\u0004!\u0017\u0001F:f]\u0012\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003<K\u001e\\\u0015B\u00014=\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002<Q&\u0011\u0011\u000e\u0010\u0002\u0004\u0013:$\b\"B6\u0001\t\u0003a\u0017!E7bs\n,'+Z2pe\u0012,\u00050Z7qiR\u00111*\u001c\u0005\u0006/*\u0004\r\u0001\u0017\u0005\u0006_\u0002!\t\u0006]\u0001\ri\"\u0014x\u000e\u001e;mKRKW.\u001a\u000b\u0004uE4\b\"\u0002:o\u0001\u0004\u0019\u0018\u0001D2mS\u0016tG/T3ue&\u001c\u0007C\u0001\ru\u0013\t)\u0018DA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007\"B\u0007o\u0001\u00049\bC\u0001\ry\u0013\tI\u0018D\u0001\u0007NKR\u0014\u0018nY\"p]\u001aLw\rC\u0003|\u0001\u0011EC0\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0006{\u0006\r\u0011Q\u0004\t\u0003}~l\u0011AG\u0005\u0004\u0003\u0003Q\"AC'fiJL7MT1nK\"9\u0011Q\u0001>A\u0002\u0005\u001d\u0011!D:b]&$\u0018N_3e+N,'\u000f\u0005\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003'\u00012!!\u0004=\u001b\t\tyAC\u0002\u0002\u0012\u0019\ta\u0001\u0010:p_Rt\u0014bAA\u000by\u00051\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eT1!!\u0006=\u0011\u001d\tyB\u001fa\u0001\u0003\u000f\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\b\u0003G\u0001A\u0011BA\u0013\u0003A)\u00070Z7qi6+GO]5d\u001d\u0006lW-F\u0001~\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t\u0001#\u001a=f[B$8+\u001a8t_Jt\u0015-\\3\u0016\u0005\u0005\u001d\u0001bBA\u0018\u0001\u0011%\u0011\u0011G\u0001\u0012]\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,Gc\u0001)\u00024!9\u0011QGA\u0017\u0001\u0004Q\u0014!\u00028b]>\u001c\b")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public void maybeRecordAndThrottle(RequestChannel.Request request, Function1<Object, BoxedUnit> sendResponseCallback) {
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        if (this.quotasEnabled()) {
            ClientSensors quotaSensors = this.getOrCreateQuotaSensors(request.session().sanitizedUser(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNoThrottle(quotaSensors, this.nanosToPercentage(timeNanos))));
            this.recordAndThrottleOnQuotaViolation(quotaSensors, this.nanosToPercentage(request.requestThreadTimeNanos()), sendResponseCallback);
        } else {
            sendResponseCallback.apply$mcVI$sp(0);
        }
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        block0: {
            if (!this.quotasEnabled()) break block0;
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExempt(this.nanosToPercentage(timeNanos))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        return package$.MODULE$.min(super.throttleTime(clientMetric, config), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return "exempt-" + QuotaType$Request$.MODULE$;
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

