/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$Throttle$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final ReassignPartitionsCommand.Throttle NoThrottle;
    private final String AnyLogDir;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Map<TopicPartitionReplica, String> $lessinit$greater$default$4() {
        return scala.collection.Map$.MODULE$.empty();
    }

    public AdminUtilities $lessinit$greater$default$5() {
        return AdminUtils$.MODULE$;
    }

    public ReassignPartitionsCommand.Throttle NoThrottle() {
        return this.NoThrottle;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        Option<AdminClient> adminClientOpt = this.createAdminClient(opts);
        try (ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());){
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkUtils, adminClientOpt, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkUtils, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkUtils, adminClientOpt, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)("Partitions reassignment failed due to " + e.getMessage()));
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
    }

    private Option<AdminClient> createAdminClient(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        None$ none$;
        if (opts.options().has(opts.bootstrapServerOpt())) {
            Properties props = new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            props.put("client.id", "reassign-partitions-tool");
            none$ = new Some((Object)AdminClient.create((Properties)props));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void verifyAssignment(ZkUtils zkUtils, Option<AdminClient> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils.readFileAsString((String)jsonFile);
        this.verifyAssignment(zkUtils, adminClientOpt, jsonString);
    }

    public void verifyAssignment(ZkUtils zkUtils, Option<AdminClient> adminClientOpt, String jsonString) {
        Predef$.MODULE$.println((Object)"Status of partition reassignment: ");
        Tuple2<Seq<Tuple2<TopicAndPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsToBeReassigned, (Object)replicaAssignment);
        Tuple2 tuple23 = tuple22;
        Seq partitionsToBeReassigned2 = (Seq)tuple23._1();
        Map replicaAssignment2 = (Map)tuple23._2();
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfPartitionReassignmentSucceeded(zkUtils, (Map<TopicAndPartition, Seq<Object>>)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()));
        Map<TopicPartitionReplica, ReassignmentStatus> replicaReassignmentStatus = this.checkIfReplicaReassignmentSucceeded(adminClientOpt, (Map<TopicPartitionReplica, String>)replicaAssignment2);
        reassignedPartitionsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$1(x0$1);
            return BoxedUnit.UNIT;
        });
        replicaReassignmentStatus.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$2(x0$2);
            return BoxedUnit.UNIT;
        });
        this.removeThrottle(zkUtils, (Map<TopicAndPartition, Seq<Object>>)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()), reassignedPartitionsStatus, this.removeThrottle$default$4());
    }

    public void removeThrottle(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus, AdminUtilities admin) {
        block1: {
            BooleanRef changed = BooleanRef.create((boolean)false);
            if (!reassignedPartitionsStatus.forall((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$removeThrottle$1(x0$3)))) break block1;
            ((IterableLike)zkUtils.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
                block0: {
                    Properties configs = admin.fetchEntityConfig(zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                    if (!(configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null)) break block0;
                    admin.changeBrokerConfig(zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                    changed$1.elem = true;
                }
            });
            Seq topics = (Seq)((SetLike)partitionsToBeReassigned.keySet().map((Function1 & Serializable & scala.Serializable)tp -> tp.topic(), Set$.MODULE$.canBuildFrom())).toSeq().distinct();
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ReassignPartitionsCommand$.$anonfun$removeThrottle$5(zkUtils, admin, changed, topic);
                return BoxedUnit.UNIT;
            });
            if (changed.elem) {
                Predef$.MODULE$.println((Object)"Throttle was removed.");
            }
        }
    }

    public AdminUtilities removeThrottle$default$4() {
        return AdminUtils$.MODULE$;
    }

    public void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt()))).split(','))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$generateAssignment$1(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString((String)topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkUtils, (Seq<Object>)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map proposedAssignments = (Map)tuple2._1();
        Map currentAssignments = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)proposedAssignments, (Object)currentAssignments);
        Tuple2 tuple23 = tuple22;
        Map proposedAssignments2 = (Map)tuple23._1();
        Map currentAssignments2 = (Map)tuple23._2();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)currentAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)proposedAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentAssignment = zkUtils.getReplicaAssignmentForTopics(topicsToReassign);
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            String string = tp.topic();
            return string;
        });
        Product rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        Seq<BrokerMetadata> brokerMetadatas = AdminUtils$.MODULE$.getBrokerMetadatas(zkUtils, (RackAwareMode)rackAwareMode, (Option<Seq<Object>>)new Some(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Seq seq;
            scala.collection.mutable.Map assignment;
            String topic;
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                Seq replicas;
                topic = (String)tuple2._1();
                assignment = (scala.collection.mutable.Map)tuple2._2();
                Tuple2 tuple22 = (Tuple2)assignment.head();
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                seq = replicas = (Seq)tuple22._2();
            } else {
                throw new MatchError((Object)tuple2);
            }
            Seq replicas = seq;
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), replicas.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionsToBeReassigned.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)replicas);
                return tuple22;
            }, scala.collection.Map$.MODULE$.canBuildFrom()));
            return map;
        });
        return new Tuple2((Object)partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(ZkUtils zkUtils, Option<AdminClient> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String reassignmentJsonString = Utils.readFileAsString((String)reassignmentJsonFile);
        long throttle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.throttleOpt()));
        long timeoutMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt()));
        this.executeAssignment(zkUtils, adminClientOpt, reassignmentJsonString, new ReassignPartitionsCommand.Throttle(throttle, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$2()), timeoutMs);
    }

    public void executeAssignment(ZkUtils zkUtils, Option<AdminClient> adminClientOpt, String reassignmentJsonString, ReassignPartitionsCommand.Throttle throttle, long timeoutMs) {
        Tuple2<Seq<Tuple2<TopicAndPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseAndValidate(zkUtils, reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionAssignment = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
        Tuple2 tuple23 = tuple22;
        Seq partitionAssignment2 = (Seq)tuple23._1();
        Map replicaAssignment2 = (Map)tuple23._2();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkUtils, adminClientOpt, (Map<TopicAndPartition, Seq<Object>>)partitionAssignment2.toMap(Predef$.MODULE$.$conforms()), (Map<TopicPartitionReplica, String>)replicaAssignment2, this.$lessinit$greater$default$5());
        if (zkUtils.pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath())) {
            Predef$.MODULE$.println((Object)"There is an existing assignment running.");
            reassignPartitionsCommand.maybeLimit(throttle);
        } else {
            this.printCurrentAssignment(zkUtils, (Seq<String>)((Seq)partitionAssignment2.map((Function1 & Serializable & scala.Serializable)x$6 -> ((TopicAndPartition)x$6._1()).topic(), Seq$.MODULE$.canBuildFrom())));
            if (throttle.value() >= 0L) {
                Predef$.MODULE$.println((Object)String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
            }
            if (reassignPartitionsCommand.reassignPartitions(throttle, timeoutMs)) {
                Predef$.MODULE$.println((Object)"Successfully started reassignment of partitions.");
            } else {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAssignment2})));
            }
        }
    }

    public long executeAssignment$default$5() {
        return 10000L;
    }

    public void printCurrentAssignment(ZkUtils zkUtils, Seq<String> topics) {
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = zkUtils.getReplicaAssignmentForTopics(topics);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public String formatAsReassignmentJson(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Seq replicas;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$7;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    replicas = (Seq)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String topic = topicAndPartition.topic();
            int partition = topicAndPartition.partition();
            Map map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)partition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)replicas), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log_dirs"), replicas.map((Function1 & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$2(replicaLogDirAssignment, topic, partition, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom()))}));
            return map;
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    public Tuple2<Seq<Tuple2<TopicAndPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Map replicaAssignment = Map$.MODULE$.empty();
        Option$.MODULE$.option2Iterable(Json$.MODULE$.parseFull(jsonData)).toSeq().foreach((Function1 & Serializable & scala.Serializable)js -> {
            ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, js);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
    }

    public Tuple2<Seq<Tuple2<TopicAndPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parseAndValidate(ZkUtils zkUtils, String reassignmentJsonString) {
        Tuple2<Seq<Tuple2<TopicAndPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsToBeReassigned, (Object)replicaAssignment);
        Tuple2 tuple23 = tuple22;
        Seq partitionsToBeReassigned2 = (Seq)tuple23._1();
        Map replicaAssignment2 = (Map)tuple23._2();
        if (partitionsToBeReassigned2.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        if (partitionsToBeReassigned2.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$1(x$9)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
            TopicAndPartition tp;
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
            return topicAndPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$4(x0$11)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
                Tuple2 tuple2 = x0$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                Iterable duplicateReplicas = (Iterable)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$13 -> {
            Tuple2 tuple2 = x0$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            String string = tp.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> existingAssignment = zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
        Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$14 -> {
            TopicAndPartition tp;
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
            return topicAndPartition;
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)existingAssignment.contains((Object)key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException("The proposed assignment contains non-existent partitions: " + nonExistentPartitions);
        }
        Seq<Object> existingBrokerIDs = zkUtils.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()).values().flatten((Function1)Predef$.MODULE$.$conforms())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            throw new AdminCommandFailedException("The proposed assignment contains non-existent brokerIDs: " + nonExistingBrokerIDs.mkString(","));
        }
        replicaAssignment2.foreach((Function1 & Serializable & scala.Serializable)x0$15 -> {
            ReassignPartitionsCommand$.$anonfun$parseAndValidate$10(existingAssignment, x0$15);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)partitionsToBeReassigned2, (Object)replicaAssignment2);
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        Map partitionsBeingReassigned = zkUtils.getPartitionsBeingReassigned().mapValues((Function1 & Serializable & scala.Serializable)x$10 -> x$10.newReplicas());
        return ((TraversableOnce)partitionsToBeReassigned.keys().map((Function1 & Serializable & scala.Serializable)topicAndPartition -> new Tuple2(topicAndPartition, (Object)MODULE$.checkIfPartitionReassignmentSucceeded(zkUtils, (TopicAndPartition)topicAndPartition, partitionsToBeReassigned, (Map<TopicAndPartition, Seq<Object>>)partitionsBeingReassigned)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<TopicPartitionReplica, ReassignmentStatus> checkIfReplicaReassignmentSucceeded(Option<AdminClient> adminClientOpt, Map<TopicPartitionReplica, String> replicaAssignment) {
        scala.collection.immutable.Map map;
        if (replicaAssignment.nonEmpty()) {
            AdminClient adminClient = (AdminClient)adminClientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
            });
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeReplicaLogDirs((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(replicaAssignment.keySet()).asJava()).all().get()).asScala();
        } else {
            map = scala.collection.Map$.MODULE$.empty();
        }
        scala.collection.immutable.Map replicaLogDirInfos = map;
        return (Map)replicaAssignment.map(arg_0 -> ReassignPartitionsCommand$.$anonfun$checkIfReplicaReassignmentSucceeded$2((Map)replicaLogDirInfos, arg_0), scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Product product;
        Seq newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
        Option option = partitionsBeingReassigned.get((Object)topicAndPartition);
        if (option instanceof Some) {
            product = ReassignmentInProgress$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            Product product2;
            Seq<Object> assignedReplicas;
            Seq<Object> seq = assignedReplicas = zkUtils.getReplicasForPartition(topicAndPartition.topic(), topicAndPartition.partition());
            Seq seq2 = newReplicas;
            if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                product2 = ReassignmentCompleted$.MODULE$;
            } else {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                product2 = ReassignmentFailed$.MODULE$;
            }
            product = product2;
        } else {
            throw new MatchError((Object)option);
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        block6: {
            ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts;
            block7: {
                block5: {
                    opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
                    if (args.length == 0) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "This command moves topic partitions between replicas.");
                    }
                    int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1(opts, x$1)));
                    if (actions != 1) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
                    }
                    CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
                    if (!opts.options().has((OptionSpec)opts.verifyOpt())) break block5;
                    if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
                    }
                    CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.throttleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
                    break block6;
                }
                if (!opts.options().has((OptionSpec)opts.generateOpt())) break block7;
                if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
                }
                CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.throttleOpt(), opts.reassignmentJsonFileOpt()}))));
                break block6;
            }
            if (!opts.options().has((OptionSpec)opts.executeOpt())) break block6;
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError((Object)reassignmentStatus);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError((Object)reassignmentStatus);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$1(Tuple2 x0$3) {
        ReassignmentStatus status;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeThrottle$5(ZkUtils zkUtils$2, AdminUtilities admin$1, BooleanRef changed$1, String topic) {
        block0: {
            Properties configs = admin$1.fetchEntityConfig(zkUtils$2, ConfigType$.MODULE$.Topic(), topic);
            if (!(configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null)) break block0;
            admin$1.changeTopicConfig(zkUtils$2, topic, configs);
            changed$1.elem = true;
        }
    }

    public static final /* synthetic */ int $anonfun$generateAssignment$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$2(Map replicaLogDirAssignment$1, String topic$2, int partition$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(topic$2, partition$1, r), (Function0 & Serializable & scala.Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$6(Tuple2 x$7) {
        Object object = x$7._2();
        String string = MODULE$.AnyLogDir();
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$2(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1 & Serializable & scala.Serializable)p -> {
            Seq seq;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                Some some = (Some)option;
                JsonValue jsonValue = (JsonValue)some.value();
                seq = (Seq)jsonValue.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1 & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.MODULE$.AnyLogDir(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            Seq newLogDirs = seq;
            if (newReplicas.size() != newLogDirs.size()) {
                throw new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of replicas list ", " is different from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newReplicas})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of log dirs list ", " for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newLogDirs, new TopicAndPartition(topic, partition)})));
            }
            partitionAssignment$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip((GenIterable)newLogDirs, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int replica = tuple2._1$mcI$sp();
                String logDir = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, partition, replica)), (Object)logDir);
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$6(x$7))));
        });
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue js) {
        Option$.MODULE$.option2Iterable(js.asJsonObject().get("partitions")).toSeq().foreach((Function1 & Serializable & scala.Serializable)partitionsSeq -> {
            ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$2(partitionAssignment$1, replicaAssignment$1, partitionsSeq);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$1(Tuple2 x$9) {
        return ((SeqLike)x$9._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$4(Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable duplicatedReplicas = (Iterable)tuple2._2();
        boolean bl = duplicatedReplicas.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$parseAndValidate$10(scala.collection.mutable.Map existingAssignment$1, Tuple2 x0$15) {
        Tuple2 tuple2 = x0$15;
        if (tuple2 != null) {
            TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
            String logDir = (String)tuple2._2();
            if (((SeqLike)existingAssignment$1.getOrElse((Object)new TopicAndPartition(replica.topic(), replica.partition()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())).contains((Object)BoxesRunTime.boxToInteger((int)replica.brokerId()))) {
                throw new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The proposed assignment intends to move an existing replica ", " to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"another log directory ", " on the same broker. This is not currently supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logDir})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$checkIfReplicaReassignmentSucceeded$2(Map replicaLogDirInfos$1, Tuple2 x0$16) {
        void var3_12;
        Tuple2 tuple2 = x0$16;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
        String newLogDir = (String)tuple2._2();
        Option option = replicaLogDirInfos$1.get((Object)replica);
        if (option instanceof Some) {
            Product product;
            Some some = (Some)option;
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)some.value();
            if (replicaLogDirInfo.getCurrentReplicaLogDir() == null) {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " is not found in any live log dir on "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker ", ". There is likely offline log directory on the broker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replica.brokerId())}))));
                product = ReassignmentFailed$.MODULE$;
            } else {
                String string = replicaLogDirInfo.getFutureReplicaLogDir();
                String string2 = newLogDir;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    product = ReassignmentInProgress$.MODULE$;
                } else if (replicaLogDirInfo.getFutureReplicaLogDir() != null) {
                    Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " on broker ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition()), BoxesRunTime.boxToInteger((int)replica.brokerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is being moved to log dir ", " instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaLogDirInfo.getFutureReplicaLogDir(), newLogDir}))));
                    product = ReassignmentFailed$.MODULE$;
                } else {
                    String string3 = replicaLogDirInfo.getCurrentReplicaLogDir();
                    String string4 = newLogDir;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        product = ReassignmentCompleted$.MODULE$;
                    } else {
                        Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " on broker ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition()), BoxesRunTime.boxToInteger((int)replica.brokerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not being moved from log dir ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaLogDirInfo.getCurrentReplicaLogDir(), newLogDir}))));
                        product = ReassignmentFailed$.MODULE$;
                    }
                }
            }
            ReassignmentInProgress$ reassignmentInProgress$ = product;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " is not found in any live log dir on broker ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topic(), BoxesRunTime.boxToInteger((int)replica.partition()), BoxesRunTime.boxToInteger((int)replica.brokerId())})));
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
        }
        void status = var3_12;
        return new Tuple2((Object)replica, (Object)status);
    }

    public static final /* synthetic */ boolean $anonfun$validateAndParseArgs$1(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1, OptionSpec x$1) {
        return opts$1.options().has(x$1);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.NoThrottle = new ReassignPartitionsCommand.Throttle(-1L, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$2());
        this.AnyLogDir = "any";
    }
}

