/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0003\n\u00151aQ\"\u0001\u0002\n\u0005-\u0011!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0003M_:<\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!\u0011!Q\u0001\ni\tQa\u00184jY\u0016\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0005%|'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011AAR5mK\"I1\u0005\u0001B\u0001B\u0003%A\u0002J\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018BA\u0012\u000b\u0011%1\u0003A!A!\u0002\u00139#&\u0001\u0007nCbLe\u000eZ3y'&TX\r\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\u0004\u0013:$\u0018B\u0001\u0014\u000b\u0011%a\u0003A!A!\u0002\u0013i\u0003'\u0001\u0005xe&$\u0018M\u00197f!\tia&\u0003\u00020\u001d\t9!i\\8mK\u0006t\u0017B\u0001\u0017\u000b\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q)A'\u000e\u001c8qA\u0011\u0011\u0002\u0001\u0005\u00063E\u0002\rA\u0007\u0005\u0006GE\u0002\r\u0001\u0004\u0005\bME\u0002\n\u00111\u0001(\u0011\u001da\u0013\u0007%AA\u00025BQA\u000f\u0001\u0005Bm\n\u0011\"\u001a8uef\u001c\u0016N_3\u0016\u0003\u001dBQ!\u0010\u0001\u0005By\na![:Gk2dW#A\u0017\t\u000b\u0001\u0003A\u0011B!\u0002\u0013QLW.Z:uC6\u0004Hc\u0001\u0007C\u0015\")1i\u0010a\u0001\t\u00061!-\u001e4gKJ\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0010\u0002\u00079Lw.\u0003\u0002J\r\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b-{\u0004\u0019A\u0014\u0002\u00039DQ!\u0014\u0001\u0005\n9\u000baB]3mCRLg/Z(gMN,G\u000fF\u0002(\u001fBCQa\u0011'A\u0002\u0011CQa\u0013'A\u0002\u001dBQA\u0015\u0001\u0005\u0002M\u000b\u0011\u0002\\1ti\u0016sGO]=\u0016\u0003Q\u0003\"!C+\n\u0005Y\u0013!a\u0004+j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;\t\u000ba\u0003A\u0011A-\u0002\u000b\u0015tGO]=\u0015\u0005QS\u0006\"B&X\u0001\u00049\u0003\"\u0002/\u0001\t\u0003j\u0016A\u00039beN,WI\u001c;ssR\u0019a,\u00192\u0011\u0005%y\u0016B\u00011\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\u0006\u0007n\u0003\r\u0001\u0012\u0005\u0006\u0017n\u0003\ra\n\u0005\u0006I\u0002!\t!Z\u0001\f[\u0006L(-Z!qa\u0016tG\r\u0006\u0003gS*d\u0007CA\u0007h\u0013\tAgB\u0001\u0003V]&$\b\"\u0002!d\u0001\u0004a\u0001\"B6d\u0001\u0004a\u0011AB8gMN,G\u000fC\u0004nGB\u0005\t\u0019A\u0017\u0002\u001bM\\\u0017\u000e\u001d$vY2\u001c\u0005.Z2l\u0011\u0015y\u0007\u0001\"\u0001q\u0003\u0019awn\\6vaR\u0011A+\u001d\u0005\u0006e:\u0004\r\u0001D\u0001\u0010i\u0006\u0014x-\u001a;US6,7\u000f^1na\")A\u000f\u0001C!k\u0006AAO];oG\u0006$X\rF\u0001g\u0011\u00159\b\u0001\"\u0011y\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0003MfDQa\u001b<A\u00021AQa\u001f\u0001\u0005\nq\f\u0011\u0003\u001e:v]\u000e\fG/\u001a+p\u000b:$(/[3t)\t1W\u0010C\u0003\u007fu\u0002\u0007q%A\u0004f]R\u0014\u0018.Z:\t\r\u0005\u0005\u0001\u0001\"\u0011v\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u0013\u0005\u0015\u0001!%A\u0005\u0002\u0005\u001d\u0011!F7bs\n,\u0017\t\u001d9f]\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0013Q3!LA\u0006W\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\f\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0011\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"DA\u0010\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u0005B%\u0001\ttkB,'\u000f\n2bg\u0016|eMZ:fiV\tAbB\u0005\u0002&\t\t\t\u0011#\u0001\u0002(\u0005IA+[7f\u0013:$W\r\u001f\t\u0004\u0013\u0005%b\u0001C\u0001\u0003\u0003\u0003E\t!a\u000b\u0014\t\u0005%\u0012Q\u0006\t\u0004\u001b\u0005=\u0012bAA\u0019\u001d\t1\u0011I\\=SK\u001aDqAMA\u0015\t\u0003\t)\u0004\u0006\u0002\u0002(!Q\u0011\u0011HA\u0015#\u0003%\t!a\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiDK\u0002(\u0003\u0017A!\"!\u0011\u0002*E\u0005I\u0011AA\u0004\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = (TimestampOffset)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new TimestampOffset(this.timestamp(idx, n), this.relativeOffset(idx, n));
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> "Attempt to append to a full time index (size = " + this._entries() + ").");
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().offset()), this.file().getAbsolutePath()})));
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append a timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().timestamp()), this.file().getAbsolutePath()})));
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToLong((long)offset), this.file().getName()})));
                this.mmap().putLong(timestamp);
                this.mmap().putInt((int)(offset - this.super$baseOffset()));
                this._entries_$eq(this._entries() + 1);
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> this._entries() + " entries but file position in index is " + this.mmap().position() + ".");
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            if (slot == -1) {
                timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
            } else {
                TimestampOffset entry = (TimestampOffset)this.parseEntry(idx, slot);
                timestampOffset = new TimestampOffset(entry.timestamp(), entry.offset());
            }
            return timestampOffset;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            return this.mmap().position(this._entries() * this.entrySize());
        });
    }

    @Override
    public void sanityCheck() {
        TimestampOffset entry = this.lastEntry();
        long lastTimestamp = entry.timestamp();
        long lastOffset = entry.offset();
        Predef$.MODULE$.require(this._entries() == 0 || lastTimestamp >= this.timestamp(this.mmap(), 0), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last timestamp "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the first timestamp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastTimestamp), BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0))})));
        Predef$.MODULE$.require(this._entries() == 0 || lastOffset >= super.baseOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is smaller than the first offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOffset), BoxesRunTime.boxToLong((long)this.super$baseOffset())})));
        long len = this.file().length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0 & Serializable & scala.Serializable)() -> "Time index file " + this.file().getAbsolutePath() + " is corrupt, found " + len + " bytes which is not positive or not a multiple of 12.");
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
    }
}

