/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.common.KafkaException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u0001\u0003\u0001\u001d\u0011AbU8dW\u0016$8+\u001a:wKJT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Aa\u0002\u0006\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0011D\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\r\r|gNZ5h+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!e\b\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\u0006\u0001\u0003\u0006\u0004%\tAJ\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011qC\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005O\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!O\u001e\u000e\u0003iR!!\u0005\u0016\n\u0005qR$\u0001\u0002+j[\u0016D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0006i&lW\r\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0005\u0003!\u0019XmY;sSRL\u0018BA$E\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\t\u0011%\u0003!\u0011!Q\u0001\n\t\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD#B'P!F\u0013\u0006C\u0001(\u0001\u001b\u0005\u0011\u0001\"B\u000eK\u0001\u0004i\u0002\"B\fK\u0001\u00049\u0003\"\u0002\u001cK\u0001\u0004A\u0004\"\u0002!K\u0001\u0004\u0011\u0005b\u0002+\u0001\u0005\u0004%I!V\u0001\nK:$\u0007o\\5oiN,\u0012A\u0016\t\u0005/rs6-D\u0001Y\u0015\tI&,A\u0005j[6,H/\u00192mK*\u00111LC\u0001\u000bG>dG.Z2uS>t\u0017BA/Y\u0005\ri\u0015\r\u001d\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003\u0007)J!A\u00191\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019$\u0011aB2mkN$XM]\u0005\u0003Q\u0016\u0014\u0001\"\u00128e!>Lg\u000e\u001e\u0005\u0007U\u0002\u0001\u000b\u0011\u0002,\u0002\u0015\u0015tG\r]8j]R\u001c\b\u0005C\u0004m\u0001\t\u0007I\u0011B7\u0002'9,X\u000e\u0015:pG\u0016\u001c8o\u001c:UQJ,\u0017\rZ:\u0016\u00039\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\t1\fgn\u001a\u0006\u0002g\u0006!!.\u0019<b\u0013\t)\bOA\u0004J]R,w-\u001a:\t\r]\u0004\u0001\u0015!\u0003o\u0003QqW/\u001c)s_\u000e,7o]8s)\"\u0014X-\u00193tA!9\u0011\u0010\u0001b\u0001\n\u0013i\u0017!E7bqF+X-^3e%\u0016\fX/Z:ug\"11\u0010\u0001Q\u0001\n9\f!#\\1y#V,W/\u001a3SKF,Xm\u001d;tA!9Q\u0010\u0001b\u0001\n\u0013q\u0018!\u0006;pi\u0006d\u0007K]8dKN\u001cxN\u001d+ie\u0016\fGm]\u000b\u0002\u007fB\u0019\u0011\"!\u0001\n\u0007\u0005\r!BA\u0002J]RDq!a\u0002\u0001A\u0003%q0\u0001\fu_R\fG\u000e\u0015:pG\u0016\u001c8o\u001c:UQJ,\u0017\rZ:!\u0011!\tY\u0001\u0001b\u0001\n\u0013i\u0017aE7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\bbBA\b\u0001\u0001\u0006IA\\\u0001\u0015[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n\u001d\u0011\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0011\u0001H7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003xJ^3se&$Wm]\u000b\u0003\u0003/\u0001r!!\u0007\u0002\u001c\u0005uq0D\u0001[\u0013\ti&\f\u0005\u0003\u0002 \u00055b\u0002BA\u0011\u0003S\u00012!a\t\u000b\u001b\t\t)CC\u0002\u0002(\u0019\ta\u0001\u0010:p_Rt\u0014bAA\u0016\u0015\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000b\u000b\u0011!\t)\u0004\u0001Q\u0001\n\u0005]\u0011!H7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003xJ^3se&$Wm\u001d\u0011\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0012A\u00037pO\u000e{g\u000e^3yiV\u0011\u0011Q\b\t\u0004s\u0005}\u0012bAA!u\tQAj\\4D_:$X\r\u001f;\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003{\t1\u0002\\8h\u0007>tG/\u001a=uA!I\u0011\u0011\n\u0001C\u0002\u0013%\u00111J\u0001\u0011[\u0016lwN]=Q_>d7+\u001a8t_J,\"!!\u0014\u0011\u0007!\ny%C\u0002\u0002R%\u0012aaU3og>\u0014\b\u0002CA+\u0001\u0001\u0006I!!\u0014\u0002#5,Wn\u001c:z!>|GnU3og>\u0014\b\u0005C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\\u0005\u0019S.Z7pef\u0004vn\u001c7EKBdW\r^3e!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,WCAA/!\u0011\ty&!\u0019\u000e\u0003)J1!a\u0019+\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002^\u0005!S.Z7pef\u0004vn\u001c7EKBdW\r^3e!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007\u0005C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002\\\u0005\u0001S.Z7pef\u0004vn\u001c7EKBdW\r^3e)&lW-T3ue&\u001cg*Y7f\u0011!\ty\u0007\u0001Q\u0001\n\u0005u\u0013!I7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003\"CA:\u0001\t\u0007I\u0011BA;\u0003)iW-\\8ssB{w\u000e\\\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{R\u0013AB7f[>\u0014\u00180\u0003\u0003\u0002\u0002\u0006m$AC'f[>\u0014\u0018\u0010U8pY\"A\u0011Q\u0011\u0001!\u0002\u0013\t9(A\u0006nK6|'/\u001f)p_2\u0004\u0003\"CAE\u0001\t\u0007I\u0011AAF\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\"!!$\u0011\u00079\u000by)C\u0002\u0002\u0012\n\u0011aBU3rk\u0016\u001cHo\u00115b]:,G\u000e\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAG\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0003\"CAM\u0001\t\u0007I\u0011BAN\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u0003;\u0003R!CAP\u0003GK1!!)\u000b\u0005\u0015\t%O]1z!\rq\u0015QU\u0005\u0004\u0003O\u0013!!\u0003)s_\u000e,7o]8s\u0011!\tY\u000b\u0001Q\u0001\n\u0005u\u0015a\u00039s_\u000e,7o]8sg\u0002B!\"a,\u0001\u0005\u0004%\tAAAY\u0003%\t7mY3qi>\u00148/\u0006\u0002\u00024B9\u0011QWA^G\u0006uVBAA\\\u0015\r\tILW\u0001\b[V$\u0018M\u00197f\u0013\ri\u0016q\u0017\t\u0004\u001d\u0006}\u0016bAAa\u0005\tA\u0011iY2faR|'\u000f\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BAZ\u0003)\t7mY3qi>\u00148\u000f\t\u0005\f\u0003\u0013\u0004\u0001\u0019!a\u0001\n\u0013\tY-\u0001\td_:tWm\u0019;j_:\fVo\u001c;bgV\u0011\u0011Q\u001a\t\u0004\u001d\u0006=\u0017bAAi\u0005\t\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0005\f\u0003+\u0004\u0001\u0019!a\u0001\n\u0013\t9.\u0001\u000bd_:tWm\u0019;j_:\fVo\u001c;bg~#S-\u001d\u000b\u0005\u00033\fy\u000eE\u0002\n\u00037L1!!8\u000b\u0005\u0011)f.\u001b;\t\u0015\u0005\u0005\u00181[A\u0001\u0002\u0004\ti-A\u0002yIEB1\"!:\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002N\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\t\u0013\u0005%\b\u00011A\u0005\n\u0005-\u0018!G:u_B\u0004X\r\u001a)s_\u000e,7o]5oOJ+\u0017/^3tiN,\"!!<\u0011\u0007%\ty/C\u0002\u0002r*\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002v\u0002\u0001\r\u0011\"\u0003\u0002x\u0006i2\u000f^8qa\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t?\u0012*\u0017\u000f\u0006\u0003\u0002Z\u0006e\bBCAq\u0003g\f\t\u00111\u0001\u0002n\"A\u0011Q \u0001!B\u0013\ti/\u0001\u000eti>\u0004\b/\u001a3Qe>\u001cWm]:j]\u001e\u0014V-];fgR\u001c\b\u0005C\u0004\u0003\u0002\u0001!\tAa\u0001\u0002\u000fM$\u0018M\u001d;vaR!\u0011\u0011\u001cB\u0003\u0011)\u00119!a@\u0011\u0002\u0003\u0007\u0011Q^\u0001\u0012gR\f'\u000f^;q!J|7-Z:t_J\u001c\bb\u0002B\u0006\u0001\u0011\u0005!QB\u0001\u0010gR\f'\u000f\u001e)s_\u000e,7o]8sgR\u0011\u0011\u0011\u001c\u0005\b\u0005#\u0001A\u0011\u0001B\u0007\u0003Y\u0019Ho\u001c9Qe>\u001cWm]:j]\u001e\u0014V-];fgR\u001c\bb\u0002B\u000b\u0001\u0011\u0005!QB\u0001\tg\",H\u000fZ8x]\"9!\u0011\u0004\u0001\u0005\u0002\tm\u0011!\u00032pk:$\u0007k\u001c:u)\ry(Q\u0004\u0005\b\u0005?\u00119\u00021\u0001_\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011!\u0011\u0019\u0003\u0001C\t\u0005\t\u0015\u0012\u0001\u00048foB\u0013xnY3tg>\u0014H\u0003DAR\u0005O\u0011YC!\f\u00030\t\u0005\u0003b\u0002B\u0015\u0005C\u0001\ra`\u0001\u0003S\u0012D\u0001\"!3\u0003\"\u0001\u0007\u0011Q\u001a\u0005\b\u0005?\u0011\t\u00031\u0001_\u0011!\u0011\tD!\tA\u0002\tM\u0012\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011\u0011)D!\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\tA!Y;uQ*\u0011QIK\u0005\u0005\u0005\u007f\u00119D\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"A\u00111\u000fB\u0011\u0001\u0004\t9\b\u0003\u0005\u0003F\u0001!\tA\u0001B$\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$HcA@\u0003J!A!1\nB\"\u0001\u0004\u0011i%A\u0004bI\u0012\u0014Xm]:\u0011\t\t=#QK\u0007\u0003\u0005#R1Aa\u0015s\u0003\rqW\r^\u0005\u0005\u0005/\u0012\tFA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b\u0002\u0003B.\u0001\u0011\u0005!A!\u0018\u0002\u0013A\u0014xnY3tg>\u0014H\u0003BAR\u0005?BqA!\u0019\u0003Z\u0001\u0007q0A\u0003j]\u0012,\u0007\u0010C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003h\u0005\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t%$\u0006BAw\u0005WZ#A!\u001c\u0011\t\t=$\u0011P\u0007\u0003\u0005cRAAa\u001d\u0003v\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005oR\u0011AC1o]>$\u0018\r^5p]&!!1\u0010B9\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SocketServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endpoints;
    private final Integer numProcessorThreads;
    private final Integer maxQueuedRequests;
    private final int kafka$network$SocketServer$$totalProcessorThreads;
    private final Integer maxConnectionsPerIp;
    private final Map<String, Object> maxConnectionsPerIpOverrides;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool kafka$network$SocketServer$$memoryPool;
    private final RequestChannel requestChannel;
    private final Processor[] kafka$network$SocketServer$$processors;
    private final scala.collection.mutable.Map<EndPoint, Acceptor> acceptors;
    private ConnectionQuotas connectionQuotas;
    private boolean stoppedProcessingRequests;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return this.endpoints;
    }

    private Integer numProcessorThreads() {
        return this.numProcessorThreads;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int kafka$network$SocketServer$$totalProcessorThreads() {
        return this.kafka$network$SocketServer$$totalProcessorThreads;
    }

    private Integer maxConnectionsPerIp() {
        return this.maxConnectionsPerIp;
    }

    private Map<String, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    public MemoryPool kafka$network$SocketServer$$memoryPool() {
        return this.kafka$network$SocketServer$$memoryPool;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Processor[] kafka$network$SocketServer$$processors() {
        return this.kafka$network$SocketServer$$processors;
    }

    public scala.collection.mutable.Map<EndPoint, Acceptor> acceptors() {
        return this.acceptors;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private boolean stoppedProcessingRequests() {
        return this.stoppedProcessingRequests;
    }

    private void stoppedProcessingRequests_$eq(boolean x$1) {
        this.stoppedProcessingRequests = x$1;
    }

    public void startup(boolean startupProcessors) {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.connectionQuotas_$eq(new ConnectionQuotas(Predef$.MODULE$.Integer2int(this.maxConnectionsPerIp()), this.maxConnectionsPerIpOverrides()));
            Integer sendBufferSize = this.config().socketSendBufferBytes();
            Integer recvBufferSize = this.config().socketReceiveBufferBytes();
            int brokerId = this.config().brokerId();
            IntRef processorBeginIndex = IntRef.create((int)0);
            this.config().listeners().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
                SocketServer.$anonfun$startup$1(this, sendBufferSize, recvBufferSize, brokerId, processorBeginIndex, endpoint);
                return BoxedUnit.UNIT;
            });
            if (startupProcessors) {
                this.startProcessors();
            }
        }
        this.newGauge("NetworkProcessorAvgIdlePercent", new Gauge<Object>(this){
            private final MetricName[] ioWaitRatioMetricNames;
            private final /* synthetic */ SocketServer $outer;

            private MetricName[] ioWaitRatioMetricNames() {
                return this.ioWaitRatioMetricNames;
            }

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ioWaitRatioMetricNames())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$1(this, metricName)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.$outer.kafka$network$SocketServer$$totalProcessorThreads();
            }

            public static final /* synthetic */ double $anonfun$value$3(KafkaMetric x$1) {
                return x$1.value();
            }

            public static final /* synthetic */ double $anonfun$value$1($anon$1 $this, MetricName metricName) {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.$outer.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$3(x$1))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ioWaitRatioMetricNames = (MetricName[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$outer.kafka$network$SocketServer$$processors())).map((Function1 & Serializable & scala.Serializable)p -> $this.$outer.metrics().metricName("io-wait-ratio", "socket-server-metrics", p.metricTags()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MetricName.class)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.network.SocketServer$$anon$1 org.apache.kafka.common.MetricName ), $anonfun$value$2(), $anonfun$value$3$adapted(org.apache.kafka.common.metrics.KafkaMetric ), $anonfun$ioWaitRatioMetricNames$1(kafka.network.SocketServer$$anon$1 kafka.network.Processor )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolAvailable", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolUsed", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().size() - this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started " + this.acceptors().size() + " acceptor threads");
    }

    public boolean startup$default$1() {
        return true;
    }

    public synchronized void startProcessors() {
        this.acceptors().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.startProcessors();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started processors for ", " acceptors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.acceptors().size())})));
    }

    public void stopProcessingRequests() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping socket server request processors");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.acceptors().values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.kafka$network$SocketServer$$processors())).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
            this.requestChannel().clear();
            this.stoppedProcessingRequests_$eq(true);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped socket server request processors");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down socket server");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.stoppedProcessingRequests()) {
                this.stopProcessingRequests();
            }
            this.requestChannel().shutdown();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            n = ((Acceptor)this.acceptors().apply(this.endpoints().apply((Object)listenerName))).serverChannel().socket().getLocalPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", e);
        }
        return n;
    }

    public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol securityProtocol, MemoryPool memoryPool) {
        return new Processor(id, this.time(), Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel(), connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), listenerName, securityProtocol, this.config(), this.metrics(), this.credentialProvider(), memoryPool, this.logContext());
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.get(address))));
    }

    public Processor processor(int index) {
        return this.kafka$network$SocketServer$$processors()[index];
    }

    public static final /* synthetic */ void $anonfun$startup$1(SocketServer $this, Integer sendBufferSize$1, Integer recvBufferSize$1, int brokerId$1, IntRef processorBeginIndex$1, EndPoint endpoint) {
        ListenerName listenerName = endpoint.listenerName();
        SecurityProtocol securityProtocol = endpoint.securityProtocol();
        int processorEndIndex = processorBeginIndex$1.elem + Predef$.MODULE$.Integer2int($this.numProcessorThreads());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(processorBeginIndex$1.elem), processorEndIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            $this.kafka$network$SocketServer$$processors()[i] = $this.newProcessor(i, $this.connectionQuotas(), listenerName, securityProtocol, $this.kafka$network$SocketServer$$memoryPool());
        });
        Acceptor acceptor = new Acceptor(endpoint, Predef$.MODULE$.Integer2int(sendBufferSize$1), Predef$.MODULE$.Integer2int(recvBufferSize$1), brokerId$1, (Processor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.kafka$network$SocketServer$$processors())).slice(processorBeginIndex$1.elem, processorEndIndex), $this.connectionQuotas());
        $this.acceptors().put((Object)endpoint, (Object)acceptor);
        KafkaThread.nonDaemon((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-socket-acceptor-", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName, securityProtocol, BoxesRunTime.boxToInteger((int)endpoint.port())})), (Runnable)acceptor).start();
        acceptor.awaitStartup();
        processorBeginIndex$1.elem = processorEndIndex;
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.endpoints = ((TraversableOnce)config.listeners().map((Function1 & Serializable & scala.Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.numProcessorThreads = config.numNetworkThreads();
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.kafka$network$SocketServer$$totalProcessorThreads = Predef$.MODULE$.Integer2int(this.numProcessorThreads()) * this.endpoints().size();
        this.maxConnectionsPerIp = config.maxConnectionsPerIp();
        this.maxConnectionsPerIpOverrides = config.maxConnectionsPerIpOverrides();
        this.logContext = new LogContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SocketServer brokerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokerId())})));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", "socket-server-metrics");
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", "socket-server-metrics");
        this.memoryPoolSensor().add((CompoundStat)new org.apache.kafka.common.metrics.stats.Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName()));
        this.kafka$network$SocketServer$$memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.requestChannel = new RequestChannel(this.kafka$network$SocketServer$$totalProcessorThreads(), Predef$.MODULE$.Integer2int(this.maxQueuedRequests()));
        this.kafka$network$SocketServer$$processors = new Processor[this.kafka$network$SocketServer$$totalProcessorThreads()];
        this.acceptors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.stoppedProcessingRequests = false;
        this.requestChannel().addResponseListener((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.kafka$network$SocketServer$$processors()[id].wakeup());
    }
}

