/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AdminClientIntegrationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\ti\u0001#D\u0001\u000f\u0015\tyA!A\u0003vi&d7/\u0003\u0002\u0012\u001d\t9Aj\\4hS:<\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\tI\u0001\u0001C\u0003\u0018\u0001\u0011\u0005\u0001$A\u0007hY>\u0014\u0017\r\u001c+j[\u0016|W\u000f^\u000b\u00023A\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0006eVdWm\u001d\u0006\u0003=}\tQA[;oSRT\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001c\u0005\u001d!\u0016.\\3pkRD#A\u0006\u0013\u0011\u0005\u00152S\"A\u000f\n\u0005\u001dj\"\u0001\u0002*vY\u0016Dq!\u000b\u0001A\u0002\u0013\u0005!&\u0001\u0004dY&,g\u000e^\u000b\u0002WA\u0011A\u0006N\u0007\u0002[)\u0011afL\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003aE\nqa\u00197jK:$8O\u0003\u0002\u0006e)\u00111gH\u0001\u0007CB\f7\r[3\n\u0005Uj#aC!e[&t7\t\\5f]RDqa\u000e\u0001A\u0002\u0013\u0005\u0001(\u0001\u0006dY&,g\u000e^0%KF$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001Z\n\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015B\u0016\u0002\u000f\rd\u0017.\u001a8uA!9A\t\u0001b\u0001\n\u0003)\u0015!\u0002;pa&\u001cW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001eDaa\u0014\u0001!\u0002\u00131\u0015A\u0002;pa&\u001c\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u0013A\f'\u000f^5uS>tW#A*\u0011\u0005i\"\u0016BA+<\u0005\rIe\u000e\u001e\u0005\u0007/\u0002\u0001\u000b\u0011B*\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001.\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\f\u0005\u0002]?6\tQL\u0003\u0002_c\u000511m\\7n_:L!\u0001Y/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1!\r\u0001Q\u0001\nm\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\u0006I\u0002!\t%Z\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u00121m\u001a\t\u0003K!L!![\u000f\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0007\u0001\"\u0011f\u0003!!X-\u0019:E_^t\u0007F\u00016n!\t)c.\u0003\u0002p;\t)\u0011I\u001a;fe\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\u0016aC:feZ,'oQ8v]RDaa\u001d\u0001!\u0002\u0013\u0019\u0016\u0001D:feZ,'oQ8v]R\u0004\u0003bB;\u0001\u0005\u0004%\tAU\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r]\u0004\u0001\u0015!\u0003T\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002Bq!\u001f\u0001C\u0002\u0013\u0005!+A\u0007qe>$WoY3s\u0007>,h\u000e\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B*\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!)Q\u0010\u0001C!}\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0000!\u0019\t\t!!\u0005\u0002\u00189!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\r\u00051AH]8pizJ\u0011\u0001P\u0005\u0004\u0003\u001fY\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u0004<!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\t\u000511/\u001a:wKJLA!!\t\u0002\u001c\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tAb\u0019:fCR,7i\u001c8gS\u001e$\"!!\u000b\u0011\u0011\u0005-\u0012\u0011GA\u001b\u0003\u0007j!!!\f\u000b\u0007\u0005=\"*\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003[\u00111!T1q!\u0011\t9$a\u0010\u000f\t\u0005e\u00121\b\t\u0004\u0003\u000bY\u0014bAA\u001fw\u00051\u0001K]3eK\u001aL1!TA!\u0015\r\tid\u000f\t\u0004\u000f\u0006\u0015\u0013bAA$\u0011\n1qJ\u00196fGRDq!a\u0013\u0001\t\u0003\ti%A\u0007xC&$hi\u001c:U_BL7m\u001d\u000b\bs\u0005=\u0013\u0011KA,\u0011\u0019I\u0013\u0011\na\u0001W!A\u00111KA%\u0001\u0004\t)&A\bfqB,7\r^3e!J,7/\u001a8u!\u0019\t\t!!\u0005\u00026!A\u0011\u0011LA%\u0001\u0004\t)&A\bfqB,7\r^3e\u001b&\u001c8/\u001b8h\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nq$Y:tKJ$h)\u001e;ve\u0016,\u0005pY3qi&|g\u000eV=qK\u0016\u000bX/\u00197t)\u0015I\u0014\u0011MAB\u0011!\t\u0019'a\u0017A\u0002\u0005\u0015\u0014A\u00024viV\u0014X\r\r\u0003\u0002h\u0005E\u0004#\u0002/\u0002j\u00055\u0014bAA6;\nY1*\u00194lC\u001a+H/\u001e:f!\u0011\ty'!\u001d\r\u0001\u0011a\u00111OA1\u0003\u0003\u0005\tQ!\u0001\u0002v\t\u0019q\fJ\u0019\u0012\t\u0005]\u0014Q\u0010\t\u0004u\u0005e\u0014bAA>w\t9aj\u001c;iS:<\u0007c\u0001\u001e\u0002\u0000%\u0019\u0011\u0011Q\u001e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0006\u0006m\u0003\u0019AAD\u0003\u0015\u0019G.\u0019>{a\u0011\tI)!%\u0011\r\u0005]\u00121RAH\u0013\u0011\ti)!\u0011\u0003\u000b\rc\u0017m]:\u0011\t\u0005=\u0014\u0011\u0013\u0003\r\u0003'\u000b\u0019)!A\u0001\u0002\u000b\u0005\u0011Q\u0013\u0002\u0004?\u0012\u0012\u0014\u0003BA<\u0003/\u0003B!!\u0001\u0002\u001a&!\u00111TA\u000b\u0005%!\u0006N]8xC\ndW\r\u0003\u0004\u0002 \u0002!\t!Z\u0001\ni\u0016\u001cHo\u00117pg\u0016DC!!(\u0002$B\u0019Q%!*\n\u0007\u0005\u001dVD\u0001\u0003UKN$\bBBAV\u0001\u0011\u0005Q-A\u0007uKN$H*[:u\u001d>$Wm\u001d\u0015\u0005\u0003S\u000b\u0019\u000b\u0003\u0004\u00022\u0002!\t!Z\u0001\u0017i\u0016\u001cHo\u0011:fCR,G)\u001a7fi\u0016$v\u000e]5dg\"\"\u0011qVAR\u0011\u0019\t9\f\u0001C\u0001K\u0006aB/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007\u0006BA[\u0003GCa!!0\u0001\t\u0003)\u0017a\u0005;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014\b\u0006BA^\u0003GCa!a1\u0001\t\u0003)\u0017a\u0005;fgR$Um]2sS\n,Gj\\4ESJ\u001c\b\u0006BAa\u0003GCa!!3\u0001\t\u0003)\u0017A\u0007;fgR$Um]2sS\n,'+\u001a9mS\u000e\fGj\\4ESJ\u001c\b\u0006BAd\u0003GCa!a4\u0001\t\u0003)\u0017a\u0006;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:tQ\u0011\ti-a)\t\r\u0005U\u0007\u0001\"\u0001f\u0003m!Xm\u001d;EKN\u001c'/\u001b2f\u0003:$\u0017\t\u001c;fe\u000e{gNZ5hg\"\"\u00111[AR\u0011\u0019\tY\u000e\u0001C\u0001K\u0006!B/Z:u\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]NDC!!7\u0002$\"1\u0011\u0011\u001d\u0001\u0005\u0002\u0015\f!\u0004^3tiN+Wm[!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sINDC!a8\u0002$\"1\u0011q\u001d\u0001\u0005\u0002\u0015\fA\u0004^3ti2{wm\u0015;beR|eMZ:fi\u000eCWmY6q_&tG\u000f\u000b\u0003\u0002f\u0006-\bcA\u0013\u0002n&\u0019\u0011q^\u000f\u0003\r%;gn\u001c:fQ\u0011\t)/a)\t\r\u0005U\b\u0001\"\u0001f\u0003\u0011\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\b\u0006BAz\u0003GCa!a?\u0001\t\u0003)\u0017!\n;fgR|eMZ:fiN4uN\u001d+j[\u0016\u001c\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\u0011\tI0a)\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005i2/\u001e2tGJL'-Z!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000fF\u0003:\u0005\u000b\u00119\u0001C\u0004E\u0003\u007f\u0004\r!!\u000e\t\u0011\t%\u0011q a\u0001\u0005\u0017\t\u0001bY8ogVlWM\u001d\t\t\u0005\u001b\u0011\tB!\u0006\u0003\u00165\u0011!q\u0002\u0006\u0004\u0005\u0013y\u0013\u0002\u0002B\n\u0005\u001f\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#\u0002\u001e\u0003\u0018\tm\u0011b\u0001B\rw\t)\u0011I\u001d:bsB\u0019!H!\b\n\u0007\t}1H\u0001\u0003CsR,\u0007b\u0002B\u0012\u0001\u0011%!QE\u0001\fg\u0016tGMU3d_J$7\u000fF\u0004:\u0005O\u0011)D!\u000f\t\u0011\t%\"\u0011\u0005a\u0001\u0005W\t\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0005[\u0011\tD!\u0006\u0003\u00165\u0011!q\u0006\u0006\u0004\u0005Sy\u0013\u0002\u0002B\u001a\u0005_\u0011QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bb\u0002B\u001c\u0005C\u0001\raU\u0001\u000b]Vl'+Z2pe\u0012\u001c\bBB-\u0003\"\u0001\u00071\f\u0003\u0004\u0003>\u0001!\t!Z\u0001\u0018i\u0016\u001cH/\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jONDCAa\u000f\u0002$\"I!1\t\u0001C\u0002\u0013\u0005!QI\u0001\u0005\u0003\u000ec\u0015'\u0006\u0002\u0003HA!!\u0011\nB(\u001b\t\u0011YEC\u0002\u0003Nu\u000b1!Y2m\u0013\u0011\u0011\tFa\u0013\u0003\u0015\u0005\u001bGNQ5oI&tw\r\u0003\u0005\u0003V\u0001\u0001\u000b\u0011\u0002B$\u0003\u0015\t5\tT\u0019!\u0011\u0019\u0011I\u0006\u0001C\u0001K\u0006\tB/Z:u\u0003\u000edw\n]3sCRLwN\\:)\t\t]\u00131\u0015\u0005\u0007\u0005?\u0002A\u0011A3\u0002!Q,7\u000f\u001e#fY\u0006LX\rZ\"m_N,\u0007\u0006\u0002B/\u0003GCaA!\u001a\u0001\t\u0003)\u0017A\u0004;fgR4uN]2f\u00072|7/\u001a\u0015\u0005\u0005G\n\u0019\u000b\u0003\u0004\u0003l\u0001!\t!Z\u0001\u001bi\u0016\u001cH/T5oS6,XNU3rk\u0016\u001cH\u000fV5nK>,Ho\u001d\u0015\u0005\u0005S\n\u0019\u000b\u0003\u0004\u0003r\u0001!\t!Z\u0001\u0019i\u0016\u001cHoQ1mY&sg\t\\5hQR$\u0016.\\3pkR\u001c\b\u0006\u0002B8\u0003G;qAa\u001e\u0003\u0011\u0003\u0011I(\u0001\u000eBI6Lgn\u00117jK:$\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\n\u0005w2a!\u0001\u0002\t\u0002\tu4C\u0002B>\u0005\u007f\u0012)\tE\u0002;\u0005\u0003K1Aa!<\u0005\u0019\te.\u001f*fMB\u0019!Ha\"\n\u0007\t%5H\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004\u0014\u0005w\"\tA!$\u0015\u0005\te\u0004\u0002\u0003BI\u0005w\"\tAa%\u0002-\rDWmY6WC2LG-\u00117uKJ\u001cuN\u001c4jON$r!\u000fBK\u0005/\u00139\u000b\u0003\u0004*\u0005\u001f\u0003\ra\u000b\u0005\t\u00053\u0013y\t1\u0001\u0003\u001c\u0006qAo\u001c9jGJ+7o\\;sG\u0016\f\u0004\u0003\u0002BO\u0005Gk!Aa(\u000b\u0007\t\u0005V,\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0005K\u0013yJ\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u0011\t%&q\u0012a\u0001\u00057\u000ba\u0002^8qS\u000e\u0014Vm]8ve\u000e,'\u0007\u0003\u0005\u0003.\nmD\u0011\u0001BX\u0003a\u0019\u0007.Z2l\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\bs\tE&\u0011\u0019Bg\u0011!\u0011\u0019La+A\u0002\tU\u0016\u0001\u0003>l\u00072LWM\u001c;\u0011\t\t]&QX\u0007\u0003\u0005sS1Aa/\u0005\u0003\tQ8.\u0003\u0003\u0003@\ne&!D&bM.\f'l[\"mS\u0016tG\u000f\u0003\u0005\u0003D\n-\u0006\u0019\u0001Bc\u0003\u001d\u0019XM\u001d<feN\u0004b!!\u0001\u0002\u0012\t\u001d\u0007\u0003BA\r\u0005\u0013LAAa3\u0002\u001c\tY1*\u00194lCN+'O^3s\u0011\u0019I#1\u0016a\u0001W!Q!\u0011\u001bB>\u0003\u0003%IAa5\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0007\u0002")
public class AdminClientIntegrationTest
extends IntegrationTestHarness {
    private AdminClient client = null;
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final int serverCount;
    private final int consumerCount;
    private final int producerCount;
    private final AclBinding ACL1 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, adminClient);
    }

    public static void checkValidAlterConfigs(AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$21 = this.serverCount();
        String x$22 = this.zkConnect();
        Some x$23 = new Some((Object)this.securityProtocol());
        Option<File> x$24 = this.trustStoreFile();
        Option<Properties> x$25 = this.serverSaslProperties();
        int x$26 = 2;
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$33 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$21, x$22, x$27, x$28, (Option<SecurityProtocol>)x$23, x$24, x$25, x$29, x$30, x$31, x$32, x$33, x$26, x$34);
        cfgs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.listenerName().value());
            config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value(), $this.securityProtocol().name})));
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            return !config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass") : BoxedUnit.UNIT;
        });
        cfgs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            AdminClientIntegrationTest.$anonfun$generateConfigs$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)cfgs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put((String)key, (String)value);
            return object;
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Set topics = (java.util.Set)client.listTopics().names().get();
            return expectedPresent.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$waitForTopics$4(topics, topicName)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz) {
        try {
            future.get();
            throw this.fail("Expected CompletableFuture.get to return an exception", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)("Expected an exception of type " + clazz.getName() + "; got type " + cause.getClass().getName()), (boolean)clazz.isInstance(cause));
            return;
        }
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())})), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assert.assertEquals((long)partitionId, (long)partition.partition());
            Assert.assertEquals((long)3L, (long)partition.replicas().size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                AdminClientIntegrationTest.$anonfun$testCreateDeleteTopics$6(this, replica);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size());
            Assert.assertEquals((long)3L, (long)partition.isr().size());
            Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1 & Serializable & scala.Serializable)x$7 -> new NewTopic(x$7, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Collection nodes = (Collection)this.client().describeCluster().nodes().get();
        String clusterId = (String)this.client().describeCluster().clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).apis().clusterId(), (Object)clusterId);
        Node controller = (Node)this.client().describeCluster().controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).apis().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminClientIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$2))).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> x$8.keys().toSeq());
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$9))).get();
            Seq expectedPartitions = (Seq)partitionsByBroker.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker.get(BoxesRunTime.boxToInteger((int)brokerId));
            Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                return map;
            }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$7(topic, x$10)));
            Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$9(server, x0$4);
                return BoxedUnit.UNIT;
            });
        });
        this.client().close();
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            int brokerId = tuple2._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$2(this, x0$6);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable futures = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values();
        futures.foreach((Function1 & Serializable & scala.Serializable)future -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(this, future);
            return BoxedUnit.UNIT;
        });
        this.createTopic(topic, 1, this.serverCount(), this.createTopic$default$4());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(topic, tp, firstReplicaAssignment, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                LogManager qual$4 = server.logManager();
                TopicPartition x$41 = tp$1;
                boolean x$42 = qual$4.getLog$default$2();
                String logDir = ((Log)qual$4.getLog(x$41, x$42).get()).dir().getParent();
                Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId()));
                String string = logDir;
                return !(object != null ? !object.equals(string) : string != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            String x$43 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$44 = this.securityProtocol();
            Option<File> x$45 = this.trustStoreFile();
            int x$46 = 0;
            long x$47 = 10000L;
            int x$48 = -1;
            long x$49 = TestUtils$.MODULE$.createNewProducer$default$3();
            long x$50 = TestUtils$.MODULE$.createNewProducer$default$4();
            long x$51 = TestUtils$.MODULE$.createNewProducer$default$6();
            Option<Properties> x$52 = TestUtils$.MODULE$.createNewProducer$default$10();
            ByteArraySerializer x$53 = TestUtils$.MODULE$.createNewProducer$default$11();
            ByteArraySerializer x$54 = TestUtils$.MODULE$.createNewProducer$default$12();
            Option<Properties> x$55 = TestUtils$.MODULE$.createNewProducer$default$13();
            try (KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$43, x$48, x$49, x$50, x$46, x$51, x$47, x$44, x$45, x$52, x$53, x$54, x$55);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numMessages})).getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> numMessages.get() > 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced before timeout. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numMessages, producerFuture.value()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    LogManager qual$5 = server.logManager();
                    TopicPartition x$56 = tp$1;
                    boolean x$57 = qual$5.getLog$default$2();
                    String logDir = ((Log)qual$5.getLog(x$56, x$57).get()).dir().getParent();
                    Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId()));
                    String string = logDir;
                    return !(object != null ? !object.equals(string) : string != null);
                }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{producerFuture$1.value()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> numMessages.get() - currentMessagesNum > 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced within timeout after replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numMessages.get() - currentMessagesNum)), producerFuture.value()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Seq<ConsumerRecord<byte[], byte[]>> consumerRecords = TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, finalNumMessages, this.securityProtocol(), this.trustStoreFile(), TestUtils$.MODULE$.consumeTopicRecords$default$6());
        ((IterableLike)consumerRecords.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$7);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1 & Serializable & scala.Serializable)option -> {
            AdminClientIntegrationTest.$anonfun$testCreatePartitions$3(this, topic1, topic2, alterResult, altered, newPartition2Assignments, option);
            return BoxedUnit.UNIT;
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            throw this.fail("Expect InvalidTopicException when the topic is queued for deletion", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
            return;
        }
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().close();
    }

    @Test
    @Ignore
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        LongRef lowWatermark = LongRef.create((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Assert.assertEquals((long)5L, (long)lowWatermark.elem);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            block3: {
                result$1.elem = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
                KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get(this.topicPartition());
                try {
                    lowWatermark$1.elem = ((DeletedRecords)future.get(1000L, TimeUnit.MILLISECONDS)).lowWatermark();
                    if (lowWatermark$1.elem == 5L) {
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                catch (LeaderNotAvailableException e) {
                    bl = false;
                }
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected low watermark of the partition to be 5L", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.client().close();
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().getReplica(this.topicPartition()).get()).logStartOffset()));
        this.client().close();
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.topicPartition());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new Long(0L))}))).asJava()).get(this.topicPartition())).offset());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        result.all().get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new Long(0L))}))).asJava()).get(this.topicPartition())).offset());
        result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava());
        result.all().get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new Long(0L))}))).asJava()).get(this.topicPartition()));
        this.client().close();
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(0L);
            return !consumer.assignment().isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AdminClientIntegrationTest.$anonfun$sendRecords$1(this, producer, topicPartition, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$15 -> (RecordMetadata)x$15.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class);
        this.client().close();
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1 & Serializable & scala.Serializable)x$16 -> new NewTopic(x$16, 1, 1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(2L, TimeUnit.HOURS);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future2, TimeoutException.class);
        future.get();
        this.client().close(30L, TimeUnit.MINUTES);
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$17 -> new NewTopic(x$17, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(0L, TimeUnit.MILLISECONDS);
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$18 -> new NewTopic(x$18, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
        this.client().close();
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        KafkaAdminClient client = KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory);
        KafkaFuture future = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$19 -> new NewTopic(x$19, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        KafkaFuture future2 = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1 & Serializable & scala.Serializable)x$20 -> new NewTopic(x$20, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        client.close();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    public static final /* synthetic */ void $anonfun$generateConfigs$2(AdminClientIntegrationTest $this, Properties x$1) {
        Implicits$.MODULE$.PropertiesOps(x$1).$plus$plus$eq($this.serverConfig());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$4(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$6(AdminClientIntegrationTest $this, Node replica) {
        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((replica.id() < $this.serverCount() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$2) {
        int leaderId;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = leaderId = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$9) {
        return x$9.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, TopicPartition x$10) {
        String string = x$10.topic();
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        TopicPartition x$35 = tp;
        boolean x$36 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(x$35, x$36).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$9(KafkaServer server$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String logDir = (String)tuple2._1();
        DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$10(server$1, logDir, tp);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$12) {
        return x$12.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeReplicaLogDirs$2(AdminClientIntegrationTest $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
        DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$12))).get();
        TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
        LogManager qual$2 = server.logManager();
        TopicPartition x$37 = tp;
        boolean x$38 = qual$2.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$2.getLog(x$37, x$38).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(AdminClientIntegrationTest $this, KafkaFuture future) {
        ExecutionException exception = (ExecutionException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)future.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        Assert.assertTrue((boolean)(exception.getCause() instanceof ReplicaNotAvailableException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(String topic$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, KafkaServer server) {
        LogManager qual$3 = server.logManager();
        TopicPartition x$39 = tp$1;
        boolean x$40 = qual$3.getLog$default$2();
        String logDir = ((Log)qual$3.getLog(x$39, x$40).get()).dir().getParent();
        Assert.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ConsumerRecord consumerRecord = (ConsumerRecord)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), (Object)new String((byte[])consumerRecord.value()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    private final int numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    public static final /* synthetic */ void $anonfun$testCreatePartitions$3(AdminClientIntegrationTest $this, String topic1$2, String topic2$1, ObjectRef alterResult$1, ObjectRef altered$1, java.util.List newPartition2Assignments$1, CreatePartitionsOptions option) {
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is a decrease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
            try {
                ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when requesting a noop"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            }
            catch (ExecutionException e2) {
                Object object;
                Object object2;
                Assert.assertTrue((String)desc, (boolean)(e2.getCause() instanceof InvalidPartitionsException));
                Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e2.getCause().getMessage());
                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1))}))).asJava(), option);
                try {
                    object2 = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                }
                catch (ExecutionException e3) {
                    Assert.assertTrue((String)desc, (boolean)(e3.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e3.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                    object2 = BoxedUnit.UNIT;
                }
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                try {
                    object = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
                }
                catch (ExecutionException e4) {
                    Assert.assertTrue((String)desc, (boolean)(e4.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e4.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
                    object = BoxedUnit.UNIT;
                }
                String unknownTopic = "an-unknown-topic";
                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
                    throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidTopicException when using an unknown topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
                }
                catch (ExecutionException e5) {
                    Assert.assertTrue((String)desc, (boolean)(e5.getCause() instanceof UnknownTopicOrPartitionException));
                    Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e5.getCause().getMessage());
                    alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                    try {
                        altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                        throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is invalid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
                    }
                    catch (ExecutionException e6) {
                        Assert.assertTrue((String)desc, (boolean)(e6.getCause() instanceof InvalidPartitionsException));
                        Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e6.getCause().getMessage());
                        Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                        try {
                            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when #brokers != replication factor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
                        }
                        catch (ExecutionException e7) {
                            Assert.assertTrue((String)desc, (boolean)(e7.getCause() instanceof InvalidReplicaAssignmentException));
                            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e7.getCause().getMessage());
                            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                            try {
                                altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
                            }
                            catch (ExecutionException e8) {
                                Assert.assertTrue((String)desc, (boolean)(e8.getCause() instanceof InvalidReplicaAssignmentException));
                                Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e8.getCause().getMessage());
                                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                                try {
                                    altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                    throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
                                }
                                catch (ExecutionException e9) {
                                    Assert.assertTrue((String)desc, (boolean)(e9.getCause() instanceof InvalidReplicaAssignmentException));
                                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e9.getCause().getMessage());
                                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                    alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                                    try {
                                        altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                        throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
                                    }
                                    catch (ExecutionException e10) {
                                        Assert.assertTrue((String)desc, (boolean)(e10.getCause() instanceof InvalidReplicaAssignmentException));
                                        Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e10.getCause().getMessage());
                                        Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                                        try {
                                            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
                                        }
                                        catch (ExecutionException e11) {
                                            Assert.assertTrue((String)desc, (boolean)(e11.getCause() instanceof InvalidReplicaAssignmentException));
                                            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e11.getCause().getMessage());
                                            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                            alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                                            try {
                                                altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                                throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
                                            }
                                            catch (ExecutionException e12) {
                                                Assert.assertTrue((String)desc, (boolean)(e12.getCause() instanceof InvalidReplicaAssignmentException));
                                                Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e12.getCause().getMessage());
                                                Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                                alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.emptyList()))}))).asJava(), option);
                                                try {
                                                    altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
                                                    throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
                                                }
                                                catch (ExecutionException e13) {
                                                    Assert.assertTrue((String)desc, (boolean)(e13.getCause() instanceof InvalidReplicaAssignmentException));
                                                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e13.getCause().getMessage());
                                                    Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
                                                    return;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(AdminClientIntegrationTest $this, KafkaProducer producer$1, TopicPartition topicPartition$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})));
        return producer$1.send(record);
    }

    public AdminClientIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
        this.serverCount = 3;
        this.consumerCount = 1;
        this.producerCount = 1;
    }
}

