/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class UpdateOffsetsInZK$
implements Logging {
    public static UpdateOffsetsInZK$ MODULE$;
    private final String Earliest;
    private final String Latest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new UpdateOffsetsInZK$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        UpdateOffsetsInZK$ updateOffsetsInZK$ = this;
        synchronized (updateOffsetsInZK$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String Earliest() {
        return this.Earliest;
    }

    public String Latest() {
        return this.Latest;
    }

    public void main(String[] args) {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "WARNING: UpdateOffsetsInZK is deprecated and will be dropped in releases following 0.11.0.0.");
        if (args.length < 3) {
            throw this.usage();
        }
        ConsumerConfig config = new ConsumerConfig(Utils.loadProps((String)args[1]));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        String string = args[0];
        String string2 = this.Earliest();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.getAndSetOffsets(zkUtils, OffsetRequest$.MODULE$.EarliestTime(), config, args[2]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = this.Latest();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.getAndSetOffsets(zkUtils, OffsetRequest$.MODULE$.LatestTime(), config, args[2]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw this.usage();
            }
        }
    }

    private void getAndSetOffsets(ZkUtils zkUtils, long offsetOption, ConsumerConfig config, String topic) {
        Map<String, Seq<Object>> partitionsPerTopicMap = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Nil$ partitions = Nil$.MODULE$;
        Option option = partitionsPerTopicMap.get((Object)topic);
        if (!(option instanceof Some)) {
            throw new RuntimeException("Can't find topic " + topic);
        }
        Some some = (Some)option;
        Seq l = (Seq)some.value();
        partitions = (Seq)l.sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(s, t) -> s < t);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        IntRef numParts = IntRef.create((int)0);
        partitions.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            int b;
            Option<Object> brokerHostingPartition = zkUtils.getLeaderForPartition(topic, partition);
            Option<Object> option = brokerHostingPartition;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new KafkaException("Broker " + brokerHostingPartition + " is unavailable. Cannot issue " + "getOffsetsBefore request");
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            int n = b = BoxesRunTime.unboxToInt((Object)some.value());
            int broker = n;
            Option<Broker> option2 = zkUtils.getBrokerInfo(broker);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Broker brokerInfo = (Broker)some2.value();
                BrokerEndPoint brokerEndPoint = brokerInfo.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
                SimpleConsumer consumer = new SimpleConsumer(brokerEndPoint.host(), brokerEndPoint.port(), 10000, 102400, "UpdateOffsetsInZk");
                TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
                OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(offsetOption, 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                long offset = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(config.groupId(), topic);
                Predef$.MODULE$.println((Object)("updating partition " + partition + " with new offset: " + offset));
                zkUtils.updatePersistentPath(topicDirs.consumerOffsetDir() + "/" + partition, ((Object)BoxesRunTime.boxToLong((long)offset)).toString(), zkUtils.updatePersistentPath$default$3());
                ++numParts$1.elem;
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Broker information for broker id %d does not exist in ZK")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker)})));
                }
                throw new MatchError(option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)("updated the offset for " + numParts.elem + " partitions"));
    }

    private Nothing$ usage() {
        Predef$.MODULE$.println((Object)("USAGE: " + this.getClass().getName() + " [earliest | latest] consumer.properties topic"));
        return Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
    }

    private UpdateOffsetsInZK$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.Earliest = "earliest";
        this.Latest = "latest";
    }
}

