/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CU3rk\u0016\u001cHoU3oIRC'/Z1e\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005)Q\u000f^5mg&\u0011QB\u0003\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0005\u0010\u0001\t\u0015\r\u0011\"\u0001\u0011\u00031\u0019wN\u001c;s_2dWM]%e+\u0005\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"aA%oi\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011#A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\t5\u0001\u0011)\u0019!C\u00017\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003q\u0001\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001d\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nQ!];fk\u0016,\u0012!\n\t\u0004M5zS\"A\u0014\u000b\u0005!J\u0013AC2p]\u000e,(O]3oi*\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059:#!\u0004\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002\u001ea%\u0011\u0011G\u0001\u0002\n#V,W/Z%uK6D\u0001b\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0007cV,W/\u001a\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\nQB\\3uo>\u00148n\u00117jK:$X#A\u001c\u0011\u0005a\u0002U\"A\u001d\u000b\u0005iZ\u0014aB2mS\u0016tGo\u001d\u0006\u0003\u000bqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011)\u000f\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\t\u0011\r\u0003!\u0011!Q\u0001\n]\naB\\3uo>\u00148n\u00117jK:$\b\u0005\u0003\u0005F\u0001\t\u0015\r\u0011\"\u0001G\u0003)\u0011'o\\6fe:{G-Z\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jO\u0001\u0007G>lWn\u001c8\n\u00051K%\u0001\u0002(pI\u0016D\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IaR\u0001\fEJ|7.\u001a:O_\u0012,\u0007\u0005\u0003\u0005Q\u0001\t\u0015\r\u0011\"\u0001R\u0003\u0019\u0019wN\u001c4jOV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V\t\u000511/\u001a:wKJL!a\u0016+\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\t3\u0002\u0011\t\u0011)A\u0005%\u000691m\u001c8gS\u001e\u0004\u0003\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\u0002\tQLW.Z\u000b\u0002;B\u0011a\fY\u0007\u0002?*\u00111\"S\u0005\u0003C~\u0013A\u0001V5nK\"A1\r\u0001B\u0001B\u0003%Q,A\u0003uS6,\u0007\u0005\u0003\u0005f\u0001\t\u0015\r\u0011\"\u0001g\u0003y\u0011X-];fgR\u0014\u0016\r^3B]\u0012\fV/Z;f)&lW-T3ue&\u001c7/F\u0001h!\tA\u0017/D\u0001j\u0015\tQ7.\u0001\u0003d_J,'B\u00017n\u0003\u001diW\r\u001e:jGNT!A\\8\u0002\re\fW.\\3s\u0015\u0005\u0001\u0018aA2p[&\u0011!/\u001b\u0002\u0006)&lWM\u001d\u0005\ti\u0002\u0011\t\u0011)A\u0005O\u0006y\"/Z9vKN$(+\u0019;f\u0003:$\u0017+^3vKRKW.Z'fiJL7m\u001d\u0011\t\u0011Y\u0004!Q1A\u0005\u0002]\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\u0005A\bCA\u000fz\u0013\tQ(AA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I\u0001_\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b\u0005\u0003\u0006\u007f\u0001\t\u0005\t\u0015!\u0003\u0000\u0003+\tAA\\1nKB!\u0011\u0011AA\b\u001d\u0011\t\u0019!a\u0003\u0011\u0007\u0005\u00151#\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0004\u0002\rq\u0012xn\u001c;?\u0013\r\tiaE\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000551#\u0003\u0002\u007f\u0019!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011A\u0002\u001fj]&$h\b\u0006\f\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019!\ti\u0002\u0001\u0003\u0004\u0010\u0003/\u0001\r!\u0005\u0005\u00075\u0005]\u0001\u0019\u0001\u000f\t\r\r\n9\u00021\u0001&\u0011\u0019)\u0014q\u0003a\u0001o!1Q)a\u0006A\u0002\u001dCa\u0001UA\f\u0001\u0004\u0011\u0006BB.\u0002\u0018\u0001\u0007Q\f\u0003\u0004f\u0003/\u0001\ra\u001a\u0005\u0007m\u0006]\u0001\u0019\u0001=\t\ry\f9\u00021\u0001\u0000\u0011!\t)\u0004\u0001b\u0001\n\u0013\u0001\u0012aD:pG.,G\u000fV5nK>,H/T:\t\u000f\u0005e\u0002\u0001)A\u0005#\u0005\u00012o\\2lKR$\u0016.\\3pkRl5\u000f\t\u0005\b\u0003{\u0001A\u0011IA \u0003\u0019!wnV8sWR\u0011\u0011\u0011\t\t\u0004%\u0005\r\u0013bAA#'\t!QK\\5u\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\n1B\u0019:pW\u0016\u0014(+Z1esR\u0011\u0011Q\n\t\u0004%\u0005=\u0013bAA)'\t9!i\\8mK\u0006t\u0007")
public class RequestSendThread
extends ShutdownableThread {
    private final int controllerId;
    private final ControllerContext controllerContext;
    private final BlockingQueue<QueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;

    public int controllerId() {
        return this.controllerId;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public BlockingQueue<QueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Override
    public void doWork() {
        block11: {
            QueueItem queueItem = this.queue().take();
            if (queueItem == null) {
                throw new MatchError((Object)queueItem);
            }
            ApiKeys apiKey = queueItem.apiKey();
            AbstractRequest.Builder<? extends AbstractRequest> requestBuilder = queueItem.request();
            Function1<AbstractResponse, BoxedUnit> callback = queueItem.callback();
            long enqueueTimeMs = queueItem.enqueueTimeMs();
            Tuple4 tuple4 = new Tuple4((Object)apiKey, requestBuilder, callback, (Object)BoxesRunTime.boxToLong((long)enqueueTimeMs));
            Tuple4 tuple42 = tuple4;
            ApiKeys apiKey2 = (ApiKeys)tuple42._1();
            AbstractRequest.Builder requestBuilder2 = (AbstractRequest.Builder)tuple42._2();
            Function1 callback2 = (Function1)tuple42._3();
            long enqueueTimeMs2 = BoxesRunTime.unboxToLong((Object)tuple42._4());
            this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - enqueueTimeMs2, TimeUnit.MILLISECONDS);
            ClientResponse clientResponse = null;
            try {
                ApiKeys api;
                boolean isSendSuccessful = false;
                while (this.isRunning() && !isSendSuccessful) {
                    try {
                        if (!this.brokerReady()) {
                            isSendSuccessful = false;
                            this.backoff$1();
                            continue;
                        }
                        ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), requestBuilder2, this.time().milliseconds(), true);
                        clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time());
                        isSendSuccessful = true;
                    }
                    catch (Throwable e) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Controller ").append(this.controllerId()).append(" epoch ").append(this.controllerContext().epoch()).append(" fails to send request ").append(requestBuilder2).append(" ").append(new StringBuilder(35).append("to broker ").append(this.brokerNode()).append(". Reconnecting to broker.").toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        this.networkClient().close(this.brokerNode().idString());
                        isSendSuccessful = false;
                        this.backoff$1();
                    }
                }
                if (clientResponse == null) break block11;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(apiKey2).toString());
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().withControllerEpoch(this.controllerContext().epoch()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Received response ").append(new StringBuilder(34).append(response.toString(requestHeader.apiVersion())).append(" for request ").append(api).append(" with correlation id ").toString()).append(new StringBuilder(16).append(requestHeader.correlationId()).append(" sent to broker ").append(this.brokerNode()).toString()).toString());
                if (callback2 != null) {
                    callback2.apply((Object)response);
                }
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Controller ").append(this.controllerId()).append(" fails to send a request to broker ").append(this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.networkClient().close(this.brokerNode().idString());
            }
        }
    }

    private boolean brokerReady() {
        boolean bl;
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            bl = true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            bl = false;
        }
        return bl;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public RequestSendThread(int controllerId, ControllerContext controllerContext, BlockingQueue<QueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerContext = controllerContext;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.logIdent_$eq(new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

