/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eq!B\u0001\u0003\u0011\u0003I\u0011!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4fe*\u00111\u0001B\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u0012!J|G-^2fe&#W*\u00198bO\u0016\u00148cA\u0006\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\u00067-!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%AqAH\u0006C\u0002\u0013\u0005q$\u0001\bDkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003\u0001\u0002\"aD\u0011\n\u0005\t\u0002\"\u0001\u0002'p]\u001eDa\u0001J\u0006!\u0002\u0013\u0001\u0013aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\t\u000f\u0019Z!\u0019!C\u0001?\u0005a\u0001+\u001b3CY>\u001c7nU5{K\"1\u0001f\u0003Q\u0001\n\u0001\nQ\u0002U5e\u00052|7m[*ju\u0016\u0004\u0003\"\u0002\u0016\f\t\u0003Y\u0013aG4f]\u0016\u0014\u0018\r^3Qe>$WoY3s\u0013\u0012\u0014En\\2l\u0015N|g\u000e\u0006\u0002-eA\u0019q\"L\u0018\n\u00059\u0002\"!B!se\u0006L\bCA\b1\u0013\t\t\u0004C\u0001\u0003CsR,\u0007\"B\u001a*\u0001\u0004!\u0014a\u00049s_\u0012,8-\u001a:JI\ncwnY6\u0011\u0005))\u0014B\u0001\u001c\u0003\u0005=\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\\u0007\"\u0002\u001d\f\t\u0003I\u0014\u0001\u00079beN,\u0007K]8ek\u000e,'/\u00133CY>\u001c7\u000eR1uCR\u0011AG\u000f\u0005\u0006w]\u0002\r\u0001L\u0001\tUN|g\u000eR1uC\u001a!AB\u0001\u0001>'\rad\u0002\u0006\u0005\t\u007fq\u0012)\u0019!C\u0001\u0001\u0006A!M]8lKJLE-F\u0001B!\ty!)\u0003\u0002D!\t\u0019\u0011J\u001c;\t\u0011\u0015c$\u0011!Q\u0001\n\u0005\u000b\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u001dc$Q1A\u0005\u0002!\u000b\u0001B_6DY&,g\u000e^\u000b\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\u0011AJB\u0001\u0003u.L!AT&\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011!\u0001FH!A!\u0002\u0013I\u0015!\u0003>l\u00072LWM\u001c;!\u0011\u0015YB\b\"\u0001S)\r\u0019F+\u0016\t\u0003\u0015qBQaP)A\u0002\u0005CQaR)A\u0002%Cqa\u0016\u001fA\u0002\u0013%\u0001,\u0001\fdkJ\u0014XM\u001c;Qe>$WoY3s\u0013\u0012\u0014En\\2l+\u0005!\u0004b\u0002.=\u0001\u0004%IaW\u0001\u001bGV\u0014(/\u001a8u!J|G-^2fe&#'\t\\8dW~#S-\u001d\u000b\u00039~\u0003\"aD/\n\u0005y\u0003\"\u0001B+oSRDq\u0001Y-\u0002\u0002\u0003\u0007A'A\u0002yIEBaA\u0019\u001f!B\u0013!\u0014aF2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6!\u0011\u001d!G\b1A\u0005\n}\taB\\3yiB\u0013x\u000eZ;dKJLE\rC\u0004gy\u0001\u0007I\u0011B4\u0002%9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI~#S-\u001d\u000b\u00039\"Dq\u0001Y3\u0002\u0002\u0003\u0007\u0001\u0005\u0003\u0004ky\u0001\u0006K\u0001I\u0001\u0010]\u0016DH\u000f\u0015:pIV\u001cWM]%eA!)A\u000e\u0010C\u0005[\u0006)r-\u001a;OK^\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\G#\u0001/\t\u000b=dD\u0011\u00029\u00025\rDWmY6Qe>$WoY3s\u0013\u0012\u0014En\\2l5.$\u0015\r^1\u0015\u000bE<\b0a\u0003\u0011\t=\u0011H/Q\u0005\u0003gB\u0011a\u0001V;qY\u0016\u0014\u0004CA\bv\u0013\t1\bCA\u0004C_>dW-\u00198\t\u000b\u001ds\u0007\u0019A%\t\u000bet\u0007\u0019\u0001>\u0002\tA\fG\u000f\u001b\t\u0004w\u0006\u0015ab\u0001?\u0002\u0002A\u0011Q\u0010E\u0007\u0002}*\u0011q\u0010C\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0001#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\tIA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\u0001\u0002BBA\u0007]\u0002\u0007A&\u0001\u0007fqB,7\r^3e\t\u0006$\u0018\rC\u0004\u0002\u0012q\"\t!a\u0005\u0002%\u001d,g.\u001a:bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0002A!1\u0011q\u0003\u001f\u0005\u00025\f\u0001b\u001d5vi\u0012|wO\u001c")
public class ProducerIdManager
implements Logging {
    private final int brokerId;
    private final KafkaZkClient zkClient;
    private ProducerIdBlock currentProducerIdBlock;
    private long nextProducerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ProducerIdBlock parseProducerIdBlockData(byte[] byArray) {
        return ProducerIdManager$.MODULE$.parseProducerIdBlockData(byArray);
    }

    public static byte[] generateProducerIdBlockJson(ProducerIdBlock producerIdBlock) {
        return ProducerIdManager$.MODULE$.generateProducerIdBlockJson(producerIdBlock);
    }

    public static long PidBlockSize() {
        return ProducerIdManager$.MODULE$.PidBlockSize();
    }

    public static long CurrentVersion() {
        return ProducerIdManager$.MODULE$.CurrentVersion();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerIdManager producerIdManager = this;
        synchronized (producerIdManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private ProducerIdBlock currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private void currentProducerIdBlock_$eq(ProducerIdBlock x$1) {
        this.currentProducerIdBlock = x$1;
    }

    private long nextProducerId() {
        return this.nextProducerId;
    }

    private void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    private void getNewProducerIdBlock() {
        boolean zkWriteComplete = false;
        while (!zkWriteComplete) {
            ProducerIdBlock producerIdBlock;
            Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient().getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option dataOpt = (Option)tuple2._1();
            int zkVersion = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)dataOpt, (Object)BoxesRunTime.boxToInteger((int)zkVersion));
            Tuple2 tuple23 = tuple22;
            Option dataOpt2 = (Option)tuple23._1();
            int zkVersion2 = tuple23._2$mcI$sp();
            Option option = dataOpt2;
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] data = (byte[])some.value();
                ProducerIdBlock currProducerIdBlock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(data);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Read current producerId block ").append(currProducerIdBlock).append(", Zk path version ").append(zkVersion2).toString());
                if (currProducerIdBlock.blockEndId() > Long.MAX_VALUE - ProducerIdManager$.MODULE$.PidBlockSize()) {
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(132).append("Exhausted all producerIds as the next block's end producerId is will has exceeded long type limit (current block end producerId is ").append(currProducerIdBlock.blockEndId()).append(")").toString());
                    throw new KafkaException("Have exhausted all producerIds.");
                }
                producerIdBlock = new ProducerIdBlock(this.brokerId(), currProducerIdBlock.blockEndId() + 1L, currProducerIdBlock.blockEndId() + ProducerIdManager$.MODULE$.PidBlockSize());
            } else if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("There is no producerId block yet (Zk path version ").append(zkVersion2).append("), creating the first block").toString());
                producerIdBlock = new ProducerIdBlock(this.brokerId(), 0L, ProducerIdManager$.MODULE$.PidBlockSize() - 1L);
            } else {
                throw new MatchError((Object)option);
            }
            this.currentProducerIdBlock_$eq(producerIdBlock);
            byte[] newProducerIdBlockData = ProducerIdManager$.MODULE$.generateProducerIdBlockJson(this.currentProducerIdBlock());
            Tuple2<Object, Object> tuple24 = this.zkClient().conditionalUpdatePath(ProducerIdBlockZNode$.MODULE$.path(), newProducerIdBlockData, zkVersion2, (Option<Function3<KafkaZkClient, String, byte[], Tuple2<Object, Object>>>)new Some((Function3 & Serializable & scala.Serializable)(zkClient, path, expectedData) -> this.checkProducerIdBlockZkData((KafkaZkClient)zkClient, (String)path, (byte[])expectedData)));
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            boolean succeeded = tuple24._1$mcZ$sp();
            int version = tuple24._2$mcI$sp();
            Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(succeeded, version);
            Tuple2.mcZI.sp sp3 = sp2;
            boolean succeeded2 = sp3._1$mcZ$sp();
            int version2 = sp3._2$mcI$sp();
            zkWriteComplete = succeeded2;
            if (!zkWriteComplete) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Acquired new producerId block ").append(this.currentProducerIdBlock()).append(" by writing to Zk with path version ").append(version2).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, Object> checkProducerIdBlockZkData(KafkaZkClient zkClient, String path, byte[] expectedData) {
        try {
            expectedPidBlock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(expectedData);
            var6_5 = zkClient.getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
            if (var6_5 == null) ** GOTO lbl-1000
            var7_6 = (Option)var6_5._1();
            zkVersion = var6_5._2$mcI$sp();
            if (var7_6 instanceof Some) {
                var9_8 = (Some)var7_6;
                data = (byte[])var9_8.value();
                v0 = currProducerIdBLock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(data);
                var12_11 = expectedPidBlock;
                var4_12 = new Tuple2.mcZI.sp(!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null), zkVersion);
            } else if (var6_5 != null && None$.MODULE$.equals(var13_13 = (Option)var6_5._1())) {
                var4_12 = new Tuple2.mcZI.sp(false, -1);
            } else {
                throw new MatchError(var6_5);
            }
            v1 = var4_12;
        }
        catch (Exception e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkProducerIdBlockZkData$1(java.lang.String byte[] ), ()Ljava/lang/String;)((String)path, (byte[])expectedData), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkProducerIdBlockZkData$2(java.lang.Exception ), ()Ljava/lang/Exception;)((Exception)e));
            v1 = new Tuple2.mcZI.sp(false, -1);
        }
        return v1;
    }

    public synchronized long generateProducerId() {
        if (this.nextProducerId() > this.currentProducerIdBlock().blockEndId()) {
            this.getNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().blockStartId() + 1L);
        } else {
            this.nextProducerId_$eq(this.nextProducerId() + 1L);
        }
        return this.nextProducerId() - 1L;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Shutdown complete: last producerId assigned ").append(this.nextProducerId()).toString());
    }

    public static final /* synthetic */ String $anonfun$checkProducerIdBlockZkData$1(String path$1, byte[] expectedData$1) {
        return new StringBuilder(74).append("Error while checking for producerId block Zk data on path ").append(path$1).append(": expected data ").append(String.valueOf(new String(expectedData$1, StandardCharsets.UTF_8))).toString();
    }

    public static final /* synthetic */ Exception $anonfun$checkProducerIdBlockZkData$2(Exception e$1) {
        return e$1;
    }

    public ProducerIdManager(int brokerId, KafkaZkClient zkClient) {
        this.brokerId = brokerId;
        this.zkClient = zkClient;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(23).append("[ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.currentProducerIdBlock = null;
        this.nextProducerId = -1L;
        ProducerIdManager producerIdManager = this;
        synchronized (producerIdManager) {
            this.getNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().blockStartId());
        }
    }
}

