/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011eqAB\u0001\u0003\u0011\u0003!a!A\u0005Qe>\u001cWm]:pe*\u00111\u0001B\u0001\b]\u0016$xo\u001c:l\u0015\u0005)\u0011!B6bM.\f\u0007CA\u0004\t\u001b\u0005\u0011aAB\u0005\u0003\u0011\u0003!!BA\u0005Qe>\u001cWm]:peN\u0011\u0001b\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bIAA\u0011\u0001\u000b\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0002\u0005\b-!\u0011\r\u0011\"\u0001\u0018\u0003UIE\r\\3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016,\u0012\u0001\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019\u0019FO]5oO\"1\u0011\u0005\u0003Q\u0001\na\ta#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW\r\t\u0005\bG!\u0011\r\u0011\"\u0001\u0018\u0003eqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4\t\r\u0015B\u0001\u0015!\u0003\u0019\u0003iqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4!\u0011\u001d9\u0003B1A\u0005\u0002]\t\u0011\u0003T5ti\u0016tWM]'fiJL7\rV1h\u0011\u0019I\u0003\u0002)A\u00051\u0005\u0011B*[:uK:,'/T3ue&\u001cG+Y4!\r\u0015I!\u0001\u0001\u0003,'\rQCf\f\t\u0003\u000f5J!A\f\u0002\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<feRC'/Z1e!\t\u00014'D\u00012\u0015\t\u0011D!A\u0004nKR\u0014\u0018nY:\n\u0005Q\n$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\"AaG\u000bBC\u0002\u0013\u0005q'\u0001\u0002jIV\t\u0001\b\u0005\u0002\rs%\u0011!(\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u001f+\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u0007%$\u0007\u0005\u0003\u0005?U\t\u0005\t\u0015!\u0003@\u0003\u0011!\u0018.\\3\u0011\u0005\u0001SU\"A!\u000b\u0005\t\u001b\u0015!B;uS2\u001c(B\u0001#F\u0003\u0019\u0019w.\\7p]*\u0011QA\u0012\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014x-\u0003\u0002L\u0003\n!A+[7f\u0011!i%F!A!\u0002\u0013A\u0014AD7bqJ+\u0017/^3tiNK'0\u001a\u0005\t\u001f*\u0012\t\u0011)A\u0005!\u0006q!/Z9vKN$8\t[1o]\u0016d\u0007CA\u0004R\u0013\t\u0011&A\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\u0011QS#\u0011!Q\u0001\nU\u000b\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0005\u001d1\u0016BA,\u0003\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7\u000f\u0003\u0005ZU\t\u0005\t\u0015!\u0003[\u0003Q\u0019wN\u001c8fGRLwN\\:NCbLE\r\\3NgB\u0011AbW\u0005\u000396\u0011A\u0001T8oO\"AaL\u000bB\u0001B\u0003%q,\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0002aE6\t\u0011M\u0003\u0002\u0004\u0007&\u00111-\u0019\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\tK*\u0012\t\u0011)A\u0005M\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA!Y;uQ*\u00111nQ\u0001\tg\u0016\u001cWO]5us&\u0011Q\u000e\u001b\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2D\u0001b\u001c\u0016\u0003\u0002\u0003\u0006I\u0001]\u0001\u0007G>tg-[4\u0011\u0005E$X\"\u0001:\u000b\u0005M$\u0011AB:feZ,'/\u0003\u0002ve\nY1*\u00194lC\u000e{gNZ5h\u0011!\u0011$F!A!\u0002\u00139\bC\u0001={\u001b\u0005I(B\u0001\u001aD\u0013\tY\u0018PA\u0004NKR\u0014\u0018nY:\t\u0011uT#\u0011!Q\u0001\ny\f!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feB\u0019q0a\u0001\u000e\u0005\u0005\u0005!BA6\u0005\u0013\u0011\t)!!\u0001\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\u0005\u000b\u0003\u0013Q#\u0011!Q\u0001\n\u0005-\u0011AC7f[>\u0014\u0018\u0010U8pYB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\r\u000ba!\\3n_JL\u0018\u0002BA\u000b\u0003\u001f\u0011!\"T3n_JL\bk\\8m\u0011)\tIB\u000bB\u0001B\u0003%\u00111D\u0001\u000bY><7i\u001c8uKb$\bc\u0001!\u0002\u001e%\u0019\u0011qD!\u0003\u00151{wmQ8oi\u0016DH\u000f\u0003\u0004\u0013U\u0011\u0005\u00111\u0005\u000b\u001d\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA !\t9!\u0006\u0003\u00047\u0003C\u0001\r\u0001\u000f\u0005\u0007}\u0005\u0005\u0002\u0019A \t\r5\u000b\t\u00031\u00019\u0011\u0019y\u0015\u0011\u0005a\u0001!\"1A+!\tA\u0002UCa!WA\u0011\u0001\u0004Q\u0006B\u00020\u0002\"\u0001\u0007q\f\u0003\u0004f\u0003C\u0001\rA\u001a\u0005\u0007_\u0006\u0005\u0002\u0019\u00019\t\rI\n\t\u00031\u0001x\u0011\u0019i\u0018\u0011\u0005a\u0001}\"A\u0011\u0011BA\u0011\u0001\u0004\tY\u0001\u0003\u0005\u0002\u001a\u0005\u0005\u0002\u0019AA\u000e\u000f\u001d\t\u0019E\u000bE\u0005\u0003\u000b\nAbQ8o]\u0016\u001cG/[8o\u0013\u0012\u0004B!a\u0012\u0002J5\t!FB\u0004\u0002L)BI!!\u0014\u0003\u0019\r{gN\\3di&|g.\u00133\u0014\u000b\u0005%3\"a\u0014\u0011\u00071\t\t&C\u0002\u0002T5\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqAEA%\t\u0003\t9\u0006\u0006\u0002\u0002F!A\u00111LA%\t\u0003\ti&\u0001\u0006ge>l7\u000b\u001e:j]\u001e$B!a\u0018\u0003HA)A\"!\u0019\u0002f%\u0019\u00111M\u0007\u0003\r=\u0003H/[8o!\u0011\t9%a\u001a\u0007\u000f\u0005-#\u0006\u0011\u0002\u0002jM9\u0011qM\u0006\u0002l\u0005=\u0003c\u0001\u0007\u0002n%\u0019\u0011qN\u0007\u0003\u000fA\u0013x\u000eZ;di\"Y\u00111OA4\u0005+\u0007I\u0011AA;\u0003%awnY1m\u0011>\u001cH/\u0006\u0002\u0002xA!\u0011\u0011PAD\u001d\u0011\tY(a!\u0011\u0007\u0005uT\"\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q\n\u0002\rq\u0012xn\u001c;?\u0013\r\t))D\u0001\u0007!J,G-\u001a4\n\u0007}\tIIC\u0002\u0002\u00066A1\"!$\u0002h\tE\t\u0015!\u0003\u0002x\u0005QAn\\2bY\"{7\u000f\u001e\u0011\t\u0015\u0005E\u0015q\rBK\u0002\u0013\u0005q'A\u0005m_\u000e\fG\u000eU8si\"Q\u0011QSA4\u0005#\u0005\u000b\u0011\u0002\u001d\u0002\u00151|7-\u00197Q_J$\b\u0005C\u0006\u0002\u001a\u0006\u001d$Q3A\u0005\u0002\u0005U\u0014A\u0003:f[>$X\rS8ti\"Y\u0011QTA4\u0005#\u0005\u000b\u0011BA<\u0003-\u0011X-\\8uK\"{7\u000f\u001e\u0011\t\u0015\u0005\u0005\u0016q\rBK\u0002\u0013\u0005q'\u0001\u0006sK6|G/\u001a)peRD!\"!*\u0002h\tE\t\u0015!\u00039\u0003-\u0011X-\\8uKB{'\u000f\u001e\u0011\t\u0015\u0005%\u0016q\rBK\u0002\u0013\u0005q'A\u0003j]\u0012,\u0007\u0010\u0003\u0006\u0002.\u0006\u001d$\u0011#Q\u0001\na\na!\u001b8eKb\u0004\u0003b\u0002\n\u0002h\u0011\u0005\u0011\u0011\u0017\u000b\r\u0003K\n\u0019,!.\u00028\u0006e\u00161\u0018\u0005\t\u0003g\ny\u000b1\u0001\u0002x!9\u0011\u0011SAX\u0001\u0004A\u0004\u0002CAM\u0003_\u0003\r!a\u001e\t\u000f\u0005\u0005\u0016q\u0016a\u0001q!9\u0011\u0011VAX\u0001\u0004A\u0004\u0002CA`\u0003O\"\t%!1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001e\t\u0015\u0005\u0015\u0017qMA\u0001\n\u0003\t9-\u0001\u0003d_BLH\u0003DA3\u0003\u0013\fY-!4\u0002P\u0006E\u0007BCA:\u0003\u0007\u0004\n\u00111\u0001\u0002x!I\u0011\u0011SAb!\u0003\u0005\r\u0001\u000f\u0005\u000b\u00033\u000b\u0019\r%AA\u0002\u0005]\u0004\"CAQ\u0003\u0007\u0004\n\u00111\u00019\u0011%\tI+a1\u0011\u0002\u0003\u0007\u0001\b\u0003\u0006\u0002V\u0006\u001d\u0014\u0013!C\u0001\u0003/\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002Z*\"\u0011qOAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAt\u001b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCAx\u0003O\n\n\u0011\"\u0001\u0002r\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAzU\rA\u00141\u001c\u0005\u000b\u0003o\f9'%A\u0005\u0002\u0005]\u0017AD2paf$C-\u001a4bk2$He\r\u0005\u000b\u0003w\f9'%A\u0005\u0002\u0005E\u0018AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0003\u007f\f9'%A\u0005\u0002\u0005E\u0018AD2paf$C-\u001a4bk2$H%\u000e\u0005\n\u0005\u0007\t9'!A\u0005B]\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\"\u0003B\u0004\u0003O\n\t\u0011\"\u00018\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\u0011Y!a\u001a\u0002\u0002\u0013\u0005!QB\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yA!\u0006\u0011\u00071\u0011\t\"C\u0002\u0003\u00145\u00111!\u00118z\u0011%\u00119B!\u0003\u0002\u0002\u0003\u0007\u0001(A\u0002yIEB!Ba\u0007\u0002h\u0005\u0005I\u0011\tB\u000f\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0010!\u0019\u0011\tCa\n\u0003\u00105\u0011!1\u0005\u0006\u0004\u0005Ki\u0011AC2pY2,7\r^5p]&!!\u0011\u0006B\u0012\u0005!IE/\u001a:bi>\u0014\bB\u0003B\u0017\u0003O\n\t\u0011\"\u0001\u00030\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u00032\t]\u0002c\u0001\u0007\u00034%\u0019!QG\u0007\u0003\u000f\t{w\u000e\\3b]\"Q!q\u0003B\u0016\u0003\u0003\u0005\rAa\u0004\t\u0015\tm\u0012qMA\u0001\n\u0003\u0012i$\u0001\u0005iCND7i\u001c3f)\u0005A\u0004B\u0003B!\u0003O\n\t\u0011\"\u0011\u0003D\u00051Q-];bYN$BA!\r\u0003F!Q!q\u0003B \u0003\u0003\u0005\rAa\u0004\t\u0011\t%\u0013\u0011\fa\u0001\u0003o\n\u0011a\u001d\u0005\u000b\u0005\u001b\nI%!A\u0005\u0002\n=\u0013!B1qa2LH\u0003DA3\u0005#\u0012\u0019F!\u0016\u0003X\te\u0003\u0002CA:\u0005\u0017\u0002\r!a\u001e\t\u000f\u0005E%1\na\u0001q!A\u0011\u0011\u0014B&\u0001\u0004\t9\bC\u0004\u0002\"\n-\u0003\u0019\u0001\u001d\t\u000f\u0005%&1\na\u0001q!Q!QLA%\u0003\u0003%\tIa\u0018\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\rB5!\u0015a\u0011\u0011\rB2!)a!QMA<q\u0005]\u0004\bO\u0005\u0004\u0005Oj!A\u0002+va2,W\u0007\u0003\u0006\u0003l\tm\u0013\u0011!a\u0001\u0003K\n1\u0001\u001f\u00131\u0011%\u0011yG\u000bb\u0001\n\u0013\u0011\t(\u0001\boK^\u001cuN\u001c8fGRLwN\\:\u0016\u0005\tM\u0004C\u0002B;\u0005\u007f\u0012\u0019)\u0004\u0002\u0003x)!!\u0011\u0010B>\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005{b\u0012\u0001B;uS2LAA!!\u0003x\t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007\u0003\u0002BC\u0005\u001fk!Aa\"\u000b\t\t%%1R\u0001\tG\"\fgN\\3mg*\u0019!Q\u0012\u000f\u0002\u00079Lw.\u0003\u0003\u0003\u0012\n\u001d%!D*pG.,Go\u00115b]:,G\u000e\u0003\u0005\u0003\u0016*\u0002\u000b\u0011\u0002B:\u0003=qWm^\"p]:,7\r^5p]N\u0004\u0003\"\u0003BMU\t\u0007I\u0011\u0002BN\u0003EIgN\u001a7jO\"$(+Z:q_:\u001cXm]\u000b\u0003\u0005;\u0003\u0002Ba(\u0003&\u0006]$\u0011V\u0007\u0003\u0005CSAAa)\u0003$\u00059Q.\u001e;bE2,\u0017\u0002\u0002BT\u0005C\u00131!T1q!\u0011\u0011YK!-\u000f\u0007\u001d\u0011i+C\u0002\u00030\n\taBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u00034\nU&\u0001\u0003*fgB|gn]3\u000b\u0007\t=&\u0001\u0003\u0005\u0003:*\u0002\u000b\u0011\u0002BO\u0003IIgN\u001a7jO\"$(+Z:q_:\u001cXm\u001d\u0011\t\u0013\tu&F1A\u0005\n\t}\u0016!\u0004:fgB|gn]3Rk\u0016,X-\u0006\u0002\u0003BB1!Q\u000fBb\u0005SKAA!2\u0003x\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<G)Z9vK\"A!\u0011\u001a\u0016!\u0002\u0013\u0011\t-\u0001\bsKN\u0004xN\\:f#V,W/\u001a\u0011\t\u0015\t5'F1A\u0005\u0002\u0011\u0011y-\u0001\u0006nKR\u0014\u0018n\u0019+bON,\"A!5\u0011\r\tM'Q\u001b\r\u0019\u001b\t\u0011Y(\u0003\u0003\u0003(\nm\u0004\u0002\u0003BmU\u0001\u0006IA!5\u0002\u00175,GO]5d)\u0006<7\u000f\t\u0005\n\u0005;T#\u0019!C\u0005\u0005?\f\u0001b]3mK\u000e$xN]\u000b\u0003\u0005C\u00042\u0001\u0019Br\u0013\r\u0011)/\u0019\u0002\t'\u0016dWm\u0019;pe\"A!\u0011\u001e\u0016!\u0002\u0013\u0011\t/A\u0005tK2,7\r^8sA!A!Q\u001e\u0016\u0005\u0012\t\u0011y/\u0001\bde\u0016\fG/Z*fY\u0016\u001cGo\u001c:\u0015\t\t\u0005(\u0011\u001f\u0005\t\u0005g\u0014Y\u000f1\u0001\u0003v\u0006q1\r[1o]\u0016d')^5mI\u0016\u0014\bc\u00011\u0003x&\u0019!\u0011`1\u0003\u001d\rC\u0017M\u001c8fY\n+\u0018\u000e\u001c3fe\"A!Q \u0016A\u0002\u0013%q'A\noKb$8i\u001c8oK\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010C\u0005\u0004\u0002)\u0002\r\u0011\"\u0003\u0004\u0004\u00059b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq~#S-\u001d\u000b\u0005\u0007\u000b\u0019Y\u0001E\u0002\r\u0007\u000fI1a!\u0003\u000e\u0005\u0011)f.\u001b;\t\u0013\t]!q`A\u0001\u0002\u0004A\u0004bBB\bU\u0001\u0006K\u0001O\u0001\u0015]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r\u001f\u0011\t\u000f\rM!\u0006\"\u0011\u0004\u0016\u0005\u0019!/\u001e8\u0015\u0005\r\u0015\u0001bBB\rU\u0011%11D\u0001\u0011aJ|7-Z:t\u000bb\u001cW\r\u001d;j_:$ba!\u0002\u0004\u001e\r\u0005\u0002\u0002CB\u0010\u0007/\u0001\r!a\u001e\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\t\u0011\r\r2q\u0003a\u0001\u0007K\t\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\r\u001d2\u0011\u0007\b\u0005\u0007S\u0019iC\u0004\u0003\u0002~\r-\u0012\"\u0001\b\n\u0007\r=R\"A\u0004qC\u000e\\\u0017mZ3\n\t\rM2Q\u0007\u0002\n)\"\u0014xn^1cY\u0016T1aa\f\u000e\u0011\u001d\u0019ID\u000bC\u0005\u0007w\tq\u0003\u001d:pG\u0016\u001c8o\u00115b]:,G.\u0012=dKB$\u0018n\u001c8\u0015\u0011\r\u00151QHB!\u0007\u0007B\u0001ba\u0010\u00048\u0001\u0007\u0011qO\u0001\nG\"\fgN\\3m\u0013\u0012D\u0001ba\b\u00048\u0001\u0007\u0011q\u000f\u0005\t\u0007G\u00199\u00041\u0001\u0004&!91q\t\u0016\u0005\n\rU\u0011a\u00059s_\u000e,7o\u001d(foJ+7\u000f]8og\u0016\u001c\b\u0002CB&U\u0011E!a!\u0014\u0002\u0019M,g\u000e\u001a*fgB|gn]3\u0015\r\r\u00151qJB*\u0011!\u0019\tf!\u0013A\u0002\t%\u0016\u0001\u0003:fgB|gn]3\t\u0011\rU3\u0011\na\u0001\u0007/\nAB]3ta>t7/Z*f]\u0012\u00042\u0001YB-\u0013\r\u0019Y&\u0019\u0002\u0005'\u0016tG\rC\u0004\u0004`)\"Ia!\u0006\u0002\tA|G\u000e\u001c\u0005\b\u0007GRC\u0011BB\u000b\u0003a\u0001(o\\2fgN\u001cu.\u001c9mKR,GMU3dK&4Xm\u001d\u0005\b\u0007ORC\u0011BB\u000b\u0003U\u0001(o\\2fgN\u001cu.\u001c9mKR,GmU3oINDqaa\u001b+\t\u0013\u0019i'\u0001\u000bva\u0012\fG/\u001a*fcV,7\u000f^'fiJL7m\u001d\u000b\u0005\u0007\u000b\u0019y\u0007\u0003\u0005\u0004R\r%\u0004\u0019\u0001BU\u0011\u001d\u0019\u0019H\u000bC\u0005\u0007+\t1\u0003\u001d:pG\u0016\u001c8\u000fR5tG>tg.Z2uK\u0012Dqaa\u001e+\t\u0013\u0019I(A\u0003dY>\u001cX\r\u0006\u0003\u0004\u0006\rm\u0004\u0002CB?\u0007k\u0002\r!a\u001e\u0002\u0019\r|gN\\3di&|g.\u00133\t\u000f\r\u0005%\u0006\"\u0001\u0004\u0004\u00061\u0011mY2faR$Ba!\u0002\u0004\u0006\"A1qQB@\u0001\u0004\u0011\u0019)A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\u0007\u0017SC\u0011BB\u000b\u0003]\u0019wN\u001c4jOV\u0014XMT3x\u0007>tg.Z2uS>t7\u000fC\u0004\u0004\u0010*\"Ia!\u0006\u0002\u0011\rdwn]3BY2D\u0001b! +\t#\u001111\u0013\u000b\u0005\u0003o\u001a)\n\u0003\u0005\u0004\u0018\u000eE\u0005\u0019ABM\u0003\u0019\u0019xnY6fiB!11TBQ\u001b\t\u0019iJC\u0002\u0004 r\t1A\\3u\u0013\u0011\u0019\u0019k!(\u0003\rM{7m[3u\u0011!\u00199K\u000bC\u0001\u0005\r%\u0016aD3ocV,W/\u001a*fgB|gn]3\u0015\t\r\u001511\u0016\u0005\t\u0007#\u001a)\u000b1\u0001\u0003*\"91q\u0016\u0016\u0005\n\rE\u0016a\u00043fcV,W/\u001a*fgB|gn]3\u0015\u0005\t%\u0006bBB[U\u0011\u0005!aN\u0001\u0012e\u0016\u001c\bo\u001c8tKF+X-^3TSj,\u0007bBB]U\u0011\u0005!aN\u0001\u0016S:4G.[4iiJ+7\u000f]8og\u0016\u001cu.\u001e8u\u0011!\u0019iL\u000bC\u0001\u0005\r}\u0016\u0001F8qK:|%o\u00117pg&twm\u00115b]:,G\u000e\u0006\u0003\u0004B\u000e%\u0007#\u0002\u0007\u0002b\r\r\u0007c\u00011\u0004F&\u00191qY1\u0003\u0019-\u000bgm[1DQ\u0006tg.\u001a7\t\u0011\ru41\u0018a\u0001\u0003oBqa!4+\t\u0013\u0019y-\u0001\fiC:$G.Z\"iC:tW\r\\'vi\u0016,e/\u001a8u)\u0019\u0019)a!5\u0004T\"A1QPBf\u0001\u0004\t9\b\u0003\u0005\u0004V\u000e-\u0007\u0019ABl\u0003\u0015)g/\u001a8u!\u0011\u0019Ina=\u000f\t\rm7q\u001e\b\u0005\u0007;\u001ciO\u0004\u0003\u0004`\u000e-h\u0002BBq\u0007StAaa9\u0004h:!\u0011QPBs\u0013\u0005I\u0015BA$I\u0013\t)a)\u0003\u0002E\u000b&\u00111aQ\u0005\u0004\u0007c\f\u0017\u0001D&bM.\f7\t[1o]\u0016d\u0017\u0002BB{\u0007o\u0014\u0001c\u00115b]:,G.T;uK\u00163XM\u001c;\u000b\u0007\rE\u0018\rC\u0004\u0004|*\"Ia!@\u0002!Q\u0014\u00180\u00168nkR,7\t[1o]\u0016dG\u0003BB\u0003\u0007\u007fD\u0001b! \u0004z\u0002\u0007\u0011q\u000f\u0005\t\t\u0007QC\u0011\u0001\u0002\u0005\u0006\u000591\r[1o]\u0016dG\u0003BBa\t\u000fA\u0001b! \u0005\u0002\u0001\u0007\u0011q\u000f\u0005\t\t\u0017QC\u0011\u0001\u0002\u0005\u000e\u0005\tb.^7Ti\u0006<W\r\u001a*fG\u0016Lg/Z:\u0015\u0007a\"y\u0001\u0003\u0005\u0004~\u0011%\u0001\u0019AA<\u0011\u001d!\u0019B\u000bC!\u0007+\taa^1lKV\u0004\bb\u0002C\fU\u0011\u00053QC\u0001\tg\",H\u000fZ8x]\u0002")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    public final Metrics kafka$network$Processor$$metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final Selector selector;
    private int nextConnectionIndex;

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            this.config.addReconfigurable((Reconfigurable)channelBuilder3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.kafka$network$Processor$$metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        block7: {
            this.startupComplete();
            block5: while (true) {
                while (this.isRunning()) {
                    try {
                        this.configureNewConnections();
                        this.processNewResponses();
                        this.poll();
                        this.processCompletedReceives();
                        this.processCompletedSends();
                        this.processDisconnected();
                        continue block5;
                    }
                    catch (Throwable e) {
                        this.processException("Processor got uncaught exception.", e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
                this.shutdownComplete();
            }
        }
    }

    private void processException(String errorMessage, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ControlThrowable) {
            ControlThrowable controlThrowable = (ControlThrowable)throwable2;
            throw (Throwable)controlThrowable;
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse = null;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                BoxedUnit boxedUnit;
                RequestChannel.Response response = currentResponse;
                if (response instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)response;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)response;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        block1: {
            String connectionId = response.request().context().connectionId;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
            if (this.channel(connectionId).isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
                response.request().updateRequestMetrics(0L, response);
            }
            if (!this.openOrClosingChannel(connectionId).isDefined()) break block1;
            this.selector().send(responseSend);
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        try {
            this.selector().poll(300L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$4(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        block0: {
            RequestChannel.Response response = this.responseQueue().poll();
            if (response == null) break block0;
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public int numStagedReceives(String connectionId) {
        return BoxesRunTime.unboxToInt((Object)this.openOrClosingChannel(connectionId).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)Processor.$anonfun$numStagedReceives$1(this, c))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            KafkaChannel channel = (KafkaChannel)some.value();
            RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
            String connectionId = receive.source();
            RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol);
            RequestChannel.Request req = new RequestChannel.Request($this.id(), context, $this.time.nanoseconds(), $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
            $this.requestChannel.sendRequest(req);
            $this.selector().mute(connectionId);
            $this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable e) {
            $this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            RequestChannel.Response response = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destination()).append(" completed, but not in `inflightResponses`").toString());
            });
            $this.updateRequestMetrics(response);
            response.onComplete().foreach((Function1 & Serializable & scala.Serializable)onComplete -> {
                onComplete.apply((Object)send);
                return BoxedUnit.UNIT;
            });
            $this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
            $this.tryUnmuteChannel(send.destination());
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId).toString());
            })).remoteHost();
            $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
                $this.updateRequestMetrics(response);
                return BoxedUnit.UNIT;
            });
            $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
        }
        catch (Throwable e) {
            $this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append(connectionId).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$2, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$2).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec(address);
        }
        $this.selector().close(connectionId$2);
        $this.inflightResponses().remove((Object)connectionId$2).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public static final /* synthetic */ int $anonfun$numStagedReceives$1(Processor $this, KafkaChannel c) {
        return $this.selector().numStagedReceives(c);
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.kafka$network$Processor$$metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)$anon$4.$anonfun$value$6(m))));
            }

            public static final /* synthetic */ double $anonfun$value$6(KafkaMetric m) {
                return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$5(), $anonfun$value$6$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        ListenerName listenerName2 = listenerName;
        ListenerName listenerName3 = config.interBrokerListenerName();
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (!(listenerName2 != null ? !listenerName2.equals(listenerName3) : listenerName3 != null) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache()));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

