/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochFileCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011%i\u0001A!A!\u0002\u0013q1$\u0001\u0003oC6,\u0007CA\b\u0019\u001d\t\u0001b\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\r\u00051AH]8pizR\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011q\u0003F\u0005\u0003\u001bqI!!\b\u0010\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u0003?\u0011\tQ!\u001e;jYND\u0011\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0015\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0011aB2mkN$XM]\u0005\u0003O\u0011\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0003\u0002\"\u0015!A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002\nY%\u0011QF\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003\u0013EJ!A\r\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"AA\u0007\u0001B\u0001B\u0003%Q'A\u0003rk>$\u0018\r\u0005\u0002\nm%\u0011qG\u0001\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"!C\u001e\n\u0005q\u0012!\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}Q9\u0001)\u0011\"D\t\u00163\u0005CA\u0005\u0001\u0011\u0015iQ\b1\u0001\u000f\u0011\u0015\tS\b1\u0001#\u0011\u0015QS\b1\u0001,\u0011\u0015yS\b1\u00011\u0011\u0015!T\b1\u00016\u0011\u0015IT\b1\u0001;\u000b\u0011A\u0005\u0001A%\u0003\u0007I+\u0015\u000b\u0005\u0002K5:\u00111j\u0014\b\u0003\u0019:s!!E'\n\u0003\u0015I!a\u0001\u0003\b\u000bA\u0013\u0001\u0012A)\u00023I+\u0007\u000f\\5dC\u0006cG/\u001a:M_\u001e$\u0015N]:UQJ,\u0017\r\u001a\t\u0003\u0013I3Q!\u0001\u0002\t\u0002M\u001b\"A\u0015+\u0011\u0005U3V\"\u0001\u000b\n\u0005]#\"AB!osJ+g\rC\u0003?%\u0012\u0005\u0011\fF\u0001R\r\u0015Y&\u000b\u0001\u0002]\u000511U\r^2i%\u0016\fX/Z:u'\rQF+\u0018\t\u0003=\u0006t!!C0\n\u0005\u0001\u0014\u0011!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u00037\nT!\u0001\u0019\u0002\t\u0011\u0011T&Q1A\u0005\u0002\u0015\f!\"\u001e8eKJd\u00170\u001b8h+\u00051\u0007CA4u\u001d\tA'/D\u0001j\u0015\tQ7.\u0001\u0005sKF,Xm\u001d;t\u0015\taW.\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b9T!a\u001c9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0018aA8sO&\u00111/[\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0003kZ\u0014qAQ;jY\u0012,'O\u0003\u0002tS\"A\u0001P\u0017B\u0001B\u0003%a-A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003\"\u0002 [\t\u0003QHCA>~!\ta(,D\u0001S\u0011\u0015!\u0017\u00101\u0001g\u0011\u0019y(\f\"\u0001\u0002\u0002\u00059\u0011n]#naRLXCAA\u0002!\r)\u0016QA\u0005\u0004\u0003\u000f!\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0017QF\u0011AA\u0007\u0003\u0019ygMZ:fiR!\u0011qBA\u000b!\r)\u0016\u0011C\u0005\u0004\u0003'!\"\u0001\u0002'p]\u001eD\u0001\"a\u0006\u0002\n\u0001\u0007\u0011\u0011D\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tY\"!\b\u000e\u0003-L1!a\bl\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\t[\t\u0003\n)#\u0001\u0005u_N#(/\u001b8h)\t\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\t1\fgn\u001a\u0006\u0003\u0003c\tAA[1wC&\u0019\u0011$a\u000b\u0007\u000f\u0005]\"\u000b\u0001\u0002\u0002:\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006\u001cR!!\u000eU\u0003w\u00012AXA\u001f\u0013\r\t9D\u0019\u0005\u000bI\u0006U\"Q1A\u0005\u0002\u0005\u0005SCAA\"!\u0019\t)%a\u0013\u0002P9\u0019\u0001.a\u0012\n\u0007\u0005%\u0013.A\u0007GKR\u001c\u0007NU3ta>t7/Z\u0005\u0005\u0003o\tiEC\u0002\u0002J%\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+Z\u0017A\u0002:fG>\u0014H-\u0003\u0003\u0002Z\u0005M#a\u0002*fG>\u0014Hm\u001d\u0005\u000bq\u0006U\"\u0011!Q\u0001\n\u0005\r\u0003b\u0002 \u00026\u0011\u0005\u0011q\f\u000b\u0005\u0003C\n\u0019\u0007E\u0002}\u0003kAq\u0001ZA/\u0001\u0004\t\u0019\u0005\u0003\u0005\u0002h\u0005UB\u0011AA5\u0003\u0015)'O]8s+\t\tY\u0007\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\th[\u0001\taJ|Go\\2pY&!\u0011QOA8\u0005\u0019)%O]8sg\"A\u0011\u0011PA\u001b\t\u0003\tY(A\u0005u_J+7m\u001c:egV\u0011\u0011Q\u0010\t\u0005\u0003#\ny(\u0003\u0003\u0002\u0002\u0006M#!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u0002\u0006\u0006UB\u0011AAD\u00035A\u0017n\u001a5XCR,'/\\1sWV\u0011\u0011q\u0002\u0005\t\u0003\u0017\u000b)\u0004\"\u0001\u0002\b\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002CAH\u0003k!\t!!%\u0002\u0013\u0015D8-\u001a9uS>tWCAAJ!\u0015)\u0016QSAM\u0013\r\t9\n\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005m\u0015Q\u0015\b\u0005\u0003;\u000b\tKD\u0002\u0012\u0003?K\u0011!F\u0005\u0004\u0003G#\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003O\u000bIKA\u0005UQJ|w/\u00192mK*\u0019\u00111\u0015\u000b\t\u0011\u0005\r\u0012Q\u0007C!\u0003K)a!a,\u0001\u0001\u0005E&A\u0001)E!\rQ\u0015Q\u0007\u0005\n\u0003k\u0003!\u0019!C\u0005\u0003o\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0005\u0005e\u0006cA+\u0002<&\u0019\u0011Q\u0018\u000b\u0003\u0007%sG\u000f\u0003\u0005\u0002B\u0002\u0001\u000b\u0011BA]\u0003)\u0011X\r\u001d7jG\u0006LE\r\t\u0005\n\u0003\u000b\u0004!\u0019!C\u0005\u0003\u000f\f\u0001\"\\1y\u0005f$Xm]\u000b\u0003\u0003\u0013\u0004B!!\u000b\u0002L&!\u0011QZA\u0016\u0005\u001dIe\u000e^3hKJD\u0001\"!5\u0001A\u0003%\u0011\u0011Z\u0001\n[\u0006D()\u001f;fg\u0002B\u0011\"!6\u0001\u0005\u0004%I!a2\u0002\u0013\u0019,Go\u00195TSj,\u0007\u0002CAm\u0001\u0001\u0006I!!3\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0004\u0002^\u0002!\t!a8\u0002\u000b\u0019,Go\u00195\u0015\t\u0005\u0005\u00181\u001f\t\u0007\u0003G\fI/!<\u000e\u0005\u0005\u0015(bAAt)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0018Q\u001d\u0002\u0004'\u0016\f\bcB+\u0002p\u0006e\u0011\u0011W\u0005\u0004\u0003c$\"A\u0002+va2,'\u0007C\u0004\u0002v\u0006m\u0007\u0019A%\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\t\u000f\u0005e\b\u0001\"\u0001\u0002|\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"!@\u0003\u0004\t\u0015!\u0011\u0002\t\u0004+\u0006}\u0018b\u0001B\u0001)\t!QK\\5u\u0011!\t9\"a>A\u0002\u0005e\u0001\u0002\u0003B\u0004\u0003o\u0004\r!a\u0004\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\t\u0005\u0017\t9\u00101\u0001\u00022\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006DqAa\u0004\u0001\t\u0003\u0011\t\"\u0001\fiC:$G.Z(gMN,GoT;u\u001f\u001a\u0014\u0016M\\4f)\u0011\tyAa\u0005\t\u0011\u0005]!Q\u0002a\u0001\u00033AqAa\u0006\u0001\t\u0003\u0011I\"\u0001\u000eiC:$G.\u001a)beRLG/[8og^KG\u000f[#se>\u00148\u000f\u0006\u0003\u0002~\nm\u0001\u0002\u0003B\u000f\u0005+\u0001\rAa\b\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002\u001c\n\u0005\u0012\u0011D\u0005\u0005\u0005G\tIK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u00119\u0003\u0001C\u0001\u0005S\tqCY;jY\u0012dU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;\u0015\t\t-\"\u0011\b\t\u0007\u0005[\u0011yCa\r\u000f\u0005-{\u0016b\u0001B\u0019E\n!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N\u0004\u0002\"a9\u00036\u0005e\u0011\u0011X\u0005\u0005\u0005o\t)OA\u0002NCBD\u0001Ba\u000f\u0003&\u0001\u0007!QH\u0001\u000eC2d\u0007+\u0019:uSRLwN\\:\u0011\r\u0005\r\u0018\u0011\u001eB !\u001d)\u0016q^A\r\u0005\u0003\u00022!\u0003B\"\u0013\r\u0011)E\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0003U1W\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$BA!\u0014\u0003VAA\u00111\u001dB\u001b\u00033\u0011y\u0005E\u0002i\u0005#J1Aa\u0015j\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRD\u0001B!\b\u0003H\u0001\u0007!1\u0007\u0005\b\u00053\u0002A\u0011\u0001B.\u00035i\u0017-\u001f2f)J,hnY1uKR!!Q\fB4!\u0019\u0011iCa\f\u0003`AA\u00111\u001dB\u001b\u00033\u0011\t\u0007E\u0002\n\u0005GJ1A!\u001a\u0003\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016D\u0001B!\u001b\u0003X\u0001\u0007!QJ\u0001\u000eM\u0016$8\r[3e\u000bB|7\r[:\t\u000f\t5\u0004\u0001\"\u0001\u0003p\u0005\t\"-^5mI\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\tE$1\u000f\t\u0006\u0005[\u0011y#\u0013\u0005\t\u0005k\u0012Y\u00071\u0001\u0003>\u0005a\u0001/\u0019:uSRLwN\\'ba\u0002")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        org.apache.kafka.common.requests.FetchRequest request = (org.apache.kafka.common.requests.FetchRequest)fetchRequest.underlying().build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return (Seq)((Seq)partitionData.elem).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition key = (TopicPartition)tuple2._1();
            FetchResponse.PartitionData value = (FetchResponse.PartitionData)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData((FetchResponse.PartitionData<Records>)value));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica futureReplica = this.replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        if (fetchOffset != futureReplica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset().messageOffset())})));
        }
        partition.appendRecordsToFollowerOrFutureReplica(records, true);
        long futureReplicaHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(futureReplica.logEndOffset().messageOffset()), partitionData.highWatermark());
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(futureReplicaHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset());
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica futureReplica = this.replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Replica currentReplica = this.replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        long logEndOffset = currentReplica.logEndOffset().messageOffset();
        if (logEndOffset < futureReplica.logEndOffset().messageOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)futureReplica.logEndOffset().messageOffset()), BoxesRunTime.boxToLong((long)logEndOffset)})));
            partition.truncateTo(logEndOffset, true);
            l = logEndOffset;
        } else {
            long currentReplicaStartOffset = currentReplica.logStartOffset();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's start offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)futureReplica.logEndOffset().messageOffset()), BoxesRunTime.boxToLong((long)currentReplicaStartOffset)})));
            long offsetToFetch = Math.max(currentReplicaStartOffset, futureReplica.logEndOffset().messageOffset());
            if (currentReplicaStartOffset > futureReplica.logEndOffset().messageOffset()) {
                partition.truncateFullyAndStartAt(currentReplicaStartOffset, true);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        }
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$buildLeaderEpochRequest$2(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.epochCacheOpt$1(tp));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$buildLeaderEpochRequest$4(x0$5)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map partitionsWithEpoch2 = (scala.collection.immutable.Map)tuple23._1();
        scala.collection.immutable.Map partitionsWithoutEpoch2 = (scala.collection.immutable.Map)tuple23._2();
        scala.collection.immutable.Map result = (scala.collection.immutable.Map)partitionsWithEpoch2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Option epochCacheOpt = (Option)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)((LeaderEpochFileCache)epochCacheOpt.get()).latestEpoch()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new AbstractFetcherThread.ResultWithPartitions<scala.collection.immutable.Map>(result, (Set<TopicPartition>)partitionsWithoutEpoch2.keys().toSet());
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$7;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                int epoch = tuple22._2$mcI$sp();
                try {
                    Tuple2<Object, Object> tuple23 = ((LeaderEpochFileCache)$this.replicaMgr.getReplicaOrException(tp).epochs().get()).endOffsetFor(epoch);
                    if (tuple23 == null) {
                        throw new MatchError(tuple23);
                    }
                    int leaderEpoch = tuple23._1$mcI$sp();
                    long leaderOffset = tuple23._2$mcJ$sp();
                    Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(leaderEpoch, leaderOffset);
                    Tuple2.mcIJ.sp sp3 = sp2;
                    int leaderEpoch2 = sp3._1$mcI$sp();
                    long leaderOffset2 = sp3._2$mcJ$sp();
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, leaderEpoch2, leaderOffset2));
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            SetLike setLike;
            Tuple2 tuple2 = x0$8;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Replica futureReplica = $this.replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
                    Partition partition = (Partition)$this.replicaMgr.getPartition(topicPartition).get();
                    if (epochOffset.hasError()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Retrying leaderEpoch request for partition ").append(topicPartition).append(" as the current replica reported an error: ").append(epochOffset.error()).toString());
                        setLike = partitionsWithError.$plus$eq((Object)topicPartition);
                    } else {
                        OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState(topicPartition, epochOffset, futureReplica, true);
                        partition.truncateTo(offsetTruncationState.offset(), true);
                        setLike = fetchOffsets.put((Object)topicPartition, (Object)offsetTruncationState);
                    }
                }
                catch (KafkaStorageException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to truncate ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    setLike = partitionsWithError.$plus$eq((Object)topicPartition);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            SetLike setLike2 = setLike;
            return setLike2;
        });
        return new AbstractFetcherThread.ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        BoxedUnit boxedUnit;
        Option maxPartitionOpt = ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$buildFetchRequest$1(this, x0$9)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$greater((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() < ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (maxPartitionOpt.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)maxPartitionOpt.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)partitionFetchState);
            Tuple2 tuple23 = tuple22;
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            PartitionFetchState partitionFetchState2 = (PartitionFetchState)tuple23._2();
            try {
                long logStartOffset = this.replicaMgr.getReplicaOrException(topicPartition2, Request$.MODULE$.FutureLocalReplicaId()).logStartOffset();
                boxedUnit = requestMap.put(topicPartition2, new FetchRequest.PartitionData(partitionFetchState2.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize())));
            }
            catch (KafkaStorageException kafkaStorageException) {
                boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition2);
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(requestBuilder), (Set<TopicPartition>)partitionsWithError);
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Option epochCacheOpt$1(TopicPartition tp) {
        return this.replicaMgr.getReplica(tp, Request$.MODULE$.FutureLocalReplicaId()).map((Function1 & Serializable & scala.Serializable)x$2 -> (LeaderEpochFileCache)x$2.epochs().get());
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$2(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState state = (PartitionFetchState)tuple2._2();
        boolean bl = state.isTruncatingLog();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$4(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option epochCacheOpt = (Option)tuple2._2();
        boolean bl = epochCacheOpt.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildFetchRequest$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch() && !$this.quota.isQuotaExceeded();
        return bl;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, true);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.underlying().fetchData()).asScala()).apply((Object)topicPartition)).fetchOffset;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData<Records> underlying;

        public FetchResponse.PartitionData<Records> underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            MemoryRecords memoryRecords;
            BaseRecords baseRecords = this.underlying().records;
            MemoryRecords memoryRecords2 = MemoryRecords.EMPTY;
            if (!(baseRecords != null ? !baseRecords.equals(memoryRecords2) : memoryRecords2 != null)) {
                memoryRecords = (MemoryRecords)this.underlying().records;
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(this.underlying().records.sizeInBytes());
                ((FileRecords)this.underlying().records).readInto(buffer, 0);
                memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
            }
            return memoryRecords;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData<Records> underlying) {
            this.underlying = underlying;
        }
    }
}

