/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.epoch.LeaderEpochFileCache;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\r\u001de\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u000e\u0002\t9\fW.\u001a\t\u0003\u001faq!\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011A\u0002\u001fs_>$hHC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9B#\u0001\u0004Qe\u0016$WMZ\u0005\u00033i\u0011aa\u0015;sS:<'BA\f\u0015\u0013\tiA$\u0003\u0002\u001e=\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0015\tyB!A\u0003vi&d7\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003%1W\r^2iKJLE\r\u0005\u0002$I5\tA#\u0003\u0002&)\t\u0019\u0011J\u001c;\t\u0013\u001d\u0002!\u0011!Q\u0001\n!r\u0013\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003\u001d\u0019G.^:uKJL!!\f\u0016\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qE\u0003\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005a!M]8lKJ\u001cuN\u001c4jOB\u0011\u0011BM\u0005\u0003g\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"AQ\u0007\u0001B\u0001B\u0003%a'\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!C\u001c\n\u0005a\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u001fF\u001b\u0005i$B\u0001\u001e?\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\b\u001b\u0016$(/[2t\u0011!A\u0005A!A!\u0002\u0013I\u0015\u0001\u0002;j[\u0016\u0004\"A\u0013'\u000e\u0003-S!a\b \n\u00055[%\u0001\u0002+j[\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0006cV|G/\u0019\t\u0003\u0013EK!A\u0015\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\u0011Q\u0003!\u0011!Q\u0001\nU\u000b!\u0004\\3bI\u0016\u0014XI\u001c3q_&tGO\u00117pG.LgnZ*f]\u0012\u00042a\t,Y\u0013\t9FC\u0001\u0004PaRLwN\u001c\t\u0003\u0013eK!A\u0017\u0002\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\t\u000bq\u0003A\u0011A/\u0002\rqJg.\u001b;?))qv\fY1cG\u0012,gm\u001a\t\u0003\u0013\u0001AQ!D.A\u00029AQ!I.A\u0002\tBQaJ.A\u0002!BQ\u0001M.A\u0002EBQ!N.A\u0002YBQAO.A\u0002mBQ\u0001S.A\u0002%CQaT.A\u0002ACq\u0001V.\u0011\u0002\u0003\u0007Q+\u0002\u0003j\u0001\u0001Q'a\u0001*F#B\u00111N\u001f\b\u0003YBt!!\\8\u000f\u0005Eq\u0017\"A\u0003\n\u0005\r!q!B9\u0003\u0011\u0003\u0011\u0018\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002\ng\u001a)\u0011A\u0001E\u0001iN\u00111/\u001e\t\u0003GYL!a\u001e\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015a6\u000f\"\u0001z)\u0005\u0011h!B>t\u0001\ta(\u0001\u0004$fi\u000eD'+Z9vKN$8c\u0001>v{B\u0019a0a\u0001\u000f\u0005%y\u0018bAA\u0001\u0005\u0005)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017bA>\u0002\u0006)\u0019\u0011\u0011\u0001\u0002\t\u0015\u0005%!P!b\u0001\n\u0003\tY!\u0001\u0007tKN\u001c\u0018n\u001c8QCJ$8/\u0006\u0002\u0002\u000eAA\u0011qBA\r\u0003;\t)#\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006LA!a\u0007\u0002\u0012\t\u0019Q*\u00199\u0011\t\u0005}\u0011\u0011E\u0007\u0002}%\u0019\u00111\u0005 \u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011qEA\u001a\u001d\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017}\u0005A!/Z9vKN$8/\u0003\u0003\u00022\u0005-\u0012\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BA\u001b\u0003o\u0011Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BA\u0019\u0003WA!\"a\u000f{\u0005\u0003\u0005\u000b\u0011BA\u0007\u00035\u0019Xm]:j_:\u0004\u0016M\u001d;tA!Q\u0011q\b>\u0003\u0006\u0004%\t!!\u0011\u0002\u0015UtG-\u001a:ms&tw-\u0006\u0002\u0002DA!\u0011qEA#\u0013\u0011\t9%a\u000e\u0003\u000f\t+\u0018\u000e\u001c3fe\"Q\u00111\n>\u0003\u0002\u0003\u0006I!a\u0011\u0002\u0017UtG-\u001a:ms&tw\r\t\u0005\u00079j$\t!a\u0014\u0015\r\u0005E\u0013QKA,!\r\t\u0019F_\u0007\u0002g\"A\u0011\u0011BA'\u0001\u0004\ti\u0001\u0003\u0005\u0002@\u00055\u0003\u0019AA\"\u0011\u001d\tYF\u001fC\u0001\u0003;\naa\u001c4gg\u0016$H\u0003BA0\u0003K\u00022aIA1\u0013\r\t\u0019\u0007\u0006\u0002\u0005\u0019>tw\r\u0003\u0005\u0002h\u0005e\u0003\u0019AA\u000f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\u001b{\t\u0003\ni'A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005=\u0004cA\u0012\u0002r%\u0019\u00111\u000f\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u000f>\u0005B\u0005e\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\t\u0005\u0005\u0015QC\u0001\u0005Y\u0006tw-C\u0002\u001a\u0003\u007f2q!!\u000et\u0001\t\t9iE\u0003\u0002\u0006V\fI\tE\u0002\u007f\u0003\u0017KA!!\u000e\u0002\u0006!Y\u0011qHAC\u0005\u000b\u0007I\u0011AAH+\t\t\t\n\u0005\u0004\u0002\u0014\u0006e\u0015Q\u0014\b\u0005\u0003S\t)*\u0003\u0003\u0002\u0018\u0006-\u0012!\u0004$fi\u000eD'+Z:q_:\u001cX-\u0003\u0003\u00026\u0005m%\u0002BAL\u0003W\u0001B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003Gs\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0002(\u0006\u0005&a\u0002*fG>\u0014Hm\u001d\u0005\f\u0003\u0017\n)I!A!\u0002\u0013\t\t\nC\u0004]\u0003\u000b#\t!!,\u0015\t\u0005=\u0016\u0011\u0017\t\u0005\u0003'\n)\t\u0003\u0005\u0002@\u0005-\u0006\u0019AAI\u0011!\t),!\"\u0005\u0002\u0005]\u0016!B3se>\u0014XCAA]!\u0011\tY,!1\u000e\u0005\u0005u&bAA`}\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002D\u0006u&AB#se>\u00148\u000f\u0003\u0005\u0002H\u0006\u0015E\u0011AAe\u0003%!xNU3d_J$7/\u0006\u0002\u0002LB!\u0011qTAg\u0013\u0011\ty-!)\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\t\u0019.!\"\u0005\u0002\u0005U\u0017!\u00045jO\"<\u0016\r^3s[\u0006\u00148.\u0006\u0002\u0002`!A\u0011\u0011\\AC\t\u0003\t).\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u0011\u0005u\u0017Q\u0011C\u0001\u0003?\f\u0011\"\u001a=dKB$\u0018n\u001c8\u0016\u0005\u0005\u0005\b\u0003B\u0012W\u0003G\u0004B!!:\u0002p:!\u0011q]Av\u001d\r\t\u0012\u0011^\u0005\u0002+%\u0019\u0011Q\u001e\u000b\u0002\u000fA\f7m[1hK&!\u0011\u0011_Az\u0005%!\u0006N]8xC\ndWMC\u0002\u0002nRA\u0001\"a\u001e\u0002\u0006\u0012\u0005\u0013\u0011\u0010\u0005\n\u0003s\u001c\u0018\u0013!C\u0001\u0003w\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTCAA\u007fU\r)\u0016q`\u0016\u0003\u0005\u0003\u0001BAa\u0001\u0003\u000e5\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!A\u0005v]\u000eDWmY6fI*\u0019!1\u0002\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0010\t\u0015!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00161!1\u0003\u0001\u0001\u0005+\u0011!\u0001\u0015#\u0011\u0007-\f)\tC\u0005\u0003\u001a\u0001\u0011\r\u0011\"\u0003\u0003\u001c\u0005I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002E!9!q\u0004\u0001!\u0002\u0013\u0011\u0013A\u0003:fa2L7-Y%eA!I!1\u0005\u0001C\u0002\u0013%!QE\u0001\u000bY><7i\u001c8uKb$XC\u0001B\u0014!\rQ%\u0011F\u0005\u0004\u0005WY%A\u0003'pO\u000e{g\u000e^3yi\"A!q\u0006\u0001!\u0002\u0013\u00119#A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0003\"\u0003B\u001a\u0001\t\u0007I\u0011\u0002B\u001b\u00039aW-\u00193fe\u0016sG\r]8j]R,\u0012\u0001\u0017\u0005\b\u0005s\u0001\u0001\u0015!\u0003Y\u0003=aW-\u00193fe\u0016sG\r]8j]R\u0004\u0003B\u0003B\u001f\u0001\t\u0007I\u0011\u0001\u0002\u0003@\u0005\u0019b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]V\u0011!\u0011\t\t\u0004G\t\r\u0013b\u0001B#)\t)1\u000b[8si\"A!\u0011\n\u0001!\u0002\u0013\u0011\t%\u0001\u000bgKR\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g\u000e\t\u0005\u000b\u0005\u001b\u0002!\u0019!C\u0001\u0005\t}\u0012AI8gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g\u000e\u0003\u0005\u0003R\u0001\u0001\u000b\u0011\u0002B!\u0003\rzgMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiZ+'o]5p]\u0002B!B!\u0016\u0001\u0005\u0004%\tA\u0001B \u0003aa\u0017n\u001d;PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e,feNLwN\u001c\u0005\t\u00053\u0002\u0001\u0015!\u0003\u0003B\u0005IB.[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8!\u0011%\u0011i\u0006\u0001b\u0001\n\u0013\ti'\u0001\fgKR\u001c\u0007.T3uC\u0012\fG/Y*vaB|'\u000f^3e\u0011!\u0011\t\u0007\u0001Q\u0001\n\u0005=\u0014a\u00064fi\u000eDW*\u001a;bI\u0006$\u0018mU;qa>\u0014H/\u001a3!\u0011%\u0011)\u0007\u0001b\u0001\n\u0013\u00119'A\u0004nCb<\u0016-\u001b;\u0016\u0005\t%\u0004\u0003BA?\u0005WJAA!\u001c\u0002\u0000\t9\u0011J\u001c;fO\u0016\u0014\b\u0002\u0003B9\u0001\u0001\u0006IA!\u001b\u0002\u00115\f\u0007pV1ji\u0002B\u0011B!\u001e\u0001\u0005\u0004%IAa\u001a\u0002\u00115LgNQ=uKND\u0001B!\u001f\u0001A\u0003%!\u0011N\u0001\n[&t')\u001f;fg\u0002B\u0011B! \u0001\u0005\u0004%IAa\u001a\u0002\u00115\f\u0007PQ=uKND\u0001B!!\u0001A\u0003%!\u0011N\u0001\n[\u0006D()\u001f;fg\u0002B\u0011B!\"\u0001\u0005\u0004%IAa\u001a\u0002\u0013\u0019,Go\u00195TSj,\u0007\u0002\u0003BE\u0001\u0001\u0006IA!\u001b\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0005\u0003\u000e\u0002\u0011\r\u0011\"\u0003\u0002n\u0005a2\u000f[8vY\u0012\u001cVM\u001c3MK\u0006$WM]#q_\u000eD'+Z9vKN$\b\u0002\u0003BI\u0001\u0001\u0006I!a\u001c\u0002;MDw.\u001e7e'\u0016tG\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\u0002B\u0011B!&\u0001\u0005\u0004%IAa&\u0002'\u0019,Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\te\u0005\u0003\u0002BN\u0005Ck!A!(\u000b\u0007\t}\u0005)A\u0004dY&,g\u000e^:\n\t\t\r&Q\u0014\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0005\t\u0005O\u0003\u0001\u0015!\u0003\u0003\u001a\u0006!b-\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7fe\u0002BqAa+\u0001\t\u0013\u0011i+A\u0007fa>\u001c\u0007nQ1dQ\u0016|\u0005\u000f\u001e\u000b\u0005\u0005_\u0013i\f\u0005\u0003$-\nE\u0006\u0003\u0002BZ\u0005sk!A!.\u000b\u0007\t]&!A\u0003fa>\u001c\u0007.\u0003\u0003\u0003<\nU&\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\r\u0003\u0005\u0003@\n%\u0006\u0019AA\u000f\u0003\t!\b\u000fC\u0004\u0003D\u0002!\tE!2\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA8\u0011\u001d\u0011I\r\u0001C\u0001\u0005\u0017\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003\u0003Bg\u0005'\u0014)N!7\u0011\u0007\r\u0012y-C\u0002\u0003RR\u0011A!\u00168ji\"A\u0011q\rBd\u0001\u0004\ti\u0002\u0003\u0005\u0003X\n\u001d\u0007\u0019AA0\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u0011\tm'q\u0019a\u0001\u0005+\tQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007b\u0002Bp\u0001\u0011\u0005!\u0011]\u0001\u001c[\u0006L(-Z,be:Lem\u0014<feNL'0\u001a3SK\u000e|'\u000fZ:\u0015\r\t5'1\u001dBt\u0011!\u0011)O!8A\u0002\u0005-\u0017a\u0002:fG>\u0014Hm\u001d\u0005\t\u0003O\u0012i\u000e1\u0001\u0002\u001e!9!1\u001e\u0001\u0005\u0002\t5\u0018A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\t\u0005}#q\u001e\u0005\t\u0003O\u0012I\u000f1\u0001\u0002\u001e!9!1\u001f\u0001\u0005\u0002\tU\u0018A\u00075b]\u0012dW\rU1si&$\u0018n\u001c8t/&$\b.\u0012:s_J\u001cH\u0003\u0002Bg\u0005oD\u0001B!?\u0003r\u0002\u0007!1`\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBAs\u0005{\fi\"\u0003\u0003\u0003\u0000\u0006M(\u0001C%uKJ\f'\r\\3\t\u000f\r\r\u0001\u0001\"\u0005\u0004\u0006\u0005)a-\u001a;dQR!1qAB\n!\u0019\t)o!\u0003\u0004\u000e%!11BAz\u0005\r\u0019V-\u001d\t\bG\r=\u0011Q\u0004B\u000b\u0013\r\u0019\t\u0002\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\rU1\u0011\u0001a\u0001U\u0006aa-\u001a;dQJ+\u0017/^3ti\"91\u0011\u0004\u0001\u0005\n\rm\u0011AF3be2LWm\u001d;Pe2\u000bG/Z:u\u001f\u001a47/\u001a;\u0015\r\u0005}3QDB\u0010\u0011!\t9ga\u0006A\u0002\u0005u\u0001\u0002CB\u0011\u0007/\u0001\r!a\u0018\u0002!\u0015\f'\u000f\\5fgR|%\u000fT1uKN$\bbBB\u0013\u0001\u0011\u00053qE\u0001\u0012EVLG\u000e\u001a$fi\u000eD'+Z9vKN$H\u0003BB\u0015\u0007_\u0001BA`B\u0016U&!1QFA\u0003\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og\"A1\u0011GB\u0012\u0001\u0004\u0019\u0019$\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000f\u0005\u0004\u0002f\u000e%1Q\u0007\t\bG\r=\u0011QDB\u001c!\rI1\u0011H\u0005\u0004\u0007w\u0011!a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007bBB \u0001\u0011\u00053\u0011I\u0001\u000e[\u0006L(-\u001a+sk:\u001c\u0017\r^3\u0015\t\r\r3Q\u000b\t\u0006}\u000e-2Q\t\t\t\u0007\u000f\u001ai%!\b\u0004P5\u00111\u0011\n\u0006\u0004\u0007\u0017\"\u0012AC2pY2,7\r^5p]&!\u00111DB%!\rI1\u0011K\u0005\u0004\u0007'\u0012!!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\u0005\t\u0007/\u001ai\u00041\u0001\u0004Z\u0005ia-\u001a;dQ\u0016$W\t]8dQN\u0004\u0002ba\u0012\u0004N\u0005u11\f\t\u0005\u0003S\u0019i&\u0003\u0003\u0004`\u0005-\"AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0007G\u0002A\u0011IB3\u0003]\u0011W/\u001b7e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0003\u0004h\r-\u0004#\u0002@\u0004,\r%\u0004cBB$\u0007\u001b\niB\t\u0005\t\u0007[\u001a\t\u00071\u0001\u00044\u0005i\u0011\r\u001c7QCJ$\u0018\u000e^5p]NDqa!\u001d\u0001\t\u0003\u001a\u0019(A\u000bgKR\u001c\u0007.\u00129pG\"\u001chI]8n\u0019\u0016\fG-\u001a:\u0015\t\re3Q\u000f\u0005\t\u0005s\u001cy\u00071\u0001\u0004j!91\u0011\u0010\u0001\u0005\n\rm\u0014AF:i_VdGMR8mY><XM\u001d+ie>$H\u000f\\3\u0015\r\u0005=4QPB@\u0011\u0019y5q\u000fa\u0001!\"A\u0011qMB<\u0001\u0004\ti\u0002C\u0007\u0004\u0004\u0002\u0001\n1!A\u0001\n\u0013\u0019)IL\u0001\u0013gV\u0004XM\u001d\u0013t_V\u00148-\u001a\"s_.,'/F\u0001)\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final boolean fetchMetadataSupported;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean shouldSendLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private boolean fetchMetadataSupported() {
        return this.fetchMetadataSupported;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean shouldSendLeaderEpochRequest() {
        return this.shouldSendLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    private Option<LeaderEpochFileCache> epochCacheOpt(TopicPartition tp) {
        return this.replicaMgr.getReplica(tp).map((Function1 & Serializable & scala.Serializable)x$1 -> (LeaderEpochFileCache)x$1.epochs().get());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block2: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown) break block2;
            try {
                this.leaderEndpoint().close();
            }
            catch (Throwable t) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Fail to close leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica replica = this.replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark());
        long leaderLogStartOffset = partitionData.logStartOffset();
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        this.replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        block0: {
            if (this.fetchRequestVersion() > 2 || records.sizeInBytes() <= 0 || records.validBytes() > 0) break block0;
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica replica = this.replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L);
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replica.logEndOffset().messageOffset()).append(" to current ").append(new StringBuilder(23).append("leader's latest offset ").append(leaderEndOffset).toString()).toString());
            partition.truncateTo(leaderEndOffset, false);
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), topicPartition, leaderEndOffset);
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L);
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replica.logEndOffset().messageOffset()).append(" to current ").append(new StringBuilder(22).append("leader's start offset ").append(leaderStartOffset).toString()).toString());
            long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
            if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
                partition.truncateFullyAndStartAt(leaderStartOffset, false);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        }
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        Object object;
        try {
            ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest.underlying());
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            object = !this.fetchSessionHandler().handleResponse(fetchResponse) ? Nil$.MODULE$ : (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition key = (TopicPartition)tuple2._1();
                FetchResponse.PartitionData value = (FetchResponse.PartitionData)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData((FetchResponse.PartitionData<Records>)value));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return object;
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest) {
        ListOffsetRequest.Builder builder;
        if (this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Predef$.MODULE$.long2Long(earliestOrLatest))}));
            builder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        } else {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            builder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setOffsetData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        }
        ListOffsetRequest.Builder requestBuilder = builder;
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = partitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long((Long)partitionData.offsets.get(0));
        return l;
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                if (partitionFetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, topicPartition)) {
                    try {
                        long logStartOffset = $this.replicaMgr.getReplicaOrException(topicPartition).logStartOffset();
                        builder.add(topicPartition, new FetchRequest.PartitionData(partitionFetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize())));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget());
        Object object = this.fetchMetadataSupported() ? requestBuilder.metadata(fetchData.metadata()) : BoxedUnit.UNIT;
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(fetchData.sessionPartitions(), requestBuilder), (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            SetLike setLike;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset leaderEpochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Replica replica = $this.replicaMgr.getReplicaOrException(tp);
                    Partition partition = (Partition)$this.replicaMgr.getPartition(tp).get();
                    if (leaderEpochOffset.hasError()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Retrying leaderEpoch request for partition ").append(replica.topicPartition()).append(" as the leader reported an error: ").append(leaderEpochOffset.error()).toString());
                        setLike = partitionsWithError.$plus$eq((Object)tp);
                    } else {
                        OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState(tp, leaderEpochOffset, replica, this.getOffsetTruncationState$default$4());
                        if (offsetTruncationState.offset() < replica.highWatermark().messageOffset()) {
                            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(replica.highWatermark().messageOffset()).toString());
                        }
                        partition.truncateTo(offsetTruncationState.offset(), false);
                        if (offsetTruncationState.truncationCompleted()) {
                            $this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation($this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
                        }
                        setLike = fetchOffsets.put((Object)tp, (Object)offsetTruncationState);
                    }
                }
                catch (KafkaStorageException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to truncate ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    setLike = partitionsWithError.$plus$eq((Object)tp);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            SetLike setLike2 = setLike;
            return setLike2;
        });
        return new AbstractFetcherThread.ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$buildLeaderEpochRequest$1(x0$4)))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), this.epochCacheOpt(tp));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$buildLeaderEpochRequest$3(x0$6)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map partitionsWithEpoch2 = (scala.collection.immutable.Map)tuple23._1();
        scala.collection.immutable.Map partitionsWithoutEpoch2 = (scala.collection.immutable.Map)tuple23._2();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Build leaderEpoch request ").append(partitionsWithEpoch2).toString());
        scala.collection.immutable.Map result = (scala.collection.immutable.Map)partitionsWithEpoch2.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Option epochCacheOpt = (Option)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)((LeaderEpochFileCache)epochCacheOpt.get()).latestEpoch()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new AbstractFetcherThread.ResultWithPartitions<scala.collection.immutable.Map>(result, (Set<TopicPartition>)partitionsWithoutEpoch2.keys().toSet());
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        ObjectRef result = ObjectRef.create(null);
        if (this.shouldSendLeaderEpochRequest()) {
            java.util.Map partitionsAsJava = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                int epoch = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)epoch));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(this.offsetForLeaderEpochRequestVersion(), partitionsAsJava);
            try {
                ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
                result.elem = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Receive leaderEpoch response ").append((Map)result$1.elem).toString());
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                result.elem = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple2 tuple2 = x0$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
            }
        } else {
            result.elem = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, -1, -1L));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }
        return (Map)result.elem;
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition.topic(), topicPartition.partition());
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$1(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState state = (PartitionFetchState)tuple2._2();
        boolean bl = state.isTruncatingLog();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$3(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option epochCacheOpt = (Option)tuple2._2();
        boolean bl = epochCacheOpt.nonEmpty();
        return bl;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, true);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(39).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").append(new StringBuilder(12).append("fetcherId=").append(fetcherId).append("] ").toString()).toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append(this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), this.logContext()));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))));
        short s = this.offsetForLeaderEpochRequestVersion = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? (short)1 : 0;
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)));
        this.fetchMetadataSupported = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$);
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.shouldSendLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts;
        private final FetchRequest.Builder underlying;

        public java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts() {
            return this.sessionParts;
        }

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return this.sessionParts().get((Object)topicPartition).fetchOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.sessionParts().isEmpty() && this.underlying().toForget().isEmpty();
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts, FetchRequest.Builder underlying) {
            this.sessionParts = sessionParts;
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData<Records> underlying;

        public FetchResponse.PartitionData<Records> underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            return (MemoryRecords)this.underlying().records;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData<Records> underlying) {
            this.underlying = underlying;
        }
    }
}

