/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.QuotaType;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001\u001d\u0011qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011ABU3qY&\u001c\u0017-U;pi\u0006D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007G>tg-[4\u0016\u0003m\u0001\"!\u0006\u000f\n\u0005u\u0011!!\b*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\t\u0011}\u0001!\u0011!Q\u0001\nm\tqaY8oM&<\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0003#\u0003\u001diW\r\u001e:jGN,\u0012a\t\t\u0003I5j\u0011!\n\u0006\u0003C\u0019R!a\n\u0015\u0002\r\r|W.\\8o\u0015\t)\u0011F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u0005\u001diU\r\u001e:jGND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaI\u0001\t[\u0016$(/[2tA!A!\u0007\u0001BC\u0002\u0013%1'A\bsKBd\u0017nY1uS>tG+\u001f9f+\u0005!\u0004CA\u000b6\u0013\t1$AA\u0005Rk>$\u0018\rV=qK\"A\u0001\b\u0001B\u0001B\u0003%A'\u0001\tsKBd\u0017nY1uS>tG+\u001f9fA!A!\b\u0001BC\u0002\u0013%1(\u0001\u0003uS6,W#\u0001\u001f\u0011\u0005uzT\"\u0001 \u000b\u0005E1\u0013B\u0001!?\u0005\u0011!\u0016.\\3\t\u0011\t\u0003!\u0011!Q\u0001\nq\nQ\u0001^5nK\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtD#\u0002$H\u0011&S\u0005CA\u000b\u0001\u0011\u0015I2\t1\u0001\u001c\u0011\u0015\t3\t1\u0001$\u0011\u0015\u00114\t1\u00015\u0011\u0015Q4\t1\u0001=\u0011\u001da\u0005A1A\u0005\n5\u000bA\u0001\\8dWV\ta\n\u0005\u0002P16\t\u0001K\u0003\u0002R%\u0006)An\\2lg*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0015\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"11\f\u0001Q\u0001\n9\u000bQ\u0001\\8dW\u0002Bq!\u0018\u0001C\u0002\u0013%a,A\nuQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7/F\u0001`!\u0011\u0001\u0017m\u00198\u000e\u0003IK!A\u0019*\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002eW:\u0011Q-\u001b\t\u0003M*i\u0011a\u001a\u0006\u0003Q\u001a\ta\u0001\u0010:p_Rt\u0014B\u00016\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)T\u0001cA8uo:\u0011\u0001O\u001d\b\u0003MFL\u0011aC\u0005\u0003g*\tq\u0001]1dW\u0006<W-\u0003\u0002vm\n\u00191+Z9\u000b\u0005MT\u0001CA\u0005y\u0013\tI(BA\u0002J]RDaa\u001f\u0001!\u0002\u0013y\u0016\u0001\u0006;ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004~\u0001\u0001\u0007I\u0011\u0002@\u0002\u000bE,x\u000e^1\u0016\u0003}\u00042\u0001JA\u0001\u0013\r\t\u0019!\n\u0002\u0006#V|G/\u0019\u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0005\u0003\u0013\t\u0011\"];pi\u0006|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u0004\u0013\u00055\u0011bAA\b\u0015\t!QK\\5u\u0011%\t\u0019\"!\u0002\u0002\u0002\u0003\u0007q0A\u0002yIEBq!a\u0006\u0001A\u0003&q0\u0001\u0004rk>$\u0018\r\t\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;\tAb]3og>\u0014\u0018iY2fgN,\"!a\b\u0011\u0007U\t\t#C\u0002\u0002$\t\u0011AbU3og>\u0014\u0018iY2fgND\u0001\"a\n\u0001A\u0003%\u0011qD\u0001\u000eg\u0016t7o\u001c:BG\u000e,7o\u001d\u0011\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0012A\u0004:bi\u0016lU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003_\u0001B!!\r\u000245\ta%C\u0002\u00026\u0019\u0012!\"T3ue&\u001cg*Y7f\u0011!\tI\u0004\u0001Q\u0001\n\u0005=\u0012a\u0004:bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005YQ\u000f\u001d3bi\u0016\fVo\u001c;b)\u0011\tY!!\u0011\t\ru\fY\u00041\u0001\u0000\u0011\u001d\t)\u0005\u0001C!\u0003\u000f\nq\"[:Rk>$\u0018-\u0012=dK\u0016$W\rZ\u000b\u0003\u0003\u0013\u00022!CA&\u0013\r\tiE\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0006\u0001C!\u0003'\n1\"[:UQJ|G\u000f\u001e7fIR!\u0011\u0011JA+\u0011!\t9&a\u0014A\u0002\u0005e\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003c\tY&C\u0002\u0002^\u0019\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002b\u0001!\t!a\u0019\u0002\rI,7m\u001c:e)\u0011\tY!!\u001a\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003S\nQA^1mk\u0016\u00042!CA6\u0013\r\tiG\u0003\u0002\u0005\u0019>tw\rC\u0004\u0002r\u0001!\t!a\u001d\u0002\u001b5\f'o\u001b+ie>$H\u000f\\3e)\u0019\tY!!\u001e\u0002z!9\u0011qOA8\u0001\u0004\u0019\u0017!\u0002;pa&\u001c\u0007bBA>\u0003_\u0002\rA\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bbBA9\u0001\u0011\u0005\u0011q\u0010\u000b\u0005\u0003\u0017\t\t\tC\u0004\u0002x\u0005u\u0004\u0019A2\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006q!/Z7pm\u0016$\u0006N]8ui2,G\u0003BA\u0006\u0003\u0013Cq!a\u001e\u0002\u0004\u0002\u00071\rC\u0004\u0002\u000e\u0002!\t!a$\u0002\u0015U\u0004\b/\u001a:C_VtG\r\u0006\u0002\u0002j!9\u00111\u0013\u0001\u0005\n\u0005U\u0015\u0001F4fiF+x\u000e^1NKR\u0014\u0018nY\"p]\u001aLw\r\u0006\u0003\u0002\u0018\u0006u\u0005c\u0001\u0013\u0002\u001a&\u0019\u00111T\u0013\u0003\u00195+GO]5d\u0007>tg-[4\t\ru\f\t\n1\u0001\u0000\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u000baa]3og>\u0014HCAAS!\r!\u0013qU\u0005\u0004\u0003S+#AB*f]N|'\u000f")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType replicationType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota quota;
    private final SensorAccess sensorAccess;
    private final MetricName rateMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicationQuotaManager replicationQuotaManager = this;
        synchronized (replicationQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private QuotaType replicationType() {
        return this.replicationType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    private Quota quota() {
        return this.quota;
    }

    private void quota_$eq(Quota x$1) {
        this.quota = x$1;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    private MetricName rateMetricName() {
        return this.rateMetricName;
    }

    public void updateQuota(Quota quota) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.quota_$eq(quota);
                KafkaMetric metric = (KafkaMetric)this.metrics().metrics().get(this.rateMetricName());
                if (metric == null) break block0;
                metric.config(this.getQuotaMetricConfig(quota));
            }
        });
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s: Quota violated for sensor (%s), metric: (%s), metric-value: (%f), bound: (%f)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicationType(), this.sensor().name(), qve.metricName(), BoxesRunTime.boxToDouble((double)qve.value()), BoxesRunTime.boxToDouble((double)qve.bound())})));
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        return partitions != null ? partitions == Constants$.MODULE$.AllReplicas() || partitions.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())) : false;
    }

    @Override
    public void record(long value) {
        try {
            this.sensor().record((double)value);
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Record: Quota violated, but ignored, for sensor (").append(this.sensor().name()).append("), metric: (").append(qve.metricName()).append("), value : (").append(qve.value()).append("), bound: (").append(qve.bound()).append("), recordedValue (").append(value).append(")").toString());
        }
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, Constants$.MODULE$.AllReplicas());
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public long upperBound() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.quota() != null ? (long)this.quota().bound() : Long.MAX_VALUE));
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess().getOrCreate(this.replicationType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.rateMetricName(), (Function0<Option<MetricConfig>>)(Function0 & Serializable & scala.Serializable)() -> new Some((Object)this.getQuotaMetricConfig(this.quota())), (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new SimpleRate());
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.replicationType = replicationType;
        this.time = time;
        Logging.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.quota = null;
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(replicationType).toString());
    }
}

