/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u0011!Q\u0001\nY\taaY8oM&<\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0019\u0019XM\u001d<fe&\u00111\u0004\u0007\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011q$J\u0005\u0003M\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!A\u0003A!A!\u0002\u0013I\u0013\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005)jS\"A\u0016\u000b\u00051\"\u0011A\u0001>l\u0013\tq3FA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005q\u0001/\u0019:uSRLwN\\*uCR,\u0007\u0003\u0002\u001a8s\u0011k\u0011a\r\u0006\u0003iU\nq!\\;uC\ndWM\u0003\u00027\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001a$aA'baB\u0011!HQ\u0007\u0002w)\u0011A(P\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q$BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001eL!aQ\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011q$R\u0005\u0003\r\n\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\r\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003q\u0019wN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"a\b&\n\u0005-\u0013!\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0005\u0006\u001b\u0002!\tAT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f=\u0003\u0016KU*U+B\u0011q\u0004\u0001\u0005\u0006+1\u0003\rA\u0006\u0005\u0006;1\u0003\rA\b\u0005\u0006G1\u0003\r\u0001\n\u0005\u0006Q1\u0003\r!\u000b\u0005\u0006a1\u0003\r!\r\u0005\u0006\u00112\u0003\r!\u0013\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u00031\u0019wN\u001c;s_2dWM]%e+\u0005I\u0006CA\u0005[\u0013\tY&BA\u0002J]RDa!\u0018\u0001!\u0002\u0013I\u0016!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\u0006!Bo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ,\u0012!\u0019\t\u0003?\tL!a\u0019\u0002\u0003)Q{\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3s\u0011%)\u0007\u00011AA\u0002\u0013%a-\u0001\ru_BL7\rR3mKRLwN\\'b]\u0006<WM]0%KF$\"a\u001a6\u0011\u0005%A\u0017BA5\u000b\u0005\u0011)f.\u001b;\t\u000f-$\u0017\u0011!a\u0001C\u0006\u0019\u0001\u0010J\u0019\t\u00135\u0004\u0001\u0019!A!B\u0013\t\u0017!\u0006;pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000f\t\u0005\b_\u0002\u0001\r\u0011\"\u0001Y\u0003UygM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gnQ8v]RDq!\u001d\u0001A\u0002\u0013\u0005!/A\rpM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;`I\u0015\fHCA4t\u0011\u001dY\u0007/!AA\u0002eCa!\u001e\u0001!B\u0013I\u0016AF8gM2Lg.\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0011\t\u000b]\u0004A\u0011\u0001=\u0002\u000fM$\u0018M\u001d;vaR\tq\rC\u0003{\u0001\u0011\u0005\u00010\u0001\u0005tQV$Hm\\<o\u0011\u0015a\b\u0001\"\u0001~\u0003]\u0019X\r\u001e+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000f\u0006\u0002h}\")ql\u001fa\u0001C\"1\u0011\u0011\u0001\u0001\u0005\na\f\u0001$\u001b8ji&\fG.\u001b>f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0019\t)\u0001\u0001C\u0001q\u0006\tCO]5hO\u0016\u0014xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\u0005.\u00198hK\"9\u0011Q\u0001\u0001\u0005\u0002\u0005%AcA4\u0002\f!A\u0011QBA\u0004\u0001\u0004\ty!A\u0003u_BL7\r\u0005\u0003\u0002\u0012\u0005}a\u0002BA\n\u00037\u00012!!\u0006\u000b\u001b\t\t9BC\u0002\u0002\u001a\u0019\ta\u0001\u0010:p_Rt\u0014bAA\u000f\u0015\u00051\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\b\u000b\u0011\u001d\t)\u0001\u0001C\u0001\u0003O!2aZA\u0015\u0011\u001d\u0001\u0014Q\u0005a\u0001\u0003W\u0001b!!\u0005\u0002.e\"\u0015b\u0001\u001d\u0002$!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$raZA\u001b\u0003\u0017\ny\u0005\u0003\u0005\u00028\u0005=\u0002\u0019AA\u001d\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003w\t)%\u000f\b\u0005\u0003{\t\tE\u0004\u0003\u0002\u0016\u0005}\u0012\"A\u0006\n\u0007\u0005\r#\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\u0004'\u0016\f(bAA\"\u0015!9\u0011QJA\u0018\u0001\u0004!\u0015a\u0003;be\u001e,Go\u0015;bi\u0016D!\"!\u0015\u00020A\u0005\t\u0019AA*\u0003\t\u0002\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_(qiB)\u0011\"!\u0016\u0002Z%\u0019\u0011q\u000b\u0006\u0003\r=\u0003H/[8o!\ry\u00121L\u0005\u0004\u0003;\u0012!a\b)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'R\u0014\u0018\r^3hs\"9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0014!\u00059beRLG/[8og&s7\u000b^1uKR!\u0011QMA6!\u0015\t\t\"a\u001a:\u0013\u0011\tI'a\t\u0003\u0007M+G\u000fC\u0004\u0002n\u0005}\u0003\u0019\u0001#\u0002\u000bM$\u0018\r^3\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t\u0005i1\r[1oO\u0016\u001cF/\u0019;f)>$raZA;\u0003s\ni\bC\u0004\u0002x\u0005=\u0004\u0019A\u001d\u0002\u0013A\f'\u000f^5uS>t\u0007bBA>\u0003_\u0002\r\u0001R\u0001\rGV\u0014(/\u001a8u'R\fG/\u001a\u0005\b\u0003\u001b\ny\u00071\u0001E\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000bq#\u001e9eCR,7i\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:\u0015\u000f\u001d\f))a\"\u0002\n\"9\u0011qOA@\u0001\u0004I\u0004bBA>\u0003\u007f\u0002\r\u0001\u0012\u0005\b\u0003\u001b\ny\b1\u0001E\u0011\u001d\ti\t\u0001C\u0005\u0003\u001f\u000bA\u0003Z8IC:$G.Z*uCR,7\t[1oO\u0016\u001cHcB4\u0002\u0012\u0006M\u0015Q\u0013\u0005\t\u0003o\tY\t1\u0001\u0002:!9\u0011QJAF\u0001\u0004!\u0005\u0002CA)\u0003\u0017\u0003\r!a\u0015\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\u0006\u0019\u0013N\\5uS\u0006d\u0017N_3MK\u0006$WM]!oI&\u001b(OR8s!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\u001d\u0003;C\u0001\"a\u000e\u0002\u0018\u0002\u0007\u0011\u0011\b\u0005\b\u0003C\u0003A\u0011BAR\u0003a)G.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003s\t)+a*\t\u0011\u0005]\u0012q\u0014a\u0001\u0003sA\u0001\"!+\u0002 \u0002\u0007\u0011\u0011L\u0001 a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eL\bbBAW\u0001\u0011%\u0011qV\u0001\u001bI>,E.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003c\u000by,!1\u0011\u0013%\t\u0019,!\u000f\u0002:\u0005]\u0016bAA[\u0015\t1A+\u001e9mKN\u0002r!!\u0005\u0002.e\nI\f\u0005\u0003\u0002<\u0005m\u0016\u0002BA_\u0003\u0013\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u0011\u0005]\u00121\u0016a\u0001\u0003sA\u0001\"!+\u0002,\u0002\u0007\u0011\u0011\f\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003AaW-\u00193fe\u001a{'o\u00144gY&tW\r\u0006\u0003\u0002J\u0006u\u0007CBA\u001e\u0003\u000b\nY\r\u0005\u0005\n\u0003gK\u0014QZAn!\u0015I\u0011QKAh!\u0011\t\t.a6\u000e\u0005\u0005M'bAAk\t\u0005\u0019\u0011\r]5\n\t\u0005e\u00171\u001b\u0002\r\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\t\u0006\u0003w\t)%\u0017\u0005\t\u0003?\f\u0019\r1\u0001\u0002b\u0006aB.Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"\u001c\bCBA\u001e\u0003\u000b\n\u0019\u000f\u0005\u0004\n\u0003KL\u0014\u0011^\u0005\u0004\u0003OT!A\u0002+va2,'\u0007E\u0002 \u0003WL1!!<\u0003\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\u0018!\u00057fC\u0012,'OR8s%\u0016\f7o]5h]R!\u0011\u0011ZA{\u0011!\ty.a<A\u0002\u0005\u0005\bbBA}\u0001\u0011%\u00111`\u0001\u001aY\u0016\fG-\u001a:G_J\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017\r\u0006\u0003\u0002J\u0006u\b\u0002CAp\u0003o\u0004\r!!9\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005YB.Z1eKJ4uN]\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:$b!!3\u0003\u0006\t\u001d\u0001\u0002CAp\u0003\u007f\u0004\r!!9\t\u0011\t%\u0011q a\u0001\u0005\u0017\t1c\u001d5viRLgn\u001a#po:\u0014%o\\6feN\u0004R!!\u0005\u0002heCqAa\u0004\u0001\t\u0013\u0011\t\"A\tjgZ\u000bG.\u001b3Ue\u0006t7/\u001b;j_:$bAa\u0005\u0003\u001a\tm\u0001cA\u0005\u0003\u0016%\u0019!q\u0003\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u000fB\u0007\u0001\u0004I\u0004bBA'\u0005\u001b\u0001\r\u0001\u0012\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0003QawnZ%om\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R)qMa\t\u0003&!9\u0011q\u000fB\u000f\u0001\u0004I\u0004bBA'\u0005;\u0001\r\u0001\u0012\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u0003Qawn\u001a$bS2,Gm\u0015;bi\u0016\u001c\u0005.\u00198hKRIqM!\f\u00030\tM\"Q\u0007\u0005\b\u0003o\u00129\u00031\u0001:\u0011\u001d\u0011\tDa\nA\u0002\u0011\u000b\u0011bY;seN#\u0018\r^3\t\u000f\u00055#q\u0005a\u0001\t\"A!q\u0007B\u0014\u0001\u0004\u0011I$\u0001\u0003d_\u0012,\u0007\u0003\u0002B\u001e\u0005#rAA!\u0010\u0003L9!!q\bB$\u001d\u0011\u0011\tE!\u0012\u000f\t\u0005U!1I\u0005\u0002\u0003&\u0011q\bQ\u0005\u0004\u0005\u0013r\u0014!\u0003>p_.,W\r]3s\u0013\u0011\u0011iEa\u0014\u0002\u001f-+W\r]3s\u000bb\u001cW\r\u001d;j_:T1A!\u0013?\u0013\u0011\u0011\u0019F!\u0016\u0003\t\r{G-\u001a\u0006\u0005\u0005\u001b\u0012y\u0005C\u0004\u0003*\u0001!IA!\u0017\u0015\u0013\u001d\u0014YF!\u0018\u0003`\t\u0005\u0004bBA<\u0005/\u0002\r!\u000f\u0005\b\u0005c\u00119\u00061\u0001E\u0011\u001d\tiEa\u0016A\u0002\u0011C\u0001Ba\u0019\u0003X\u0001\u0007!QM\u0001\u0002iB!\u00111\bB4\u0013\u0011\u0011I'!\u0013\u0003\u0013QC'o\\<bE2,\u0007\"\u0003B7\u0001E\u0005I\u0011\u0001B8\u0003qA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\"A!\u001d+\t\u0005M#1O\u0016\u0003\u0005k\u0002BAa\u001e\u0003\u00026\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(A\u0005v]\u000eDWmY6fI*\u0019!q\u0010\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0004\ne$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class PartitionStateMachine
implements Logging {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final Map<TopicPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;
    private TopicDeletionManager topicDeletionManager;
    private int offlinePartitionCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private TopicDeletionManager topicDeletionManager() {
        return this.topicDeletionManager;
    }

    private void topicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.topicDeletionManager = x$1;
    }

    public int offlinePartitionCount() {
        return this.offlinePartitionCount;
    }

    public void offlinePartitionCount_$eq(int x$1) {
        this.offlinePartitionCount = x$1;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing partition state");
        this.initializePartitionState();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering online partition state changes");
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Started partition state machine with initial state -> ").append($this.partitionState).toString());
    }

    public void shutdown() {
        this.partitionState.clear();
        this.offlinePartitionCount_$eq(0);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void setTopicDeletionManager(TopicDeletionManager topicDeletionManager) {
        this.topicDeletionManager_$eq(topicDeletionManager);
    }

    private void initializePartitionState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            PartitionStateMachine.$anonfun$initializePartitionState$1(this, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void triggerOnlinePartitionStateChange() {
        this.triggerOnlinePartitionStateChange((scala.collection.immutable.Map<TopicPartition, PartitionState>)this.partitionState.toMap(Predef$.MODULE$.$conforms()));
    }

    public void triggerOnlinePartitionStateChange(String topic) {
        this.triggerOnlinePartitionStateChange((scala.collection.immutable.Map<TopicPartition, PartitionState>)this.partitionState.filterKeys((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(topic, p))).toMap(Predef$.MODULE$.$conforms()));
    }

    public void triggerOnlinePartitionStateChange(scala.collection.immutable.Map<TopicPartition, PartitionState> partitionState) {
        Seq partitionsToTrigger = ((MapLike)partitionState.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$2(this, x0$1)))).keys().toSeq();
        this.handleStateChanges((Seq<TopicPartition>)partitionsToTrigger, OnlinePartition$.MODULE$, (Option<PartitionLeaderElectionStrategy>)Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
    }

    public void handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        if (partitions.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Controller moved to another broker when moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error while moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public Option<PartitionLeaderElectionStrategy> handleStateChanges$default$3() {
        return None$.MODULE$;
    }

    public Set<TopicPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, x0$2)))).keySet().toSet();
    }

    private void changeStateTo(TopicPartition partition, PartitionState currentState, PartitionState targetState) {
        this.partitionState.put((Object)partition, (Object)targetState);
        this.updateControllerMetrics(partition, currentState, targetState);
    }

    private void updateControllerMetrics(TopicPartition partition, PartitionState currentState, PartitionState targetState) {
        block1: {
            block2: {
                if (this.topicDeletionManager().isTopicWithDeletionStarted(partition.topic())) break block1;
                PartitionState partitionState = currentState;
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (!(partitionState == null ? offlinePartition$ != null : !partitionState.equals(offlinePartition$))) break block2;
                PartitionState partitionState2 = targetState;
                OfflinePartition$ offlinePartition$2 = OfflinePartition$.MODULE$;
                if (partitionState2 != null ? !partitionState2.equals(offlinePartition$2) : offlinePartition$2 != null) break block2;
                this.offlinePartitionCount_$eq(this.offlinePartitionCount() + 1);
                break block1;
            }
            PartitionState partitionState = currentState;
            OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
            if (partitionState != null ? !partitionState.equals(offlinePartition$) : offlinePartition$ != null) break block1;
            PartitionState partitionState3 = targetState;
            OfflinePartition$ offlinePartition$3 = OfflinePartition$.MODULE$;
            if (partitionState3 == null ? offlinePartition$3 != null : !partitionState3.equals(offlinePartition$3)) {
                this.offlinePartitionCount_$eq(this.offlinePartitionCount() - 1);
            }
        }
    }

    private void doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> (PartitionState)$this.partitionState.getOrElseUpdate(partition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$));
        Tuple2 tuple2 = partitions.partition((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.isValidTransition(partition, targetState)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validPartitions, (Object)invalidPartitions);
        Tuple2 tuple23 = tuple22;
        Seq validPartitions2 = (Seq)tuple23._1();
        Seq invalidPartitions2 = (Seq)tuple23._2();
        invalidPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        PartitionState partitionState = targetState;
        if (NewPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionStateMachine.$anonfun$doHandleStateChanges$5(this, targetState, stateChangeLog, partition);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OnlinePartition$.MODULE$.equals(partitionState)) {
            BoxedUnit boxedUnit;
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doHandleStateChanges$7(this, partition)));
            Seq partitionsToElectLeader = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doHandleStateChanges$8(this, partition)));
            if (uninitializedPartitions.nonEmpty()) {
                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                successfulInitializations.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    PartitionStateMachine.$anonfun$doHandleStateChanges$9(this, targetState, stateChangeLog, partition);
                    return BoxedUnit.UNIT;
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Seq<TopicPartition> successfulElections = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                successfulElections.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    PartitionStateMachine.$anonfun$doHandleStateChanges$11(this, targetState, stateChangeLog, partition);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (OfflinePartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionStateMachine.$anonfun$doHandleStateChanges$13(this, targetState, stateChangeLog, partition);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NonExistentPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionStateMachine.$anonfun$doHandleStateChanges$15(this, targetState, stateChangeLog, partition);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)partitionState);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var3_2;
        Seq seq;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionReplicaAssignment((TopicPartition)partition)), Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$4)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$5);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq liveReplicas = (Seq)tuple2._2();
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.controllerContext.epochZkVersion());
        }
        catch (ControllerMovedException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller moved to another broker when trying to create the topic partition state znode", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw e;
        }
        catch (Exception e) {
            partitionsWithLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$9(this, e, x0$7);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            BoxedUnit boxedUnit;
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), true);
                boxedUnit = successfulInitializations.$plus$eq((Object)partition);
            } else {
                this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var3_2;
    }

    private Seq<TopicPartition> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Buffer successfulElections = (Buffer)Buffer$.MODULE$.empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doElectLeaderForPartitions(partitions, partitionLeaderElectionStrategy);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Seq success = (Seq)tuple3._1();
            Seq updatesToRetry = (Seq)tuple3._2();
            scala.collection.immutable.Map failedElections = (scala.collection.immutable.Map)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)success, (Object)updatesToRetry, (Object)failedElections);
            Tuple3 tuple33 = tuple32;
            Seq success2 = (Seq)tuple33._1();
            Seq updatesToRetry2 = (Seq)tuple33._2();
            scala.collection.immutable.Map failedElections2 = (scala.collection.immutable.Map)tuple33._3();
            remaining = updatesToRetry2;
            successfulElections.$plus$plus$eq((TraversableOnce)success2);
            failedElections2.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                PartitionStateMachine.$anonfun$electLeaderForPartitions$1(this, x0$8);
                return BoxedUnit.UNIT;
            });
        }
        return successfulElections;
    }

    private Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        Map failedElections = Map$.MODULE$.empty();
        Buffer leaderIsrAndControllerEpochPerPartition = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            Option option;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = (PartitionState)$this.partitionState.apply((Object)partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                BoxedUnit boxedUnit;
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    boxedUnit = failedElections.put((Object)partition, (Object)exception);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option = leaderIsrAndControllerEpochPerPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderIsrAndControllerEpochOpt.get()));
            } else {
                KeeperException.Code code3 = getDataResponse.resultCode();
                KeeperException.Code code4 = KeeperException.Code.NONODE;
                if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    option = failedElections.put((Object)partition, (Object)exception);
                } else {
                    option = failedElections.put((Object)partition, getDataResponse.resultException().get());
                }
            }
            return option;
        });
        Tuple2 tuple22 = leaderIsrAndControllerEpochPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(this, x0$9)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Buffer invalidPartitionsForElection = (Buffer)tuple22._1();
        Buffer validPartitionsForElection = (Buffer)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection);
        Tuple2 tuple24 = tuple23;
        Buffer invalidPartitionsForElection2 = (Buffer)tuple24._1();
        Buffer validPartitionsForElection2 = (Buffer)tuple24._2();
        invalidPartitionsForElection2.foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            String failMsg = new StringBuilder(71).append("aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append(new StringBuilder(101).append("already written by another controller. This probably means that the current controller ").append(this.controllerId()).append(" went through ").toString()).append(new StringBuilder(62).append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString()).toString();
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        if (validPartitionsForElection2.isEmpty()) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)failedElections.toMap(Predef$.MODULE$.$conforms()));
        }
        Set shuttingDownBrokers = this.controllerContext.shuttingDownBrokerIds().toSet();
        PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
        if (OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForOffline((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x0$11)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForReassign((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$12 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x0$12)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForPreferredReplica((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$13 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$7(x0$13)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForControlledShutdown((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2, (Set<Object>)shuttingDownBrokers).partition((Function1 & Serializable & scala.Serializable)x0$14 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$8(x0$14)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy2);
        }
        Tuple2 tuple25 = tuple2;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        Seq partitionsWithoutLeaders = (Seq)tuple25._1();
        Seq partitionsWithLeaders = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
        Tuple2 tuple27 = tuple26;
        Seq partitionsWithoutLeaders2 = (Seq)tuple27._1();
        Seq partitionsWithLeaders2 = (Seq)tuple27._2();
        partitionsWithoutLeaders2.foreach((Function1 & Serializable & scala.Serializable)x0$15 -> {
            Tuple3 tuple3 = x0$15;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(partitionLeaderElectionStrategy).toString();
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        scala.collection.immutable.Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)x0$16 -> {
            Tuple3 tuple3 = x0$16;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Seq recipients = (Seq)tuple3._3();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)recipients);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)x0$17 -> {
            Tuple3 tuple3 = x0$17;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Option leaderAndIsrOpt = (Option)tuple3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderAndIsrOpt.get());
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)updateLeaderAndIsrResult);
        }
        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3 tuple3 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3 tuple32 = tuple3;
        scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple32._1();
        Seq updatesToRetry2 = (Seq)tuple32._2();
        scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple32._3();
        successfulUpdates2.foreach((Function1 & Serializable & scala.Serializable)x0$18 -> {
            PartitionStateMachine.$anonfun$doElectLeaderForPartitions$12(this, recipientsPerPartition, x0$18);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)successfulUpdates2.keys().toSeq(), (Object)updatesToRetry2, (Object)failedElections.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedUpdates2));
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForOffline(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Tuple2 tuple2 = leaderIsrAndControllerEpochs.partition((Function1 & Serializable & scala.Serializable)x0$19 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$leaderForOffline$1(this, x0$19)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas, (Object)partitionsWithLiveInSyncReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple23._2();
        Tuple2<scala.collection.immutable.Map<String, LogConfig>, scala.collection.immutable.Map<String, Exception>> tuple24 = this.zkClient.getLogConfigs((Seq<String>)((Seq)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$20 -> {
            Tuple2 tuple2 = x0$20;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            String string = partition.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())), this.config.originals());
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        scala.collection.immutable.Map logConfigs = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map failed = (scala.collection.immutable.Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)logConfigs, (Object)failed);
        Tuple2 tuple26 = tuple25;
        scala.collection.immutable.Map logConfigs2 = (scala.collection.immutable.Map)tuple26._1();
        scala.collection.immutable.Map failed2 = (scala.collection.immutable.Map)tuple26._2();
        Seq partitionsWithUncleanLeaderElectionState = (Seq)((TraversableLike)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$21 -> {
            Tuple3 tuple3;
            Tuple2 tuple2 = x0$21;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                if (failed2.contains((Object)partition.topic())) {
                    this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)failed2.apply((Object)partition.topic()));
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)((Object)((Object)logConfigs2.apply((Object)partition.topic())))).uncleanLeaderElectionEnable()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            return tuple32;
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$22 -> {
            Tuple2 tuple2 = x0$22;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return (Seq)partitionsWithUncleanLeaderElectionState.map((Function1 & Serializable & scala.Serializable)x0$23 -> {
            Tuple3 tuple3;
            Tuple3 tuple32 = x0$23;
            if (tuple32 != null) {
                TopicPartition partition = (TopicPartition)tuple32._1();
                Option leaderIsrAndControllerEpochOpt = (Option)tuple32._2();
                boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
                Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
                Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
                if (leaderIsrAndControllerEpochOpt.nonEmpty()) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                    List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                    Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), uncleanLeaderElectionEnabled, $this.controllerContext);
                    Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForOffline$8(this, partition, leaderIsrAndControllerEpoch, isr, BoxesRunTime.unboxToInt((Object)leader)));
                    tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveReplicas);
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)liveReplicas);
                }
            } else {
                throw new MatchError((Object)tuple32);
            }
            Tuple3 tuple33 = tuple3;
            return tuple33;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForReassign(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$24 -> {
            Tuple2 tuple2 = x0$24;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> reassignment = ((ReassignedPartitionsContext)$this.controllerContext.partitionsBeingReassigned().apply((Object)partition)).newReplicas();
            Seq liveReplicas = (Seq)reassignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForReassign$3(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, reassignment);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForPreferredReplica(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$25 -> {
            Tuple2 tuple2 = x0$25;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
            Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForPreferredReplica$3(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, assignment);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForControlledShutdown(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs, Set<Object> shuttingDownBrokers) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$26 -> {
            Tuple2 tuple2 = x0$26;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
            Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, true));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveOrShuttingDownReplicas.toSet(), shuttingDownBrokers);
            List newIsr = (List)isr.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> !$this.controllerContext.shuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replica)));
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForControlledShutdown$4(leaderIsrAndControllerEpoch, newIsr, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveOrShuttingDownReplicas);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean isValidTransition(TopicPartition partition, PartitionState targetState) {
        return targetState.validPreviousStates().contains(this.partitionState.apply((Object)partition));
    }

    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = (PartitionState)this.partitionState.apply((Object)partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder(31).append("Partition ").append(partition).append(" should be in one of ").append(new StringBuilder(50).append(targetState.validPreviousStates().mkString(",")).append(" states before moving to ").append(targetState).append(" state. Instead it is in ").toString()).append(new StringBuilder(6).append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" failed to change state for partition ").append(partition).append(" ").append(new StringBuilder(9).append("from ").append(currState).append(" to ").append(targetState).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$initializePartitionState$1(PartitionStateMachine $this, TopicPartition topicPartition) {
        Option option = $this.controllerContext.partitionLeadershipInfo().get((Object)topicPartition);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
            if ($this.controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.changeStateTo(topicPartition, NonExistentPartition$.MODULE$, OnlinePartition$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.changeStateTo(topicPartition, NonExistentPartition$.MODULE$, OfflinePartition$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            $this.changeStateTo(topicPartition, NonExistentPartition$.MODULE$, NewPartition$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(String topic$1, TopicPartition p) {
        return p.topic().equals(topic$1);
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$2(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        PartitionState partitionState = (PartitionState)tuple2._2();
        boolean bl = !$this.topicDeletionManager().isTopicQueuedUpForDeletion(partition.topic()) && (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 x0$2) {
        PartitionState s;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionState partitionState = s = (PartitionState)tuple2._2();
        PartitionState partitionState2 = state$1;
        boolean bl = !(partitionState != null ? !partitionState.equals(partitionState2) : partitionState2 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$5(PartitionStateMachine $this, PartitionState targetState$2, StateChangeLogger stateChangeLog$1, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).append(" with ").append(new StringBuilder(18).append("assigned replicas ").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).toString()).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), NewPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$7(PartitionStateMachine $this, TopicPartition partition) {
        Object object = $this.partitionState.apply((Object)partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(object != null ? !object.equals(newPartition$) : newPartition$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$8(PartitionStateMachine $this, TopicPartition partition) {
        Object object = $this.partitionState.apply((Object)partition);
        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
        if (object == null) {
            if (offlinePartition$ == null) return true;
        } else if (object.equals(offlinePartition$)) return true;
        Object object2 = $this.partitionState.apply((Object)partition);
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (object2 != null) {
            if (!object2.equals(onlinePartition$)) return false;
            return true;
        }
        if (onlinePartition$ == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(PartitionStateMachine $this, PartitionState targetState$2, StateChangeLogger stateChangeLog$1, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).append(" with state ").append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply((Object)partition)).leaderAndIsr())).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$11(PartitionStateMachine $this, PartitionState targetState$2, StateChangeLogger stateChangeLog$1, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).append(" with state ").append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply((Object)partition)).leaderAndIsr())).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(PartitionStateMachine $this, PartitionState targetState$2, StateChangeLogger stateChangeLog$1, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), OfflinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(PartitionStateMachine $this, PartitionState targetState$2, StateChangeLogger stateChangeLog$1, TopicPartition partition) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState.apply((Object)partition)).append(" to ").append(targetState$2).toString());
        $this.changeStateTo(partition, (PartitionState)$this.partitionState.apply((Object)partition), NonExistentPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq liveReplicas = (Seq)tuple2._2();
        boolean bl = liveReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(PartitionStateMachine $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Seq replicas = (Seq)tuple2._2();
        String failMsg = new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" encountered error during state change of ").append(new StringBuilder(53).append("partition ").append(partition).append(" from New to Online, assigned replicas are ").toString()).append(new StringBuilder(37).append("[").append(replicas.mkString(",")).append("], live brokers are [").append($this.controllerContext.liveBrokerIds()).append("]. No assigned ").toString()).append("replica is alive.").toString();
        $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$9(PartitionStateMachine $this, Exception e$4, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        $this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)NewPartition$.MODULE$, e$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$electLeaderForPartitions$1(PartitionStateMachine $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        $this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(PartitionStateMachine $this, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(Tuple3 x0$11) {
        Tuple3 tuple3 = x0$11;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(Tuple3 x0$12) {
        Tuple3 tuple3 = x0$12;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$7(Tuple3 x0$13) {
        Tuple3 tuple3 = x0$13;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$8(Tuple3 x0$14) {
        Tuple3 tuple3 = x0$14;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$12(PartitionStateMachine $this, scala.collection.immutable.Map recipientsPerPartition$1, Tuple2 x0$18) {
        Tuple2 tuple2 = x0$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        Seq<Object> replicas = $this.controllerContext.partitionReplicaAssignment(partition);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition)), partition, leaderIsrAndControllerEpoch, replicas, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$leaderForOffline$1(PartitionStateMachine $this, Tuple2 x0$19) {
        Tuple2 tuple2 = x0$19;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        List liveInSyncReplicas = (List)leaderIsrAndControllerEpoch.leaderAndIsr().isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
        boolean bl = liveInSyncReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$8(PartitionStateMachine $this, TopicPartition partition$4, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, List isr$1, int leader) {
        List newIsr = isr$1.contains((Object)BoxesRunTime.boxToInteger((int)leader)) ? (List)isr$1.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition$4, $this.controllerContext.isReplicaOnline$default$3())) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
        return leaderIsrAndControllerEpoch$1.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForReassign$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$2, int leader) {
        return leaderIsrAndControllerEpoch$2.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForPreferredReplica$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$3, int leader) {
        return leaderIsrAndControllerEpoch$3.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForControlledShutdown$4(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$4, List newIsr$1, int leader) {
        return leaderIsrAndControllerEpoch$4.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr$1);
    }

    public PartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, Map<TopicPartition, PartitionState> partitionState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.partitionState = partitionState;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(38).append("[PartitionStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
        this.offlinePartitionCount = 0;
    }
}

