/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005{W\u000ec\u0017.\u001a8u!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0002{W&\u0011QE\t\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005Y\u0001\u0001\"B\u0002'\u0001\u0004)\u0002\"\u0002\u000e'\u0001\u0004Y\u0002\"B\u0010'\u0001\u0004\u0001\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0019\u0011\u0005Y\t\u0014B\u0001\u001a\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0019\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003QI7\u000fR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIV\t\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\u000f\t{w\u000e\\3b]\"1\u0011\t\u0001Q\u0001\na\nQ#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$\u0007\u0005C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002#Q|\u0007/[2t)>\u0014U\rR3mKR,G-F\u0001F!\r15*T\u0007\u0002\u000f*\u0011\u0001*S\u0001\b[V$\u0018M\u00197f\u0015\tQ%\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001T$\u0003\u0007M+G\u000f\u0005\u0002O+:\u0011qj\u0015\t\u0003!*i\u0011!\u0015\u0006\u0003%\u001a\ta\u0001\u0010:p_Rt\u0014B\u0001+\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QS\u0001BB-\u0001A\u0003%Q)\u0001\nu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001R\u0001\u001ai>\u0004\u0018nY:XSRDG)\u001a7fi&|gn\u0015;beR,G\r\u0003\u0004^\u0001\u0001\u0006I!R\u0001\u001bi>\u0004\u0018nY:XSRDG)\u001a7fi&|gn\u0015;beR,G\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0001E\u0003m!x\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]\"1\u0011\r\u0001Q\u0001\n\u0015\u000bA\u0004^8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007\u0005C\u0003d\u0001\u0011\u0005A-\u0001\u0003j]&$HcA3i[B\u0011\u0011BZ\u0005\u0003O*\u0011A!\u00168ji\")\u0011N\u0019a\u0001U\u0006A\u0012N\\5uS\u0006dGk\u001c9jGN$vNQ3EK2,G/\u001a3\u0011\u0007-dW*D\u0001J\u0013\ta\u0015\nC\u0003oE\u0002\u0007!.\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0006a\u0002!\t!]\u0001\u0011iJLHk\u001c9jG\u0012+G.\u001a;j_:$\u0012!\u001a\u0005\u0006g\u0002!\t!]\u0001\u0006e\u0016\u001cX\r\u001e\u0005\u0006k\u0002!\tA^\u0001\u0019K:\fX/Z;f)>\u0004\u0018nY:G_J$U\r\\3uS>tGCA3x\u0011\u0015AH\u000f1\u0001k\u0003\u0019!x\u000e]5dg\")!\u0010\u0001C\u0001w\u00069\"/Z:v[\u0016$U\r\\3uS>tgi\u001c:U_BL7m\u001d\u000b\u0003KrDq\u0001_=\u0011\u0002\u0003\u0007!\u000eC\u0003\u007f\u0001\u0011\u0005q0A\ngC&d'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002f\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!\u0001\u0005sKBd\u0017nY1t!\u0011YG.a\u0002\u0011\u0007Y\tI!C\u0002\u0002\f\t\u00111\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!a\u0004\u0001\t\u0003\t\t\"\u0001\u0010nCJ\\Gk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019Q-a\u0005\t\ra\fi\u00011\u0001k\u0011\u001d\t9\u0002\u0001C\u0005\u00033\tA$[:U_BL7-\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002\u001c\u0005}\u0001cA\u0005\u0002\u001e%\u0011qH\u0003\u0005\b\u0003C\t)\u00021\u0001N\u0003\u0015!x\u000e]5d\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\t\u0011$[:U_BL7\rR3mKRLwN\\%o!J|wM]3tgR!\u00111DA\u0015\u0011\u001d\t\t#a\tA\u00025Cq!!\f\u0001\t\u0003\ty#\u0001\u000ejgR{\u0007/[2XSRDG)\u001a7fi&|gn\u0015;beR,G\r\u0006\u0003\u0002\u001c\u0005E\u0002bBA\u0011\u0003W\u0001\r!\u0014\u0005\b\u0003k\u0001A\u0011AA\u001c\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\u0011\tY\"!\u000f\t\u000f\u0005\u0005\u00121\u0007a\u0001\u001b\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012aF2p[BdW\r^3SKBd\u0017nY1EK2,G/[8o)\r)\u0017\u0011\t\u0005\t\u0003\u0007\tY\u00041\u0001\u0002\u0006!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0013AG5t)>\u0004\u0018nY#mS\u001eL'\r\\3G_J$U\r\\3uS>tG\u0003BA\u000e\u0003\u0013Bq!!\t\u0002D\u0001\u0007Q\nC\u0004\u0002N\u0001!I!a\u0014\u000235\f'o\u001b+pa&\u001cgi\u001c:EK2,G/[8o%\u0016$(/\u001f\u000b\u0004K\u0006E\u0003bBA\u0011\u0003\u0017\u0002\r!\u0014\u0005\b\u0003+\u0002A\u0011BA,\u0003M\u0019w.\u001c9mKR,G)\u001a7fi\u0016$v\u000e]5d)\r)\u0017\u0011\f\u0005\b\u0003C\t\u0019\u00061\u0001N\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\nqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u0004K\u0006\u0005\u0004B\u0002=\u0002\\\u0001\u0007!\u000eC\u0004\u0002f\u0001!I!a\u001a\u0002)M$\u0018M\u001d;SKBd\u0017nY1EK2,G/[8o)\r)\u0017\u0011\u000e\u0005\t\u0003W\n\u0019\u00071\u0001\u0002\u0006\u0005a\"/\u001a9mS\u000e\f7OR8s)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007bBA8\u0001\u0011%\u0011\u0011O\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0004K\u0006M\u0004\u0002CA;\u0003[\u0002\r!a\u001e\u0002+A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fIB!1\u000e\\A=!\u0011\tY(a#\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000baaY8n[>t'bA\u0003\u0002\u0004*!\u0011QQAD\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011R\u0001\u0004_J<\u0017\u0002BAG\u0003{\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\u0012\u0002!I!]\u0001\u0010e\u0016\u001cX/\\3EK2,G/[8og\"I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011qS\u0001\"e\u0016\u001cX/\\3EK2,G/[8o\r>\u0014Hk\u001c9jGN$C-\u001a4bk2$H%M\u000b\u0003\u00033S3A[ANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'bAAT\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TopicDeletionManager
implements Logging {
    private final KafkaController controller;
    private final ControllerEventManager eventManager;
    private final KafkaZkClient zkClient;
    private final ControllerContext controllerContext;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsWithDeletionStarted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsWithDeletionStarted() {
        return this.topicsWithDeletionStarted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
            this.zkClient.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext().epochZkVersion());
        }
    }

    public void tryTopicDeletion() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.resumeDeletions();
        }
    }

    public void reset() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().clear();
            this.topicsWithDeletionStarted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
            this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).toString());
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isTopicWithDeletionStarted(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsWithDeletionStarted().contains((Object)topic) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void markTopicForDeletionRetry(String topic) {
        scala.collection.immutable.Set<PartitionAndReplica> failedReplicas = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Retrying delete topic for topic ").append(topic).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
    }

    private void completeDeleteTopic(String topic) {
        this.controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        scala.collection.immutable.Set<PartitionAndReplica> replicasForDeletedTopic = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.zkClient.deleteTopicZNode(topic, this.controllerContext().epochZkVersion());
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), this.controllerContext().epochZkVersion());
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), this.controllerContext().epochZkVersion());
        this.controllerContext().removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        BoxedUnit boxedUnit;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Topic deletion callback for ").append(topics.mkString(",")).toString());
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        Set unseenTopicsForDeletion = (Set)topics.$minus$minus(this.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
            this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
            this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
            boxedUnit = this.topicsWithDeletionStarted().$plus$plus$eq((TraversableOnce)unseenTopicsForDeletion);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)partitions);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion(this.controllerContext().partitionsForTopic(topic));
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topic()).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Partition deletion callback for ").append(partitionsToBeDeleted.mkString(",")).toString());
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$resumeDeletions$2(this, topic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$2, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            scala.collection.immutable.Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$, new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1()));
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$, new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1()));
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion started for replicas ").append(replicasForDeletionRetry.mkString(",")).toString());
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$, new Callbacks((Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived($this.controller, stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId)));
                return BoxedUnit.UNIT;
            }));
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Dead Replicas (").append(deadReplicasForTopic.mkString(",")).append(") found for topic ").append(topic).toString());
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$2(TopicDeletionManager $this, String topic) {
        block6: {
            block5: {
                if ($this.controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    $this.completeDeleteTopic(topic);
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
                } else if ($this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    scala.collection.immutable.Set<PartitionAndReplica> replicasInDeletionStartedState = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    scala.collection.immutable.Set replicaIds = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.replica()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.topicPartition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion for replicas ").append(replicaIds.mkString(",")).append(" for partition ").append(partitions.mkString(",")).append(" of topic ").append(topic).append(" in progress").toString());
                } else if ($this.controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    $this.markTopicForDeletionRetry(topic);
                }
                if (!$this.isTopicEligibleForDeletion(topic)) break block5;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append(topic).append(" (re)started").toString());
                $this.onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                break block6;
            }
            if (!$this.isTopicIneligibleForDeletion(topic)) break block6;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not retrying deletion of topic ").append(topic).append(" at this time since it is marked ineligible for deletion").toString());
        }
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager, KafkaZkClient zkClient) {
        this.controller = controller;
        this.eventManager = eventManager;
        this.zkClient = zkClient;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(27).append("[Topic Deletion Manager ").append(controller.config().brokerId()).append("], ").toString());
        this.controllerContext = controller.controllerContext();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsWithDeletionStarted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

