/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u0005w!B\u0001\u0003\u0011\u0003I\u0011a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QBA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4feN\u00111B\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bUYA\u0011\u0001\f\u0002\rqJg.\u001b;?)\u0005I\u0001b\u0002\r\f\u0005\u0004%\t!G\u0001 \t\u00164\u0017-\u001e7u)J\fgn]1di&|gn]'bqRKW.Z8vi6\u001bX#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\rIe\u000e\u001e\u0005\u0007=-\u0001\u000b\u0011\u0002\u000e\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000f\t\u0005\bA-\u0011\r\u0011\"\u0001\u001a\u0003\t\"UMZ1vYR$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\"1!e\u0003Q\u0001\ni\t1\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004%\u0017\t\u0007I\u0011A\r\u0002U\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\"1ae\u0003Q\u0001\ni\t1\u0006R3gCVdG/\u00112peR$\u0016.\\3e\u001fV$HK]1og\u0006\u001cG/[8og&sG/\u001a:wC2l5\u000f\t\u0005\bQ-\u0011\r\u0011\"\u0001\u001a\u00039\"UMZ1vYR\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001c;feZ\fG.T:\t\r)Z\u0001\u0015!\u0003\u001b\u0003=\"UMZ1vYR\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001c;feZ\fG.T:!\r\u0011a!\u0001\u0001\u0017\u0014\u0007-rQ\u0006\u0005\u0002/c5\tqF\u0003\u00021\r\u0005)Q\u000f^5mg&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0011!!4F!A!\u0002\u0013Q\u0012\u0001\u00032s_.,'/\u00133\t\u0011YZ#\u0011!Q\u0001\n]\n\u0001B_6DY&,g\u000e\u001e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\t!A_6\n\u0005qJ$!D&bM.\f'l[\"mS\u0016tG\u000f\u0003\u0005?W\t\u0005\t\u0015!\u0003@\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002/\u0001&\u0011\u0011i\f\u0002\n'\u000eDW\rZ;mKJD\u0001bQ\u0016\u0003\u0002\u0003\u0006I\u0001R\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t)\u0005*D\u0001G\u0015\t9e!\u0001\u0004tKJ4XM]\u0005\u0003\u0013\u001a\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005LW\t\u0005\t\u0015!\u0003M\u0003\u0019\u0019wN\u001c4jOB\u0011!\"T\u0005\u0003\u001d\n\u0011\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0011!\u00016F!A!\u0002\u0013\t\u0016\u0001\u0002;j[\u0016\u0004\"AU.\u000e\u0003MS!\u0001\r+\u000b\u0005U3\u0016AB2p[6|gN\u0003\u0002\b/*\u0011\u0001,W\u0001\u0007CB\f7\r[3\u000b\u0003i\u000b1a\u001c:h\u0013\ta6K\u0001\u0003US6,\u0007\"B\u000b,\t\u0003qFcB0aC\n\u001cG-\u001a\t\u0003\u0015-BQ\u0001N/A\u0002iAQAN/A\u0002]BQAP/A\u0002}BQaQ/A\u0002\u0011CQaS/A\u00021CQ\u0001U/A\u0002E+AaZ\u0016\u0001Q\n12+\u001a8e)btW*\u0019:lKJ\u001c8)\u00197mE\u0006\u001c7\u000eE\u0005\u0010S.Tb\u000f`@\u0002\u0006%\u0011!\u000e\u0005\u0002\n\rVt7\r^5p]V\u0002\"\u0001\\:\u000f\u00055\f\bC\u00018\u0011\u001b\u0005y'B\u00019\t\u0003\u0019a$o\\8u}%\u0011!\u000fE\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s!A\u0011qO_\u0007\u0002q*\u0011\u0011\u0010V\u0001\te\u0016\fX/Z:ug&\u00111\u0010\u001f\u0002\u0012)J\fgn]1di&|gNU3tk2$\bC\u0001\u0006~\u0013\tq(AA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rE\u0002\u000b\u0003\u0003I1!a\u0001\u0003\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u0011\u0007=\t9!C\u0002\u0002\nA\u0011A!\u00168ji\"I\u0011QB\u0016C\u0002\u0013%\u0011qB\u0001\rg\",H\u000f^5oO\u0012{wO\\\u000b\u0003\u0003#\u0001B!a\u0005\u0002&5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u00037\ti\"\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\b\u0002\"\u0005!Q\u000f^5m\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003+\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA\u0016W\u0001\u0006I!!\u0005\u0002\u001bMDW\u000f\u001e;j]\u001e$un\u001e8!\u0011%\tyc\u000bb\u0001\n\u0013\t\t$A\u0005ti\u0006$X\rT8dWV\u0011\u00111\u0007\t\u0005\u0003k\tY$\u0004\u0002\u00028)!\u0011\u0011HA\r\u0003\u0015awnY6t\u0013\u0011\ti$a\u000e\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.D\u0001\"!\u0011,A\u0003%\u00111G\u0001\u000bgR\fG/\u001a'pG.\u0004\u0003\"CA#W\t\u0007I\u0011BA$\u0003Eaw.\u00193j]\u001e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002V\u0005eSBAA'\u0015\u0011\ty%!\u0015\u0002\u000f5,H/\u00192mK*\u0019\u00111\u000b\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u00055#aA*fiB\u0019!\"a\u0017\n\u0007\u0005u#A\u0001\u0012Ue\u0006t7/Y2uS>t\u0007+\u0019:uSRLwN\\!oI2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\t\u0003CZ\u0003\u0015!\u0003\u0002J\u0005\u0011Bn\\1eS:<\u0007+\u0019:uSRLwN\\:!\u0011%\t)g\u000bb\u0001\n\u0013\t9%A\tmK\u00064\u0018N\\4QCJ$\u0018\u000e^5p]ND\u0001\"!\u001b,A\u0003%\u0011\u0011J\u0001\u0013Y\u0016\fg/\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0005\u0002n-\u0012\r\u0011\"\u0003\u0002p\u0005ABO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005E\u0004cBA&\u0003gR\u0012qO\u0005\u0005\u0003k\niEA\u0002NCB\u00042ACA=\u0013\r\tYH\u0001\u0002\u0016)btW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,e\u000e\u001e:z\u0011!\tyh\u000bQ\u0001\n\u0005E\u0014!\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iK\u0002B\u0001\"a!,\u0005\u0004%I!G\u0001\u001fiJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RDq!a\",A\u0003%!$A\u0010ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u0002B\u0001\"a#,\t\u0003\u0011\u0011QR\u0001\u0014C\u0012$Gj\\1eS:<\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0003\u000b\ty)a%\t\u000f\u0005E\u0015\u0011\u0012a\u00015\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\t)*!#A\u0002i\t\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u0011\u0005e5\u0006\"\u0001\u0003\u00037\u000bQb\u001d;bi\u0016\u0014V-\u00193M_\u000e\\WCAAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&\u0002BAR\u0003o\taCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0005\u0005\u0003O\u000b\tK\u0001\u0005SK\u0006$Gj\\2l\u0011\u001d\tYk\u000bC\u0001\u0003[\u000bA\u0003^5nK\u0012|U\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHCAAX!\u0019\t\t,a/\u0002B:!\u00111WA\\\u001d\rq\u0017QW\u0005\u0002#%\u0019\u0011\u0011\u0018\t\u0002\u000fA\f7m[1hK&!\u0011QXA`\u0005!IE/\u001a:bE2,'bAA]!A\u0019!\"a1\n\u0007\u0005\u0015'AA\u0011Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0003:$\u0007K]8ek\u000e,'/\u00133Fa>\u001c\u0007\u000eC\u0004\u0002J.\"\t!a3\u0002?\u0015t\u0017M\u00197f)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g\u000e\u0006\u0002\u0002\u0006!9\u0011qZ\u0016\u0005\u0002\u0005E\u0017aE4fiR\u0013\u0018M\\:bGRLwN\\*uCR,G\u0003BAj\u0003c\u0004\u0002\"!-\u0002V\u0006e\u0017Q]\u0005\u0005\u0003/\fyL\u0001\u0004FSRDWM\u001d\t\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\u001c+\u0002\u0011A\u0014x\u000e^8d_2LA!a9\u0002^\n1QI\u001d:peN\u0004RaDAt\u0003WL1!!;\u0011\u0005\u0019y\u0005\u000f^5p]B\u0019!\"!<\n\u0007\u0005=(A\u0001\u0010D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG\r\u0016=o\u001b\u0016$\u0018\rZ1uC\"9\u00111_Ag\u0001\u0004Y\u0017a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\t\u000f\u0005]8\u0006\"\u0001\u0002z\u0006q\u0002/\u001e;Ue\u0006t7/Y2uS>t7\u000b^1uK&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0007\u0003w\fi0a@\u0011\u0011\u0005E\u0016Q[Am\u0003WDq!a=\u0002v\u0002\u00071\u000eC\u0004\u0003\u0002\u0005U\b\u0019\u0001?\u0002\u0017QDh.T3uC\u0012\fG/\u0019\u0005\b\u0005\u000bYC\u0011\u0002B\u0004\u0003y9W\r^!oI6\u000b\u0017PY3BI\u0012$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\r\u0006\u0004\u0002T\n%!1\u0002\u0005\b\u0003g\u0014\u0019\u00011\u0001l\u0011!\u0011iAa\u0001A\u0002\t=\u0011!F2sK\u0006$X\r\u001a+y]6+G/\u00193bi\u0006|\u0005\u000f\u001e\t\u0005\u001f\u0005\u001dH\u0010C\u0004\u0003\u0014-\"\tA!\u0006\u00029Y\fG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgR!!q\u0003B\u000f!\ry!\u0011D\u0005\u0004\u00057\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005?\u0011\t\u00021\u0001\u001b\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0011\u001d\u0011\u0019c\u000bC\u0001\u0005K\tq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\t\u001d\u0002\u0003\u0002B\u0015\u0005Wi!!!\b\n\t\t5\u0012Q\u0004\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\u0019W\u0011\u0005!1G\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u00045\tU\u0002bBAz\u0005_\u0001\ra\u001b\u0005\u0007\u0005sYC\u0011B\r\u0002C\u001d,G\u000f\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\t\u000f\tu2\u0006\"\u0003\u0003@\u00059Bn\\1e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0007\u0005\u0003\u00129Ea\u0015\u0011\u000b9\u0012\u0019e\u001b?\n\u0007\t\u0015sF\u0001\u0003Q_>d\u0007\u0002\u0003B%\u0005w\u0001\rAa\u0013\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!!Q\nB(\u001b\u0005!\u0016b\u0001B))\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAK\u0005w\u0001\rA\u0007\u0005\t\u0005/ZC\u0011\u0001\u0002\u0003Z\u0005a\u0012\r\u001a3M_\u0006$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHk\\\"bG\",G\u0003CA\u0003\u00057\u0012yF!\u0019\t\u000f\tu#Q\u000ba\u00015\u0005\tB\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005U%Q\u000ba\u00015!A!1\rB+\u0001\u0004\u0011\t%\u0001\u000enKR\fG-\u0019;b!\u0016\u0014HK]1og\u0006\u001cG/[8oC2LE\rC\u0004\u0003h-\"\tA!\u001b\u0002I1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:Uq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\u0002\"!\u0002\u0003l\t5$q\u000e\u0005\b\u0003#\u0013)\u00071\u0001\u001b\u0011\u001d\t)J!\u001aA\u0002iA\u0001B!\u001d\u0003f\u0001\u0007!1O\u0001\u000fg\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:t!\r\u0011)HZ\u0007\u0002W!9!\u0011P\u0016\u0005\u0002\tm\u0014A\n:f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R1\u0011Q\u0001B?\u0005\u007fBq!!%\u0003x\u0001\u0007!\u0004C\u0004\u0002\u0016\n]\u0004\u0019\u0001\u000e\t\u000f\t\r5\u0006\"\u0003\u0002L\u0006qc/\u00197jI\u0006$X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;JgN#\u0018M\u00197f\u0011\u001d\u00119i\u000bC\u0001\u0005\u0013\u000ba#\u00199qK:$GK]1og\u0006\u001cG/[8o)>dun\u001a\u000b\r\u0003\u000b\u0011YI!$\u0003\u0010\nM%Q\u0014\u0005\b\u0003g\u0014)\t1\u0001l\u0011\u001d\t)J!\"A\u0002iAqA!%\u0003\u0006\u0002\u0007q0A\u0006oK^lU\r^1eCR\f\u0007\u0002\u0003BK\u0005\u000b\u0003\rAa&\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007cB\b\u0003\u001a\u0006e\u0017QA\u0005\u0004\u00057\u0003\"!\u0003$v]\u000e$\u0018n\u001c82\u0011)\u0011yJ!\"\u0011\u0002\u0003\u0007!\u0011U\u0001\re\u0016$(/_(o\u000bJ\u0014xN\u001d\t\b\u001f\te\u0015\u0011\u001cB\f\u0011\u001d\u0011)k\u000bC\u0001\u0003\u0017\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\n\u0005S[\u0013\u0013!C\u0001\u0005W\u000b\u0001%\u00199qK:$GK]1og\u0006\u001cG/[8o)>dun\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0016\u0016\u0005\u0005C\u0013yk\u000b\u0002\u00032B!!1\u0017B_\u001b\t\u0011)L\u0003\u0003\u00038\ne\u0016!C;oG\",7m[3e\u0015\r\u0011Y\fE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B`\u0005k\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final Set<TransactionPartitionAndLeaderEpoch> leavingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionStateManager transactionStateManager = this;
        synchronized (transactionStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    private Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    private Set<TransactionPartitionAndLeaderEpoch> leavingPartitions() {
        return this.leavingPartitions;
    }

    private scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        long now = this.time.milliseconds();
        return (Iterable)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> (Iterable)((TraversableLike)this.transactionMetadataCache().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$2(this, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
            Iterable iterable = (Iterable)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$5(now, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String txnId = (String)tuple2._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long now = $this.time.milliseconds();
            CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map transactionalIdByPartition = ((TraversableLike)this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
                    Iterable iterable = (Iterable)((TraversableLike)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$6)))).filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5(this, now, x0$7)))).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                        Tuple2 tuple2 = x0$8;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String transactionalId = (String)tuple2._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                        TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> txnMetadata.prepareDead());
                        TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                        return transactionalIdCoordinatorEpochAndMetadata;
                    }, Iterable$.MODULE$.canBuildFrom());
                    return iterable;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
                scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple2 tuple2 = x0$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int partition = tuple2._1$mcI$sp();
                    scala.collection.mutable.Iterable transactionalIdCoordinatorEpochAndMetadatas = (scala.collection.mutable.Iterable)tuple2._2();
                    SimpleRecord[] deletes = (SimpleRecord[])((TraversableOnce)transactionalIdCoordinatorEpochAndMetadatas.map((Function1 & Serializable & scala.Serializable)entry -> new SimpleRecord(now, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])deletes);
                    TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)records);
                    return tuple22;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responses -> {
                    this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
            });
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(String transactionalId, TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right().map((Function1 & Serializable & scala.Serializable)x$2 -> (CoordinatorEpochAndTxnMetadata)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        return (Either)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            int partitionId = this.partitionFor(transactionalId);
            if (this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
            } else if (this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(partitionId, x$4)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            } else {
                Left left2;
                Option option = this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)some.value();
                    Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
                    left2 = package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$5 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$5)));
                } else if (None$.MODULE$.equals(option)) {
                    left2 = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                } else {
                    throw new MatchError((Object)option);
                }
                left = left2;
            }
            return left;
        });
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        return BoxesRunTime.unboxToInt((Object)this.zkClient.getTopicPartitionCount("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.config.transactionLogNumPartitions()));
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Attempted to load offsets and group metadata from ").append(topicPartition).append(", but found no log").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Log log = (Log)some.value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && !this.shuttingDown().get() && BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition, coordinatorEpoch, idAndEpoch)))))) {
                    MemoryRecords memoryRecords;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), (Option<Object>)None$.MODULE$, true, false);
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        MemoryRecords memoryRecords2;
                        memoryRecords = memoryRecords2 = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        Buffer buffer2;
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Loaded offsets and group metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                            buffer2 = BoxedUnit.UNIT;
                        } else {
                            buffer2 = buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    MemoryRecords memRecords = memoryRecords;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append($this.time.milliseconds() - startMs).append(" milliseconds").toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> metadataPerTransactionalId) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, metadataPerTransactionalId);
        Option currentTxnMetadataCacheEntry = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        if (currentTxnMetadataCacheEntry.isDefined()) {
            int coordinatorEpoch2 = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).coordinatorEpoch();
            Pool<String, TransactionMetadata> metadataPerTxnId = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).metadataPerTransactionalId();
            String errorMsg = new StringBuilder(90).append("The metadata cache for txn partition ").append(txnTopicPartition).append(" has already exist with epoch ").append(coordinatorEpoch2).append(" ").append(new StringBuilder(40).append("and ").append(metadataPerTxnId.size()).append(" entries while trying to add to it; ").toString()).append("this should not happen").toString();
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loadTransactions$1(coordinatorEpoch, sendTxnMarkers, topicPartition, partitionAndLeaderEpoch), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.leavingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringBuilder(26).append("remove-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeTransactions$1(partitionId, topicPartition, partitionAndLeaderEpoch), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            boolean bl = false;
            Right right = null;
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.getTransactionState(transactionalId);
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                BoxedUnit boxedUnit2 = (BoxedUnit)responseCallback.apply((Object)err);
                return;
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Option option = (Option)right.value();
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit3 = (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    return;
                }
            }
            if (!bl) throw new MatchError(either);
            Option option = (Option)right.value();
            if (!(option instanceof Some)) throw new MatchError(either);
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata metadata = epochAndMetadata.transactionMetadata();
            boolean append = BoxesRunTime.unboxToBoolean(metadata.inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                    responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }));
            if (append) {
                $this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
                    this.updateCacheCallback$1(responseStatus, transactionalId, coordinatorEpoch, newMetadata, responseCallback, retryOnError, topicPartition);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata).append(" for transaction id ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append(" to the local transaction log").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        });
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(int txnPartitionId$1, TransactionPartitionAndLeaderEpoch x$1) {
        return x$1.txnPartitionId() == txnPartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$2(TransactionStateManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int txnPartitionId = tuple2._1$mcI$sp();
        boolean bl = !$this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(txnPartitionId, x$1)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$5(long now$1, Tuple2 x0$3) {
        boolean bl;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        TransactionState transactionState = txnMetadata.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        boolean bl3 = bl2;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        boolean bl = txnMetadata.txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)CoreUtils$.MODULE$.inReadLock($this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
            $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
                toRemove.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                    String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                    TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                    return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Object object;
                        if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                            Errors errors = response$1.error;
                            Errors errors2 = Errors.NONE;
                            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                                object = txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                                return object;
                            }
                        }
                        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch()))).toString());
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        object = BoxedUnit.UNIT;
                        return object;
                    });
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$10);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$3(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$2;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$3;
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Object object;
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        if (!record.hasValue()) {
            object = loadedTransactions$1.remove(transactionalId);
        } else {
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            object = loadedTransactions$1.put(transactionalId, txnMetadata);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    private final void loadTransactions$1(int coordinatorEpoch$2, Function5 sendTxnMarkers$1, TopicPartition topicPartition$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Loading transaction metadata from ").append(topicPartition$3).toString());
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$2);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) break block0;
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$2, loadedTransactions);
                ListBuffer transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                    Tuple2 tuple2 = x0$11;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String transactionalId = (String)tuple2._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    private final void removeTransactions$1(int partitionId$1, TopicPartition topicPartition$4, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3) {
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            if (this.leavingPartitions().contains((Object)partitionAndLeaderEpoch$3)) {
                Option option = this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$1));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)some.value();
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Removed ").append(txnMetadataCacheEntry.metadataPerTransactionalId().size()).append(" cached transaction metadata for ").append(topicPartition$4).append(" on follower transition").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(206).append("Trying to remove cached transaction metadata for ").append(topicPartition$4).append(" on follower transition but there is no entries remaining; ").append("it is likely that another process for removing the cached entries has just executed earlier before").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$3));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$1, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$1).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$1, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$1).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$1) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$1).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$1)).append(") while it was ").append(coordinatorEpoch$1).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
        } else {
            metadata$1.completeTransitionTo(newMetadata$1);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$1).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$1).append(" for ").append(transactionalId$1).append(" succeeded").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1) {
        return new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$1).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$1)).append(") while it was ").append(coordinatorEpoch$1).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1, Function1 retryOnError$1, ObjectRef responseError$1, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, TransactionMetadata metadata$2) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$1) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
            } else {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
                metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            }
        } else {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$1).toString()).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$1, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$1).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$1, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(72).append("TransactionalId ").append(transactionalId$1).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Function1 retryOnError$1, TopicPartition topicPartition$5) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = status.error;
                            var16_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var16_9) == false : var16_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$1, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var17_10 = status.error;
                                var13_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var17_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var17_10) != false));
                                if (var13_11) {
                                    var10_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var12_13 = Errors.NOT_LEADER_FOR_PARTITION.equals(var17_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var17_10) != false;
                                    if (var12_13) {
                                        var10_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var11_14 = Errors.MESSAGE_TOO_LARGE.equals(var17_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var17_10) != false;
                                        var10_12 = var11_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var17_10;
                                    }
                                }
                                v1 = var10_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var18_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var18_16) == false : var18_16 != null) break block13;
                            var19_17 = false;
                            var20_18 = null;
                            var21_19 = this.getTransactionState(transactionalId$1);
                            if (!(var21_19 instanceof Left)) break block14;
                            var22_20 = (Left)var21_19;
                            err = (Errors)var22_20.value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$1, (Errors)err));
                            responseError.elem = err;
                            var9_22 = BoxedUnit.UNIT;
                            break block15;
                        }
                        if (!(var21_19 instanceof Right)) break block16;
                        var19_17 = true;
                        var20_18 = (Right)var21_19;
                        var24_25 = (Option)var20_18.value();
                        if (!(var24_25 instanceof Some)) break block16;
                        var25_26 = (Some)var24_25;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var25_26.value();
                        metadata = epochAndMetadata.transactionMetadata();
                        var9_23 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var19_17 || !None$.MODULE$.equals(var28_29 = (Option)var20_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    var9_24 = BoxedUnit.UNIT;
                    break block15;
                }
                throw new MatchError(var21_19);
            }
            var29_30 = false;
            var30_31 = null;
            var31_32 = this.getTransactionState(transactionalId$1);
            if (!(var31_32 instanceof Right)) ** GOTO lbl-1000
            var29_30 = true;
            var30_31 = (Right)var31_32;
            var32_33 = (Option)var30_31.value();
            if (var32_33 instanceof Some) {
                var33_34 = (Some)var32_33;
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)var33_34.value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                var8_37 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager int kafka.coordinator.transaction.TxnTransitMetadata scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1, (Function1)retryOnError$1, (ObjectRef)responseError, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (TransactionMetadata)metadata));
            } else if (var29_30 && None$.MODULE$.equals(var36_40 = (Option)var30_31.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$1, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
                var8_38 = BoxedUnit.UNIT;
            } else if (var31_32 instanceof Left) {
                var37_41 = (Left)var31_32;
                error = (Errors)var37_41.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$1, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
                var8_39 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var31_32);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time) {
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.leavingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
    }
}

