/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\t}h\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001B\u0004\u000b\u001b!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00059Q.\u001a;sS\u000e\u001c\u0018BA\r\u0017\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\taa]3sm\u0016\u0014\u0018BA\u0010\u001d\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003G\u0011j\u0011AA\u0005\u0003K\t\u0011Qb\u00117fC:,'oQ8oM&<\u0007\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\u0002\u000f1|w\rR5sgV\t\u0011\u0006E\u0002+eUr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u000592\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\t$\"A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$aA*fc*\u0011\u0011G\u0003\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n!![8\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u0005\r&dW\r\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003*\u0003!awn\u001a#jeN\u0004\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\u0002\t1|wm]\u000b\u0002\u0005B!qbQ#Q\u0013\t!\u0005C\u0001\u0003Q_>d\u0007C\u0001$O\u001b\u00059%B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011QA\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u0012R\u0013\t\u0011&AA\u0002M_\u001eD\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0006Y><7\u000f\t\u0005\t-\u0002\u0011)\u0019!C\u0001/\u0006!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\u0012\u0001\u0017\t\u00037eK!A\u0017\u000f\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0011!a\u0006A!A!\u0002\u0013A\u0016!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\t\u0005\t=\u0002\u0011\t\u0011)A\u0005?\u0006!A/[7f!\t\u0001'-D\u0001b\u0015\t\tr)\u0003\u0002dC\n!A+[7f\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u0019a\u0014N\\5u}Q1q\r[5kW2\u0004\"a\t\u0001\t\u000b\u0005\"\u0007\u0019\u0001\u0012\t\u000b\u001d\"\u0007\u0019A\u0015\t\u000b\u0001#\u0007\u0019\u0001\"\t\u000bY#\u0007\u0019\u0001-\t\u000fy#\u0007\u0013!a\u0001?\"9a\u000e\u0001a\u0001\n\u0013y\u0017AB2p]\u001aLw-F\u0001#\u0011\u001d\t\b\u00011A\u0005\nI\f!bY8oM&<w\fJ3r)\t\u0019h\u000f\u0005\u0002\ni&\u0011QO\u0003\u0002\u0005+:LG\u000fC\u0004xa\u0006\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004z\u0001\u0001\u0006KAI\u0001\bG>tg-[4!Q\tA8\u0010\u0005\u0002\ny&\u0011QP\u0003\u0002\tm>d\u0017\r^5mK\"Iq\u0010\u0001b\u0001\n\u0003\u0011\u0011\u0011A\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0001E\u0002$\u0003\u000bI1!a\u0002\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\u0004\u0005y1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u0003'\u00012aDA\u000b\u0013\r\t9\u0002\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJD\u0001\"a\u0007\u0001A\u0003%\u00111C\u0001\u000bi\"\u0014x\u000e\u001e;mKJ\u0004\u0003\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0003!\u0019G.Z1oKJ\u001cXCAA\u0012!\u0019\t)#a\f\u000245\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0004nkR\f'\r\\3\u000b\u0007\u00055\"\"\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002(\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\t)$a\u000e\u000e\u0003\u00011a!!\u000f\u0001\t\u0005m\"!D\"mK\u0006tWM\u001d+ie\u0016\fGm\u0005\u0003\u00028\u0005u\u0002cA\b\u0002@%\u0019\u0011\u0011\t\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\f\u0003\u000b\n9D!A!\u0002\u0013\t9%\u0001\u0005uQJ,\u0017\rZ%e!\rI\u0011\u0011J\u0005\u0004\u0003\u0017R!aA%oi\"9Q-a\u000e\u0005\u0002\u0005=C\u0003BA\u001a\u0003#B\u0001\"!\u0012\u0002N\u0001\u0007\u0011q\t\u0005\t\u0003+\n9\u0004\"\u0015\u0002X\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0013(\u0001\u0003mC:<\u0017\u0002BA2\u0003;\u0012aa\u0015;sS:<\u0007BCA4\u0003o\u0011\r\u0011\"\u0001\u0002j\u000591\r\\3b]\u0016\u0014XCAA6!\r\u0019\u0013QN\u0005\u0004\u0003_\u0012!aB\"mK\u0006tWM\u001d\u0005\n\u0003g\n9\u0004)A\u0005\u0003W\n\u0001b\u00197fC:,'\u000f\t\u0005\u000b\u0003o\n9\u00041A\u0005\u0002\u0005e\u0014!\u00037bgR\u001cF/\u0019;t+\t\tY\bE\u0002$\u0003{J1!a \u0003\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011)\t\u0019)a\u000eA\u0002\u0013\u0005\u0011QQ\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\u0007M\f9\tC\u0005x\u0003\u0003\u000b\t\u00111\u0001\u0002|!I\u00111RA\u001cA\u0003&\u00111P\u0001\u000bY\u0006\u001cHo\u0015;biN\u0004\u0003fAAEw\"A\u0011\u0011SA\u001c\t\u0013\t\u0019*A\u0005dQ\u0016\u001c7\u000eR8oKR\u00191/!&\t\u000f\u0005]\u0015q\u0012a\u0001\u000b\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CAN\u0003o!\t%!(\u0002\r\u0011|wk\u001c:l)\u0005\u0019\b\u0002CAQ\u0003o!I!a)\u0002#\rdW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u0002&B\u0019\u0011\"a*\n\u0007\u0005%&BA\u0004C_>dW-\u00198\t\u0011\u00055\u0016q\u0007C\u0005\u0003_\u000b\u0001b\u00197fC:dun\u001a\u000b\u0004g\u0006E\u0006\u0002CAZ\u0003W\u0003\r!!.\u0002\u0013\rdW-\u00198bE2,\u0007cA\u0012\u00028&\u0019\u0011\u0011\u0018\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002>\u0006]B\u0011AA`\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0017M\f\t-!2\u0002X\u0006\u0005\u0018Q\u001d\u0005\t\u0003\u0007\fY\f1\u0001\u0002H\u0005\u0011\u0011\u000e\u001a\u0005\t\u0003\u000f\fY\f1\u0001\u0002J\u0006!a.Y7f!\u0011\tY-a5\u000f\t\u00055\u0017q\u001a\t\u0003Y)I1!!5\u000b\u0003\u0019\u0001&/\u001a3fM&!\u00111MAk\u0015\r\t\tN\u0003\u0005\t\u00033\fY\f1\u0001\u0002\\\u0006!aM]8n!\rI\u0011Q\\\u0005\u0004\u0003?T!\u0001\u0002'p]\u001eD\u0001\"a9\u0002<\u0002\u0007\u00111\\\u0001\u0003i>D\u0001\"a:\u0002<\u0002\u0007\u00111P\u0001\u0006gR\fGo\u001d\u0005\t\u0003W\u0004\u0001\u0015!\u0003\u0002$\u0005I1\r\\3b]\u0016\u00148\u000f\t\u0005\b\u0003_\u0004A\u0011AAO\u0003\u001d\u0019H/\u0019:ukBDq!a=\u0001\t\u0003\ti*\u0001\u0005tQV$Hm\\<o\u0011\u001d\t9\u0010\u0001C!\u0003s\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0002|B1\u0011Q`A\u0000\u0003\u0013l!!a\u000b\n\t\t\u0005\u00111\u0006\u0002\u0004'\u0016$\bb\u0002B\u0003\u0001\u0011\u0005#qA\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$2a\u001dB\u0005\u0011!\u0011YAa\u0001A\u0002\t5\u0011!\u00038fo\u000e{gNZ5h!\rY\"qB\u0005\u0004\u0005#a\"aC&bM.\f7i\u001c8gS\u001eDqA!\u0006\u0001\t\u0003\u00129\"A\u0006sK\u000e|gNZ5hkJ,G#B:\u0003\u001a\tu\u0001\u0002\u0003B\u000e\u0005'\u0001\rA!\u0004\u0002\u0013=dGmQ8oM&<\u0007\u0002\u0003B\u0006\u0005'\u0001\rA!\u0004\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$\u0005i\u0011MY8si\u000ecW-\u00198j]\u001e$2a\u001dB\u0013\u0011\u001d\t9Ja\bA\u0002\u0015CqA!\u000b\u0001\t\u0003\u0011Y#A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$2a\u001dB\u0017\u0011\u001d\u0011yCa\nA\u0002U\nq\u0001Z1uC\u0012K'\u000fC\u0004\u00034\u0001!\tA!\u000e\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\bg\n]\"\u0011\bB\u001f\u0011\u001d\t9J!\rA\u0002\u0015CqAa\u000f\u00032\u0001\u0007Q'\u0001\u0007t_V\u00148-\u001a'pO\u0012K'\u000fC\u0004\u0003@\tE\u0002\u0019A\u001b\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'\u000fC\u0004\u0003D\u0001!\tA!\u0012\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\u0007M\u00149\u0005\u0003\u0005\u0003J\t\u0005\u0003\u0019AAe\u0003\r!\u0017N\u001d\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000fF\u0004t\u0005#\u0012\u0019F!\u0016\t\u000f\t=\"1\na\u0001k!9\u0011q\u0013B&\u0001\u0004)\u0005\u0002\u0003B,\u0005\u0017\u0002\r!a7\u0002\r=4gm]3u\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0005;\nQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\rF\u0002t\u0005?Bq!a&\u0003Z\u0001\u0007Q\tC\u0004\u0003d\u0001!\tA!\u001a\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR\u00191Oa\u001a\t\u0011\t%$\u0011\ra\u0001\u0005W\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006\u0003{\u0014i'R\u0005\u0005\u0005_\nYC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005k\nA\"Y<bSR\u001cE.Z1oK\u0012$\u0002\"!*\u0003x\te$1\u0010\u0005\b\u0003/\u0013\t\b1\u0001F\u0011!\u00119F!\u001dA\u0002\u0005m\u0007B\u0003B?\u0005c\u0002\n\u00111\u0001\u0002\\\u0006IQ.\u0019=XC&$Xj\u001d\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005\u000b\u0003b!!@\u0003n\t\u001d\u0005#B\u0005\u0003\n\u0016\u0003\u0016b\u0001BF\u0015\t1A+\u001e9mKJBqAa$\u0001\t\u0003!q.A\u0007dkJ\u0014XM\u001c;D_:4\u0017n\u001a\u0005\t\u0005'\u0003A\u0011\u0001\u0002\u0003\u0016\u0006a1\r\\3b]\u0016\u00148i\\;oiV\u0011\u0011q\t\u0005\n\u00053\u0003\u0011\u0013!C\u0001\u00057\u000ba#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005;SC!a7\u0003 .\u0012!\u0011\u0015\t\u0005\u0005G\u0013i+\u0004\u0002\u0003&*!!q\u0015BU\u0003%)hn\u00195fG.,GMC\u0002\u0003,*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yK!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u00034\nA\tA!.\u0002\u00151{wm\u00117fC:,'\u000fE\u0002$\u0005o3a!\u0001\u0002\t\u0002\te6c\u0001B\\\u0011!9QMa.\u0005\u0002\tuFC\u0001B[\u0011)\u0011\tMa.C\u0002\u0013\u0005!1Y\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011)\r\u0005\u0004\u0002~\u0006}\u0018\u0011\f\u0005\n\u0005\u0013\u00149\f)A\u0005\u0005\u000b\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\t\u0005\t\u0005\u001b\u00149\f\"\u0001\u0003P\u0006i1\r\\3b]\u0016\u00148i\u001c8gS\u001e$2A\tBi\u0011\u001dq'1\u001aa\u0001\u0005\u001bA\u0001B!6\u00038\u0012\u0005!q[\u0001\u0018GJ,\u0017\r^3OK^\u001cE.Z1oK\u0012\u001cVmZ7f]R$bA!7\u0003`\n\u0005\bcA\u0012\u0003\\&\u0019!Q\u001c\u0002\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0004\u0004\u0005'\u0004\r\u0001\u0015\u0005\t\u0005G\u0014\u0019\u000e1\u0001\u0002\\\u0006Q!-Y:f\u001f\u001a47/\u001a;\t\u0011\t\u001d(q\u0017C\u0001\u0005S\fqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\t-(Q\u001eBx\u0005g\u0004r!\u0003BE\u00037\fY\u000e\u0003\u0004\u0004\u0005K\u0004\r\u0001\u0015\u0005\t\u0005c\u0014)\u000f1\u0001\u0002\\\u0006\u0001b-\u001b:ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e\u0005\t\u0005k\u0014)\u000f1\u0001\u0002\\\u0006\tRO\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;\t\u0015\te(qWI\u0001\n\u0003\u0011Y0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0005{T3a\u0018BP\u0001")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(Log log, long l, long l2) {
        return LogCleaner$.MODULE$.calculateCleanableBytes(log, l, l2);
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.kafka$log$LogCleaner$$cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.kafka$log$LogCleaner$$cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.kafka$log$LogCleaner$$cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$2(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$2) {
                return (double)100 * x$2.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)$anon$3.$anonfun$value$4(x$4)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$3.$anonfun$value$5(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$4) {
                return x$4.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$5) {
                return x$5.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)$anon$4.$anonfun$value$7(x$7)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$7) {
                return x$7.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            block0: {
                boolean cleaned = this.cleanFilthiestLog();
                if (cleaned) break block0;
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean cleanFilthiestLog() {
            boolean bl;
            ObjectRef currentLog = ObjectRef.create((Object)None$.MODULE$);
            try {
                boolean bl2;
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
                if (None$.MODULE$.equals(option)) {
                    bl2 = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    currentLog.elem = new Some((Object)cleanable.log());
                    this.cleanLog(cleanable);
                    bl2 = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl2;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                try {
                    deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(currentLog, x0$1)));
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
                }
                bl = cleaned;
            }
            catch (Throwable throwable) {
                Exception exception;
                Throwable throwable2 = throwable;
                boolean bl3 = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                if (bl3) {
                    throw throwable2;
                }
                if (throwable2 instanceof Exception) {
                    exception = (Exception)throwable2;
                    if (((Option)currentLog.elem).isEmpty()) {
                        throw new IllegalStateException("currentLog cannot be empty on an unexpected exception", exception);
                    }
                } else {
                    throw throwable;
                }
                Log erroneousLog = (Log)((Option)currentLog.elem).get();
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(erroneousLog).append(". Marking its partition (").append(erroneousLog.topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(erroneousLog.dir().getParent(), erroneousLog.topicPartition());
                boolean bl4 = false;
                bl = bl4;
            }
            return bl;
        }

        private void cleanLog(LogToClean cleanable) {
            long endOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                    Tuple2 tuple23 = tuple22;
                    long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                    CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                    endOffset = nextDirtyOffset2;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().dir().getParent();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block0: {
                this.lastStats_$eq(stats);
                String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (stats.invalidMessagesRead() <= 0L) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(ObjectRef currentLog$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Log log = (Log)tuple2._2();
            currentLog$1.elem = new Some((Object)log);
            int n = log.deleteOldSegments();
            return n;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        }
    }
}

